/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.member.business.member.local.service.internal;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.member.business.member.local.entity.HolidayEntity;
import com.biz.crm.member.business.member.local.entity.HolidayIntegral;
import com.biz.crm.member.business.member.local.helper.UserSearchHelper;
import com.biz.crm.member.business.member.local.repository.HolidayIntegralRepository;
import com.biz.crm.member.business.member.local.repository.HolidayRepository;
import com.biz.crm.member.business.member.local.service.AppletPopupNotifyService;
import com.biz.crm.member.business.member.local.service.HolidayService;
import com.biz.crm.member.business.member.local.utils.AssertUtils;
import com.biz.crm.member.business.member.sdk.dto.HolidayDto;
import com.biz.crm.member.business.member.sdk.dto.HolidayIntegralDto;
import com.biz.crm.member.business.member.sdk.enums.HolidayTypeEnum;
import com.biz.crm.member.business.member.sdk.enums.TriggerConditionEnum;
import com.biz.crm.member.business.member.sdk.enums.TriggerTypeEnum;
import com.biz.crm.member.business.member.sdk.vo.HolidayIntegralVo;
import com.biz.crm.member.business.member.sdk.vo.HolidayVo;
import com.biz.crm.member.business.member.sdk.vo.applet.AppletPopupNotifyVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class HolidayServiceImpl
implements HolidayService {
    @Autowired
    private HolidayRepository holidayRepository;
    @Autowired
    private HolidayIntegralRepository holidayIntegralRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private RedisMutexService redisMutexService;
    @Autowired
    private LoginUserService loginUserService;
    @Autowired
    private AppletPopupNotifyService appletPopupNotifyService;
    @Autowired
    private UserSearchHelper userSearchHelper;
    public static final String MMS_HOLIDAY_CODE_REDIS_KEY = "mms:holiday:code:index:%s";
    public static final String MMS_HOLIDAY_CODE_PREFIX = "JR";

    private String generateCode(String tenantCode) {
        String redisKey = String.format(MMS_HOLIDAY_CODE_REDIS_KEY, tenantCode);
        String index = this.redisMutexService.getAndIncrement(redisKey, 1L, Integer.valueOf(6));
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        return StringUtils.join((Object[])new String[]{MMS_HOLIDAY_CODE_PREFIX, format.format(new Date()), index});
    }

    @Override
    public Page<HolidayVo> findByConditions(Pageable pageable, HolidayDto holidayDto) {
        if (Objects.isNull(holidayDto)) {
            holidayDto = new HolidayDto();
        }
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.holidayRepository.findByConditions((Page<HolidayVo>)page, holidayDto);
    }

    @Override
    public HolidayVo findDetailById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        HolidayEntity holidayEntity = (HolidayEntity)((Object)this.holidayRepository.getById((Serializable)((Object)id)));
        Validate.notNull((Object)((Object)holidayEntity), (String)"\u8282\u65e5\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        HolidayVo holidayVo = (HolidayVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)holidayEntity, HolidayVo.class, HashSet.class, LinkedList.class, new String[0]);
        List integrals = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.holidayIntegralRepository.lambdaQuery().eq(HolidayIntegral::getHolidayCode, (Object)holidayVo.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).list();
        if (CollectionUtils.isNotEmpty((Collection)integrals)) {
            List holidayIntegralVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)integrals, HolidayIntegral.class, HolidayIntegralVo.class, HashSet.class, LinkedList.class, new String[0]);
            holidayVo.setIntegrals(holidayIntegralVos);
        }
        return holidayVo;
    }

    @Override
    public HolidayVo create(HolidayDto holidayDto) {
        this.createValidate(holidayDto);
        holidayDto.setCode(this.generateCode(TenantUtils.getTenantCode()));
        holidayDto.setTenantCode(TenantUtils.getTenantCode());
        holidayDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        holidayDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        HolidayEntity holidayEntity = (HolidayEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)holidayDto, HolidayEntity.class, HashSet.class, LinkedList.class, new String[0]));
        this.holidayRepository.saveOrUpdate((Object)holidayEntity);
        List integrals = holidayDto.getIntegrals();
        if (CollectionUtils.isNotEmpty((Collection)integrals)) {
            List holidayIntegrals = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)integrals, HolidayIntegralDto.class, HolidayIntegral.class, HashSet.class, LinkedList.class, new String[0]);
            for (HolidayIntegral holidayIntegral : holidayIntegrals) {
                holidayIntegral.setHolidayCode(holidayEntity.getCode());
                holidayIntegral.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                holidayIntegral.setTenantCode(TenantUtils.getTenantCode());
                holidayIntegral.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            }
            this.holidayIntegralRepository.saveBatch(holidayIntegrals);
        }
        return (HolidayVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)holidayEntity, HolidayVo.class, HashSet.class, LinkedList.class, new String[0]);
    }

    private void createValidate(HolidayDto holidayDto) {
        List integrals;
        Validate.notNull((Object)holidayDto, (String)"\u65b0\u589e\u5b9e\u4f53\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)holidayDto.getName(), (String)"\u8282\u65e5\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)holidayDto.getType(), (String)"\u8282\u65e5\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)holidayDto.getExtraIntegralTop(), (String)"\u79ef\u5206\u4e0a\u9650\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (HolidayTypeEnum.FESTIVAL.getCode().equals(holidayDto.getType())) {
            Validate.notNull((Object)holidayDto.getHolidayEndDate(), (String)"\u8282\u5047\u65e5\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notNull((Object)holidayDto.getHolidayStartDate(), (String)"\u8282\u5047\u65e5\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
        if (HolidayTypeEnum.BIRTHDAY.getCode().equals(holidayDto.getType())) {
            HolidayEntity entity = (HolidayEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.holidayRepository.lambdaQuery().eq(HolidayEntity::getType, (Object)HolidayTypeEnum.BIRTHDAY.getCode())).eq(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.ENABLE.getCode())).one());
            AssertUtils.isTrue(Objects.isNull((Object)entity), "\u5df2\u7ecf\u5b58\u5728\u751f\u65e5\u7684\u914d\u7f6e,\u8bf7\u52ff\u91cd\u590d\u914d\u7f6e");
        }
        if (CollectionUtils.isNotEmpty((Collection)(integrals = holidayDto.getIntegrals()))) {
            ArrayList<String> channels = new ArrayList<String>();
            for (HolidayIntegralDto integral : integrals) {
                Validate.notBlank((CharSequence)integral.getChannel(), (String)"\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                Validate.notNull((Object)integral.getMultiple(), (String)"\u79ef\u5206\u500d\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                channels.add(integral.getChannel());
            }
            HashSet<String> set = new HashSet<String>();
            set.addAll(channels);
            Validate.isTrue((set.size() == channels.size() ? 1 : 0) != 0, (String)"\u6e20\u9053\u91cd\u590d", (Object[])new Object[0]);
        }
    }

    @Override
    public HolidayVo update(HolidayDto holidayDto) {
        this.updateValidate(holidayDto);
        holidayDto.setTenantCode(TenantUtils.getTenantCode());
        holidayDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        holidayDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        HolidayEntity oldHoliday = (HolidayEntity)((Object)this.holidayRepository.getById((Serializable)((Object)holidayDto.getId())));
        Validate.notNull((Object)((Object)oldHoliday), (String)"\u7f16\u8f91\u8282\u65e5\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        HolidayEntity holidayEntity = (HolidayEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)holidayDto, HolidayEntity.class, HashSet.class, LinkedList.class, new String[0]));
        this.holidayRepository.saveOrUpdate((Object)holidayEntity);
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"holiday_code", (Object)oldHoliday.getCode());
        wrapper.eq((Object)"tenant_code", (Object)oldHoliday.getTenantCode());
        this.holidayIntegralRepository.remove((Wrapper)wrapper);
        List integrals = holidayDto.getIntegrals();
        if (CollectionUtils.isNotEmpty((Collection)integrals)) {
            List holidayIntegrals = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)integrals, HolidayIntegralDto.class, HolidayIntegral.class, HashSet.class, LinkedList.class, new String[0]);
            for (HolidayIntegral holidayIntegral : holidayIntegrals) {
                holidayIntegral.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                holidayIntegral.setTenantCode(TenantUtils.getTenantCode());
                holidayIntegral.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                holidayIntegral.setHolidayCode(holidayEntity.getCode());
            }
            this.holidayIntegralRepository.saveBatch(holidayIntegrals);
        }
        return (HolidayVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)holidayEntity, HolidayVo.class, HashSet.class, LinkedList.class, new String[0]);
    }

    private void updateValidate(HolidayDto holidayDto) {
        List integrals;
        Validate.notNull((Object)holidayDto, (String)"\u7f16\u8f91\u5b9e\u4f53\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)holidayDto.getName(), (String)"\u8282\u65e5\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)holidayDto.getType(), (String)"\u8282\u65e5\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)holidayDto.getExtraIntegralTop(), (String)"\u79ef\u5206\u4e0a\u9650\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)holidayDto.getCode(), (String)"\u7f16\u8f91\u65f6\uff0c\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)holidayDto.getId(), (String)"\u7f16\u8f91\u65f6\uff0c\u4e3b\u952eid\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (HolidayTypeEnum.FESTIVAL.getCode().equals(holidayDto.getType())) {
            Validate.notNull((Object)holidayDto.getHolidayEndDate(), (String)"\u8282\u5047\u65e5\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notNull((Object)holidayDto.getHolidayStartDate(), (String)"\u8282\u5047\u65e5\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
        if (HolidayTypeEnum.BIRTHDAY.getCode().equals(holidayDto.getType())) {
            List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.holidayRepository.lambdaQuery().ne(HolidayEntity::getCode, (Object)holidayDto.getCode())).eq(HolidayEntity::getType, (Object)HolidayTypeEnum.BIRTHDAY.getCode())).eq(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.ENABLE.getCode())).list();
            AssertUtils.isTrue(list.size() == 0, "\u5df2\u7ecf\u5b58\u5728\u751f\u65e5\u7684\u914d\u7f6e,\u8bf7\u52ff\u91cd\u590d\u914d\u7f6e");
        }
        if (CollectionUtils.isNotEmpty((Collection)(integrals = holidayDto.getIntegrals()))) {
            ArrayList<String> channels = new ArrayList<String>();
            for (HolidayIntegralDto integral : integrals) {
                Validate.notBlank((CharSequence)integral.getChannel(), (String)"\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                Validate.notNull((Object)integral.getMultiple(), (String)"\u79ef\u5206\u500d\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                channels.add(integral.getChannel());
            }
            HashSet<String> set = new HashSet<String>();
            set.addAll(channels);
            Validate.isTrue((set.size() == channels.size() ? 1 : 0) != 0, (String)"\u6e20\u9053\u91cd\u590d", (Object[])new Object[0]);
        }
    }

    @Override
    public void enableBatch(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.holidayRepository.lambdaUpdate().set(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.ENABLE.getCode())).in(UuidEntity::getId, ids)).update();
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.holidayRepository.lambdaQuery().eq(HolidayEntity::getType, (Object)HolidayTypeEnum.BIRTHDAY.getCode())).eq(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.ENABLE.getCode())).list();
        AssertUtils.isTrue(list.size() > 1, "\u4e0d\u80fd\u540c\u65f6\u542f\u7528\u4e24\u4e2a\u4ee5\u4e0a\u7684\u751f\u65e5\u914d\u7f6e");
    }

    @Override
    public void disableBatch(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.holidayRepository.lambdaUpdate().set(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.DISABLE.getCode())).in(UuidEntity::getId, ids)).update();
    }

    @Override
    public void deleteBatch(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.holidayRepository.lambdaUpdate().set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).in(UuidEntity::getId, ids)).update();
    }

    @Override
    @DynamicTaskService(cornExpression="0 1 0 1/1 * ?", taskDesc="\u6bcf\u59298\u70b955\u5411\u7ec8\u7aef\u63a8\u9001\u4e00\u6b21\u5408\u8ba1\u5956\u52b1")
    public void addOnePopup() throws ParseException {
        String memberCode = this.userSearchHelper.getMemberLogin().getMemberCode();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date date = new Date();
        String format = simpleDateFormat.format(date);
        Date currentDate = simpleDateFormat.parse(format);
        List list = ((LambdaQueryChainWrapper)this.holidayRepository.lambdaQuery().eq(HolidayEntity::getHolidayStartDate, (Object)currentDate)).list();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (HolidayEntity holidayEntity : list) {
                AppletPopupNotifyVo appletPopupNotifyVo = new AppletPopupNotifyVo();
                appletPopupNotifyVo.setTriggerType(TriggerTypeEnum.HOLIDAY.getCode());
                appletPopupNotifyVo.setTriggerConditions(TriggerConditionEnum.HOLIDAY_CONF.getCode());
                appletPopupNotifyVo.setMemberCode(memberCode);
                Date holidayEndDate = holidayEntity.getHolidayEndDate();
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(holidayEndDate);
                calendar.set(11, 23);
                calendar.set(12, 59);
                calendar.set(13, 0);
                calendar.set(14, 0);
                Date endTime = calendar.getTime();
                appletPopupNotifyVo.setEndTime(endTime);
                this.appletPopupNotifyService.addOne(appletPopupNotifyVo);
            }
        }
    }
}

