/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.member.business.member.local.service.internal;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.member.business.member.local.entity.IndustryEntity;
import com.biz.crm.member.business.member.local.repository.IndustryRepository;
import com.biz.crm.member.business.member.local.service.IndustryService;
import com.biz.crm.member.business.member.sdk.dto.IndustryDto;
import com.biz.crm.member.business.member.sdk.dto.IndustryPageDto;
import com.biz.crm.member.business.member.sdk.vo.IndustryPageVo;
import com.biz.crm.member.business.member.sdk.vo.IndustryVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class IndustryServiceImpl
implements IndustryService {
    private static final Logger log = LoggerFactory.getLogger(IndustryServiceImpl.class);
    @Autowired
    private IndustryRepository industryRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private RedisMutexService redisMutexService;
    @Autowired
    private LoginUserService loginUserService;
    public static final String MMS_INDUSTRY_CODE_REDIS_KEY = "mms:industry:code:index:%s";
    public static final String MMS_INDUSTRY_CODE_PREFIX = "HY";

    @Override
    public Page<IndustryPageVo> findByConditions(Pageable pageable, IndustryPageDto industryPageDto) {
        if (Objects.isNull(industryPageDto)) {
            industryPageDto = new IndustryPageDto();
        }
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.industryRepository.findByConditions((Page<IndustryPageVo>)page, industryPageDto);
    }

    @Override
    public IndustryVo findDetailById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        IndustryEntity industryEntity = (IndustryEntity)((Object)((LambdaQueryChainWrapper)this.industryRepository.lambdaQuery().eq(UuidEntity::getId, (Object)id)).one());
        return (IndustryVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)industryEntity, IndustryVo.class, HashSet.class, LinkedList.class, new String[0]);
    }

    @Override
    public IndustryVo create(IndustryDto industryDto) {
        this.createValidate(industryDto);
        IndustryEntity industryEntity = (IndustryEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)industryDto, IndustryEntity.class, HashSet.class, LinkedList.class, new String[0]));
        this.industryRepository.save((Object)industryEntity);
        return (IndustryVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)industryEntity, IndustryVo.class, HashSet.class, LinkedList.class, new String[0]);
    }

    private void createValidate(IndustryDto industryDto) {
        Validate.notNull((Object)industryDto, (String)"\u65b0\u589e\u5b9e\u4f53\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)industryDto.getName(), (String)"\u884c\u4e1a\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        String code = this.generateCode(TenantUtils.getTenantCode());
        industryDto.setCode(code);
        Date now = new Date();
        industryDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        industryDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        industryDto.setTenantCode(TenantUtils.getTenantCode());
    }

    private String generateCode(String tenantCode) {
        String redisKey = String.format(MMS_INDUSTRY_CODE_REDIS_KEY, tenantCode);
        String index = this.redisMutexService.getAndIncrement(redisKey, 1L, Integer.valueOf(6));
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        return StringUtils.join((Object[])new String[]{MMS_INDUSTRY_CODE_PREFIX, format.format(new Date()), index});
    }

    @Override
    public IndustryVo update(IndustryDto industryDto) {
        this.updateValidate(industryDto);
        IndustryEntity oldEntity = (IndustryEntity)((Object)((LambdaQueryChainWrapper)this.industryRepository.lambdaQuery().eq(UuidEntity::getId, (Object)industryDto.getId())).one());
        Validate.notNull((Object)((Object)oldEntity), (String)"\u7f16\u8f91\u884c\u4e1a\u4fe1\u606f\u4e0d\u5b58\u5728\uff01", (Object[])new Object[0]);
        IndustryEntity industryEntity = (IndustryEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)industryDto, IndustryEntity.class, HashSet.class, LinkedList.class, new String[0]));
        this.industryRepository.saveOrUpdate((Object)industryEntity);
        return (IndustryVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)industryEntity, IndustryVo.class, HashSet.class, LinkedList.class, new String[0]);
    }

    public void updateValidate(IndustryDto industryDto) {
        Validate.notNull((Object)industryDto, (String)"\u7f16\u8f91\u5b9e\u4f53\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)industryDto.getId(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\u4e3b\u952eid\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)industryDto.getCode(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u884c\u4e1a\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)industryDto.getName(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u884c\u4e1a\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Date now = new Date();
        industryDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        industryDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        industryDto.setTenantCode(TenantUtils.getTenantCode());
    }

    @Override
    public void enableBatch(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        List industryEntities = ((LambdaQueryChainWrapper)this.industryRepository.lambdaQuery().in(UuidEntity::getId, ids)).list();
        if (CollectionUtils.isEmpty((Collection)industryEntities)) {
            return;
        }
        industryEntities.stream().forEach(industryEntity -> industryEntity.setEnableStatus(EnableStatusEnum.ENABLE.getCode()));
        this.industryRepository.updateBatchById(industryEntities);
    }

    @Override
    public void disableBatch(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        List industryEntities = ((LambdaQueryChainWrapper)this.industryRepository.lambdaQuery().in(UuidEntity::getId, ids)).list();
        if (CollectionUtils.isEmpty((Collection)industryEntities)) {
            return;
        }
        industryEntities.stream().forEach(industryEntity -> industryEntity.setEnableStatus(EnableStatusEnum.DISABLE.getCode()));
        this.industryRepository.updateBatchById(industryEntities);
    }

    @Override
    public void deleteBatch(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.industryRepository.lambdaUpdate().set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE)).in(UuidEntity::getId, ids)).update();
    }
}

