/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.member.business.member.local.service.internal;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.member.business.member.local.entity.InfoCategory;
import com.biz.crm.member.business.member.local.mapper.InfoCategoryMapper;
import com.biz.crm.member.business.member.local.repository.InfoCategoryRepository;
import com.biz.crm.member.business.member.local.service.InfoCategoryService;
import com.biz.crm.member.business.member.sdk.dto.InfoCategoryDto;
import com.biz.crm.member.business.member.sdk.dto.InfoCategoryPaginationDto;
import com.biz.crm.member.business.member.sdk.vo.InfoCategoryVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class InfoCategoryServiceImpl
implements InfoCategoryService {
    private static final Logger log = LoggerFactory.getLogger(InfoCategoryServiceImpl.class);
    @Autowired
    private InfoCategoryRepository infoCategoryRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired
    private InfoCategoryMapper infoCategoryMapper;

    @Override
    public InfoCategoryVo createInfoCategory(InfoCategoryDto infoCategoryDto) {
        this.createValidation(infoCategoryDto);
        InfoCategory infoCategory = (InfoCategory)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)infoCategoryDto, InfoCategory.class, HashSet.class, LinkedList.class, new String[0]));
        infoCategory.setTenantCode(TenantUtils.getTenantCode());
        infoCategory.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        infoCategory.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        infoCategory.setCode((String)this.generateCodeService.generateCode("ZX_CATEGORY", 5).get(0));
        this.infoCategoryRepository.save((Object)infoCategory);
        InfoCategoryVo infoCategoryVo = (InfoCategoryVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)infoCategory, InfoCategoryVo.class, HashSet.class, LinkedList.class, new String[0]);
        return infoCategoryVo;
    }

    @Override
    public InfoCategoryVo updateInfoCategory(InfoCategoryDto infoCategoryDto) {
        Optional.ofNullable(infoCategoryDto.getInfoSort()).ifPresent(infoSort -> Validate.isTrue((infoSort > 0 ? 1 : 0) != 0, (String)"\u5e8f\u53f7\u4e0d\u80fd\u5c0f\u4e8e0", (Object[])new Object[0]));
        String infoCategoryId = infoCategoryDto.getId();
        Validate.notBlank((CharSequence)infoCategoryId, (String)"\u4fee\u6539\u8d44\u8baf\u5206\u7c7b\u4fe1\u606fid\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        InfoCategory current = (InfoCategory)((Object)this.infoCategoryRepository.getById((Serializable)((Object)infoCategoryId)));
        Validate.notNull((Object)((Object)current), (String)"\u4fee\u6539\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        InfoCategory infoCategory = (InfoCategory)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)infoCategoryDto, InfoCategory.class, HashSet.class, LinkedList.class, new String[0]));
        this.infoCategoryRepository.saveOrUpdate((Object)infoCategory);
        InfoCategoryVo result = (InfoCategoryVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)infoCategory, InfoCategoryVo.class, HashSet.class, LinkedList.class, new String[0]);
        return result;
    }

    @Override
    public Page<InfoCategoryVo> pageInfoCategory(Pageable pageable, InfoCategoryPaginationDto paginationDto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        paginationDto = Optional.ofNullable(paginationDto).orElse(new InfoCategoryPaginationDto());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<InfoCategoryVo> result = this.infoCategoryMapper.pageInfoCategory(paginationDto, (Page<InfoCategoryVo>)page, DelFlagStatusEnum.NORMAL.getCode());
        return result;
    }

    @Override
    public InfoCategoryVo getInfoCategoryById(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u83b7\u53d6\u5355\u4e2a\u8d44\u8baf\u5206\u7c7b\u4fe1\u606f\u65f6\uff0cid\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        InfoCategory infoCategory = (InfoCategory)((Object)this.infoCategoryRepository.getById((Serializable)((Object)id)));
        Validate.notNull((Object)((Object)infoCategory), (String)"\u67e5\u8be2\u7684\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        InfoCategoryVo result = (InfoCategoryVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)infoCategory, InfoCategoryVo.class, HashSet.class, LinkedList.class, new String[0]);
        return result;
    }

    @Override
    @Transactional
    public void turnOnInfoCategory(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"ids\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.infoCategoryRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
    }

    @Override
    @Transactional
    public void turnOffInfoCategory(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"ids\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.infoCategoryRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
    }

    @Override
    @Transactional
    public void logicDeleteInfoCategory(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.infoCategoryRepository.logicDeleteInfoCategoryByIds(ids);
    }

    @Override
    public List<InfoCategoryVo> appListEnableInfoCategoryByApplyRange(String applyRange) {
        Validate.notBlank((CharSequence)applyRange, (String)"\u5e94\u7528\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(InfoCategory::getApplyRange, (Object)applyRange)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.ENABLE.getCode())).orderByAsc(InfoCategory::getInfoSort);
        List infoCategories = this.infoCategoryRepository.list((Wrapper)queryWrapper);
        Collection result = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)infoCategories, InfoCategory.class, InfoCategoryVo.class, HashSet.class, LinkedList.class, new String[0]);
        return (List)result;
    }

    private void createValidation(InfoCategoryDto infoCategoryDto) {
        this.validation(infoCategoryDto);
    }

    private void validation(InfoCategoryDto infoCategoryDto) {
        Validate.notBlank((CharSequence)infoCategoryDto.getInfoName(), (String)"\u8d44\u8baf\u5206\u7c7b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)infoCategoryDto.getInfoSort(), (String)"\u6392\u5e8f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)infoCategoryDto.getApplyRange(), (String)"\u5e94\u7528\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((infoCategoryDto.getInfoSort() > 0 ? 1 : 0) != 0, (String)"\u5e8f\u53f7\u4e0d\u80fd\u5c0f\u4e8e0", (Object[])new Object[0]);
    }
}

