/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.member.business.member.local.service.internal;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.member.business.member.local.entity.InfoManage;
import com.biz.crm.member.business.member.local.entity.InfoUpvote;
import com.biz.crm.member.business.member.local.helper.UserSearchHelper;
import com.biz.crm.member.business.member.local.repository.InfoManageRepository;
import com.biz.crm.member.business.member.local.service.DiscussService;
import com.biz.crm.member.business.member.local.service.InfoManageService;
import com.biz.crm.member.business.member.local.service.InfoUpvoteService;
import com.biz.crm.member.business.member.sdk.dto.InfoManageDto;
import com.biz.crm.member.business.member.sdk.dto.InfoManagePaginationDto;
import com.biz.crm.member.business.member.sdk.dto.InfoManagePubDto;
import com.biz.crm.member.business.member.sdk.enums.DiscussCheckStatusEnum;
import com.biz.crm.member.business.member.sdk.enums.InfoApplyModelEnum;
import com.biz.crm.member.business.member.sdk.enums.InfoTypeEnum;
import com.biz.crm.member.business.member.sdk.vo.InfoCountDto;
import com.biz.crm.member.business.member.sdk.vo.InfoManageVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class InfoManageServiceImpl
implements InfoManageService {
    private static final Logger log = LoggerFactory.getLogger(InfoManageServiceImpl.class);
    @Autowired
    private InfoManageRepository infoManageRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired
    private InfoUpvoteService infoUpvoteService;
    @Autowired
    private DiscussService discussService;
    @Autowired
    private UserSearchHelper userSearchHelper;

    @Override
    public InfoManageVo createRichText(InfoManageDto dto) {
        this.createRichTextValidate(dto);
        InfoManage infoManage = (InfoManage)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, InfoManage.class, HashSet.class, LinkedList.class, new String[0]));
        InfoManageVo result = this.create(infoManage);
        return result;
    }

    @Override
    public InfoManageVo createPubAccount(InfoManagePubDto dto) {
        this.createPubValidate(dto);
        InfoManage infoManage = (InfoManage)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, InfoManage.class, HashSet.class, LinkedList.class, new String[0]));
        InfoManageVo result = this.create(infoManage);
        return result;
    }

    @Override
    @Transactional
    public void logicDeleteInfoByIds(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"ids\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.infoManageRepository.logicDeleteByIds(ids);
    }

    @Override
    public InfoManageVo updateInfo(InfoManageDto dto) {
        Optional.ofNullable(dto.getSerialNum()).ifPresent(serialNum -> Validate.isTrue((serialNum > 0 ? 1 : 0) != 0, (String)"\u5e8f\u53f7\u4e0d\u80fd\u5c0f\u4e8e0", (Object[])new Object[0]));
        String infoId = dto.getId();
        Validate.notBlank((CharSequence)infoId, (String)"id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        InfoManage infoManage = (InfoManage)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, InfoManage.class, HashSet.class, LinkedList.class, new String[0]));
        this.infoManageRepository.saveOrUpdate((Object)infoManage);
        InfoManageVo result = (InfoManageVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)infoManage, InfoManageVo.class, HashSet.class, LinkedList.class, new String[0]);
        return result;
    }

    @Override
    @Transactional
    public void turnOnInfoByIds(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.infoManageRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
    }

    @Override
    @Transactional
    public void turnOffByIds(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.infoManageRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
    }

    @Override
    public Page<InfoManageVo> pageInfo(Pageable pageable, InfoManagePaginationDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        dto = Optional.ofNullable(dto).orElse(new InfoManagePaginationDto());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<InfoManageVo> result = this.infoManageRepository.pageInfo((Page<InfoManageVo>)page, dto);
        this.populateCount(result.getRecords(), "", "");
        return result;
    }

    @Override
    public List<InfoManageVo> getAppIndexInfoLimitThree() {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.ENABLE.getCode())).eq(InfoManage::getApplyModel, (Object)InfoApplyModelEnum.INFO_CHOICE_NESS)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).orderByDesc(UuidOpEntity::getCreateTime)).last("limit 3");
        List infoManages = this.infoManageRepository.list((Wrapper)queryWrapper);
        Collection result = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)infoManages, InfoManage.class, InfoManageVo.class, HashSet.class, LinkedList.class, new String[0]);
        return (List)result;
    }

    @Override
    public Page<InfoManageVo> pageInfoManageApp(Pageable pageable, String infoCategoryCode, String applyModel) {
        Validate.notBlank((CharSequence)applyModel, (String)"\u5e94\u7528\u6a21\u5757\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)infoCategoryCode, (String)"\u8d44\u8baf\u5206\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        InfoManagePaginationDto paginationDto = new InfoManagePaginationDto();
        paginationDto.setApplyModel(applyModel);
        paginationDto.setInfoCategoryCode(infoCategoryCode);
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<InfoManageVo> result = this.infoManageRepository.pageInfo((Page<InfoManageVo>)page, paginationDto);
        this.populateCount(result.getRecords(), DiscussCheckStatusEnum.APPROVE.getValue(), EnableStatusEnum.ENABLE.getCode());
        this.populateUpvote(result.getRecords());
        return result;
    }

    @Override
    public void addInfoReadNum(String infoCode, String modifyAccount, String modifyName, Date modifyTime) {
        Integer step = 1;
        this.infoManageRepository.incrementReadNumByStep(infoCode, step, modifyAccount, modifyName, modifyTime);
    }

    @Override
    public InfoManageVo appGetInfoDetailByCode(String infoCode) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(InfoManage::getCode, (Object)infoCode);
        InfoManage infoManage = (InfoManage)((Object)this.infoManageRepository.getOne((Wrapper)queryWrapper));
        String modifyAccount = infoManage.getModifyAccount();
        String modifyName = infoManage.getModifyName();
        Date modifyTime = infoManage.getModifyTime();
        this.addInfoReadNum(infoCode, modifyAccount, modifyName, modifyTime);
        InfoManageVo result = (InfoManageVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)infoManage, InfoManageVo.class, HashSet.class, LinkedList.class, new String[0]);
        this.populateCount(Collections.singletonList(result), DiscussCheckStatusEnum.APPROVE.getValue(), EnableStatusEnum.ENABLE.getCode());
        this.populateUpvote(Collections.singletonList(result));
        return result;
    }

    @Override
    public InfoManageVo appShareInfoByCode(String infoCode) {
        Validate.notBlank((CharSequence)infoCode, (String)"\u8d44\u8baf\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(InfoManage::getCode, (Object)infoCode);
        InfoManage infoManage = (InfoManage)((Object)this.infoManageRepository.getOne((Wrapper)queryWrapper));
        InfoManageVo result = (InfoManageVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)infoManage, InfoManageVo.class, HashSet.class, LinkedList.class, new String[0]);
        return result;
    }

    @Override
    public List<InfoManageVo> listEnableChoiceNessCategoryInfo() {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.ENABLE.getCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).isNotNull(InfoManage::getChoiceNessCategory)).orderByDesc(UuidOpEntity::getCreateTime);
        List infoManageList = this.infoManageRepository.list((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)infoManageList)) {
            return Collections.EMPTY_LIST;
        }
        Collection result = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)infoManageList, InfoManage.class, InfoManageVo.class, HashSet.class, LinkedList.class, new String[0]);
        return (List)result;
    }

    @Override
    public InfoManageVo getInfoByChoiceCodeLast(String choiceCategoryCode) {
        InfoManage infoManage = (InfoManage)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.infoManageRepository.lambdaQuery().eq(InfoManage::getChoiceNessCategory, (Object)choiceCategoryCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.ENABLE.getCode())).orderByDesc(UuidOpEntity::getCreateTime)).last("limit 1")).one());
        InfoManageVo result = (InfoManageVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)infoManage, InfoManageVo.class, HashSet.class, LinkedList.class, new String[0]);
        this.populateCount(Collections.singletonList(result), DiscussCheckStatusEnum.APPROVE.getValue(), EnableStatusEnum.ENABLE.getCode());
        this.populateUpvote(Collections.singletonList(result));
        return result;
    }

    private void populateUpvote(List<InfoManageVo> records) {
        List<String> infoCodes = records.stream().map(InfoManageVo::getCode).distinct().collect(Collectors.toList());
        String memberCode = this.userSearchHelper.getMemberLogin().getMemberCode();
        List<InfoUpvote> upvoteList = this.infoUpvoteService.listUpvoteInfoByMemberCodeAndInfoCodes(infoCodes, memberCode);
        Set upvoteInfoCodes = upvoteList.stream().map(InfoUpvote::getInfoCode).collect(Collectors.toSet());
        for (InfoManageVo record : records) {
            String infoCode = record.getCode();
            record.setAlreadyUpvote(Boolean.valueOf(upvoteInfoCodes.contains(infoCode)));
        }
    }

    private void populateCount(List<InfoManageVo> infoManageVoList, String checkStatus, String enableStatus) {
        List<String> infoCodes = infoManageVoList.stream().map(InfoManageVo::getCode).distinct().collect(Collectors.toList());
        List<String> discussInfoCodes = infoManageVoList.stream().filter(obj -> obj.getInfoType().equals(InfoTypeEnum.RICH_TEXT.getValue())).map(InfoManageVo::getCode).distinct().collect(Collectors.toList());
        Map<String, Integer> upvoteCountMap = this.infoUpvoteService.countUpvoteByInfoCodes(infoCodes).stream().collect(Collectors.toMap(InfoCountDto::getInfoCode, InfoCountDto::getCountNum));
        Map<String, Integer> discussCountMap = this.discussService.countByInfoCodes(discussInfoCodes, checkStatus, enableStatus).stream().collect(Collectors.toMap(InfoCountDto::getInfoCode, InfoCountDto::getCountNum));
        for (InfoManageVo infoManageVo : infoManageVoList) {
            String infoCode = infoManageVo.getCode();
            Integer upvoteNum = upvoteCountMap.getOrDefault(infoCode, 0);
            infoManageVo.setUpvoteNum(upvoteNum);
            Integer discussNum = discussCountMap.getOrDefault(infoCode, 0);
            infoManageVo.setDiscussNum(discussNum);
        }
    }

    private InfoManageVo create(InfoManage infoManage) {
        infoManage.setCode((String)this.generateCodeService.generateCode("ZX", 5).get(0));
        infoManage.setTenantCode(TenantUtils.getTenantCode());
        infoManage.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        infoManage.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        infoManage.setReadNum(0);
        this.infoManageRepository.save((Object)infoManage);
        InfoManageVo result = (InfoManageVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)infoManage, InfoManageVo.class, HashSet.class, LinkedList.class, new String[0]);
        return result;
    }

    private void createPubValidate(InfoManagePubDto dto) {
        Validate.notNull((Object)dto.getSerialNum(), (String)"\u5e8f\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getInfoTitle(), (String)"\u8d44\u8baf\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getStartTime(), (String)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getEndTime(), (String)"\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getInfoType(), (String)"\u8d44\u8baf\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getTargetUrl(), (String)"\u8df3\u8f6c\u94fe\u63a5\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((dto.getSerialNum() > 0 ? 1 : 0) != 0, (String)"\u5e8f\u53f7\u4e0d\u80fd\u5c0f\u4e8e0", (Object[])new Object[0]);
    }

    private void createRichTextValidate(InfoManageDto dto) {
        this.validation(dto);
        Validate.notBlank((CharSequence)dto.getApplyModel(), (String)"\u5e94\u7528\u6a21\u5757\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getInfoCategory(), (String)"\u8d44\u8baf\u5206\u7c7b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getInfoType(), (String)"\u8d44\u8baf\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getOverPic(), (String)"\u5c01\u9762\u56fe\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }

    private void validation(InfoManageDto dto) {
        Validate.notNull((Object)dto.getSerialNum(), (String)"\u5e8f\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getInfoTitle(), (String)"\u8d44\u8baf\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getStartTime(), (String)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getEndTime(), (String)"\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((dto.getSerialNum() > 0 ? 1 : 0) != 0, (String)"\u5e8f\u53f7\u4e0d\u80fd\u5c0f\u4e8e0", (Object[])new Object[0]);
    }
}

