/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.member.business.member.local.service.internal;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.member.business.member.local.entity.InfoUpvote;
import com.biz.crm.member.business.member.local.helper.UserSearchHelper;
import com.biz.crm.member.business.member.local.mapper.InfoUpvoteMapper;
import com.biz.crm.member.business.member.local.repository.InfoUpvoteRepository;
import com.biz.crm.member.business.member.local.service.InfoUpvoteService;
import com.biz.crm.member.business.member.sdk.vo.InfoCountDto;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InfoUpvoteServiceImpl
implements InfoUpvoteService {
    private static final Logger log = LoggerFactory.getLogger(InfoUpvoteServiceImpl.class);
    @Autowired
    private LoginUserService loginUserService;
    @Autowired
    private InfoUpvoteRepository infoUpvoteRepository;
    @Autowired
    private UserSearchHelper userSearchHelper;

    @Override
    public void addInfoUpvote(String infoCode) {
        Validate.notBlank((CharSequence)infoCode, (String)"\u8d44\u8baf\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String memberCode = this.userSearchHelper.getMemberLogin().getMemberCode();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(InfoUpvote::getInfoCode, (Object)infoCode)).eq(InfoUpvote::getMemberCode, (Object)memberCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode());
        InfoUpvote current = (InfoUpvote)((Object)this.infoUpvoteRepository.getOne((Wrapper)queryWrapper));
        Validate.isTrue((boolean)ObjectUtils.isEmpty((Object)((Object)current)), (String)"\u4e0d\u53ef\u91cd\u590d\u70b9\u8d5e", (Object[])new Object[0]);
        InfoUpvote infoUpvote = new InfoUpvote();
        infoUpvote.setMemberCode(memberCode);
        infoUpvote.setInfoCode(infoCode);
        infoUpvote.setTenantCode(TenantUtils.getTenantCode());
        infoUpvote.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        infoUpvote.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        this.infoUpvoteRepository.save((Object)infoUpvote);
    }

    @Override
    public void logicDeleteUpvote(String infoCode) {
        Validate.notBlank((CharSequence)infoCode, (String)"\u8d44\u8baf\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String memberCode = this.userSearchHelper.getMemberLogin().getMemberCode();
        this.infoUpvoteRepository.cancelUpvoteByInfoCode(infoCode, memberCode);
    }

    @Override
    public Integer countUpvoteByInfoCode(String infoCode) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(InfoUpvote::getInfoCode, (Object)infoCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode());
        int result = this.infoUpvoteRepository.count((Wrapper)queryWrapper);
        return result;
    }

    @Override
    public List<InfoCountDto> countUpvoteByInfoCodes(List<String> infoCodes) {
        if (CollectionUtils.isEmpty(infoCodes)) {
            return Collections.EMPTY_LIST;
        }
        List<InfoCountDto> result = ((InfoUpvoteMapper)this.infoUpvoteRepository.getBaseMapper()).countByInfoCode(infoCodes, DelFlagStatusEnum.NORMAL.getCode());
        return result;
    }

    @Override
    public List<InfoUpvote> listUpvoteInfoByMemberCodeAndInfoCodes(List<String> infoCodes, String memberCode) {
        if (CollectionUtils.isEmpty(infoCodes)) {
            return Collections.EMPTY_LIST;
        }
        Validate.notBlank((CharSequence)memberCode, (String)"\u83b7\u53d6\u4e0d\u5230\u5f53\u524d\u767b\u5f55\u7528\u6237\u7684\u4f1a\u5458\u7f16\u7801", (Object[])new Object[0]);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.in(InfoUpvote::getInfoCode, infoCodes)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(InfoUpvote::getMemberCode, (Object)memberCode);
        return this.infoUpvoteRepository.list((Wrapper)queryWrapper);
    }
}

