/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.member.business.member.local.service.internal;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.member.business.member.local.entity.Label;
import com.biz.crm.member.business.member.local.entity.LabelCategory;
import com.biz.crm.member.business.member.local.mapper.LabelCategoryMapper;
import com.biz.crm.member.business.member.local.repository.LabelCategoryRepository;
import com.biz.crm.member.business.member.local.repository.LabelRepository;
import com.biz.crm.member.business.member.local.service.LabelCategoryService;
import com.biz.crm.member.business.member.sdk.enums.LabelManageEnum;
import com.biz.crm.member.business.member.sdk.vo.LabelCategoryVo;
import com.biz.crm.member.business.member.sdk.vo.LabelVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="labelCategoryService")
public class LabelCategoryServiceImpl
implements LabelCategoryService {
    @Autowired
    private LabelCategoryMapper labelCategoryMapper;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private LabelCategoryRepository labelCategoryRepository;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired
    private LabelRepository labelRepository;

    @Override
    public Page<LabelCategoryVo> findByConditions(Pageable pageable, LabelCategoryVo labelCategoryVo) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        labelCategoryVo = Optional.ofNullable(labelCategoryVo).orElse(new LabelCategoryVo());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.labelCategoryRepository.findByConditions((Page<LabelCategoryVo>)page, labelCategoryVo);
    }

    @Override
    @Transactional
    public void create(LabelCategoryVo labelCategoryVo) {
        LabelCategory labelCategory = (LabelCategory)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)labelCategoryVo, LabelCategory.class, HashSet.class, LinkedList.class, new String[0]));
        labelCategory.setCode((String)this.generateCodeService.generateCode("LC", 5).get(0));
        labelCategory.setTenantCode(TenantUtils.getTenantCode());
        labelCategory.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        labelCategory.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        if (labelCategory.getSort() < 1) {
            labelCategory.setSort(1);
            Validate.notNull(null, (String)"\u6392\u5e8f\u5b57\u6bb5\u4e0d\u80fd\u5c0f\u4e8e1", (Object[])new Object[0]);
        }
        this.labelCategoryMapper.insert((Object)labelCategory);
    }

    @Override
    @Transactional
    public void update(LabelCategoryVo labelCategoryVo) {
        LabelCategory labelCategory = (LabelCategory)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)labelCategoryVo, LabelCategory.class, HashSet.class, LinkedList.class, new String[0]));
        if (labelCategory.getSort() < 1) {
            labelCategory.setSort(1);
            Validate.notNull(null, (String)"\u6392\u5e8f\u5b57\u6bb5\u4e0d\u80fd\u5c0f\u4e8e1", (Object[])new Object[0]);
        }
        this.labelCategoryMapper.updateById((Object)labelCategory);
    }

    @Override
    @Transactional
    public void enableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.labelCategoryRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
    }

    @Override
    @Transactional
    public void disableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.labelCategoryRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
    }

    @Override
    @Transactional
    public void updateDelFlagByIds(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.labelCategoryRepository.updateDelFlagByIds(ids);
    }

    @Override
    public List<LabelCategoryVo> findByConditions() {
        ArrayList<LabelCategoryVo> listVo = new ArrayList<LabelCategoryVo>();
        List<LabelCategory> list = this.labelCategoryRepository.findByConditions();
        for (LabelCategory labelCategory : list) {
            LabelCategoryVo labelCategoryVo = new LabelCategoryVo();
            labelCategoryVo.setName(labelCategory.getName());
            labelCategoryVo.setTenantCode(labelCategory.getTenantCode());
            listVo.add(labelCategoryVo);
        }
        return listVo;
    }

    @Override
    public void updateSort(String id, Integer sort) {
        LabelCategory labelCategory = (LabelCategory)((Object)this.labelCategoryMapper.selectById((Serializable)((Object)id)));
        if (sort + labelCategory.getSort() < 1) {
            this.labelCategoryRepository.updateSort(id, 1);
        } else {
            this.labelCategoryRepository.updateSort(id, sort + labelCategory.getSort());
        }
    }

    @Override
    public List<LabelCategoryVo> labelCategoryAll() {
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.labelCategoryRepository.lambdaQuery().eq(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.ENABLE.getCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).orderByAsc(LabelCategory::getSort)).list();
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)list, LabelCategory.class, LabelCategoryVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    @Override
    public List<LabelCategoryVo> labelAll(LabelCategoryVo vo) {
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.labelCategoryRepository.lambdaQuery().eq(StringUtils.isNotBlank((CharSequence)vo.getCode()), LabelCategory::getCode, (Object)vo.getCode())).eq(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.ENABLE.getCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).orderByAsc(LabelCategory::getSort)).list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Lists.newArrayList();
        }
        List labelCategoryVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)list, LabelCategory.class, LabelCategoryVo.class, HashSet.class, ArrayList.class, new String[0]);
        if (CollectionUtils.isNotEmpty((Collection)labelCategoryVos)) {
            for (LabelCategoryVo labelCategoryVo : labelCategoryVos) {
                List labelList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.labelRepository.lambdaQuery().eq(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.ENABLE.getCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(Label::getType, (Object)LabelManageEnum.AUTOMATIC_LABEL.getValue())).eq(Label::getCategoryCode, (Object)labelCategoryVo.getCode())).list();
                if (CollectionUtils.isNotEmpty((Collection)labelList)) {
                    ArrayList labelVos = Lists.newArrayList();
                    for (Label label : labelList) {
                        LabelVo labelVo = new LabelVo();
                        labelVo.setCode(label.getCode());
                        labelVo.setName(label.getName());
                        labelVo.setType(label.getType());
                        labelVos.add(labelVo);
                    }
                    labelCategoryVo.setList((List)labelVos);
                    continue;
                }
                labelCategoryVo.setList((List)Lists.newArrayList());
            }
        }
        return labelCategoryVos;
    }
}

