/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.member.business.member.local.service.internal;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.member.business.member.local.entity.Label;
import com.biz.crm.member.business.member.local.entity.LabelDetail;
import com.biz.crm.member.business.member.local.repository.LabelDetailRepository;
import com.biz.crm.member.business.member.local.repository.LabelRepository;
import com.biz.crm.member.business.member.local.service.LabelService;
import com.biz.crm.member.business.member.sdk.dto.LabelPaginationDto;
import com.biz.crm.member.business.member.sdk.enums.LabelDetailEnum;
import com.biz.crm.member.business.member.sdk.vo.LabelDetailVo;
import com.biz.crm.member.business.member.sdk.vo.LabelVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="labelService")
public class LabelServiceImpl
implements LabelService {
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private LabelRepository labelRepository;
    @Autowired
    private LabelDetailRepository labelDetailRepository;
    @Autowired
    private GenerateCodeService generateCodeService;

    @Override
    public Page<LabelVo> findByConditions(Pageable pageable, LabelPaginationDto labelPaginationDto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        labelPaginationDto = Optional.ofNullable(labelPaginationDto).orElse(new LabelPaginationDto());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.labelRepository.findByConditions((Page<LabelVo>)page, labelPaginationDto);
    }

    @Override
    @Transactional
    public void create(LabelVo labelVo) {
        this.createValidation(labelVo);
        Label label = (Label)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)labelVo, Label.class, HashSet.class, LinkedList.class, new String[0]));
        String labelCode = (String)this.generateCodeService.generateCode("LM", 5).get(0);
        label.setCode(labelCode);
        label.setTenantCode(TenantUtils.getTenantCode());
        label.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        label.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        this.labelRepository.saveOrUpdate((Object)label);
        if (CollectionUtils.isNotEmpty((Collection)labelVo.getConditions())) {
            for (LabelDetailVo condition : labelVo.getConditions()) {
                LabelDetail labelDetail = (LabelDetail)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)condition, LabelDetail.class, HashSet.class, LinkedList.class, new String[0]));
                labelDetail.setId(null);
                labelDetail.setLabelCode(labelCode);
                labelDetail.setTenantCode(TenantUtils.getTenantCode());
                labelDetail.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                labelDetail.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                this.labelDetailRepository.insert(labelDetail);
            }
        }
    }

    @Override
    @Transactional
    public void update(LabelVo labelVo) {
        this.updateValidation(labelVo);
        String currentId = labelVo.getId();
        Label current = this.labelRepository.selectById(currentId);
        current = (Label)((Object)Validate.notNull((Object)((Object)current), (String)"\u4fee\u6539\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]));
        current = (Label)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)labelVo, Label.class, HashSet.class, LinkedList.class, new String[0]));
        this.labelRepository.saveOrUpdate((Object)current);
        List list = ((LambdaQueryChainWrapper)this.labelDetailRepository.lambdaQuery().eq(LabelDetail::getLabelCode, (Object)current.getCode())).list();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            Set ids = list.stream().map(UuidEntity::getId).collect(Collectors.toSet());
            this.labelDetailRepository.removeByIds(ids);
        }
        if (CollectionUtils.isNotEmpty((Collection)labelVo.getConditions())) {
            for (LabelDetailVo condition : labelVo.getConditions()) {
                LabelDetail labelDetail = (LabelDetail)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)condition, LabelDetail.class, HashSet.class, LinkedList.class, new String[0]));
                labelDetail.setId(null);
                labelDetail.setLabelCode(current.getCode());
                labelDetail.setTenantCode(TenantUtils.getTenantCode());
                labelDetail.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                labelDetail.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                this.labelDetailRepository.insert(labelDetail);
            }
        }
    }

    @Override
    public LabelVo findDetailById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        Label label = this.labelRepository.selectById(id);
        Validate.notNull((Object)((Object)label), (String)"\u6807\u7b7e\u672a\u627e\u5230", (Object[])new Object[0]);
        LabelVo labelVo = (LabelVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)label, LabelVo.class, HashSet.class, LinkedList.class, new String[0]);
        List list = ((LambdaQueryChainWrapper)this.labelDetailRepository.lambdaQuery().eq(LabelDetail::getLabelCode, (Object)label.getCode())).list();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            labelVo.setConditions((List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)list, LabelDetail.class, LabelDetailVo.class, HashSet.class, ArrayList.class, new String[0]));
        } else {
            labelVo.setConditions((List)Lists.newArrayList());
        }
        return labelVo;
    }

    @Override
    @Transactional
    public void enableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.labelRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
    }

    @Override
    @Transactional
    public void disableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.labelRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
    }

    @Override
    @Transactional
    public void updateDelFlagByIds(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.labelRepository.updateDelFlagByIds(ids);
    }

    private void createValidation(LabelVo labelVo) {
        this.validation(labelVo);
    }

    private void updateValidation(LabelVo labelVo) {
        this.validation(labelVo);
    }

    private void validation(LabelVo labelVo) {
        Validate.notBlank((CharSequence)labelVo.getName(), (String)"\u6807\u7b7e\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)labelVo.getType(), (String)"\u6807\u7b7e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)labelVo.getCategoryCode(), (String)"\u6807\u7b7e\u5206\u7c7b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)labelVo.getCategoryName(), (String)"\u6807\u7b7e\u5206\u7c7b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (!Objects.equals("0", labelVo.getType())) {
            if (Objects.equals("1", labelVo.getType())) {
                Validate.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)labelVo.getConditions()), (String)"\u81ea\u52a8\u6807\u7b7e\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                for (LabelDetailVo condition : labelVo.getConditions()) {
                    Validate.notBlank((CharSequence)condition.getConditionType(), (String)"\u6761\u4ef6\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                    if (Objects.equals(LabelDetailEnum.LAST_SIGN_DAY.getValue(), condition.getConditionType())) {
                        Validate.notNull((Object)condition.getMin(), (String)"\u6700\u8fd1\u7b7e\u6536\u65f6\u95f4X\u5929\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                        continue;
                    }
                    if (Objects.equals(LabelDetailEnum.CONTINUOUS_YEAR.getValue(), condition.getConditionType())) {
                        Validate.notNull((Object)condition.getMin(), (String)"\u4f1a\u5458\u7b49\u7ea7\u8fde\u7eedX\u5e74\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                        Validate.notBlank((CharSequence)condition.getLevelCode(), (String)"\u8bf7\u9009\u62e9\u7b49\u7ea7", (Object[])new Object[0]);
                        Validate.notBlank((CharSequence)condition.getLevelName(), (String)"\u8bf7\u9009\u62e9\u7b49\u7ea7", (Object[])new Object[0]);
                        continue;
                    }
                    Validate.notNull((Object)condition.getMin(), (String)"\u6700\u5c0f\u533a\u95f4\u503c\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                    Validate.notNull((Object)condition.getMax(), (String)"\u6700\u5927\u533a\u95f4\u503c\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                    Validate.isTrue((condition.getMin() < condition.getMax() ? 1 : 0) != 0, (String)"\u6700\u5c0f\u533a\u95f4\u503c\u4e0d\u80fd\u5927\u4e8e\u6700\u5927\u533a\u95f4\u503c", (Object[])new Object[0]);
                }
            } else {
                Validate.isTrue((boolean)false, (String)"\u6807\u7b7e\u7c7b\u578b\u5f02\u5e38", (Object[])new Object[0]);
            }
        }
    }
}

