/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.member.business.member.local.service.internal;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.member.business.member.local.entity.LevelManageBenefitsDetail;
import com.biz.crm.member.business.member.local.repository.LevelManageBenefitsDetailRepository;
import com.biz.crm.member.business.member.local.service.LevelManageBenefitsDetailService;
import com.biz.crm.member.business.member.sdk.dto.LevelManageBenefitsDetailPaginationDto;
import com.biz.crm.member.business.member.sdk.event.LevelManageBenefitsDetailEventListener;
import com.biz.crm.member.business.member.sdk.vo.LevelManageBenefitsDetailVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="levelManageBenefitsDetailService")
public class LevelManageBenefitsDetailServiceImpl
implements LevelManageBenefitsDetailService {
    private static final Logger log = LoggerFactory.getLogger(LevelManageBenefitsDetailServiceImpl.class);
    @Autowired(required=false)
    private LevelManageBenefitsDetailRepository levelManageBenefitsDetailRepository;
    @Autowired(required=false)
    private List<LevelManageBenefitsDetailEventListener> eventListeners;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public Page<LevelManageBenefitsDetailVo> findByConditions(Pageable pageable, LevelManageBenefitsDetailPaginationDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        dto = Optional.ofNullable(dto).orElse(new LevelManageBenefitsDetailPaginationDto());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.levelManageBenefitsDetailRepository.findByConditions((Page<LevelManageBenefitsDetailVo>)page, dto);
    }

    @Override
    public LevelManageBenefitsDetailVo findDetailById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        LevelManageBenefitsDetail levelManageBenefitsDetail = this.levelManageBenefitsDetailRepository.findById(id);
        LevelManageBenefitsDetailVo levelManageBenefitsDetailVo = (LevelManageBenefitsDetailVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)levelManageBenefitsDetail, LevelManageBenefitsDetailVo.class, HashSet.class, LinkedList.class, new String[0]);
        return levelManageBenefitsDetailVo;
    }

    @Override
    @Transactional
    public LevelManageBenefitsDetailVo create(LevelManageBenefitsDetailVo levelManageBenefitsDetailVo) {
        this.createValidation(levelManageBenefitsDetailVo);
        LevelManageBenefitsDetail levelManageBenefitsDetail = (LevelManageBenefitsDetail)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)levelManageBenefitsDetailVo, LevelManageBenefitsDetail.class, HashSet.class, LinkedList.class, new String[0]));
        levelManageBenefitsDetail.setTenantCode(TenantUtils.getTenantCode());
        levelManageBenefitsDetail.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        levelManageBenefitsDetail.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        this.levelManageBenefitsDetailRepository.saveOrUpdate((Object)levelManageBenefitsDetail);
        return levelManageBenefitsDetailVo;
    }

    @Override
    @Transactional
    public LevelManageBenefitsDetailVo update(LevelManageBenefitsDetailVo levelManageBenefitsDetailVo) {
        this.updateValidation(levelManageBenefitsDetailVo);
        String currentId = levelManageBenefitsDetailVo.getId();
        LevelManageBenefitsDetail current = this.levelManageBenefitsDetailRepository.findById(currentId);
        current = (LevelManageBenefitsDetail)((Object)Validate.notNull((Object)((Object)current), (String)"\u4fee\u6539\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]));
        current = (LevelManageBenefitsDetail)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)levelManageBenefitsDetailVo, LevelManageBenefitsDetail.class, HashSet.class, LinkedList.class, new String[0]));
        this.levelManageBenefitsDetailRepository.saveOrUpdate((Object)current);
        return levelManageBenefitsDetailVo;
    }

    @Override
    @Transactional
    public void enableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.levelManageBenefitsDetailRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
    }

    @Override
    @Transactional
    public void disableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.levelManageBenefitsDetailRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
    }

    @Override
    @Transactional
    public void updateDelFlagByIds(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.levelManageBenefitsDetailRepository.updateDelFlagByIds(ids);
    }

    @Override
    @Transactional
    public void saveBatch(List<LevelManageBenefitsDetailVo> levelManageBenefitsDetailVos) {
        ArrayList saveList = Lists.newArrayList();
        for (LevelManageBenefitsDetailVo levelManageBenefitsDetailVo : levelManageBenefitsDetailVos) {
            this.validation(levelManageBenefitsDetailVo);
            LevelManageBenefitsDetail levelManageBenefitsDetail = (LevelManageBenefitsDetail)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)levelManageBenefitsDetailVo, LevelManageBenefitsDetail.class, HashSet.class, LinkedList.class, new String[0]));
            levelManageBenefitsDetail.setTenantCode(TenantUtils.getTenantCode());
            levelManageBenefitsDetail.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            levelManageBenefitsDetail.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            saveList.add(levelManageBenefitsDetail);
        }
        this.levelManageBenefitsDetailRepository.saveBatch(saveList);
    }

    @Override
    public List<LevelManageBenefitsDetailVo> findListDetailById(String levelCode, String code) {
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.levelManageBenefitsDetailRepository.lambdaQuery().eq(LevelManageBenefitsDetail::getLevelCode, (Object)levelCode)).eq(LevelManageBenefitsDetail::getLevelManageBenefitsCode, (Object)code)).orderByAsc(LevelManageBenefitsDetail::getSeq)).list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Lists.newArrayList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)list, LevelManageBenefitsDetail.class, LevelManageBenefitsDetailVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    @Override
    public void del(Set<String> ids) {
        this.levelManageBenefitsDetailRepository.removeByIds(ids);
    }

    @Override
    public List<LevelManageBenefitsDetailVo> findListDetailByLevelCodeAndCode(Set<String> bLevelCodes, List<String> codes) {
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.levelManageBenefitsDetailRepository.lambdaQuery().in(LevelManageBenefitsDetail::getLevelCode, bLevelCodes)).in(LevelManageBenefitsDetail::getLevelManageBenefitsCode, codes)).list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Lists.newArrayList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)list, LevelManageBenefitsDetail.class, LevelManageBenefitsDetailVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    private void createValidation(LevelManageBenefitsDetailVo levelManageBenefitsDetailVo) {
        this.validation(levelManageBenefitsDetailVo);
    }

    private void updateValidation(LevelManageBenefitsDetailVo levelManageBenefitsDetailVo) {
        this.validation(levelManageBenefitsDetailVo);
    }

    private void validation(LevelManageBenefitsDetailVo levelManageBenefitsDetailVo) {
        Validate.notBlank((CharSequence)levelManageBenefitsDetailVo.getLevelManageBenefitsCode(), (String)"\u5173\u8054\u6743\u76ca\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)levelManageBenefitsDetailVo.getCode(), (String)"\u6743\u76ca\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)levelManageBenefitsDetailVo.getName(), (String)"\u6743\u76ca\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)levelManageBenefitsDetailVo.getType(), (String)"\u6743\u76ca\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)levelManageBenefitsDetailVo.getSeq(), (String)"\u5e8f\u5217\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)levelManageBenefitsDetailVo.getNum(), (String)"\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }
}

