/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.member.business.member.local.service.internal;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.member.business.member.local.entity.LevelManageBenefits;
import com.biz.crm.member.business.member.local.repository.LevelManageBenefitsRepository;
import com.biz.crm.member.business.member.local.service.LevelManageBenefitsService;
import com.biz.crm.member.business.member.sdk.dto.LevelManageBenefitsPaginationDto;
import com.biz.crm.member.business.member.sdk.event.LevelManageBenefitsEventListener;
import com.biz.crm.member.business.member.sdk.vo.LevelManageBenefitsVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="levelManageBenefitsService")
public class LevelManageBenefitsServiceImpl
implements LevelManageBenefitsService {
    private static final Logger log = LoggerFactory.getLogger(LevelManageBenefitsServiceImpl.class);
    @Autowired(required=false)
    private LevelManageBenefitsRepository levelManageBenefitsRepository;
    @Autowired(required=false)
    private List<LevelManageBenefitsEventListener> eventListeners;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public Page<LevelManageBenefitsVo> findByConditions(Pageable pageable, LevelManageBenefitsPaginationDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        dto = Optional.ofNullable(dto).orElse(new LevelManageBenefitsPaginationDto());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.levelManageBenefitsRepository.findByConditions((Page<LevelManageBenefitsVo>)page, dto);
    }

    @Override
    public LevelManageBenefitsVo findDetailById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        LevelManageBenefits levelManageBenefits = this.levelManageBenefitsRepository.findById(id);
        LevelManageBenefitsVo levelManageBenefitsVo = (LevelManageBenefitsVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)levelManageBenefits, LevelManageBenefitsVo.class, HashSet.class, LinkedList.class, new String[0]);
        return levelManageBenefitsVo;
    }

    @Override
    @Transactional
    public LevelManageBenefitsVo create(LevelManageBenefitsVo levelManageBenefitsVo) {
        this.createValidation(levelManageBenefitsVo);
        LevelManageBenefits levelManageBenefits = (LevelManageBenefits)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)levelManageBenefitsVo, LevelManageBenefits.class, HashSet.class, LinkedList.class, new String[0]));
        levelManageBenefits.setTenantCode(TenantUtils.getTenantCode());
        levelManageBenefits.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        levelManageBenefits.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        this.levelManageBenefitsRepository.saveOrUpdate((Object)levelManageBenefits);
        return levelManageBenefitsVo;
    }

    @Override
    @Transactional
    public LevelManageBenefitsVo update(LevelManageBenefitsVo levelManageBenefitsVo) {
        return levelManageBenefitsVo;
    }

    @Override
    @Transactional
    public void enableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.levelManageBenefitsRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
    }

    @Override
    @Transactional
    public void disableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.levelManageBenefitsRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
    }

    @Override
    @Transactional
    public void updateDelFlagByIds(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.levelManageBenefitsRepository.updateDelFlagByIds(ids);
    }

    @Override
    public List<LevelManageBenefitsVo> findListDetailById(String levelCode) {
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.levelManageBenefitsRepository.lambdaQuery().eq(LevelManageBenefits::getLevelCode, (Object)levelCode)).orderByAsc(LevelManageBenefits::getSeq)).list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Lists.newArrayList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)list, LevelManageBenefits.class, LevelManageBenefitsVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    private void createValidation(LevelManageBenefitsVo levelManageBenefitsVo) {
        this.validation(levelManageBenefitsVo);
    }

    private void updateValidation(LevelManageBenefitsVo levelManageBenefitsVo) {
        this.validation(levelManageBenefitsVo);
    }

    private void validation(LevelManageBenefitsVo levelManageBenefitsVo) {
        Validate.notBlank((CharSequence)levelManageBenefitsVo.getLevelCode(), (String)"\u5173\u8054\u7b49\u7ea7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)levelManageBenefitsVo.getCode(), (String)"\u6743\u76ca\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)levelManageBenefitsVo.getSeq(), (String)"\u5e8f\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (levelManageBenefitsVo.getSeq() == 1) {
            Validate.notNull((Object)levelManageBenefitsVo.getYearNum(), (String)"\u8fde\u7eedx\u5e74\u8be5\u7b49\u7ea7\u4f1a\u5458\u4ee5\u4e0a\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        } else {
            Validate.notBlank((CharSequence)levelManageBenefitsVo.getName(), (String)"\u6743\u76ca\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
    }
}

