/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.member.business.member.local.service.internal;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.vo.UuidVo;
import com.biz.crm.member.business.member.local.entity.LevelManage;
import com.biz.crm.member.business.member.local.repository.LevelManageRepository;
import com.biz.crm.member.business.member.local.service.BenefitsManageService;
import com.biz.crm.member.business.member.local.service.LevelManageBenefitsDetailService;
import com.biz.crm.member.business.member.local.service.LevelManageBenefitsService;
import com.biz.crm.member.business.member.local.service.LevelManageService;
import com.biz.crm.member.business.member.local.service.SystemSettingsService;
import com.biz.crm.member.business.member.sdk.dto.LevelManagePaginationDto;
import com.biz.crm.member.business.member.sdk.enums.CpsYesOrNoEnum;
import com.biz.crm.member.business.member.sdk.event.LevelManageEventListener;
import com.biz.crm.member.business.member.sdk.vo.BenefitsManageVo;
import com.biz.crm.member.business.member.sdk.vo.LevelManageBenefitsDetailVo;
import com.biz.crm.member.business.member.sdk.vo.LevelManageBenefitsVo;
import com.biz.crm.member.business.member.sdk.vo.LevelManageVo;
import com.biz.crm.member.business.member.sdk.vo.SystemSettingsReservedVo;
import com.biz.crm.member.business.member.sdk.vo.applet.AppletLevelBenefitsDetailsVo;
import com.biz.crm.member.business.member.sdk.vo.applet.AppletLevelBenefitsVo;
import com.biz.crm.member.business.member.sdk.vo.applet.AppletLevelManageVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="levelManageService")
public class LevelManageServiceImpl
implements LevelManageService {
    private static final Logger log = LoggerFactory.getLogger(LevelManageServiceImpl.class);
    @Autowired(required=false)
    private LevelManageRepository levelManageRepository;
    @Autowired(required=false)
    private List<LevelManageEventListener> eventListeners;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private LevelManageBenefitsService levelManageBenefitsService;
    @Autowired
    private LevelManageBenefitsDetailService levelManageBenefitsDetailService;
    @Autowired
    private SystemSettingsService systemSettingsService;
    @Autowired
    private BenefitsManageService benefitsManageService;

    @Override
    public Page<LevelManageVo> findByConditions(Pageable pageable, LevelManagePaginationDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        dto = Optional.ofNullable(dto).orElse(new LevelManagePaginationDto());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.levelManageRepository.findByConditions((Page<LevelManageVo>)page, dto);
    }

    @Override
    public LevelManageVo findDetailById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        LevelManage levelManage = this.levelManageRepository.findById(id);
        levelManage = Optional.ofNullable(levelManage).orElse(new LevelManage());
        LevelManageVo levelManageVo = (LevelManageVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)levelManage, LevelManageVo.class, HashSet.class, LinkedList.class, new String[0]);
        List<LevelManageBenefitsVo> levelManageBenefitsVoList = this.levelManageBenefitsService.findListDetailById(levelManage.getLevelCode());
        if (CollectionUtils.isNotEmpty(levelManageBenefitsVoList)) {
            for (LevelManageBenefitsVo levelManageBenefitsVo : levelManageBenefitsVoList) {
                List<LevelManageBenefitsDetailVo> levelManageBenefitsDetailVoList = this.levelManageBenefitsDetailService.findListDetailById(levelManageVo.getLevelCode(), levelManageBenefitsVo.getCode());
                levelManageBenefitsVo.setList(levelManageBenefitsDetailVoList);
            }
        }
        levelManageVo.setList(levelManageBenefitsVoList);
        return levelManageVo;
    }

    @Override
    public LevelManageVo findDetailByLevelCode(String levelCode) {
        if (StringUtils.isBlank((CharSequence)levelCode)) {
            return null;
        }
        LevelManage levelManage = (LevelManage)((Object)((LambdaQueryChainWrapper)this.levelManageRepository.lambdaQuery().eq(LevelManage::getLevelCode, (Object)levelCode)).one());
        LevelManageVo levelManageVo = (LevelManageVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)levelManage, LevelManageVo.class, HashSet.class, LinkedList.class, new String[0]);
        return levelManageVo;
    }

    @Override
    @Transactional
    public LevelManageVo create(LevelManageVo levelManageVo) {
        this.createValidation(levelManageVo);
        LevelManage levelManage = (LevelManage)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)levelManageVo, LevelManage.class, HashSet.class, LinkedList.class, new String[0]));
        levelManage.setTenantCode(TenantUtils.getTenantCode());
        levelManage.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        levelManage.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        levelManage.setLevelCode((String)this.generateCodeService.generateCode("VIP", 5).get(0));
        this.levelManageRepository.saveOrUpdate((Object)levelManage);
        int benefitsCount = 1;
        for (LevelManageBenefitsVo levelManageBenefitsVo : levelManageVo.getList()) {
            levelManageBenefitsVo.setLevelCode(levelManage.getLevelCode());
            levelManageBenefitsVo.setSeq(Integer.valueOf(benefitsCount++));
            levelManageBenefitsVo.setFlagFixed(benefitsCount < 3 ? CpsYesOrNoEnum.YES.getValue() : CpsYesOrNoEnum.NO.getValue());
            this.levelManageBenefitsService.create(levelManageBenefitsVo);
            if (!CollectionUtils.isNotEmpty((Collection)levelManageBenefitsVo.getList())) continue;
            ArrayList levelManageBenefitsDetailVos = Lists.newArrayList();
            int benefitsDetailCount = 1;
            for (LevelManageBenefitsDetailVo levelManageBenefitsDetailVo : levelManageBenefitsVo.getList()) {
                levelManageBenefitsDetailVo.setLevelCode(levelManage.getLevelCode());
                levelManageBenefitsDetailVo.setLevelManageBenefitsCode(levelManageBenefitsVo.getCode());
                levelManageBenefitsDetailVo.setSeq(Integer.valueOf(benefitsDetailCount++));
                levelManageBenefitsDetailVos.add(levelManageBenefitsDetailVo);
            }
            this.levelManageBenefitsDetailService.saveBatch(levelManageBenefitsDetailVos);
        }
        return levelManageVo;
    }

    @Override
    @Transactional
    public LevelManageVo update(LevelManageVo levelManageVo) {
        String currentId = levelManageVo.getId();
        LevelManage current = this.levelManageRepository.findById(currentId);
        current = (LevelManage)((Object)Validate.notNull((Object)((Object)current), (String)"\u4fee\u6539\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]));
        levelManageVo.setLevelCode(current.getLevelCode());
        this.updateValidation(levelManageVo);
        current = (LevelManage)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)levelManageVo, LevelManage.class, HashSet.class, LinkedList.class, new String[0]));
        this.levelManageRepository.saveOrUpdate((Object)current);
        for (LevelManageBenefitsVo levelManageBenefitsVo : levelManageVo.getList()) {
            if (!CollectionUtils.isNotEmpty((Collection)levelManageBenefitsVo.getList())) continue;
            List<LevelManageBenefitsDetailVo> oldList = this.levelManageBenefitsDetailService.findListDetailById(current.getLevelCode(), levelManageBenefitsVo.getCode());
            if (CollectionUtils.isNotEmpty(oldList)) {
                this.levelManageBenefitsDetailService.del(oldList.stream().map(UuidVo::getId).collect(Collectors.toSet()));
            }
            ArrayList levelManageBenefitsDetailVos = Lists.newArrayList();
            int benefitsDetailCount = 1;
            for (LevelManageBenefitsDetailVo levelManageBenefitsDetailVo : levelManageBenefitsVo.getList()) {
                levelManageBenefitsDetailVo.setId(null);
                levelManageBenefitsDetailVo.setLevelCode(current.getLevelCode());
                levelManageBenefitsDetailVo.setLevelManageBenefitsCode(levelManageBenefitsVo.getCode());
                levelManageBenefitsDetailVo.setSeq(Integer.valueOf(benefitsDetailCount++));
                levelManageBenefitsDetailVos.add(levelManageBenefitsDetailVo);
            }
            this.levelManageBenefitsDetailService.saveBatch(levelManageBenefitsDetailVos);
        }
        return levelManageVo;
    }

    @Override
    @Transactional
    public void enableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List list1 = ((LambdaQueryChainWrapper)this.levelManageRepository.lambdaQuery().in(UuidEntity::getId, ids)).list();
        if (CollectionUtils.isNotEmpty((Collection)list1)) {
            for (LevelManage levelManage : list1) {
                LevelManageVo levelManageVo = new LevelManageVo();
                levelManageVo.setGrowStart(levelManage.getGrowStart());
                levelManageVo.setGrowEnd(levelManage.getGrowEnd());
                List<LevelManage> list = this.levelManageRepository.checkGrow(levelManageVo);
                Validate.isTrue((boolean)CollectionUtils.isEmpty(list), (String)"\u6210\u957f\u503c\u533a\u95f4\u91cd\u53e0,\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
            }
        }
        this.levelManageRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
    }

    @Override
    @Transactional
    public void disableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.levelManageRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
    }

    @Override
    @Transactional
    public void updateDelFlagByIds(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.levelManageRepository.updateDelFlagByIds(ids);
    }

    @Override
    public List<LevelManageVo> allList() {
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.levelManageRepository.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.ENABLE.getCode())).orderByAsc(LevelManage::getLevelNum)).list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Lists.newArrayList();
        }
        ArrayList levelManageVoList = Lists.newArrayList();
        for (LevelManage levelManage : list) {
            LevelManageVo levelManageVo = new LevelManageVo();
            levelManageVo.setLevelCode(levelManage.getLevelCode());
            levelManageVo.setLevelName(levelManage.getLevelName());
            levelManageVo.setLevelNum(levelManage.getLevelNum());
            levelManageVoList.add(levelManageVo);
        }
        return levelManageVoList;
    }

    @Override
    public LevelManageVo nextLevelManage(LevelManageVo levelManageVo) {
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.levelManageRepository.lambdaQuery().eq(LevelManage::getLevelNum, (Object)(levelManageVo.getLevelNum() + 1))).eq(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.ENABLE.getCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).orderByDesc(UuidOpEntity::getCreateTime)).list();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return (LevelManageVo)this.nebulaToolkitService.copyObjectByWhiteList(list.get(0), LevelManageVo.class, HashSet.class, LinkedList.class, new String[0]);
        }
        return null;
    }

    @Override
    public List<AppletLevelManageVo> getMemberLevelAll(String memberCode) {
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.levelManageRepository.lambdaQuery().eq(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.ENABLE.getCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).orderByAsc(LevelManage::getLevelNum)).list();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            List appletLevelManageVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)list, LevelManage.class, AppletLevelManageVo.class, HashSet.class, ArrayList.class, new String[0]);
            return appletLevelManageVos;
        }
        return Lists.newArrayList();
    }

    @Override
    public List<AppletLevelManageVo> getAllChildrenIncludeMe(String memberLevelCode) {
        if (StringUtils.isEmpty((CharSequence)memberLevelCode)) {
            return Lists.newArrayList();
        }
        Integer levelNum = ((LevelManage)((Object)((LambdaQueryChainWrapper)this.levelManageRepository.lambdaQuery().eq(LevelManage::getLevelCode, (Object)memberLevelCode)).one())).getLevelNum();
        List manageList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.levelManageRepository.lambdaQuery().eq(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.ENABLE.getCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).le(LevelManage::getLevelNum, (Object)levelNum)).orderByAsc(LevelManage::getLevelNum)).list();
        if (CollectionUtils.isNotEmpty((Collection)manageList)) {
            List allChildrenIncludeMe = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)manageList, LevelManage.class, AppletLevelManageVo.class, HashSet.class, ArrayList.class, new String[0]);
            return allChildrenIncludeMe;
        }
        return Lists.newArrayList();
    }

    @Override
    public List<AppletLevelBenefitsVo> getMemberBenefitsList(String levelCode, String memberCode) {
        Validate.notBlank((CharSequence)levelCode, (String)"\u8bf7\u9009\u62e9\u7b49\u7ea7\u5361\u7247\u7f16\u7801", (Object[])new Object[0]);
        LevelManage levelManage = (LevelManage)((Object)((LambdaQueryChainWrapper)this.levelManageRepository.lambdaQuery().eq(LevelManage::getLevelCode, (Object)levelCode)).one());
        Validate.notNull((Object)((Object)levelManage), (String)"\u7b49\u7ea7\u5f02\u5e38", (Object[])new Object[0]);
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.levelManageRepository.lambdaQuery().le(LevelManage::getLevelNum, (Object)levelManage.getLevelNum())).eq(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.ENABLE.getCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Lists.newArrayList();
        }
        HashSet bLevelCodes = Sets.newHashSet();
        bLevelCodes.add(levelCode);
        List<LevelManageBenefitsDetailVo> blist = this.levelManageBenefitsDetailService.findListDetailByLevelCodeAndCode(bLevelCodes, Arrays.asList("B"));
        Set<String> levelCodeSets = list.stream().map(LevelManage::getLevelCode).collect(Collectors.toSet());
        List<LevelManageBenefitsDetailVo> olist = this.levelManageBenefitsDetailService.findListDetailByLevelCodeAndCode(levelCodeSets, Arrays.asList("C", "D"));
        Map<String, List<LevelManageBenefitsDetailVo>> otherLevelManageBenefitsDetailVoMap = olist.stream().collect(Collectors.groupingBy(LevelManageBenefitsDetailVo::getLevelManageBenefitsCode));
        HashSet benefitsCodes = Sets.newHashSet();
        if (CollectionUtils.isNotEmpty(blist)) {
            benefitsCodes.add(blist.get(0).getCode());
        }
        if (CollectionUtils.isNotEmpty(olist)) {
            Set codes = olist.stream().map(LevelManageBenefitsDetailVo::getCode).collect(Collectors.toSet());
            benefitsCodes.addAll(codes);
        }
        List<BenefitsManageVo> benefitsManageVoList = this.benefitsManageService.findDetailByCodes(benefitsCodes);
        Map benefitsManageVoMap = benefitsManageVoList.stream().collect(Collectors.toMap(BenefitsManageVo::getCode, Function.identity()));
        ArrayList resultList = Lists.newArrayList();
        List<SystemSettingsReservedVo> reserved = this.systemSettingsService.findReserved();
        if (CollectionUtils.isNotEmpty(reserved)) {
            reserved.sort(Comparator.comparing(SystemSettingsReservedVo::getReservedFieldsOne));
            for (SystemSettingsReservedVo systemSettingsReservedVo : reserved) {
                AppletLevelBenefitsDetailsVo appletLevelBenefitsDetailsVo;
                if (Objects.equals("A", systemSettingsReservedVo.getReservedFieldsOne())) continue;
                AppletLevelBenefitsVo appletLevelBenefitsVo = new AppletLevelBenefitsVo();
                appletLevelBenefitsVo.setCode(systemSettingsReservedVo.getReservedFieldsOne());
                appletLevelBenefitsVo.setName(systemSettingsReservedVo.getTypeValue());
                ArrayList appletLevelBenefitsDetailsVos = Lists.newArrayList();
                if (Objects.equals("B", systemSettingsReservedVo.getReservedFieldsOne())) {
                    appletLevelBenefitsVo.setBNum(Integer.valueOf(blist.size()));
                    for (LevelManageBenefitsDetailVo levelManageBenefitsDetailVo : blist) {
                        appletLevelBenefitsDetailsVo = new AppletLevelBenefitsDetailsVo();
                        appletLevelBenefitsDetailsVo.setCode(levelManageBenefitsDetailVo.getCode());
                        BenefitsManageVo benefitsManageVo = (BenefitsManageVo)benefitsManageVoMap.get(levelManageBenefitsDetailVo.getCode());
                        if (benefitsManageVo != null) {
                            appletLevelBenefitsDetailsVo.setName(benefitsManageVo.getName());
                            appletLevelBenefitsDetailsVo.setProductDesc(benefitsManageVo.getProductDesc());
                            appletLevelBenefitsDetailsVo.setProductImage(benefitsManageVo.getProductImage());
                            appletLevelBenefitsDetailsVo.setUnit(benefitsManageVo.getUnit());
                        }
                        appletLevelBenefitsDetailsVo.setNum(levelManageBenefitsDetailVo.getNum());
                        appletLevelBenefitsDetailsVo.setRemarkDesc(levelManageBenefitsDetailVo.getRemarkDesc());
                        appletLevelBenefitsDetailsVos.add(appletLevelBenefitsDetailsVo);
                    }
                    appletLevelBenefitsVo.setList((List)appletLevelBenefitsDetailsVos);
                } else {
                    List<LevelManageBenefitsDetailVo> levelManageBenefitsDetailVos = otherLevelManageBenefitsDetailVoMap.get(systemSettingsReservedVo.getReservedFieldsOne());
                    appletLevelBenefitsVo.setBNum(Integer.valueOf(levelManageBenefitsDetailVos.size()));
                    for (LevelManageBenefitsDetailVo levelManageBenefitsDetailVo : levelManageBenefitsDetailVos) {
                        appletLevelBenefitsDetailsVo = new AppletLevelBenefitsDetailsVo();
                        appletLevelBenefitsDetailsVo.setCode(levelManageBenefitsDetailVo.getCode());
                        BenefitsManageVo benefitsManageVo = (BenefitsManageVo)benefitsManageVoMap.get(levelManageBenefitsDetailVo.getCode());
                        if (benefitsManageVo != null) {
                            appletLevelBenefitsDetailsVo.setName(benefitsManageVo.getName());
                            appletLevelBenefitsDetailsVo.setProductDesc(benefitsManageVo.getProductDesc());
                            appletLevelBenefitsDetailsVo.setProductImage(benefitsManageVo.getProductImage());
                            appletLevelBenefitsDetailsVo.setUnit(benefitsManageVo.getUnit());
                        }
                        appletLevelBenefitsDetailsVo.setNum(levelManageBenefitsDetailVo.getNum());
                        appletLevelBenefitsDetailsVo.setRemarkDesc(levelManageBenefitsDetailVo.getRemarkDesc());
                        appletLevelBenefitsDetailsVos.add(appletLevelBenefitsDetailsVo);
                    }
                    appletLevelBenefitsVo.setList((List)appletLevelBenefitsDetailsVos);
                }
                resultList.add(appletLevelBenefitsVo);
            }
        }
        return resultList;
    }

    private void createValidation(LevelManageVo levelManageVo) {
        this.validation(levelManageVo);
    }

    private void updateValidation(LevelManageVo levelManageVo) {
        this.validation(levelManageVo);
    }

    private void validation(LevelManageVo levelManageVo) {
        Validate.notNull((Object)levelManageVo.getLevelNum(), (String)"\u7b49\u7ea7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)levelManageVo.getLevelName(), (String)"\u7b49\u7ea7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)levelManageVo.getGrowStart(), (String)"\u6210\u957f\u503c\u533a\u95f4\u5f00\u59cb\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)levelManageVo.getCardImageOne(), (String)"\u7b2c\u4e00\u5e74\u8be5\u7b49\u7ea7\u5361\u7247\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)levelManageVo.getExpireDeductRatio(), (String)"\u5230\u671f\u6263\u9664\u6bd4\u4f8b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)levelManageVo.getActiveGrow(), (String)"\u6fc0\u6d3b\u6210\u957f\u503c\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<LevelManage> list = this.levelManageRepository.checkGrow(levelManageVo);
        Validate.isTrue((boolean)CollectionUtils.isEmpty(list), (String)"\u6210\u957f\u503c\u533a\u95f4\u91cd\u53e0,\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
    }
}

