/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.member.business.member.local.service.internal;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.member.business.member.local.entity.MemberInfoArchives;
import com.biz.crm.member.business.member.local.repository.MemberInfoArchivesRepository;
import com.biz.crm.member.business.member.local.service.MemberInfoArchivesService;
import com.biz.crm.member.business.member.sdk.dto.MemberInfoArchivesPaginationDto;
import com.biz.crm.member.business.member.sdk.event.MemberInfoArchivesEventListener;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoArchivesVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="memberInfoArchivesService")
public class MemberInfoArchivesServiceImpl
implements MemberInfoArchivesService {
    private static final Logger log = LoggerFactory.getLogger(MemberInfoArchivesServiceImpl.class);
    @Autowired(required=false)
    private MemberInfoArchivesRepository memberInfoArchivesRepository;
    @Autowired(required=false)
    private List<MemberInfoArchivesEventListener> eventListeners;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public Page<MemberInfoArchivesVo> findByConditions(Pageable pageable, MemberInfoArchivesPaginationDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        dto = Optional.ofNullable(dto).orElse(new MemberInfoArchivesPaginationDto());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.memberInfoArchivesRepository.findByConditions((Page<MemberInfoArchivesVo>)page, dto);
    }

    @Override
    public MemberInfoArchivesVo findDetailById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        MemberInfoArchives memberInfoArchives = this.memberInfoArchivesRepository.findById(id);
        MemberInfoArchivesVo memberInfoArchivesVo = (MemberInfoArchivesVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)memberInfoArchives, MemberInfoArchivesVo.class, HashSet.class, LinkedList.class, new String[0]);
        return memberInfoArchivesVo;
    }

    @Override
    public MemberInfoArchivesVo findDetailByMemberCode(String memberCode) {
        if (StringUtils.isBlank((CharSequence)memberCode)) {
            return null;
        }
        MemberInfoArchives memberInfoArchives = (MemberInfoArchives)((Object)((LambdaQueryChainWrapper)this.memberInfoArchivesRepository.lambdaQuery().eq(MemberInfoArchives::getMemberCode, (Object)memberCode)).one());
        MemberInfoArchivesVo memberInfoArchivesVo = (MemberInfoArchivesVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)memberInfoArchives, MemberInfoArchivesVo.class, HashSet.class, LinkedList.class, new String[0]);
        return memberInfoArchivesVo;
    }

    @Override
    @Transactional
    public MemberInfoArchivesVo create(MemberInfoArchivesVo memberInfoArchivesVo) {
        this.createValidation(memberInfoArchivesVo);
        MemberInfoArchives memberInfoArchives = (MemberInfoArchives)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)memberInfoArchivesVo, MemberInfoArchives.class, HashSet.class, LinkedList.class, new String[0]));
        memberInfoArchives.setTenantCode(TenantUtils.getTenantCode());
        memberInfoArchives.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        memberInfoArchives.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        this.memberInfoArchivesRepository.saveOrUpdate((Object)memberInfoArchives);
        return memberInfoArchivesVo;
    }

    @Override
    @Transactional
    public MemberInfoArchivesVo update(MemberInfoArchivesVo memberInfoArchivesVo) {
        this.updateValidation(memberInfoArchivesVo);
        String currentId = memberInfoArchivesVo.getId();
        MemberInfoArchives current = this.memberInfoArchivesRepository.findById(currentId);
        current = (MemberInfoArchives)((Object)Validate.notNull((Object)((Object)current), (String)"\u4fee\u6539\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]));
        current = (MemberInfoArchives)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)memberInfoArchivesVo, MemberInfoArchives.class, HashSet.class, LinkedList.class, new String[0]));
        this.memberInfoArchivesRepository.saveOrUpdate((Object)current);
        return memberInfoArchivesVo;
    }

    @Override
    @Transactional
    public void enableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.memberInfoArchivesRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
    }

    @Override
    @Transactional
    public void disableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.memberInfoArchivesRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
    }

    @Override
    @Transactional
    public void updateDelFlagByIds(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.memberInfoArchivesRepository.updateDelFlagByIds(ids);
    }

    private void createValidation(MemberInfoArchivesVo memberInfoArchivesVo) {
        this.validation(memberInfoArchivesVo);
    }

    private void updateValidation(MemberInfoArchivesVo memberInfoArchivesVo) {
        this.validation(memberInfoArchivesVo);
    }

    private void validation(MemberInfoArchivesVo memberInfoArchivesVo) {
    }
}

