/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.member.business.member.local.service.internal;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.member.business.member.local.entity.MemberInfoAssets;
import com.biz.crm.member.business.member.local.repository.MemberInfoAssetsRepository;
import com.biz.crm.member.business.member.local.service.MemberInfoAssetsService;
import com.biz.crm.member.business.member.sdk.dto.MemberInfoAssetsPaginationDto;
import com.biz.crm.member.business.member.sdk.event.MemberInfoAssetsEventListener;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoAssetsVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="memberInfoAssetsService")
public class MemberInfoAssetsServiceImpl
implements MemberInfoAssetsService {
    private static final Logger log = LoggerFactory.getLogger(MemberInfoAssetsServiceImpl.class);
    @Autowired(required=false)
    private MemberInfoAssetsRepository memberInfoAssetsRepository;
    @Autowired(required=false)
    private List<MemberInfoAssetsEventListener> eventListeners;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public Page<MemberInfoAssetsVo> findByConditions(Pageable pageable, MemberInfoAssetsPaginationDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        dto = Optional.ofNullable(dto).orElse(new MemberInfoAssetsPaginationDto());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.memberInfoAssetsRepository.findByConditions((Page<MemberInfoAssetsVo>)page, dto);
    }

    @Override
    public MemberInfoAssetsVo findDetailById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        MemberInfoAssets memberInfoAssets = this.memberInfoAssetsRepository.findById(id);
        MemberInfoAssetsVo memberInfoAssetsVo = (MemberInfoAssetsVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)memberInfoAssets, MemberInfoAssetsVo.class, HashSet.class, LinkedList.class, new String[0]);
        return memberInfoAssetsVo;
    }

    @Override
    public MemberInfoAssetsVo findDetailByMemberCode(String memberCode) {
        if (StringUtils.isBlank((CharSequence)memberCode)) {
            return null;
        }
        MemberInfoAssets memberInfoAssets = (MemberInfoAssets)((Object)((LambdaQueryChainWrapper)this.memberInfoAssetsRepository.lambdaQuery().eq(MemberInfoAssets::getMemberCode, (Object)memberCode)).one());
        MemberInfoAssetsVo memberInfoAssetsVo = (MemberInfoAssetsVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)memberInfoAssets, MemberInfoAssetsVo.class, HashSet.class, LinkedList.class, new String[0]);
        return memberInfoAssetsVo;
    }

    @Override
    @Transactional
    public MemberInfoAssetsVo create(MemberInfoAssetsVo memberInfoAssetsVo) {
        this.createValidation(memberInfoAssetsVo);
        MemberInfoAssets memberInfoAssets = (MemberInfoAssets)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)memberInfoAssetsVo, MemberInfoAssets.class, HashSet.class, LinkedList.class, new String[0]));
        memberInfoAssets.setTenantCode(TenantUtils.getTenantCode());
        memberInfoAssets.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        memberInfoAssets.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        this.memberInfoAssetsRepository.saveOrUpdate((Object)memberInfoAssets);
        return memberInfoAssetsVo;
    }

    @Override
    @Transactional
    public MemberInfoAssetsVo update(MemberInfoAssetsVo memberInfoAssetsVo) {
        this.updateValidation(memberInfoAssetsVo);
        String currentId = memberInfoAssetsVo.getId();
        MemberInfoAssets current = this.memberInfoAssetsRepository.findById(currentId);
        current = (MemberInfoAssets)((Object)Validate.notNull((Object)((Object)current), (String)"\u4fee\u6539\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]));
        current = (MemberInfoAssets)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)memberInfoAssetsVo, MemberInfoAssets.class, HashSet.class, LinkedList.class, new String[0]));
        this.memberInfoAssetsRepository.saveOrUpdate((Object)current);
        return memberInfoAssetsVo;
    }

    @Override
    @Transactional
    public void enableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.memberInfoAssetsRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
    }

    @Override
    @Transactional
    public void disableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.memberInfoAssetsRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
    }

    @Override
    @Transactional
    public void updateDelFlagByIds(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.memberInfoAssetsRepository.updateDelFlagByIds(ids);
    }

    private void createValidation(MemberInfoAssetsVo memberInfoAssetsVo) {
        this.validation(memberInfoAssetsVo);
    }

    private void updateValidation(MemberInfoAssetsVo memberInfoAssetsVo) {
        this.validation(memberInfoAssetsVo);
    }

    private void validation(MemberInfoAssetsVo memberInfoAssetsVo) {
    }
}

