/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.member.business.member.local.service.internal;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.member.business.member.local.entity.MemberInfoBenefits;
import com.biz.crm.member.business.member.local.repository.MemberInfoBenefitsRepository;
import com.biz.crm.member.business.member.local.service.DummyOrderService;
import com.biz.crm.member.business.member.local.service.DummyOrderUserService;
import com.biz.crm.member.business.member.local.service.MemberInfoBenefitsService;
import com.biz.crm.member.business.member.local.service.RealOrderService;
import com.biz.crm.member.business.member.sdk.dto.BenefitsRecordPaginationDto;
import com.biz.crm.member.business.member.sdk.dto.MemberInfoBenefitsPaginationDto;
import com.biz.crm.member.business.member.sdk.enums.BenefitsTypeEnum;
import com.biz.crm.member.business.member.sdk.enums.DummyOrderStatusEnum;
import com.biz.crm.member.business.member.sdk.enums.OrderSourceEnum;
import com.biz.crm.member.business.member.sdk.event.MemberInfoBenefitsEventListener;
import com.biz.crm.member.business.member.sdk.vo.DummyOrderVo;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoBenefitsVo;
import com.biz.crm.member.business.member.sdk.vo.RealOrderVo;
import com.biz.crm.member.business.member.sdk.vo.applet.AppletMemberInfoBenefits;
import com.biz.crm.member.business.member.sdk.vo.applet.AppletMemberInfoBenefitsReqVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="memberInfoBenefitsService")
public class MemberInfoBenefitsServiceImpl
implements MemberInfoBenefitsService {
    private static final Logger log = LoggerFactory.getLogger(MemberInfoBenefitsServiceImpl.class);
    @Autowired(required=false)
    private MemberInfoBenefitsRepository memberInfoBenefitsRepository;
    @Autowired(required=false)
    private List<MemberInfoBenefitsEventListener> eventListeners;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private DummyOrderUserService dummyOrderUserService;
    @Autowired
    private RealOrderService realOrderService;
    @Autowired
    private DummyOrderService dummyOrderService;

    @Override
    public Page<MemberInfoBenefitsVo> findByConditions(Pageable pageable, MemberInfoBenefitsPaginationDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        dto = Optional.ofNullable(dto).orElse(new MemberInfoBenefitsPaginationDto());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.memberInfoBenefitsRepository.findByConditions((Page<MemberInfoBenefitsVo>)page, dto);
    }

    @Override
    public MemberInfoBenefitsVo findDetailById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        MemberInfoBenefits memberInfoBenefits = this.memberInfoBenefitsRepository.findById(id);
        MemberInfoBenefitsVo memberInfoBenefitsVo = (MemberInfoBenefitsVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)memberInfoBenefits, MemberInfoBenefitsVo.class, HashSet.class, LinkedList.class, new String[0]);
        return memberInfoBenefitsVo;
    }

    @Override
    @Transactional
    public MemberInfoBenefitsVo create(MemberInfoBenefitsVo memberInfoBenefitsVo) {
        this.createValidation(memberInfoBenefitsVo);
        MemberInfoBenefits memberInfoBenefits = (MemberInfoBenefits)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)memberInfoBenefitsVo, MemberInfoBenefits.class, HashSet.class, LinkedList.class, new String[0]));
        memberInfoBenefits.setTenantCode(TenantUtils.getTenantCode());
        memberInfoBenefits.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        memberInfoBenefits.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        this.memberInfoBenefitsRepository.saveOrUpdate((Object)memberInfoBenefits);
        return memberInfoBenefitsVo;
    }

    @Override
    @Transactional
    public MemberInfoBenefitsVo update(MemberInfoBenefitsVo memberInfoBenefitsVo) {
        this.updateValidation(memberInfoBenefitsVo);
        String currentId = memberInfoBenefitsVo.getId();
        MemberInfoBenefits current = this.memberInfoBenefitsRepository.findById(currentId);
        current = (MemberInfoBenefits)((Object)Validate.notNull((Object)((Object)current), (String)"\u4fee\u6539\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]));
        current = (MemberInfoBenefits)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)memberInfoBenefitsVo, MemberInfoBenefits.class, HashSet.class, LinkedList.class, new String[0]));
        this.memberInfoBenefitsRepository.saveOrUpdate((Object)current);
        return memberInfoBenefitsVo;
    }

    @Override
    @Transactional
    public void enableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.memberInfoBenefitsRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
    }

    @Override
    @Transactional
    public void disableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.memberInfoBenefitsRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
    }

    @Override
    @Transactional
    public void updateDelFlagByIds(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.memberInfoBenefitsRepository.updateDelFlagByIds(ids);
    }

    @Override
    public Page<AppletMemberInfoBenefits> getMemberInfoBenefitsList(Pageable pageable, AppletMemberInfoBenefitsReqVo dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        dto = Optional.ofNullable(dto).orElse(new AppletMemberInfoBenefitsReqVo());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<AppletMemberInfoBenefits> result = this.memberInfoBenefitsRepository.getMemberInfoBenefitsList((Page<AppletMemberInfoBenefits>)page, dto);
        if (result != null && CollectionUtils.isNotEmpty((Collection)result.getRecords())) {
            for (AppletMemberInfoBenefits record : result.getRecords()) {
                RealOrderVo detailByOrderCode;
                record.setEndBenefitsTime((Date)DateUtil.offsetMonth((Date)record.getObtainBenefitsTime(), (int)record.getExchangeValidPeriod()));
                if (Objects.equals(BenefitsTypeEnum.DUMMY.getValue(), record.getBenefitsType())) {
                    DummyOrderVo dummyOrderVo = this.dummyOrderService.findDetailByOrderCode(record.getOrderCode());
                    if (dummyOrderVo != null) {
                        record.setDummyOrderStatus(dummyOrderVo.getOrderStatus());
                    }
                    record.setList(this.dummyOrderUserService.userInfoList(record.getOrderCode()));
                    continue;
                }
                if (!Objects.equals(BenefitsTypeEnum.REAL.getValue(), record.getBenefitsType()) || (detailByOrderCode = this.realOrderService.findDetailByOrderCode(record.getBenefitsType())) == null) continue;
                record.setRealOrderStatus(detailByOrderCode.getOrderStatus());
                record.setReceiptName(detailByOrderCode.getReceiptName());
                record.setReceiptPhone(detailByOrderCode.getReceiptPhone());
                record.setReceiptAddress(detailByOrderCode.getReceiptAddress());
                record.setExpressNum(detailByOrderCode.getExpressNum());
            }
        }
        return result;
    }

    @Override
    public Page<MemberInfoBenefitsVo> pageByConditions(Pageable pageable, BenefitsRecordPaginationDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        dto = Optional.ofNullable(dto).orElse(new BenefitsRecordPaginationDto());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.memberInfoBenefitsRepository.pageByConditions((Page<MemberInfoBenefitsVo>)page, dto);
    }

    @Override
    public AppletMemberInfoBenefits getMemberInfoBenefitsDetailById(String memberCode, String id) {
        MemberInfoBenefits memberInfoBenefits = this.memberInfoBenefitsRepository.findById(id);
        if (memberInfoBenefits == null) {
            Validate.isTrue((boolean)false, (String)"\u5f53\u524d\u4f1a\u5458\u6743\u76ca\u5df2\u5931\u6548", (Object[])new Object[0]);
        }
        if (!Objects.equals(memberInfoBenefits.getMemberCode(), memberCode)) {
            Validate.isTrue((boolean)false, (String)"\u5f53\u524d\u4f1a\u5458\u6743\u76ca\u975e\u672c\u4eba\u5151\u6362", (Object[])new Object[0]);
        }
        AppletMemberInfoBenefits appletMemberInfoBenefits = (AppletMemberInfoBenefits)this.nebulaToolkitService.copyObjectByWhiteList((Object)memberInfoBenefits, AppletMemberInfoBenefits.class, HashSet.class, LinkedList.class, new String[0]);
        return appletMemberInfoBenefits;
    }

    @Override
    public AppletMemberInfoBenefits getMemberInfoBenefitsSubmit(AppletMemberInfoBenefits appletMemberInfoBenefits) {
        Validate.notBlank((CharSequence)appletMemberInfoBenefits.getId(), (String)"\u5151\u6362\u6743\u76caID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        MemberInfoBenefits memberInfoBenefits = this.memberInfoBenefitsRepository.findById(appletMemberInfoBenefits.getId());
        if (memberInfoBenefits == null) {
            Validate.isTrue((boolean)false, (String)"\u5f53\u524d\u4f1a\u5458\u6743\u76ca\u5df2\u5931\u6548", (Object[])new Object[0]);
        }
        if (!Objects.equals(memberInfoBenefits.getMemberCode(), appletMemberInfoBenefits.getMemberCode())) {
            Validate.isTrue((boolean)false, (String)"\u5f53\u524d\u4f1a\u5458\u6743\u76ca\u975e\u672c\u4eba\u5151\u6362", (Object[])new Object[0]);
        }
        if (Objects.equals(BenefitsTypeEnum.DUMMY.getValue(), memberInfoBenefits.getBenefitsType())) {
            DummyOrderVo dummyOrderVo = new DummyOrderVo();
            dummyOrderVo.setOrderStatus(DummyOrderStatusEnum.STAY_USE.getValue());
            dummyOrderVo.setOrderSource(OrderSourceEnum.MEMBER_ROLE.getValue());
            dummyOrderVo.setUserCode(appletMemberInfoBenefits.getMemberCode());
            dummyOrderVo.setProductImg(memberInfoBenefits.getProductImage());
            dummyOrderVo.setProductNum(memberInfoBenefits.getNum());
            dummyOrderVo.setProductName(memberInfoBenefits.getBenefitsName());
            dummyOrderVo.setList(appletMemberInfoBenefits.getList());
            DummyOrderVo dummyOrderVo1 = this.dummyOrderService.create(dummyOrderVo);
            appletMemberInfoBenefits.setOrderId(dummyOrderVo1.getId());
            appletMemberInfoBenefits.setOrderCode(dummyOrderVo1.getOrderCode());
        } else {
            RealOrderVo realOrderVo = new RealOrderVo();
            realOrderVo.setOrderSource(OrderSourceEnum.MEMBER_ROLE.getValue());
            realOrderVo.setProductImg(memberInfoBenefits.getProductImage());
            realOrderVo.setUserCode(appletMemberInfoBenefits.getMemberCode());
            realOrderVo.setProductNum(memberInfoBenefits.getNum());
            realOrderVo.setProductName(memberInfoBenefits.getBenefitsName());
            realOrderVo.setReceiptName(appletMemberInfoBenefits.getReceiptName());
            realOrderVo.setReceiptPhone(appletMemberInfoBenefits.getReceiptPhone());
            realOrderVo.setReceiptAddress(appletMemberInfoBenefits.getReceiptAddress());
            RealOrderVo realOrderVo1 = this.realOrderService.create(realOrderVo);
            appletMemberInfoBenefits.setOrderId(realOrderVo1.getId());
            appletMemberInfoBenefits.setOrderCode(realOrderVo1.getOrderCode());
        }
        return appletMemberInfoBenefits;
    }

    private void createValidation(MemberInfoBenefitsVo memberInfoBenefitsVo) {
        this.validation(memberInfoBenefitsVo);
    }

    private void updateValidation(MemberInfoBenefitsVo memberInfoBenefitsVo) {
        this.validation(memberInfoBenefitsVo);
    }

    private void validation(MemberInfoBenefitsVo memberInfoBenefitsVo) {
    }
}

