/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.member.business.member.local.service.internal;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.member.business.member.local.entity.MemberInfoComeBackRecord;
import com.biz.crm.member.business.member.local.entity.MemberInfoComeBackRecordDetail;
import com.biz.crm.member.business.member.local.repository.MemberInfoComeBackRecordDetailRepository;
import com.biz.crm.member.business.member.local.repository.MemberInfoComeBackRecordRepository;
import com.biz.crm.member.business.member.local.service.MemberInfoComeBackRecordService;
import com.biz.crm.member.business.member.sdk.dto.MemberInfoComeBackRecordPaginationDto;
import com.biz.crm.member.business.member.sdk.event.MemberInfoComeBackRecordEventListener;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoComeBackRecordDetailVo;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoComeBackRecordVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="memberInfoComeBackRecordService")
public class MemberInfoComeBackRecordServiceImpl
implements MemberInfoComeBackRecordService {
    private static final Logger log = LoggerFactory.getLogger(MemberInfoComeBackRecordServiceImpl.class);
    @Autowired(required=false)
    private MemberInfoComeBackRecordRepository memberInfoComeBackRecordRepository;
    @Autowired(required=false)
    private List<MemberInfoComeBackRecordEventListener> eventListeners;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private MemberInfoComeBackRecordDetailRepository memberInfoComeBackRecordDetailRepository;

    @Override
    public Page<MemberInfoComeBackRecordVo> findByConditions(Pageable pageable, MemberInfoComeBackRecordPaginationDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        dto = Optional.ofNullable(dto).orElse(new MemberInfoComeBackRecordPaginationDto());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.memberInfoComeBackRecordRepository.findByConditions((Page<MemberInfoComeBackRecordVo>)page, dto);
    }

    @Override
    public MemberInfoComeBackRecordVo findDetailById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        MemberInfoComeBackRecord memberInfoComeBackRecord = this.memberInfoComeBackRecordRepository.findById(id);
        MemberInfoComeBackRecordVo memberInfoComeBackRecordVo = (MemberInfoComeBackRecordVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)memberInfoComeBackRecord, MemberInfoComeBackRecordVo.class, HashSet.class, LinkedList.class, new String[0]);
        return memberInfoComeBackRecordVo;
    }

    @Override
    @Transactional
    public MemberInfoComeBackRecordVo create(MemberInfoComeBackRecordVo memberInfoComeBackRecordVo) {
        this.createValidation(memberInfoComeBackRecordVo);
        MemberInfoComeBackRecord memberInfoComeBackRecord = (MemberInfoComeBackRecord)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)memberInfoComeBackRecordVo, MemberInfoComeBackRecord.class, HashSet.class, LinkedList.class, new String[0]));
        memberInfoComeBackRecord.setTenantCode(TenantUtils.getTenantCode());
        memberInfoComeBackRecord.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        memberInfoComeBackRecord.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        this.memberInfoComeBackRecordRepository.saveOrUpdate((Object)memberInfoComeBackRecord);
        return memberInfoComeBackRecordVo;
    }

    @Override
    @Transactional
    public MemberInfoComeBackRecordVo update(MemberInfoComeBackRecordVo memberInfoComeBackRecordVo) {
        this.updateValidation(memberInfoComeBackRecordVo);
        String currentId = memberInfoComeBackRecordVo.getId();
        MemberInfoComeBackRecord current = this.memberInfoComeBackRecordRepository.findById(currentId);
        current = (MemberInfoComeBackRecord)((Object)Validate.notNull((Object)((Object)current), (String)"\u4fee\u6539\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]));
        current = (MemberInfoComeBackRecord)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)memberInfoComeBackRecordVo, MemberInfoComeBackRecord.class, HashSet.class, LinkedList.class, new String[0]));
        this.memberInfoComeBackRecordRepository.saveOrUpdate((Object)current);
        return memberInfoComeBackRecordVo;
    }

    @Override
    @Transactional
    public void enableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.memberInfoComeBackRecordRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
    }

    @Override
    @Transactional
    public void disableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.memberInfoComeBackRecordRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
    }

    @Override
    @Transactional
    public void updateDelFlagByIds(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.memberInfoComeBackRecordRepository.updateDelFlagByIds(ids);
    }

    @Override
    public List<MemberInfoComeBackRecordDetailVo> findDetailByComeBackCode(String comeBackCode) {
        Validate.notBlank((CharSequence)comeBackCode, (String)"\u9000\u8d27\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        LambdaQueryWrapper queryDetail = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryDetail.eq(MemberInfoComeBackRecordDetail::getComeBackCode, (Object)comeBackCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).orderByDesc(UuidOpEntity::getCreateTime);
        List details = this.memberInfoComeBackRecordDetailRepository.list((Wrapper)queryDetail);
        Collection result = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)details, MemberInfoComeBackRecordDetail.class, MemberInfoComeBackRecordDetailVo.class, HashSet.class, LinkedList.class, new String[0]);
        return (List)result;
    }

    private void createValidation(MemberInfoComeBackRecordVo memberInfoComeBackRecordVo) {
        this.validation(memberInfoComeBackRecordVo);
    }

    private void updateValidation(MemberInfoComeBackRecordVo memberInfoComeBackRecordVo) {
        this.validation(memberInfoComeBackRecordVo);
    }

    private void validation(MemberInfoComeBackRecordVo memberInfoComeBackRecordVo) {
        Validate.notBlank((CharSequence)memberInfoComeBackRecordVo.getComeBackCode(), (String)"\u5355\u636e\u6d41\u6c34\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)memberInfoComeBackRecordVo.getCustomerCode(), (String)"\u53d1\u8d27\u5355\u4f4d\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)memberInfoComeBackRecordVo.getCustomerName(), (String)"\u53d1\u8d27\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)memberInfoComeBackRecordVo.getTerminalCode(), (String)"\u6536\u8d27\u5355\u4f4d\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)memberInfoComeBackRecordVo.getTerminalName(), (String)"\u6536\u8d27\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)memberInfoComeBackRecordVo.getOrgCode(), (String)"\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)memberInfoComeBackRecordVo.getOrgName(), (String)"\u7ec4\u7ec7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)memberInfoComeBackRecordVo.getDocumentTime(), (String)"\u5355\u636e\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)memberInfoComeBackRecordVo.getBackTime(), (String)"\u9000\u8d27\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)memberInfoComeBackRecordVo.getDeductionGrow(), (String)"\u83b7\u5f97\u6210\u957f\u503c\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }
}

