/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.member.business.member.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.member.business.member.local.entity.MemberInfoContact;
import com.biz.crm.member.business.member.local.repository.MemberInfoContactRepository;
import com.biz.crm.member.business.member.local.service.MemberInfoContactService;
import com.biz.crm.member.business.member.sdk.dto.MemberInfoContactPaginationDto;
import com.biz.crm.member.business.member.sdk.event.MemberInfoContactEventListener;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoContactVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="memberInfoContactService")
public class MemberInfoContactServiceImpl
implements MemberInfoContactService {
    private static final Logger log = LoggerFactory.getLogger(MemberInfoContactServiceImpl.class);
    @Autowired(required=false)
    private MemberInfoContactRepository memberInfoContactRepository;
    @Autowired(required=false)
    private List<MemberInfoContactEventListener> eventListeners;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public Page<MemberInfoContactVo> findByConditions(Pageable pageable, MemberInfoContactPaginationDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        dto = Optional.ofNullable(dto).orElse(new MemberInfoContactPaginationDto());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.memberInfoContactRepository.findByConditions((Page<MemberInfoContactVo>)page, dto);
    }

    @Override
    public MemberInfoContactVo findDetailById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        MemberInfoContact memberInfoContact = this.memberInfoContactRepository.findById(id);
        MemberInfoContactVo memberInfoContactVo = (MemberInfoContactVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)memberInfoContact, MemberInfoContactVo.class, HashSet.class, LinkedList.class, new String[0]);
        return memberInfoContactVo;
    }

    @Override
    @Transactional
    public MemberInfoContactVo create(MemberInfoContactVo memberInfoContactVo) {
        this.createValidation(memberInfoContactVo);
        MemberInfoContact memberInfoContact = (MemberInfoContact)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)memberInfoContactVo, MemberInfoContact.class, HashSet.class, LinkedList.class, new String[0]));
        memberInfoContact.setTenantCode(TenantUtils.getTenantCode());
        memberInfoContact.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        memberInfoContact.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        this.memberInfoContactRepository.saveOrUpdate((Object)memberInfoContact);
        return memberInfoContactVo;
    }

    @Override
    @Transactional
    public MemberInfoContactVo update(MemberInfoContactVo memberInfoContactVo) {
        this.updateValidation(memberInfoContactVo);
        String currentId = memberInfoContactVo.getId();
        MemberInfoContact current = this.memberInfoContactRepository.findById(currentId);
        current = (MemberInfoContact)((Object)Validate.notNull((Object)((Object)current), (String)"\u4fee\u6539\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]));
        current = (MemberInfoContact)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)memberInfoContactVo, MemberInfoContact.class, HashSet.class, LinkedList.class, new String[0]));
        this.memberInfoContactRepository.saveOrUpdate((Object)current);
        return memberInfoContactVo;
    }

    @Override
    @Transactional
    public void enableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.memberInfoContactRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
    }

    @Override
    @Transactional
    public void disableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.memberInfoContactRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
    }

    @Override
    @Transactional
    public void updateDelFlagByIds(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.memberInfoContactRepository.updateDelFlagByIds(ids);
    }

    private void createValidation(MemberInfoContactVo memberInfoContactVo) {
        this.validation(memberInfoContactVo);
    }

    private void updateValidation(MemberInfoContactVo memberInfoContactVo) {
        this.validation(memberInfoContactVo);
    }

    private void validation(MemberInfoContactVo memberInfoContactVo) {
    }
}

