/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.member.business.member.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.member.business.member.local.entity.MemberInfoGrowRecord;
import com.biz.crm.member.business.member.local.helper.UserSearchHelper;
import com.biz.crm.member.business.member.local.repository.MemberInfoGrowRecordRepository;
import com.biz.crm.member.business.member.local.service.MemberInfoComeBackRecordDetailService;
import com.biz.crm.member.business.member.local.service.MemberInfoGrowRecordService;
import com.biz.crm.member.business.member.local.service.MemberInfoReceiptRecordDetailService;
import com.biz.crm.member.business.member.sdk.dto.GrowRecordAPIPaginationDto;
import com.biz.crm.member.business.member.sdk.dto.MemberInfoGrowRecordPaginationDto;
import com.biz.crm.member.business.member.sdk.enums.GrowOperationEnum;
import com.biz.crm.member.business.member.sdk.event.MemberInfoGrowRecordEventListener;
import com.biz.crm.member.business.member.sdk.vo.GrowRecordAPIVo;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoGrowRecordVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="memberInfoGrowRecordService")
public class MemberInfoGrowRecordServiceImpl
implements MemberInfoGrowRecordService {
    private static final Logger log = LoggerFactory.getLogger(MemberInfoGrowRecordServiceImpl.class);
    @Autowired(required=false)
    private MemberInfoGrowRecordRepository memberInfoGrowRecordRepository;
    @Autowired(required=false)
    private List<MemberInfoGrowRecordEventListener> eventListeners;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired
    private MemberInfoComeBackRecordDetailService memberInfoComeBackRecordDetailService;
    @Autowired
    private MemberInfoReceiptRecordDetailService memberInfoReceiptRecordDetailService;
    @Autowired
    private UserSearchHelper userSearchHelper;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public Page<MemberInfoGrowRecordVo> findByConditions(Pageable pageable, MemberInfoGrowRecordPaginationDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        dto = Optional.ofNullable(dto).orElse(new MemberInfoGrowRecordPaginationDto());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.memberInfoGrowRecordRepository.findByConditions((Page<MemberInfoGrowRecordVo>)page, dto);
    }

    @Override
    public MemberInfoGrowRecordVo findDetailById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        MemberInfoGrowRecord memberInfoGrowRecord = this.memberInfoGrowRecordRepository.findById(id);
        MemberInfoGrowRecordVo memberInfoGrowRecordVo = (MemberInfoGrowRecordVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)memberInfoGrowRecord, MemberInfoGrowRecordVo.class, HashSet.class, LinkedList.class, new String[0]);
        return memberInfoGrowRecordVo;
    }

    @Override
    @Transactional
    public MemberInfoGrowRecordVo create(MemberInfoGrowRecordVo memberInfoGrowRecordVo) {
        this.createValidation(memberInfoGrowRecordVo);
        MemberInfoGrowRecord memberInfoGrowRecord = (MemberInfoGrowRecord)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)memberInfoGrowRecordVo, MemberInfoGrowRecord.class, HashSet.class, LinkedList.class, new String[0]));
        memberInfoGrowRecord.setTenantCode(TenantUtils.getTenantCode());
        memberInfoGrowRecord.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        memberInfoGrowRecord.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        this.memberInfoGrowRecordRepository.saveOrUpdate((Object)memberInfoGrowRecord);
        return memberInfoGrowRecordVo;
    }

    @Override
    @Transactional
    public MemberInfoGrowRecordVo update(MemberInfoGrowRecordVo memberInfoGrowRecordVo) {
        this.updateValidation(memberInfoGrowRecordVo);
        String currentId = memberInfoGrowRecordVo.getId();
        MemberInfoGrowRecord current = this.memberInfoGrowRecordRepository.findById(currentId);
        current = (MemberInfoGrowRecord)((Object)Validate.notNull((Object)((Object)current), (String)"\u4fee\u6539\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]));
        current = (MemberInfoGrowRecord)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)memberInfoGrowRecordVo, MemberInfoGrowRecord.class, HashSet.class, LinkedList.class, new String[0]));
        this.memberInfoGrowRecordRepository.saveOrUpdate((Object)current);
        return memberInfoGrowRecordVo;
    }

    @Override
    @Transactional
    public void enableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.memberInfoGrowRecordRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
    }

    @Override
    @Transactional
    public void disableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.memberInfoGrowRecordRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
    }

    @Override
    @Transactional
    public void updateDelFlagByIds(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.memberInfoGrowRecordRepository.updateDelFlagByIds(ids);
    }

    @Override
    public Page<GrowRecordAPIVo> findByConditionsAPI(Pageable pageable, GrowRecordAPIPaginationDto dto) {
        String memberCode = this.userSearchHelper.getMemberLogin().getMemberCode();
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        dto = Optional.ofNullable(dto).orElse(new GrowRecordAPIPaginationDto());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        dto.setMemberCode(memberCode);
        return this.memberInfoGrowRecordRepository.findByConditionsAPI((Page<GrowRecordAPIVo>)page, dto);
    }

    @Override
    public List<GrowRecordAPIVo> findDetail(GrowRecordAPIVo vo) {
        Validate.notBlank((CharSequence)vo.getIncreaseOrReduce(), (String)"\u8bf7\u586b\u5199increaseOrReduce\u5b57\u6bb5", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vo.getResourceDocumentCode(), (String)"\u8bf7\u586b\u5199resourceDocumentCode\u5b57\u6bb5", (Object[])new Object[0]);
        if (GrowOperationEnum.REDUCE.getValue().equals(vo.getIncreaseOrReduce())) {
            return this.memberInfoComeBackRecordDetailService.findDetailByResourceDocumentCode(vo.getResourceDocumentCode());
        }
        if (GrowOperationEnum.INCREASE.getValue().equals(vo.getIncreaseOrReduce())) {
            return this.memberInfoReceiptRecordDetailService.findDetailByResourceDocumentCode(vo.getResourceDocumentCode());
        }
        Validate.notNull(null, (String)"\u8bf7\u68c0\u67e5\u586b\u5199\u662f\u5426\u4e3aincrease/reduce", (Object[])new Object[0]);
        return null;
    }

    private void createValidation(MemberInfoGrowRecordVo memberInfoGrowRecordVo) {
        this.validation(memberInfoGrowRecordVo);
    }

    private void updateValidation(MemberInfoGrowRecordVo memberInfoGrowRecordVo) {
        this.validation(memberInfoGrowRecordVo);
    }

    private void validation(MemberInfoGrowRecordVo memberInfoGrowRecordVo) {
        Validate.notBlank((CharSequence)memberInfoGrowRecordVo.getMemberCode(), (String)"\u4f1a\u5458\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)memberInfoGrowRecordVo.getGrowCode(), (String)"\u6d41\u6c34\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)memberInfoGrowRecordVo.getSource(), (String)"\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)memberInfoGrowRecordVo.getGrow(), (String)"\u64cd\u4f5c\u6210\u957f\u503c\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }
}

