/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.member.business.member.local.service.internal;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.member.business.member.local.entity.MemberInfoIntegralRecord;
import com.biz.crm.member.business.member.local.entity.SystemSettingsDetail;
import com.biz.crm.member.business.member.local.helper.UserSearchHelper;
import com.biz.crm.member.business.member.local.repository.MemberInfoIntegralRecordRepository;
import com.biz.crm.member.business.member.local.service.AppletPopupNotifyService;
import com.biz.crm.member.business.member.local.service.MemberInfoAssetsService;
import com.biz.crm.member.business.member.local.service.MemberInfoIntegralRecordService;
import com.biz.crm.member.business.member.local.service.internal.SystemSettingsDetailServiceImpl;
import com.biz.crm.member.business.member.sdk.dto.MemberInfoIntegralRecordPaginationAPIDto;
import com.biz.crm.member.business.member.sdk.dto.MemberInfoIntegralRecordPaginationDto;
import com.biz.crm.member.business.member.sdk.enums.IntegralSourceEnum;
import com.biz.crm.member.business.member.sdk.enums.PointsViewDetailAPIEnum;
import com.biz.crm.member.business.member.sdk.enums.SystemSettingsDetailEnum;
import com.biz.crm.member.business.member.sdk.enums.TriggerConditionEnum;
import com.biz.crm.member.business.member.sdk.enums.TriggerTypeEnum;
import com.biz.crm.member.business.member.sdk.event.MemberInfoIntegralRecordEventListener;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoAssetsVo;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoIntegralRecordAPIVo;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoIntegralRecordVo;
import com.biz.crm.member.business.member.sdk.vo.MemberIntegralCountVo;
import com.biz.crm.member.business.member.sdk.vo.applet.AppletPopupNotifyVo;
import com.biz.crm.member.business.member.sdk.vo.login.MemberUserDetails;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="memberInfoIntegralRecordService")
public class MemberInfoIntegralRecordServiceImpl
implements MemberInfoIntegralRecordService {
    private static final Logger log = LoggerFactory.getLogger(MemberInfoIntegralRecordServiceImpl.class);
    @Autowired(required=false)
    private MemberInfoIntegralRecordRepository memberInfoIntegralRecordRepository;
    @Autowired(required=false)
    private SystemSettingsDetailServiceImpl systemSettingsDetailService;
    @Autowired(required=false)
    private List<MemberInfoIntegralRecordEventListener> eventListeners;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private MemberInfoAssetsService memberInfoAssetsService;
    @Autowired
    private UserSearchHelper userSearchHelper;
    @Autowired
    private AppletPopupNotifyService appletPopupNotifyService;

    @Override
    public Page<MemberInfoIntegralRecordVo> findByConditions(Pageable pageable, MemberInfoIntegralRecordPaginationDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        dto = Optional.ofNullable(dto).orElse(new MemberInfoIntegralRecordPaginationDto());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.memberInfoIntegralRecordRepository.findByConditions((Page<MemberInfoIntegralRecordVo>)page, dto);
    }

    @Override
    public Page<MemberInfoIntegralRecordAPIVo> findByConditionsAPI(Pageable pageable, MemberInfoIntegralRecordPaginationAPIDto dto) {
        MemberUserDetails memberLogin = this.userSearchHelper.getMemberLogin();
        dto.setMemberCode(memberLogin.getMemberCode());
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        dto = Optional.ofNullable(dto).orElse(new MemberInfoIntegralRecordPaginationAPIDto());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        ArrayList<String> sources = new ArrayList<String>();
        if (StringUtils.isBlank((CharSequence)dto.getSource())) {
            if (PointsViewDetailAPIEnum.INCOME.getValue().equals(dto.getType())) {
                sources.add(IntegralSourceEnum.SYS_ADD.getValue());
                sources.add(IntegralSourceEnum.QUESTIONNAIRE.getValue());
                sources.add(IntegralSourceEnum.CULTURAL_TOURISM_TOPIC.getValue());
                sources.add(IntegralSourceEnum.BIG_TURNTABLE.getValue());
                sources.add(IntegralSourceEnum.GROUP_BUY_RECEIPT.getValue());
                sources.add(IntegralSourceEnum.DAY_SIGN.getValue());
                dto.setSources(sources);
            }
            if (PointsViewDetailAPIEnum.EXPENDITURE.getValue().equals(dto.getType())) {
                sources.add(IntegralSourceEnum.PRODUCT_EXCHANGE.getValue());
                sources.add(IntegralSourceEnum.BIG_TURNTABLE_PAY.getValue());
                dto.setSources(sources);
            }
            if (PointsViewDetailAPIEnum.DEDUCTION.getValue().equals(dto.getType())) {
                sources.add(IntegralSourceEnum.SYS_DEDUCTION.getValue());
                sources.add(IntegralSourceEnum.INTEGRAL_EXPIRED.getValue());
                sources.add(IntegralSourceEnum.GROUP_BUY_RETREAT.getValue());
                dto.setSources(sources);
            }
            if (PointsViewDetailAPIEnum.ALL_TYPE.getValue().equals(dto.getType())) {
                dto.setSources(null);
            }
        } else {
            sources.add(dto.getSource());
        }
        dto.setSources(sources);
        return this.memberInfoIntegralRecordRepository.findByConditionsAPI((Page<MemberInfoIntegralRecordAPIVo>)page, dto);
    }

    @Override
    public MemberInfoIntegralRecordVo findDetailById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        MemberInfoIntegralRecord memberInfoIntegralRecord = this.memberInfoIntegralRecordRepository.findById(id);
        MemberInfoIntegralRecordVo memberInfoIntegralRecordVo = (MemberInfoIntegralRecordVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)memberInfoIntegralRecord, MemberInfoIntegralRecordVo.class, HashSet.class, LinkedList.class, new String[0]);
        return memberInfoIntegralRecordVo;
    }

    @Override
    public MemberInfoIntegralRecordVo findDetailByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        MemberInfoIntegralRecord memberInfoIntegralRecord = (MemberInfoIntegralRecord)((Object)((LambdaQueryChainWrapper)this.memberInfoIntegralRecordRepository.lambdaQuery().eq(MemberInfoIntegralRecord::getMemberCode, (Object)code)).one());
        MemberInfoIntegralRecordVo memberInfoIntegralRecordVo = (MemberInfoIntegralRecordVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)memberInfoIntegralRecord, MemberInfoIntegralRecordVo.class, HashSet.class, LinkedList.class, new String[0]);
        return memberInfoIntegralRecordVo;
    }

    @Override
    @Transactional
    public MemberInfoIntegralRecordVo create(MemberInfoIntegralRecordVo memberInfoIntegralRecordVo) {
        this.createValidation(memberInfoIntegralRecordVo);
        MemberInfoIntegralRecord memberInfoIntegralRecord = (MemberInfoIntegralRecord)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)memberInfoIntegralRecordVo, MemberInfoIntegralRecord.class, HashSet.class, LinkedList.class, new String[0]));
        memberInfoIntegralRecord.setTenantCode(TenantUtils.getTenantCode());
        memberInfoIntegralRecord.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        memberInfoIntegralRecord.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        this.memberInfoIntegralRecordRepository.saveOrUpdate((Object)memberInfoIntegralRecord);
        return memberInfoIntegralRecordVo;
    }

    @Override
    @Transactional
    public MemberInfoIntegralRecordVo update(MemberInfoIntegralRecordVo memberInfoIntegralRecordVo) {
        this.updateValidation(memberInfoIntegralRecordVo);
        String currentId = memberInfoIntegralRecordVo.getId();
        MemberInfoIntegralRecord current = this.memberInfoIntegralRecordRepository.findById(currentId);
        current = (MemberInfoIntegralRecord)((Object)Validate.notNull((Object)((Object)current), (String)"\u4fee\u6539\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]));
        current = (MemberInfoIntegralRecord)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)memberInfoIntegralRecordVo, MemberInfoIntegralRecord.class, HashSet.class, LinkedList.class, new String[0]));
        this.memberInfoIntegralRecordRepository.saveOrUpdate((Object)current);
        return memberInfoIntegralRecordVo;
    }

    @Override
    @Transactional
    public void enableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.memberInfoIntegralRecordRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
    }

    @Override
    @Transactional
    public void disableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.memberInfoIntegralRecordRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
    }

    @Override
    @Transactional
    public void updateDelFlagByIds(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.memberInfoIntegralRecordRepository.updateDelFlagByIds(ids);
    }

    @Override
    @Transactional
    public void commonInternal(MemberInfoIntegralRecordVo memberInfoIntegralRecordVo) {
        Validate.notBlank((CharSequence)memberInfoIntegralRecordVo.getMemberCode(), (String)"\u4f1a\u5458\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)memberInfoIntegralRecordVo.getSource(), (String)"\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)memberInfoIntegralRecordVo.getType(), (String)"\u79ef\u5206\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)memberInfoIntegralRecordVo.getIntegral(), (String)"\u64cd\u4f5c\u79ef\u5206\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)IntegralSourceEnum.isExist((String)memberInfoIntegralRecordVo.getSource()), (String)"\u6765\u6e90\u5f02\u5e38", (Object[])new Object[0]);
        Validate.isTrue((boolean)IntegralSourceEnum.isExistType((String)memberInfoIntegralRecordVo.getType()), (String)"\u79ef\u5206\u7c7b\u578b\u5f02\u5e38", (Object[])new Object[0]);
        MemberInfoAssetsVo memberInfoArchivesVo = this.memberInfoAssetsService.findDetailByMemberCode(memberInfoIntegralRecordVo.getMemberCode());
        Validate.notNull((Object)memberInfoArchivesVo, (String)"\u4f1a\u5458\u8d44\u4ea7\u5f02\u5e38", (Object[])new Object[0]);
        MemberInfoIntegralRecord memberInfoIntegralRecord = new MemberInfoIntegralRecord();
        memberInfoIntegralRecord.setId(null);
        memberInfoIntegralRecord.setTenantCode(TenantUtils.getTenantCode());
        memberInfoIntegralRecord.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        memberInfoIntegralRecord.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        memberInfoIntegralRecord.setIntegralCode((String)this.generateCodeService.generateCode("JF", 5).get(0));
        memberInfoIntegralRecord.setMemberCode(memberInfoIntegralRecordVo.getMemberCode());
        memberInfoIntegralRecord.setOptTime(new Date());
        memberInfoIntegralRecord.setBeforeIntegral(memberInfoArchivesVo.getTotalIntegral());
        memberInfoIntegralRecord.setAfterIntegral(memberInfoArchivesVo.getTotalIntegral() + memberInfoIntegralRecordVo.getIntegral());
        memberInfoIntegralRecord.setSource(memberInfoIntegralRecordVo.getSource());
        memberInfoIntegralRecord.setType(memberInfoIntegralRecordVo.getType());
        memberInfoIntegralRecord.setIntegral(memberInfoIntegralRecordVo.getIntegral());
        this.memberInfoIntegralRecordRepository.save((Object)memberInfoIntegralRecord);
        memberInfoArchivesVo.setTotalIntegral(Integer.valueOf(memberInfoArchivesVo.getTotalIntegral() + memberInfoIntegralRecordVo.getIntegral()));
        memberInfoArchivesVo.setCurrentIntegral(Integer.valueOf(memberInfoArchivesVo.getCurrentIntegral() + memberInfoIntegralRecordVo.getIntegral()));
        this.memberInfoAssetsService.update(memberInfoArchivesVo);
    }

    @Override
    public MemberInfoIntegralRecordAPIVo initData(String memberCode) {
        MemberInfoIntegralRecordAPIVo vo = new MemberInfoIntegralRecordAPIVo();
        MemberInfoAssetsVo memberInfoArchivesVo = this.memberInfoAssetsService.findDetailByMemberCode(memberCode);
        Validate.notNull((Object)memberInfoArchivesVo, (String)"\u4f1a\u5458\u8d44\u4ea7\u5f02\u5e38", (Object[])new Object[0]);
        vo.setCurrentIntegral(memberInfoArchivesVo.getCurrentIntegral());
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.memberInfoIntegralRecordRepository.lambdaQuery().eq(MemberInfoIntegralRecord::getMemberCode, (Object)memberCode)).orderByDesc(MemberInfoIntegralRecord::getOptTime)).list();
        if (list.isEmpty()) {
            return vo;
        }
        SystemSettingsDetail valueByKey = this.systemSettingsDetailService.findValueByKey(SystemSettingsDetailEnum.VALIDITY_PERIOD_OF_POINTS.getValue());
        if (StringUtils.isBlank((CharSequence)valueByKey.getTypeValue())) {
            valueByKey.setTypeValue("10000");
        }
        String periodOfValidity = valueByKey.getTypeValue();
        int i = Integer.parseInt(periodOfValidity);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Calendar calendar = Calendar.getInstance();
        Date currentTime = calendar.getTime();
        calendar.setTime(currentTime);
        calendar.add(2, -i);
        Date timeOpen = calendar.getTime();
        calendar.add(5, 30);
        Date timeClose = calendar.getTime();
        int sum = this.memberInfoIntegralRecordRepository.sumResidualIntegral(memberCode, timeOpen, timeClose);
        vo.setExpiringSoon(Integer.valueOf(sum));
        return vo;
    }

    @Override
    @DynamicTaskService(cornExpression="0 0 0 1 * ?", taskDesc="\u6bcf\u67081\u53f7\u67e5\u8be2\u5f53\u524d\u4f1a\u5458\u672c\u6708\u6709\u6ca1\u6709\u8fc7\u671f\u7684\u79ef\u5206")
    public void expiringSoon() {
        String memberCode = this.userSearchHelper.getMemberLogin().getMemberCode();
        SystemSettingsDetail valueByKey = this.systemSettingsDetailService.findValueByKey(SystemSettingsDetailEnum.VALIDITY_PERIOD_OF_POINTS.getValue());
        if (StringUtils.isBlank((CharSequence)valueByKey.getTypeValue())) {
            valueByKey.setTypeValue("10000");
        }
        String periodOfValidity = valueByKey.getTypeValue();
        int i = Integer.parseInt(periodOfValidity);
        Calendar calendar = Calendar.getInstance();
        int year = calendar.get(1);
        int month = calendar.get(2);
        calendar.set(year, month, 1);
        Date firstDayOfMonth = calendar.getTime();
        calendar.set(5, calendar.getActualMaximum(5));
        Date lastDayOfMonth = calendar.getTime();
        int sum = this.memberInfoIntegralRecordRepository.sumResidualIntegral(memberCode, firstDayOfMonth, lastDayOfMonth);
        if (sum > 0) {
            AppletPopupNotifyVo appletPopupNotifyVo = new AppletPopupNotifyVo();
            appletPopupNotifyVo.setMemberCode(memberCode);
            appletPopupNotifyVo.setTriggerType(TriggerTypeEnum.INTEGRAL.getCode());
            appletPopupNotifyVo.setTriggerConditions(TriggerConditionEnum.INTEGRAL_EXPIRED_MOTH.getCode());
            this.appletPopupNotifyService.addOne(appletPopupNotifyVo);
        }
    }

    @Override
    public MemberIntegralCountVo countIntegralRecord() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM");
        String currentTime = dateFormat.format(new Date(System.currentTimeMillis()));
        List<String> addType = Arrays.asList("add");
        List<String> deductionType = Arrays.asList("pay", "deduction");
        int totalAddIntegral = this.memberInfoIntegralRecordRepository.sumIntegralByTypeAndTime(addType, null);
        int currentMonthAddIntegral = this.memberInfoIntegralRecordRepository.sumIntegralByTypeAndTime(addType, currentTime);
        int totalDeductionIntegral = this.memberInfoIntegralRecordRepository.sumIntegralByTypeAndTime(deductionType, null);
        int currentMonthDeductionIntegral = this.memberInfoIntegralRecordRepository.sumIntegralByTypeAndTime(deductionType, currentTime);
        MemberIntegralCountVo result = new MemberIntegralCountVo();
        result.setTotalAddIntegral(Integer.valueOf(totalAddIntegral));
        result.setCurrentMonthAddIntegral(Integer.valueOf(currentMonthAddIntegral));
        result.setTotalDeductionIntegral(Integer.valueOf(totalDeductionIntegral));
        result.setCurrentMonthDeductionIntegral(Integer.valueOf(currentMonthDeductionIntegral));
        return result;
    }

    private void createValidation(MemberInfoIntegralRecordVo memberInfoIntegralRecordVo) {
        this.validation(memberInfoIntegralRecordVo);
    }

    private void updateValidation(MemberInfoIntegralRecordVo memberInfoIntegralRecordVo) {
        this.validation(memberInfoIntegralRecordVo);
    }

    private void validation(MemberInfoIntegralRecordVo memberInfoIntegralRecordVo) {
        Validate.notBlank((CharSequence)memberInfoIntegralRecordVo.getMemberCode(), (String)"\u4f1a\u5458\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)memberInfoIntegralRecordVo.getIntegralCode(), (String)"\u6d41\u6c34\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)memberInfoIntegralRecordVo.getSource(), (String)"\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)memberInfoIntegralRecordVo.getIntegral(), (String)"\u64cd\u4f5c\u79ef\u5206\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }
}

