/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.member.business.member.local.service.internal;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.member.business.member.local.entity.MemberInfoLevelChangeRecord;
import com.biz.crm.member.business.member.local.repository.MemberInfoLevelChangeRecordRepository;
import com.biz.crm.member.business.member.local.service.MemberInfoLevelChangeRecordService;
import com.biz.crm.member.business.member.sdk.dto.MemberInfoLevelChangeRecordPaginationDto;
import com.biz.crm.member.business.member.sdk.event.MemberInfoLevelChangeRecordEventListener;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoLevelChangeRecordVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="memberInfoLevelChangeRecordService")
public class MemberInfoLevelChangeRecordServiceImpl
implements MemberInfoLevelChangeRecordService {
    private static final Logger log = LoggerFactory.getLogger(MemberInfoLevelChangeRecordServiceImpl.class);
    @Autowired(required=false)
    private MemberInfoLevelChangeRecordRepository memberInfoLevelChangeRecordRepository;
    @Autowired(required=false)
    private List<MemberInfoLevelChangeRecordEventListener> eventListeners;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public Page<MemberInfoLevelChangeRecordVo> findByConditions(Pageable pageable, MemberInfoLevelChangeRecordPaginationDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        dto = Optional.ofNullable(dto).orElse(new MemberInfoLevelChangeRecordPaginationDto());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.memberInfoLevelChangeRecordRepository.findByConditions((Page<MemberInfoLevelChangeRecordVo>)page, dto);
    }

    @Override
    public MemberInfoLevelChangeRecordVo findDetailById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        MemberInfoLevelChangeRecord memberInfoLevelChangeRecord = this.memberInfoLevelChangeRecordRepository.findById(id);
        MemberInfoLevelChangeRecordVo memberInfoLevelChangeRecordVo = (MemberInfoLevelChangeRecordVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)memberInfoLevelChangeRecord, MemberInfoLevelChangeRecordVo.class, HashSet.class, LinkedList.class, new String[0]);
        return memberInfoLevelChangeRecordVo;
    }

    @Override
    public MemberInfoLevelChangeRecordVo findDetailByMemberCode(String memberCode) {
        if (StringUtils.isBlank((CharSequence)memberCode)) {
            return null;
        }
        MemberInfoLevelChangeRecord memberInfoLevelChangeRecord = (MemberInfoLevelChangeRecord)((Object)((LambdaQueryChainWrapper)this.memberInfoLevelChangeRecordRepository.lambdaQuery().eq(MemberInfoLevelChangeRecord::getMemberCode, (Object)memberCode)).one());
        MemberInfoLevelChangeRecordVo memberInfoLevelChangeRecordVo = (MemberInfoLevelChangeRecordVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)memberInfoLevelChangeRecord, MemberInfoLevelChangeRecordVo.class, HashSet.class, LinkedList.class, new String[0]);
        return memberInfoLevelChangeRecordVo;
    }

    @Override
    @Transactional
    public MemberInfoLevelChangeRecordVo create(MemberInfoLevelChangeRecordVo memberInfoLevelChangeRecordVo) {
        this.createValidation(memberInfoLevelChangeRecordVo);
        MemberInfoLevelChangeRecord memberInfoLevelChangeRecord = (MemberInfoLevelChangeRecord)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)memberInfoLevelChangeRecordVo, MemberInfoLevelChangeRecord.class, HashSet.class, LinkedList.class, new String[0]));
        memberInfoLevelChangeRecord.setTenantCode(TenantUtils.getTenantCode());
        memberInfoLevelChangeRecord.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        memberInfoLevelChangeRecord.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        this.memberInfoLevelChangeRecordRepository.saveOrUpdate((Object)memberInfoLevelChangeRecord);
        return memberInfoLevelChangeRecordVo;
    }

    @Override
    @Transactional
    public MemberInfoLevelChangeRecordVo update(MemberInfoLevelChangeRecordVo memberInfoLevelChangeRecordVo) {
        this.updateValidation(memberInfoLevelChangeRecordVo);
        String currentId = memberInfoLevelChangeRecordVo.getId();
        MemberInfoLevelChangeRecord current = this.memberInfoLevelChangeRecordRepository.findById(currentId);
        current = (MemberInfoLevelChangeRecord)((Object)Validate.notNull((Object)((Object)current), (String)"\u4fee\u6539\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]));
        current = (MemberInfoLevelChangeRecord)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)memberInfoLevelChangeRecordVo, MemberInfoLevelChangeRecord.class, HashSet.class, LinkedList.class, new String[0]));
        this.memberInfoLevelChangeRecordRepository.saveOrUpdate((Object)current);
        return memberInfoLevelChangeRecordVo;
    }

    @Override
    @Transactional
    public void enableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.memberInfoLevelChangeRecordRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
    }

    @Override
    @Transactional
    public void disableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.memberInfoLevelChangeRecordRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
    }

    @Override
    @Transactional
    public void updateDelFlagByIds(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.memberInfoLevelChangeRecordRepository.updateDelFlagByIds(ids);
    }

    private void createValidation(MemberInfoLevelChangeRecordVo memberInfoLevelChangeRecordVo) {
        this.validation(memberInfoLevelChangeRecordVo);
    }

    private void updateValidation(MemberInfoLevelChangeRecordVo memberInfoLevelChangeRecordVo) {
        this.validation(memberInfoLevelChangeRecordVo);
    }

    private void validation(MemberInfoLevelChangeRecordVo memberInfoLevelChangeRecordVo) {
    }
}

