/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.member.business.member.local.service.internal;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.member.business.member.local.entity.MemberInfoReceiptRecordDetail;
import com.biz.crm.member.business.member.local.repository.MemberInfoReceiptRecordDetailRepository;
import com.biz.crm.member.business.member.local.service.MemberInfoReceiptRecordDetailService;
import com.biz.crm.member.business.member.sdk.dto.MemberInfoReceiptRecordDetailPaginationDto;
import com.biz.crm.member.business.member.sdk.event.MemberInfoReceiptRecordDetailEventListener;
import com.biz.crm.member.business.member.sdk.vo.GrowRecordAPIVo;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoReceiptRecordDetailVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="memberInfoReceiptRecordDetailService")
public class MemberInfoReceiptRecordDetailServiceImpl
implements MemberInfoReceiptRecordDetailService {
    private static final Logger log = LoggerFactory.getLogger(MemberInfoReceiptRecordDetailServiceImpl.class);
    @Autowired(required=false)
    private MemberInfoReceiptRecordDetailRepository memberInfoReceiptRecordDetailRepository;
    @Autowired(required=false)
    private List<MemberInfoReceiptRecordDetailEventListener> eventListeners;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public Page<MemberInfoReceiptRecordDetailVo> findByConditions(Pageable pageable, MemberInfoReceiptRecordDetailPaginationDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        dto = Optional.ofNullable(dto).orElse(new MemberInfoReceiptRecordDetailPaginationDto());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.memberInfoReceiptRecordDetailRepository.findByConditions((Page<MemberInfoReceiptRecordDetailVo>)page, dto);
    }

    @Override
    public MemberInfoReceiptRecordDetailVo findDetailById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        MemberInfoReceiptRecordDetail memberInfoReceiptRecordDetail = this.memberInfoReceiptRecordDetailRepository.findById(id);
        MemberInfoReceiptRecordDetailVo memberInfoReceiptRecordDetailVo = (MemberInfoReceiptRecordDetailVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)memberInfoReceiptRecordDetail, MemberInfoReceiptRecordDetailVo.class, HashSet.class, LinkedList.class, new String[0]);
        return memberInfoReceiptRecordDetailVo;
    }

    @Override
    @Transactional
    public MemberInfoReceiptRecordDetailVo create(MemberInfoReceiptRecordDetailVo memberInfoReceiptRecordDetailVo) {
        this.createValidation(memberInfoReceiptRecordDetailVo);
        MemberInfoReceiptRecordDetail memberInfoReceiptRecordDetail = (MemberInfoReceiptRecordDetail)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)memberInfoReceiptRecordDetailVo, MemberInfoReceiptRecordDetail.class, HashSet.class, LinkedList.class, new String[0]));
        memberInfoReceiptRecordDetail.setTenantCode(TenantUtils.getTenantCode());
        memberInfoReceiptRecordDetail.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        memberInfoReceiptRecordDetail.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        this.memberInfoReceiptRecordDetailRepository.saveOrUpdate((Object)memberInfoReceiptRecordDetail);
        return memberInfoReceiptRecordDetailVo;
    }

    @Override
    @Transactional
    public MemberInfoReceiptRecordDetailVo update(MemberInfoReceiptRecordDetailVo memberInfoReceiptRecordDetailVo) {
        this.updateValidation(memberInfoReceiptRecordDetailVo);
        String currentId = memberInfoReceiptRecordDetailVo.getId();
        MemberInfoReceiptRecordDetail current = this.memberInfoReceiptRecordDetailRepository.findById(currentId);
        current = (MemberInfoReceiptRecordDetail)((Object)Validate.notNull((Object)((Object)current), (String)"\u4fee\u6539\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]));
        current = (MemberInfoReceiptRecordDetail)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)memberInfoReceiptRecordDetailVo, MemberInfoReceiptRecordDetail.class, HashSet.class, LinkedList.class, new String[0]));
        this.memberInfoReceiptRecordDetailRepository.saveOrUpdate((Object)current);
        return memberInfoReceiptRecordDetailVo;
    }

    @Override
    @Transactional
    public void enableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.memberInfoReceiptRecordDetailRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
    }

    @Override
    @Transactional
    public void disableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.memberInfoReceiptRecordDetailRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
    }

    @Override
    @Transactional
    public void updateDelFlagByIds(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.memberInfoReceiptRecordDetailRepository.updateDelFlagByIds(ids);
    }

    @Override
    public List<GrowRecordAPIVo> findDetailByResourceDocumentCode(String resourceDocumentCode) {
        ArrayList result = Lists.newArrayList();
        List list = ((LambdaQueryChainWrapper)this.memberInfoReceiptRecordDetailRepository.lambdaQuery().eq(MemberInfoReceiptRecordDetail::getReceiptCode, (Object)resourceDocumentCode)).list();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (MemberInfoReceiptRecordDetail memberInfoReceiptRecordDetail : list) {
                GrowRecordAPIVo growRecordAPIVo = new GrowRecordAPIVo();
                growRecordAPIVo.setNum(memberInfoReceiptRecordDetail.getNum());
                growRecordAPIVo.setProductName(memberInfoReceiptRecordDetail.getProductName());
                result.add(growRecordAPIVo);
            }
        }
        return result;
    }

    @Override
    @Transactional
    public void batchSave(List<MemberInfoReceiptRecordDetailVo> list) {
        for (MemberInfoReceiptRecordDetailVo memberInfoReceiptRecordDetailVo : list) {
            this.create(memberInfoReceiptRecordDetailVo);
        }
    }

    private void createValidation(MemberInfoReceiptRecordDetailVo memberInfoReceiptRecordDetailVo) {
        this.validation(memberInfoReceiptRecordDetailVo);
    }

    private void updateValidation(MemberInfoReceiptRecordDetailVo memberInfoReceiptRecordDetailVo) {
        this.validation(memberInfoReceiptRecordDetailVo);
    }

    private void validation(MemberInfoReceiptRecordDetailVo memberInfoReceiptRecordDetailVo) {
        Validate.notBlank((CharSequence)memberInfoReceiptRecordDetailVo.getReceiptCode(), (String)"\u5355\u636e\u6d41\u6c34\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)memberInfoReceiptRecordDetailVo.getProductCode(), (String)"\u4ea7\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)memberInfoReceiptRecordDetailVo.getProductName(), (String)"\u4ea7\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)memberInfoReceiptRecordDetailVo.getNum(), (String)"\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }
}

