/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.member.business.member.local.service.internal;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.member.business.member.local.entity.MemberInfoReceiptRecord;
import com.biz.crm.member.business.member.local.entity.MemberInfoReceiptRecordDetail;
import com.biz.crm.member.business.member.local.repository.MemberInfoReceiptRecordDetailRepository;
import com.biz.crm.member.business.member.local.repository.MemberInfoReceiptRecordRepository;
import com.biz.crm.member.business.member.local.service.MemberInfoReceiptRecordDetailService;
import com.biz.crm.member.business.member.local.service.MemberInfoReceiptRecordService;
import com.biz.crm.member.business.member.sdk.dto.MemberInfoReceiptRecordPaginationDto;
import com.biz.crm.member.business.member.sdk.event.MemberInfoReceiptRecordEventListener;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoReceiptRecordDetailVo;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoReceiptRecordVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="memberInfoReceiptRecordService")
public class MemberInfoReceiptRecordServiceImpl
implements MemberInfoReceiptRecordService {
    private static final Logger log = LoggerFactory.getLogger(MemberInfoReceiptRecordServiceImpl.class);
    @Autowired(required=false)
    private MemberInfoReceiptRecordRepository memberInfoReceiptRecordRepository;
    @Autowired(required=false)
    private List<MemberInfoReceiptRecordEventListener> eventListeners;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired
    private MemberInfoReceiptRecordDetailRepository memberInfoReceiptRecordDetailRepository;
    @Autowired
    private MemberInfoReceiptRecordDetailService memberInfoReceiptRecordDetailService;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public Page<MemberInfoReceiptRecordVo> findByConditions(Pageable pageable, MemberInfoReceiptRecordPaginationDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        dto = Optional.ofNullable(dto).orElse(new MemberInfoReceiptRecordPaginationDto());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.memberInfoReceiptRecordRepository.findByConditions((Page<MemberInfoReceiptRecordVo>)page, dto);
    }

    @Override
    public MemberInfoReceiptRecordVo findDetailById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        MemberInfoReceiptRecord memberInfoReceiptRecord = this.memberInfoReceiptRecordRepository.findById(id);
        MemberInfoReceiptRecordVo memberInfoReceiptRecordVo = (MemberInfoReceiptRecordVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)memberInfoReceiptRecord, MemberInfoReceiptRecordVo.class, HashSet.class, LinkedList.class, new String[0]);
        return memberInfoReceiptRecordVo;
    }

    @Override
    @Transactional
    public MemberInfoReceiptRecordVo create(MemberInfoReceiptRecordVo memberInfoReceiptRecordVo) {
        this.createValidation(memberInfoReceiptRecordVo);
        MemberInfoReceiptRecord memberInfoReceiptRecord = (MemberInfoReceiptRecord)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)memberInfoReceiptRecordVo, MemberInfoReceiptRecord.class, HashSet.class, LinkedList.class, new String[0]));
        memberInfoReceiptRecord.setTenantCode(TenantUtils.getTenantCode());
        memberInfoReceiptRecord.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        memberInfoReceiptRecord.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        this.memberInfoReceiptRecordRepository.saveOrUpdate((Object)memberInfoReceiptRecord);
        if (CollectionUtils.isNotEmpty((Collection)memberInfoReceiptRecordVo.getList())) {
            for (MemberInfoReceiptRecordDetailVo memberInfoReceiptRecordDetailVo : memberInfoReceiptRecordVo.getList()) {
                memberInfoReceiptRecordDetailVo.setReceiptCode(memberInfoReceiptRecord.getReceiptCode());
            }
            this.memberInfoReceiptRecordDetailService.batchSave(memberInfoReceiptRecordVo.getList());
        }
        return memberInfoReceiptRecordVo;
    }

    @Override
    @Transactional
    public MemberInfoReceiptRecordVo update(MemberInfoReceiptRecordVo memberInfoReceiptRecordVo) {
        this.updateValidation(memberInfoReceiptRecordVo);
        String currentId = memberInfoReceiptRecordVo.getId();
        MemberInfoReceiptRecord current = this.memberInfoReceiptRecordRepository.findById(currentId);
        current = (MemberInfoReceiptRecord)((Object)Validate.notNull((Object)((Object)current), (String)"\u4fee\u6539\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]));
        current = (MemberInfoReceiptRecord)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)memberInfoReceiptRecordVo, MemberInfoReceiptRecord.class, HashSet.class, LinkedList.class, new String[0]));
        this.memberInfoReceiptRecordRepository.saveOrUpdate((Object)current);
        return memberInfoReceiptRecordVo;
    }

    @Override
    @Transactional
    public void enableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.memberInfoReceiptRecordRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
    }

    @Override
    @Transactional
    public void disableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.memberInfoReceiptRecordRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
    }

    @Override
    @Transactional
    public void updateDelFlagByIds(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.memberInfoReceiptRecordRepository.updateDelFlagByIds(ids);
    }

    @Override
    public List<MemberInfoReceiptRecordDetailVo> findDetailByReceiptCode(String receiptCode) {
        LambdaQueryWrapper queryDetail = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryDetail.eq(MemberInfoReceiptRecordDetail::getReceiptCode, (Object)receiptCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).orderByDesc(UuidOpEntity::getCreateTime);
        List details = this.memberInfoReceiptRecordDetailRepository.list((Wrapper)queryDetail);
        Collection result = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)details, MemberInfoReceiptRecordDetail.class, MemberInfoReceiptRecordDetailVo.class, HashSet.class, LinkedList.class, new String[0]);
        return (List)result;
    }

    private void createValidation(MemberInfoReceiptRecordVo memberInfoReceiptRecordVo) {
        this.validation(memberInfoReceiptRecordVo);
    }

    private void updateValidation(MemberInfoReceiptRecordVo memberInfoReceiptRecordVo) {
        this.validation(memberInfoReceiptRecordVo);
    }

    private void validation(MemberInfoReceiptRecordVo memberInfoReceiptRecordVo) {
        Validate.notBlank((CharSequence)memberInfoReceiptRecordVo.getReceiptCode(), (String)"\u5355\u636e\u6d41\u6c34\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)memberInfoReceiptRecordVo.getCustomerCode(), (String)"\u53d1\u8d27\u5355\u4f4d\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)memberInfoReceiptRecordVo.getCustomerName(), (String)"\u53d1\u8d27\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)memberInfoReceiptRecordVo.getTerminalCode(), (String)"\u6536\u8d27\u5355\u4f4d\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)memberInfoReceiptRecordVo.getTerminalName(), (String)"\u6536\u8d27\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)memberInfoReceiptRecordVo.getOrgCode(), (String)"\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)memberInfoReceiptRecordVo.getOrgName(), (String)"\u7ec4\u7ec7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)memberInfoReceiptRecordVo.getDocumentTime(), (String)"\u5355\u636e\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)memberInfoReceiptRecordVo.getReceiptTime(), (String)"\u7b7e\u6536\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)memberInfoReceiptRecordVo.getReceiptAddr(), (String)"\u7b7e\u6536\u5730\u70b9\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)memberInfoReceiptRecordVo.getGetGrow(), (String)"\u83b7\u5f97\u6210\u957f\u503c\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }
}

