/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.member.business.member.local.service.internal;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.RandomUtil;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.UuidOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.member.business.member.local.entity.MemberInfo;
import com.biz.crm.member.business.member.local.entity.MemberInfoArchives;
import com.biz.crm.member.business.member.local.entity.MemberInfoAssets;
import com.biz.crm.member.business.member.local.entity.MemberInfoContact;
import com.biz.crm.member.business.member.local.entity.MemberInfoLevelChangeRecord;
import com.biz.crm.member.business.member.local.entity.MemberInfoSupply;
import com.biz.crm.member.business.member.local.helper.UserSearchHelper;
import com.biz.crm.member.business.member.local.repository.MemberInfoArchivesRepository;
import com.biz.crm.member.business.member.local.repository.MemberInfoAssetsRepository;
import com.biz.crm.member.business.member.local.repository.MemberInfoContactRepository;
import com.biz.crm.member.business.member.local.repository.MemberInfoGrowRecordRepository;
import com.biz.crm.member.business.member.local.repository.MemberInfoIntegralRecordRepository;
import com.biz.crm.member.business.member.local.repository.MemberInfoLevelChangeRecordRepository;
import com.biz.crm.member.business.member.local.repository.MemberInfoRepository;
import com.biz.crm.member.business.member.local.repository.MemberInfoSupplyRepository;
import com.biz.crm.member.business.member.local.service.AppletPopupNotifyService;
import com.biz.crm.member.business.member.local.service.LevelManageService;
import com.biz.crm.member.business.member.local.service.MemberInfoGrowRecordService;
import com.biz.crm.member.business.member.local.service.MemberInfoIntegralRecordService;
import com.biz.crm.member.business.member.local.service.MemberInfoService;
import com.biz.crm.member.business.member.local.service.SystemSettingsDetailService;
import com.biz.crm.member.business.member.local.service.TastingConsultantService;
import com.biz.crm.member.business.member.sdk.dto.MemberInfoPaginationDto;
import com.biz.crm.member.business.member.sdk.enums.MemberApprovalStatusEnum;
import com.biz.crm.member.business.member.sdk.enums.SystemSettingsDetailEnum;
import com.biz.crm.member.business.member.sdk.enums.TriggerConditionEnum;
import com.biz.crm.member.business.member.sdk.enums.TriggerTypeEnum;
import com.biz.crm.member.business.member.sdk.event.MemberInfoEventListener;
import com.biz.crm.member.business.member.sdk.vo.LevelManageVo;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoAllVo;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoAssetsVo;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoContactVo;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoGrowRecordVo;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoIntegralRecordVo;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoLevelChangeRecordVo;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoSupplyVo;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoVo;
import com.biz.crm.member.business.member.sdk.vo.MemberLoginVo;
import com.biz.crm.member.business.member.sdk.vo.PersonalCenterAPIVo;
import com.biz.crm.member.business.member.sdk.vo.TastingConsultantVo;
import com.biz.crm.member.business.member.sdk.vo.applet.AppletMemberBaseInfoVo;
import com.biz.crm.member.business.member.sdk.vo.applet.AppletMemberHoneVo;
import com.biz.crm.member.business.member.sdk.vo.applet.AppletMemberInfoReqVo;
import com.biz.crm.member.business.member.sdk.vo.applet.AppletMemberInfoVo;
import com.biz.crm.member.business.member.sdk.vo.applet.AppletPopupNotifyVo;
import com.biz.crm.member.business.member.sdk.vo.login.MemberUserDetails;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="memberInfoService")
public class MemberInfoServiceImpl
implements MemberInfoService {
    private static final Logger log = LoggerFactory.getLogger(MemberInfoServiceImpl.class);
    @Autowired(required=false)
    private MemberInfoRepository memberInfoRepository;
    @Autowired
    private AppletPopupNotifyService appletPopupNotifyService;
    @Autowired
    private MemberInfoArchivesRepository memberInfoArchivesRepository;
    @Autowired
    private MemberInfoContactRepository memberInfoContactRepository;
    @Autowired
    private MemberInfoSupplyRepository memberInfoSupplyRepository;
    @Autowired
    private MemberInfoAssetsRepository memberInfoAssetsRepository;
    @Autowired
    private MemberInfoLevelChangeRecordRepository memberInfoLevelChangeRecordRepository;
    @Autowired
    private MemberInfoIntegralRecordRepository memberInfoIntegralRecordRepository;
    @Autowired
    private MemberInfoIntegralRecordService memberInfoIntegralRecordService;
    @Autowired
    private MemberInfoGrowRecordRepository memberInfoGrowRecordRepository;
    @Autowired
    private MemberInfoGrowRecordService memberInfoGrowRecordService;
    @Autowired(required=false)
    private List<MemberInfoEventListener> eventListeners;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private LoginUserService loginUserService;
    @Autowired
    private UserSearchHelper userSearchHelper;
    @Autowired
    private LevelManageService levelManageService;
    @Autowired
    private SystemSettingsDetailService systemSettingsDetailService;
    @Autowired
    private TastingConsultantService tastingConsultantService;

    @Override
    public Page<MemberInfoVo> findByConditions(Pageable pageable, MemberInfoPaginationDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        dto = Optional.ofNullable(dto).orElse(new MemberInfoPaginationDto());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.memberInfoRepository.findByConditions((Page<MemberInfoVo>)page, dto);
    }

    @Override
    public MemberInfoVo findDetailById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        MemberInfo memberInfo = this.memberInfoRepository.findById(id);
        MemberInfoVo memberInfoVo = (MemberInfoVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)memberInfo, MemberInfoVo.class, HashSet.class, LinkedList.class, new String[0]);
        return memberInfoVo;
    }

    @Override
    public MemberInfoVo findDetailByMemberCode(String memberCode) {
        if (StringUtils.isBlank((CharSequence)memberCode)) {
            return null;
        }
        MemberInfo memberInfo = (MemberInfo)((Object)((LambdaQueryChainWrapper)this.memberInfoRepository.lambdaQuery().eq(MemberInfo::getMemberCode, (Object)memberCode)).one());
        MemberInfoVo memberInfoVo = (MemberInfoVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)memberInfo, MemberInfoVo.class, HashSet.class, LinkedList.class, new String[0]);
        return memberInfoVo;
    }

    @Override
    public AppletMemberBaseInfoVo findBaseInfoByMemberCode(String memberCode) {
        AppletMemberBaseInfoVo memberBaseInfoVo = new AppletMemberBaseInfoVo();
        MemberInfo memberInfo = (MemberInfo)((Object)((LambdaQueryChainWrapper)this.memberInfoRepository.lambdaQuery().eq(MemberInfo::getMemberCode, (Object)memberCode)).one());
        memberBaseInfoVo.setMemberAvatar(memberInfo.getMemberAvatar());
        memberBaseInfoVo.setMemberName(memberInfo.getMemberName());
        memberBaseInfoVo.setMemberPhone(memberInfo.getMemberPhone());
        memberBaseInfoVo.setMemberBirthday(memberInfo.getMemberBirthday());
        return memberBaseInfoVo;
    }

    @Override
    @Transactional
    public MemberInfoVo create(MemberInfoVo memberInfoVo) {
        this.createValidation(memberInfoVo);
        MemberInfo memberInfo = (MemberInfo)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)memberInfoVo, MemberInfo.class, HashSet.class, LinkedList.class, new String[0]));
        memberInfo.setTenantCode(TenantUtils.getTenantCode());
        memberInfo.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        memberInfo.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        this.memberInfoRepository.saveOrUpdate((Object)memberInfo);
        return memberInfoVo;
    }

    @Override
    @Transactional
    public MemberInfoVo update(MemberInfoVo memberInfoVo) {
        this.updateValidation(memberInfoVo);
        String currentId = memberInfoVo.getId();
        MemberInfo current = this.memberInfoRepository.findById(currentId);
        current = (MemberInfo)((Object)Validate.notNull((Object)((Object)current), (String)"\u4fee\u6539\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]));
        current = (MemberInfo)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)memberInfoVo, MemberInfo.class, HashSet.class, LinkedList.class, new String[0]));
        this.memberInfoRepository.saveOrUpdate((Object)current);
        return memberInfoVo;
    }

    @Override
    public AppletMemberBaseInfoVo updateBase(AppletMemberBaseInfoVo appletMemberBaseInfoVo) {
        MemberInfo memberInfo = (MemberInfo)((Object)((LambdaQueryChainWrapper)this.memberInfoRepository.lambdaQuery().eq(MemberInfo::getMemberCode, (Object)this.userSearchHelper.getMemberLogin().getMemberCode())).one());
        Validate.notNull((Object)((Object)memberInfo), (String)"\u4f1a\u5458\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        if (appletMemberBaseInfoVo.getMemberBirthday() != null) {
            if (memberInfo.getMemberBirthday() != null) {
                Validate.notBlank(null, (String)"\u4f1a\u5458\u751f\u65e5\u4e0d\u53ef\u4fee\u6539\uff0c\u53ea\u53ef\u65b0\u589e", (Object[])new Object[0]);
            }
            memberInfo.setMemberBirthday(appletMemberBaseInfoVo.getMemberBirthday());
        }
        if (appletMemberBaseInfoVo.getMemberAvatar() != null) {
            memberInfo.setMemberAvatar(appletMemberBaseInfoVo.getMemberAvatar());
        }
        if (appletMemberBaseInfoVo.getMemberNick() != null) {
            memberInfo.setMemberNick(appletMemberBaseInfoVo.getMemberNick());
        }
        if (appletMemberBaseInfoVo.getMemberPhone() != null) {
            memberInfo.setMemberPhone(appletMemberBaseInfoVo.getMemberPhone());
        }
        this.memberInfoRepository.saveOrUpdate((Object)memberInfo);
        return appletMemberBaseInfoVo;
    }

    @Override
    @Transactional
    public void enableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.memberInfoRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
    }

    @Override
    @Transactional
    public void disableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.memberInfoRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
    }

    @Override
    @Transactional
    public void updateDelFlagByIds(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.memberInfoRepository.updateDelFlagByIds(ids);
    }

    @Override
    public void approvalPass(MemberInfoVo memberInfoVo) {
        Validate.notBlank((CharSequence)memberInfoVo.getId(), (String)"\u4f1a\u5458ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        MemberInfo memberInfo = this.memberInfoRepository.findById(memberInfoVo.getId());
        Validate.notNull((Object)((Object)memberInfo), (String)"\u4f1a\u5458\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        Validate.isTrue((boolean)Objects.equals(MemberApprovalStatusEnum.STAY.getValue(), memberInfo.getApprovalStatus()), (String)"\u8bf7\u9009\u62e9\u672a\u5ba1\u6279\u7684\u4f1a\u5458", (Object[])new Object[0]);
        AbstractCrmUserIdentity abstractLoginUser = this.loginUserService.getAbstractLoginUser();
        memberInfo.setApprovalCode(abstractLoginUser.getUsername());
        memberInfo.setApprovalName(abstractLoginUser.getRealName());
        memberInfo.setApprovalStatus(MemberApprovalStatusEnum.PASS.getValue());
        memberInfo.setApprovalDate(new Date());
        this.memberInfoRepository.updateById((Object)memberInfo);
    }

    @Override
    public void approvalReject(MemberInfoVo memberInfoVo) {
        Validate.notBlank((CharSequence)memberInfoVo.getId(), (String)"\u4f1a\u5458ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)memberInfoVo.getApprovalRejectDesc(), (String)"\u9a73\u56de\u539f\u56e0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        MemberInfo memberInfo = this.memberInfoRepository.findById(memberInfoVo.getId());
        Validate.notNull((Object)((Object)memberInfo), (String)"\u4f1a\u5458\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        Validate.isTrue((boolean)Objects.equals(MemberApprovalStatusEnum.STAY.getValue(), memberInfo.getApprovalStatus()), (String)"\u8bf7\u9009\u62e9\u672a\u5ba1\u6279\u7684\u4f1a\u5458", (Object[])new Object[0]);
        AbstractCrmUserIdentity abstractLoginUser = this.loginUserService.getAbstractLoginUser();
        memberInfo.setApprovalCode(abstractLoginUser.getUsername());
        memberInfo.setApprovalName(abstractLoginUser.getRealName());
        memberInfo.setApprovalStatus(MemberApprovalStatusEnum.REJECT.getValue());
        memberInfo.setApprovalDate(new Date());
        memberInfo.setApprovalRejectDesc(memberInfoVo.getApprovalRejectDesc());
        this.memberInfoRepository.updateById((Object)memberInfo);
    }

    @Override
    public void maintainIndustry(MemberInfoVo memberInfoVo) {
        Validate.notBlank((CharSequence)memberInfoVo.getId(), (String)"\u4f1a\u5458ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)memberInfoVo.getIndustryCode(), (String)"\u8bf7\u9009\u62e9\u884c\u4e1a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)memberInfoVo.getIndustryName(), (String)"\u8bf7\u9009\u62e9\u884c\u4e1a", (Object[])new Object[0]);
        MemberInfo memberInfo = this.memberInfoRepository.findById(memberInfoVo.getId());
        Validate.notNull((Object)((Object)memberInfo), (String)"\u4f1a\u5458\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        memberInfo.setIndustryCode(memberInfoVo.getIndustryCode());
        memberInfo.setIndustryName(memberInfoVo.getIndustryName());
        this.memberInfoRepository.updateById((Object)memberInfo);
    }

    @Override
    public void maintainDepartment(MemberInfoVo memberInfoVo) {
        Validate.notBlank((CharSequence)memberInfoVo.getId(), (String)"\u4f1a\u5458ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)memberInfoVo.getDepartment(), (String)"\u90e8\u95e8\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        MemberInfo memberInfo = this.memberInfoRepository.findById(memberInfoVo.getId());
        Validate.notNull((Object)((Object)memberInfo), (String)"\u4f1a\u5458\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        memberInfo.setDepartment(memberInfoVo.getDepartment());
        this.memberInfoRepository.updateById((Object)memberInfo);
    }

    @Override
    public MemberInfoAllVo findAllDetailById(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u4f1a\u5458ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        MemberInfo memberInfo = this.memberInfoRepository.findById(id);
        Validate.notNull((Object)((Object)memberInfo), (String)"\u4f1a\u5458\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        MemberInfoAllVo memberInfoAllVo = (MemberInfoAllVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)memberInfo, MemberInfoAllVo.class, HashSet.class, LinkedList.class, new String[0]);
        MemberInfoArchives memberInfoArchives = (MemberInfoArchives)((Object)((LambdaQueryChainWrapper)this.memberInfoArchivesRepository.lambdaQuery().eq(MemberInfoArchives::getMemberCode, (Object)memberInfo.getMemberCode())).one());
        if (memberInfoArchives != null) {
            List memberInfoSupplyList;
            memberInfoAllVo = (MemberInfoAllVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)memberInfoArchives, MemberInfoAllVo.class, HashSet.class, LinkedList.class, new String[0]);
            List memberInfoContactList = ((LambdaQueryChainWrapper)this.memberInfoContactRepository.lambdaQuery().eq(MemberInfoContact::getTerminalCode, (Object)memberInfoArchives.getTerminalCode())).list();
            if (CollectionUtils.isNotEmpty((Collection)memberInfoContactList)) {
                memberInfoAllVo.setMemberInfoContactVoList((List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)memberInfoContactList, MemberInfoContact.class, MemberInfoContactVo.class, HashSet.class, ArrayList.class, new String[0]));
            }
            if (CollectionUtils.isNotEmpty((Collection)(memberInfoSupplyList = ((LambdaQueryChainWrapper)this.memberInfoSupplyRepository.lambdaQuery().eq(MemberInfoSupply::getTerminalCode, (Object)memberInfoArchives.getTerminalCode())).list()))) {
                memberInfoAllVo.setMemberInfoSupplyVoList((List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)memberInfoSupplyList, MemberInfoSupply.class, MemberInfoSupplyVo.class, HashSet.class, ArrayList.class, new String[0]));
            }
        }
        return memberInfoAllVo;
    }

    @Override
    public MemberInfoAssetsVo findAssetsDetailById(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u4f1a\u5458ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        MemberInfo memberInfo = this.memberInfoRepository.findById(id);
        Validate.notNull((Object)((Object)memberInfo), (String)"\u4f1a\u5458\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        MemberInfoAssets memberInfoAssets = (MemberInfoAssets)((Object)((LambdaQueryChainWrapper)this.memberInfoAssetsRepository.lambdaQuery().eq(MemberInfoAssets::getMemberCode, (Object)memberInfo.getMemberCode())).one());
        Validate.notNull((Object)((Object)memberInfoAssets), (String)"\u4f1a\u5458\u8d44\u4ea7\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        MemberInfoAssetsVo memberInfoAssetsVo = (MemberInfoAssetsVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)memberInfoAssets, MemberInfoAssetsVo.class, HashSet.class, LinkedList.class, new String[0]);
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.memberInfoLevelChangeRecordRepository.lambdaQuery().eq(MemberInfoLevelChangeRecord::getMemberCode, (Object)memberInfo.getMemberCode())).orderByDesc(UuidOpEntity::getCreateTime)).list();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            memberInfoAssetsVo.setList((List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)list, MemberInfoLevelChangeRecord.class, MemberInfoLevelChangeRecordVo.class, HashSet.class, LinkedList.class, new String[0]));
        }
        return memberInfoAssetsVo;
    }

    @Override
    @Transactional
    public void updateIntegral(MemberInfoIntegralRecordVo memberInfoIntegralRecordVo) {
        Validate.notNull((Object)memberInfoIntegralRecordVo, (String)"\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)memberInfoIntegralRecordVo.getIntegral(), (String)"\u79ef\u5206\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)memberInfoIntegralRecordVo.getMemberId(), (String)"\u4f1a\u5458ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        MemberInfo memberInfo = this.memberInfoRepository.findById(memberInfoIntegralRecordVo.getMemberId());
        Validate.notNull((Object)((Object)memberInfo), (String)"\u4f1a\u5458\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        MemberInfoAssets memberInfoAssets = (MemberInfoAssets)((Object)((LambdaQueryChainWrapper)this.memberInfoAssetsRepository.lambdaQuery().eq(MemberInfoAssets::getMemberCode, (Object)memberInfo.getMemberCode())).one());
        Validate.notNull((Object)((Object)memberInfoAssets), (String)"\u4f1a\u5458\u8d44\u4ea7\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        memberInfoIntegralRecordVo.setMemberCode(memberInfo.getMemberCode());
        memberInfoIntegralRecordVo.setOptTime(new Date());
        memberInfoIntegralRecordVo.setBeforeIntegral(memberInfoAssets.getTotalIntegral());
        memberInfoIntegralRecordVo.setAfterIntegral(Integer.valueOf(memberInfoAssets.getTotalIntegral() + memberInfoIntegralRecordVo.getIntegral()));
        memberInfoIntegralRecordVo.setIntegralCode((String)this.generateCodeService.generateCode("JF", 5).get(0));
        memberInfoIntegralRecordVo.setSource("\u7cfb\u7edf\u540e\u53f0");
        this.memberInfoIntegralRecordService.create(memberInfoIntegralRecordVo);
        memberInfoAssets.setTotalIntegral(memberInfoAssets.getTotalIntegral() + memberInfoIntegralRecordVo.getIntegral());
        memberInfoAssets.setCurrentIntegral(memberInfoAssets.getCurrentIntegral() + memberInfoIntegralRecordVo.getIntegral());
        this.memberInfoAssetsRepository.updateById((Object)memberInfoAssets);
    }

    @Override
    @Transactional
    public void updateGrow(MemberInfoGrowRecordVo memberInfoGrowRecordVo) {
        Validate.notNull((Object)memberInfoGrowRecordVo, (String)"\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)memberInfoGrowRecordVo.getGrow(), (String)"\u6210\u957f\u503c\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)memberInfoGrowRecordVo.getMemberId(), (String)"\u4f1a\u5458ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        MemberInfo memberInfo = this.memberInfoRepository.findById(memberInfoGrowRecordVo.getMemberId());
        Validate.notNull((Object)((Object)memberInfo), (String)"\u4f1a\u5458\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        MemberInfoAssets memberInfoAssets = (MemberInfoAssets)((Object)((LambdaQueryChainWrapper)this.memberInfoAssetsRepository.lambdaQuery().eq(MemberInfoAssets::getMemberCode, (Object)memberInfo.getMemberCode())).one());
        Validate.notNull((Object)((Object)memberInfoAssets), (String)"\u4f1a\u5458\u8d44\u4ea7\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        memberInfoGrowRecordVo.setMemberCode(memberInfo.getMemberCode());
        memberInfoGrowRecordVo.setOptTime(new Date());
        memberInfoGrowRecordVo.setBeforeGrow(memberInfoAssets.getTotalGrow());
        memberInfoGrowRecordVo.setAfterGrow(Integer.valueOf(memberInfoAssets.getTotalGrow() + memberInfoGrowRecordVo.getGrow()));
        memberInfoGrowRecordVo.setGrowCode((String)this.generateCodeService.generateCode("CZZ", 5).get(0));
        memberInfoGrowRecordVo.setSource("\u7cfb\u7edf\u540e\u53f0");
        this.memberInfoGrowRecordService.create(memberInfoGrowRecordVo);
        memberInfoAssets.setTotalGrow(memberInfoAssets.getTotalGrow() + memberInfoGrowRecordVo.getGrow());
        memberInfoAssets.setCurrentGrow(memberInfoAssets.getCurrentGrow() + memberInfoGrowRecordVo.getGrow());
        this.memberInfoAssetsRepository.updateById((Object)memberInfoAssets);
    }

    @Override
    public MemberLoginVo queryMemberInfo(String phone) {
        MemberLoginVo memberLoginVo = null;
        MemberInfo memberInfo = (MemberInfo)((Object)((LambdaQueryChainWrapper)this.memberInfoRepository.lambdaQuery().eq(MemberInfo::getMemberPhone, (Object)phone)).one());
        if (memberInfo != null) {
            memberLoginVo = new MemberLoginVo();
            memberLoginVo.setMemberCode(memberInfo.getMemberCode());
            memberLoginVo.setMemberPhone(memberInfo.getMemberPhone());
            memberLoginVo.setMemberName(memberInfo.getMemberName());
            memberLoginVo.setMemberNick(memberInfo.getMemberNick());
            memberLoginVo.setMemberBirthday(memberInfo.getMemberBirthday());
            memberLoginVo.setUserType(memberInfo.getUserType());
        }
        return memberLoginVo;
    }

    @Override
    public MemberLoginVo createVisitorMember(String phone) {
        MemberInfo memberInfo = new MemberInfo();
        memberInfo.setUserType("2");
        memberInfo.setMemberCode((String)this.generateCodeService.generateCode("YK", 5).get(0));
        memberInfo.setMemberPhone(phone);
        memberInfo.setMemberName("\u6e38\u5ba2" + RandomUtil.randomNumbers((int)5));
        memberInfo.setMemberNick(memberInfo.getMemberName());
        memberInfo.setTenantCode(TenantUtils.getTenantCode());
        memberInfo.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        memberInfo.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        memberInfo.setMemberRegister(new Date());
        this.memberInfoRepository.save((Object)memberInfo);
        MemberLoginVo memberLoginVo = new MemberLoginVo();
        memberLoginVo.setUserType(memberInfo.getUserType());
        memberLoginVo.setMemberCode(memberInfo.getMemberCode());
        memberLoginVo.setMemberPhone(memberInfo.getMemberPhone());
        return memberLoginVo;
    }

    @Override
    public PersonalCenterAPIVo queryMemberAssociationInfo() {
        PersonalCenterAPIVo personalCenterAPIVo = new PersonalCenterAPIVo();
        MemberUserDetails memberLogin = this.userSearchHelper.getMemberLogin();
        Validate.notNull((Object)memberLogin.getMemberCode(), (String)"\u4f1a\u5458\u4fe1\u606f\u4e3a\u7a7a", (Object[])new Object[0]);
        List list = ((LambdaQueryChainWrapper)this.memberInfoContactRepository.lambdaQuery().eq(MemberInfoContact::getMemberCode, (Object)memberLogin.getMemberCode())).list();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            MemberInfoContact memberInfoContact = (MemberInfoContact)((Object)list.get(0));
            personalCenterAPIVo.setWineHotline(memberInfoContact.getContactPhone());
        }
        MemberInfo memberInfo = (MemberInfo)((Object)((LambdaQueryChainWrapper)this.memberInfoRepository.lambdaQuery().eq(MemberInfo::getMemberCode, (Object)memberLogin.getMemberCode())).one());
        memberInfo = Optional.ofNullable(memberInfo).orElse(new MemberInfo());
        personalCenterAPIVo.setTastingAdvisor(memberInfo.getLinkTastingPhone());
        personalCenterAPIVo.setMemberCode(memberLogin.getMemberCode());
        return personalCenterAPIVo;
    }

    @Override
    public PersonalCenterAPIVo queryMemberAssociationInfoCard() {
        PersonalCenterAPIVo personalCenterAPIVo = new PersonalCenterAPIVo();
        MemberUserDetails memberLogin = this.userSearchHelper.getMemberLogin();
        Validate.notNull((Object)memberLogin.getMemberCode(), (String)"\u4f1a\u5458\u4fe1\u606f\u4e3a\u7a7a", (Object[])new Object[0]);
        MemberInfo memberInfo = (MemberInfo)((Object)((LambdaQueryChainWrapper)this.memberInfoRepository.lambdaQuery().eq(MemberInfo::getMemberCode, (Object)memberLogin.getMemberCode())).one());
        memberInfo = Optional.ofNullable(memberInfo).orElse(new MemberInfo());
        personalCenterAPIVo.setMemberName(memberInfo.getMemberName());
        personalCenterAPIVo.setMemberAvatar(memberInfo.getMemberAvatar());
        personalCenterAPIVo.setMemberCode(memberLogin.getMemberCode());
        return personalCenterAPIVo;
    }

    @Override
    public AppletMemberInfoVo getMemberInfo(String memberCode) {
        DateTime date;
        MemberInfo memberInfo = (MemberInfo)((Object)((LambdaQueryChainWrapper)this.memberInfoRepository.lambdaQuery().eq(MemberInfo::getMemberCode, (Object)memberCode)).one());
        Validate.notNull((Object)((Object)memberInfo), (String)"\u4f1a\u5458\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        AppletMemberInfoVo appletMemberInfoVo = new AppletMemberInfoVo();
        BeanUtils.copyProperties((Object)((Object)memberInfo), (Object)appletMemberInfoVo);
        MemberInfoAssets memberInfoAssets = (MemberInfoAssets)((Object)((LambdaQueryChainWrapper)this.memberInfoAssetsRepository.lambdaQuery().eq(MemberInfoAssets::getMemberCode, (Object)memberCode)).one());
        if (memberInfoAssets != null) {
            appletMemberInfoVo.setLevelCode(memberInfoAssets.getLevelCode());
            appletMemberInfoVo.setLevelName(memberInfoAssets.getLevelName());
        }
        if (StringUtils.isBlank((CharSequence)memberInfo.getMemberBirthday()) && (date = DateUtil.offsetHour((Date)memberInfo.getMemberRegister(), (int)1)).after(new Date())) {
            appletMemberInfoVo.setFirstLogin(Boolean.valueOf(true));
        }
        return appletMemberInfoVo;
    }

    @Override
    public void updMemberBirthday(AppletMemberInfoReqVo appletMemberInfoReqVo) {
        MemberInfo memberInfo = (MemberInfo)((Object)((LambdaQueryChainWrapper)this.memberInfoRepository.lambdaQuery().eq(MemberInfo::getMemberCode, (Object)appletMemberInfoReqVo.getMemberCode())).one());
        Validate.notNull((Object)((Object)memberInfo), (String)"\u4f1a\u5458\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        if (StringUtils.isBlank((CharSequence)memberInfo.getMemberBirthday())) {
            memberInfo.setMemberBirthday(appletMemberInfoReqVo.getMemberBirthday());
            this.memberInfoRepository.updateById((Object)memberInfo);
        } else {
            Validate.isTrue((boolean)false, (String)"\u751f\u65e5\u4e0d\u5141\u8bb8\u4e8c\u6b21\u4fee\u6539", (Object[])new Object[0]);
        }
    }

    @Override
    public AppletMemberHoneVo getMemberHome(String memberCode) {
        TastingConsultantVo tastingConsultantVo;
        AppletMemberHoneVo appletMemberHoneVo = new AppletMemberHoneVo();
        MemberInfo memberInfo = (MemberInfo)((Object)((LambdaQueryChainWrapper)this.memberInfoRepository.lambdaQuery().eq(MemberInfo::getMemberCode, (Object)memberCode)).one());
        Validate.notNull((Object)((Object)memberInfo), (String)"\u4f1a\u5458\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        appletMemberHoneVo.setMemberCode(memberInfo.getMemberCode());
        appletMemberHoneVo.setMemberNick(memberInfo.getMemberNick());
        appletMemberHoneVo.setMemberName(memberInfo.getMemberName());
        appletMemberHoneVo.setMemberAvatar(memberInfo.getMemberAvatar());
        appletMemberHoneVo.setMemberBirthday(memberInfo.getMemberBirthday());
        MemberInfoAssets memberInfoAssets = (MemberInfoAssets)((Object)((LambdaQueryChainWrapper)this.memberInfoAssetsRepository.lambdaQuery().eq(MemberInfoAssets::getMemberCode, (Object)memberCode)).one());
        Validate.notNull((Object)((Object)memberInfoAssets), (String)"\u4f1a\u5458\u8d44\u4ea7\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        appletMemberHoneVo.setCurrentIntegral(memberInfoAssets.getCurrentIntegral());
        appletMemberHoneVo.setCurrentGrow(memberInfoAssets.getCurrentGrow());
        appletMemberHoneVo.setLevelCode(memberInfoAssets.getLevelCode());
        appletMemberHoneVo.setLevelName(memberInfoAssets.getLevelName());
        appletMemberHoneVo.setStayBenefitsNum(memberInfoAssets.getStayBenefitsNum());
        appletMemberHoneVo.setBigWheelPrizes(memberInfoAssets.getBigWheelPrizes());
        LevelManageVo levelManageVo = this.levelManageService.findDetailByLevelCode(memberInfoAssets.getLevelCode());
        appletMemberHoneVo.setGrowStart(levelManageVo.getGrowStart());
        appletMemberHoneVo.setGrowEnd(levelManageVo.getGrowEnd());
        appletMemberHoneVo.setCardImageOne(levelManageVo.getCardImageOne());
        appletMemberHoneVo.setCardImageTwo(levelManageVo.getCardImageTwo());
        LevelManageVo nextLevelMangeVo = this.levelManageService.nextLevelManage(levelManageVo);
        if (nextLevelMangeVo != null) {
            appletMemberHoneVo.setNextLevelName(nextLevelMangeVo.getLevelName());
        }
        if ((tastingConsultantVo = this.tastingConsultantService.queryFlagTastingByPhone(memberInfo.getMemberPhone())) != null) {
            appletMemberHoneVo.setTastingCode(tastingConsultantVo.getCode());
            appletMemberHoneVo.setTastingName("\u54c1\u9274\u987e\u95ee");
            appletMemberHoneVo.setTastingPhone(tastingConsultantVo.getPhone());
            String typeValue = this.systemSettingsDetailService.findValueByKey(SystemSettingsDetailEnum.CARD_IMAGE.getValue()).getTypeValue();
            appletMemberHoneVo.setLinkTastingCard(typeValue);
        }
        appletMemberHoneVo.setMemberLevelExpires("2099-01-10");
        return appletMemberHoneVo;
    }

    @Override
    public AppletMemberHoneVo getMemberLevelInfo(String memberCode) {
        AppletMemberHoneVo appletMemberHoneVo = new AppletMemberHoneVo();
        MemberInfo memberInfo = (MemberInfo)((Object)((LambdaQueryChainWrapper)this.memberInfoRepository.lambdaQuery().eq(MemberInfo::getMemberCode, (Object)memberCode)).one());
        Validate.notNull((Object)((Object)memberInfo), (String)"\u4f1a\u5458\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        appletMemberHoneVo.setMemberCode(memberInfo.getMemberCode());
        MemberInfoAssets memberInfoAssets = (MemberInfoAssets)((Object)((LambdaQueryChainWrapper)this.memberInfoAssetsRepository.lambdaQuery().eq(MemberInfoAssets::getMemberCode, (Object)memberCode)).one());
        Validate.notNull((Object)((Object)memberInfoAssets), (String)"\u4f1a\u5458\u8d44\u4ea7\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        appletMemberHoneVo.setCurrentIntegral(memberInfoAssets.getCurrentIntegral());
        appletMemberHoneVo.setCurrentGrow(memberInfoAssets.getCurrentGrow());
        appletMemberHoneVo.setLevelCode(memberInfoAssets.getLevelCode());
        appletMemberHoneVo.setLevelName(memberInfoAssets.getLevelName());
        LevelManageVo levelManageVo = this.levelManageService.findDetailByLevelCode(memberInfoAssets.getLevelCode());
        appletMemberHoneVo.setGrowStart(levelManageVo.getGrowStart());
        appletMemberHoneVo.setGrowEnd(levelManageVo.getGrowEnd());
        appletMemberHoneVo.setCardImageOne(levelManageVo.getCardImageOne());
        appletMemberHoneVo.setCardImageTwo(levelManageVo.getCardImageTwo());
        LevelManageVo nextLevelMangeVo = this.levelManageService.nextLevelManage(levelManageVo);
        if (nextLevelMangeVo != null) {
            appletMemberHoneVo.setNextLevelName(nextLevelMangeVo.getLevelName());
        }
        appletMemberHoneVo.setMemberLevelExpires("2099-01-10");
        String typeValueText = this.systemSettingsDetailService.findValueByKey(SystemSettingsDetailEnum.UPGRADE_RULE_DESC.getValue()).getTypeValueText();
        appletMemberHoneVo.setLevelRule(typeValueText);
        return appletMemberHoneVo;
    }

    @Override
    @DynamicTaskService(cornExpression="0 0 0 1/1 * ?", taskDesc="\u6bcf\u59290\u70b9\u5411\u5f39\u7a97\u8868\u63a8\u9001\u4e00\u6b21\u751f\u65e5\u5f39\u7a97")
    public void addPopupNotify() {
        String memberCode = this.userSearchHelper.getMemberLogin().getMemberCode();
        MemberInfo memberInfo = (MemberInfo)((Object)((LambdaQueryChainWrapper)this.memberInfoRepository.lambdaQuery().eq(MemberInfo::getMemberCode, (Object)memberCode)).one());
        String memberBirthday = memberInfo.getMemberBirthday();
        if (memberBirthday != null) {
            AppletPopupNotifyVo currentApplet = new AppletPopupNotifyVo();
            AppletPopupNotifyVo beforeApplet = new AppletPopupNotifyVo();
            Calendar calendarCurrent = Calendar.getInstance();
            calendarCurrent.set(11, 0);
            calendarCurrent.set(12, 0);
            calendarCurrent.set(13, 0);
            calendarCurrent.set(14, 0);
            Date currentDate = calendarCurrent.getTime();
            DateTime birthday = DateUtil.parse((CharSequence)memberBirthday);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime((Date)birthday);
            calendar.add(6, -10);
            Date birthdayBefore = calendar.getTime();
            if (MemberInfoServiceImpl.isSameDay(currentDate, (Date)birthday)) {
                currentApplet.setEndTime(MemberInfoServiceImpl.getTargetTime((Date)birthday));
                currentApplet.setMemberCode(memberCode);
                currentApplet.setTriggerType(TriggerTypeEnum.BIRTHDAY.getCode());
                currentApplet.setTriggerConditions(TriggerConditionEnum.BIRTHDAY_DAY.getCode());
                this.appletPopupNotifyService.addOne(currentApplet);
            }
            if (MemberInfoServiceImpl.isSameDay(currentDate, birthdayBefore)) {
                beforeApplet.setEndTime(MemberInfoServiceImpl.getTargetTime(birthdayBefore));
                beforeApplet.setMemberCode(memberCode);
                beforeApplet.setTriggerType(TriggerTypeEnum.BIRTHDAY.getCode());
                beforeApplet.setTriggerConditions(TriggerConditionEnum.BIRTHDAY_10.getCode());
                this.appletPopupNotifyService.addOne(beforeApplet);
            }
        }
    }

    private void createValidation(MemberInfoVo memberInfoVo) {
        this.validation(memberInfoVo);
    }

    private void updateValidation(MemberInfoVo memberInfoVo) {
        this.validation(memberInfoVo);
    }

    private void validation(MemberInfoVo memberInfoVo) {
    }

    private static boolean isSameDay(Date date1, Date date2) {
        Calendar calendar1 = Calendar.getInstance();
        calendar1.setTime(date1);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(date2);
        return calendar1.get(2) == calendar2.get(2) && calendar1.get(5) == calendar2.get(5);
    }

    private static Date getTargetTime(Date specifiedDate) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(specifiedDate);
        calendar.set(11, 23);
        calendar.set(12, 53);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }
}

