/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.member.business.member.local.service.internal;

import cn.hutool.core.date.DateTime;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.member.business.member.local.entity.MemberInfoSign;
import com.biz.crm.member.business.member.local.helper.UserSearchHelper;
import com.biz.crm.member.business.member.local.repository.MemberInfoSignRepository;
import com.biz.crm.member.business.member.local.service.MemberInfoIntegralRecordService;
import com.biz.crm.member.business.member.local.service.MemberInfoSignService;
import com.biz.crm.member.business.member.local.service.SignInRuleService;
import com.biz.crm.member.business.member.sdk.dto.MemberInfoSignPaginationDto;
import com.biz.crm.member.business.member.sdk.enums.IntegralSourceEnum;
import com.biz.crm.member.business.member.sdk.event.MemberInfoSignEventListener;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoIntegralRecordVo;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoSignVo;
import com.biz.crm.member.business.member.sdk.vo.MemberSignCountVo;
import com.biz.crm.member.business.member.sdk.vo.MemberSignRecordVo;
import com.biz.crm.member.business.member.sdk.vo.SignInRuleDetailVo;
import com.biz.crm.member.business.member.sdk.vo.SignInRuleVo;
import com.biz.crm.member.business.member.sdk.vo.SignInfoVo;
import com.biz.crm.member.business.member.sdk.vo.SignResultVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="memberInfoSignService")
public class MemberInfoSignServiceImpl
implements MemberInfoSignService {
    private static final Logger log = LoggerFactory.getLogger(MemberInfoSignServiceImpl.class);
    @Autowired(required=false)
    private MemberInfoSignRepository memberInfoSignRepository;
    @Autowired(required=false)
    private List<MemberInfoSignEventListener> eventListeners;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private UserSearchHelper userSearchHelper;
    @Autowired
    private SignInRuleService signInRuleService;
    @Autowired
    private MemberInfoIntegralRecordService memberInfoIntegralRecordService;

    @Override
    public Page<MemberInfoSignVo> findByConditions(Pageable pageable, MemberInfoSignPaginationDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        dto = Optional.ofNullable(dto).orElse(new MemberInfoSignPaginationDto());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.memberInfoSignRepository.findByConditions((Page<MemberInfoSignVo>)page, dto);
    }

    @Override
    public MemberInfoSignVo findDetailById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        MemberInfoSign memberInfoSign = this.memberInfoSignRepository.findById(id);
        MemberInfoSignVo memberInfoSignVo = (MemberInfoSignVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)memberInfoSign, MemberInfoSignVo.class, HashSet.class, LinkedList.class, new String[0]);
        return memberInfoSignVo;
    }

    @Override
    @Transactional
    public MemberInfoSignVo create(MemberInfoSignVo memberInfoSignVo) {
        this.createValidation(memberInfoSignVo);
        MemberInfoSign memberInfoSign = (MemberInfoSign)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)memberInfoSignVo, MemberInfoSign.class, HashSet.class, LinkedList.class, new String[0]));
        memberInfoSign.setTenantCode(TenantUtils.getTenantCode());
        memberInfoSign.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        memberInfoSign.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        this.memberInfoSignRepository.saveOrUpdate((Object)memberInfoSign);
        return memberInfoSignVo;
    }

    @Override
    @Transactional
    public MemberInfoSignVo update(MemberInfoSignVo memberInfoSignVo) {
        this.updateValidation(memberInfoSignVo);
        String currentId = memberInfoSignVo.getId();
        MemberInfoSign current = this.memberInfoSignRepository.findById(currentId);
        current = (MemberInfoSign)((Object)Validate.notNull((Object)((Object)current), (String)"\u4fee\u6539\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]));
        current = (MemberInfoSign)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)memberInfoSignVo, MemberInfoSign.class, HashSet.class, LinkedList.class, new String[0]));
        this.memberInfoSignRepository.saveOrUpdate((Object)current);
        return memberInfoSignVo;
    }

    @Override
    @Transactional
    public void enableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.memberInfoSignRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
    }

    @Override
    @Transactional
    public void disableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.memberInfoSignRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
    }

    @Override
    @Transactional
    public void updateDelFlagByIds(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.memberInfoSignRepository.updateDelFlagByIds(ids);
    }

    @Override
    public MemberSignCountVo signCountNum() {
        return this.memberInfoSignRepository.signCountNum();
    }

    @Override
    public MemberSignRecordVo querySignCountNum(MemberInfoSignPaginationDto memberInfoSignPaginationDto) {
        return this.memberInfoSignRepository.querySignCountNum(memberInfoSignPaginationDto);
    }

    @Override
    public List<MemberInfoSignVo> listCurrentUserMemberInfoSign(String dateTime) {
        Validate.notBlank((CharSequence)dateTime, (String)"\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String memberCode = this.userSearchHelper.getMemberLogin().getMemberCode();
        List<MemberInfoSign> memberInfoSignList = this.memberInfoSignRepository.listMemberInfoSign(dateTime, memberCode, true);
        Collection result = this.nebulaToolkitService.copyCollectionByWhiteList(memberInfoSignList, MemberInfoSign.class, MemberInfoSignVo.class, HashSet.class, LinkedList.class, new String[0]);
        return (List)result;
    }

    @Override
    public SignInfoVo getSignDetail(String dateTime) {
        Validate.notBlank((CharSequence)dateTime, (String)"\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String memberCode = this.userSearchHelper.getMemberLogin().getMemberCode();
        List<MemberInfoSign> memberInfoSignList = this.memberInfoSignRepository.listMemberInfoSign(dateTime, memberCode, false);
        SignInfoVo result = new SignInfoVo();
        this.generateContinueDay(result, memberInfoSignList);
        this.generateSignRuleInfo(result, memberInfoSignList);
        return result;
    }

    @Override
    @Transactional
    public SignResultVo appSign() {
        this.signValidate();
        SignInRuleVo signRule = this.signInRuleService.findDetail();
        Integer everyIntegral = signRule.getEveryIntegral();
        List ruleDetailList = signRule.getList();
        Integer yearIntegralLimit = signRule.getYearIntegralLimit();
        String memberCode = this.userSearchHelper.getMemberLogin().getMemberCode();
        Integer userYearIntegral = this.memberInfoSignRepository.countUserYearIntegral(memberCode);
        int remainIntegral = yearIntegralLimit - userYearIntegral;
        SignResultVo result = new SignResultVo();
        MemberInfoSignVo memberInfoSign = new MemberInfoSignVo();
        memberInfoSign.setMemberCode(memberCode);
        memberInfoSign.setSignTime(new Date(System.currentTimeMillis()));
        Boolean yearLimit = userYearIntegral >= yearIntegralLimit;
        if (yearLimit.booleanValue()) {
            memberInfoSign.setIntegral(Integer.valueOf(0));
            this.create(memberInfoSign);
            result.setYearLimit(Boolean.valueOf(true));
            return result;
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM");
        String monthTime = format.format(new Date(System.currentTimeMillis()));
        List<MemberInfoSign> memberInfoSigns = this.memberInfoSignRepository.listExtendIntegralSign(monthTime, memberCode);
        SignInRuleDetailVo ruleDetailVo = this.computedDetailRuleArrived(ruleDetailList, memberInfoSigns);
        MemberInfoIntegralRecordVo memberIntegralRecord = new MemberInfoIntegralRecordVo();
        memberIntegralRecord.setMemberCode(memberCode);
        memberIntegralRecord.setType(IntegralSourceEnum.DAY_SIGN.getType());
        memberIntegralRecord.setSource(IntegralSourceEnum.DAY_SIGN.getValue());
        if (ObjectUtils.isEmpty((Object)ruleDetailVo)) {
            int realIntegral = remainIntegral >= everyIntegral ? everyIntegral : remainIntegral;
            memberInfoSign.setIntegral(Integer.valueOf(realIntegral));
            this.create(memberInfoSign);
            result.setObtainIntegral(Integer.valueOf(realIntegral));
            result.setMonthExtend(Boolean.valueOf(true));
            memberIntegralRecord.setIntegral(Integer.valueOf(realIntegral));
            this.memberInfoIntegralRecordService.commonInternal(memberIntegralRecord);
            return result;
        }
        List<MemberInfoSign> monthSignInfo = this.memberInfoSignRepository.listMemberInfoSign(monthTime, memberCode, false);
        SignInfoVo continueDayCount = new SignInfoVo();
        this.generateContinueDay(continueDayCount, monthSignInfo);
        Integer continueSignDay = continueDayCount.getContinueSignDay();
        Integer linkDayNum = ruleDetailVo.getLinkDayNum();
        Integer linkIntegralNum = ruleDetailVo.getLinkIntegralNum();
        if (continueSignDay + 1 != linkDayNum) {
            int realIntegral = remainIntegral >= everyIntegral ? everyIntegral : remainIntegral;
            memberInfoSign.setIntegral(Integer.valueOf(realIntegral));
            this.create(memberInfoSign);
            result.setObtainIntegral(Integer.valueOf(realIntegral));
            result.setNextContinueDay(Integer.valueOf(linkDayNum - (continueSignDay + 1)));
            result.setNextObtainIntegral(linkIntegralNum);
            memberIntegralRecord.setIntegral(Integer.valueOf(realIntegral));
            this.memberInfoIntegralRecordService.commonInternal(memberIntegralRecord);
            return result;
        }
        int currentIntegral = linkIntegralNum + everyIntegral;
        int realIntegral = remainIntegral >= currentIntegral ? currentIntegral : remainIntegral;
        memberInfoSign.setIntegral(Integer.valueOf(realIntegral));
        this.create(memberInfoSign);
        result.setObtainIntegral(Integer.valueOf(realIntegral));
        ruleDetailVo.setArrived(Boolean.valueOf(true));
        SignInRuleDetailVo nextRuleDetail = this.getNextRuleDetail(ruleDetailList);
        if (ObjectUtils.isEmpty((Object)nextRuleDetail)) {
            result.setMonthExtend(Boolean.valueOf(true));
            memberIntegralRecord.setIntegral(Integer.valueOf(realIntegral));
            this.memberInfoIntegralRecordService.commonInternal(memberIntegralRecord);
            return result;
        }
        result.setNextContinueDay(nextRuleDetail.getLinkDayNum());
        result.setNextObtainIntegral(nextRuleDetail.getLinkIntegralNum());
        memberIntegralRecord.setIntegral(Integer.valueOf(realIntegral));
        this.memberInfoIntegralRecordService.commonInternal(memberIntegralRecord);
        return result;
    }

    private void signValidate() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String dateTime = format.format(new Date(System.currentTimeMillis()));
        String memberCode = this.userSearchHelper.getMemberLogin().getMemberCode();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.likeRight(MemberInfoSign::getSignTime, (Object)dateTime)).eq(MemberInfoSign::getMemberCode, (Object)memberCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).last("limit 1");
        MemberInfoSign currentSignInfo = (MemberInfoSign)((Object)this.memberInfoSignRepository.getOne((Wrapper)queryWrapper));
        Validate.isTrue((boolean)ObjectUtils.isEmpty((Object)((Object)currentSignInfo)), (String)"\u4e00\u5929\u53ea\u80fd\u7b7e\u5230\u4e00\u6b21", (Object[])new Object[0]);
    }

    private SignInRuleDetailVo getNextRuleDetail(List<SignInRuleDetailVo> ruleDetailList) {
        SignInRuleDetailVo result = ruleDetailList.stream().filter(SignInRuleDetailVo::getArrived).findFirst().get();
        return result;
    }

    private SignInRuleDetailVo computedDetailRuleArrived(List<SignInRuleDetailVo> ruleDetailList, List<MemberInfoSign> extendIntegralSignList) {
        ruleDetailList.sort((obj1, obj2) -> obj1.getLinkDayNum().compareTo(obj2.getLinkDayNum()));
        Map<Integer, Integer> extendMap = extendIntegralSignList.stream().collect(Collectors.toMap(MemberInfoSign::getContinueDay, MemberInfoSign::getExtendObtain));
        for (SignInRuleDetailVo ruleDetail : ruleDetailList) {
            Integer linkDayNum = ruleDetail.getLinkDayNum();
            Integer linkIntegralNum = ruleDetail.getLinkIntegralNum();
            if (extendMap.containsKey(linkDayNum)) {
                Integer integer = extendMap.get(linkDayNum);
                ruleDetail.setArrived(Boolean.valueOf(linkIntegralNum == integer));
                continue;
            }
            return ruleDetail;
        }
        return null;
    }

    private void generateSignRuleInfo(SignInfoVo result, List<MemberInfoSign> memberInfoSignList) {
        List extendObtainSignList = memberInfoSignList.stream().filter(memberInfoSign -> ObjectUtils.isNotEmpty((Object)memberInfoSign.getContinueDay()) && ObjectUtils.isNotEmpty((Object)memberInfoSign.getExtendObtain())).collect(Collectors.toList());
        Map<Integer, Integer> arrivedSignMap = extendObtainSignList.stream().collect(Collectors.toMap(MemberInfoSign::getContinueDay, MemberInfoSign::getExtendObtain));
        SignInRuleVo signRule = this.signInRuleService.findDetail();
        result.setSignInRuleVo(signRule);
        List ruleDetailsList = signRule.getList();
        ruleDetailsList.sort((obj1, obj2) -> obj1.getLinkDayNum().compareTo(obj2.getLinkDayNum()));
        for (SignInRuleDetailVo ruleDetail : ruleDetailsList) {
            Integer linkDayNum = ruleDetail.getLinkDayNum();
            Integer linkIntegralNum = ruleDetail.getLinkIntegralNum();
            if (arrivedSignMap.containsKey(linkDayNum)) {
                ruleDetail.setArrived(Boolean.valueOf(arrivedSignMap.get(linkDayNum) == linkIntegralNum));
                continue;
            }
            Integer continueSignDay = result.getContinueSignDay();
            result.setNextRemainSignDay(Integer.valueOf(linkDayNum - continueSignDay));
            result.setLastObtain(BigDecimal.valueOf(linkIntegralNum.intValue()));
            break;
        }
        ruleDetailsList.stream().map(SignInRuleDetailVo::getLinkIntegralNum).reduce(Integer::sum).ifPresent(extendObtain -> result.setMaxExtendObtain(BigDecimal.valueOf(extendObtain.intValue())));
        result.setSignInRuleDetailVos(ruleDetailsList);
    }

    private void generateContinueDay(SignInfoVo result, List<MemberInfoSign> signList) {
        MemberInfoSign memberInfoSign;
        Date signTime;
        int signDay;
        int currentDay;
        if (CollectionUtils.isEmpty(signList)) {
            result.setContinueSignDay(Integer.valueOf(0));
            return;
        }
        Date lastSignTime = signList.get(0).getSignTime();
        int lastSignDay = DateTime.of((Date)lastSignTime).dayOfMonth();
        result.setTodaySign(Boolean.valueOf(lastSignDay == (currentDay = DateTime.of((long)System.currentTimeMillis()).dayOfMonth())));
        if (lastSignDay < currentDay - 1) {
            result.setContinueSignDay(Integer.valueOf(0));
            return;
        }
        int continueDay = 0;
        for (int i = 0; i < signList.size() && (signDay = DateTime.of((Date)(signTime = (memberInfoSign = signList.get(i)).getSignTime())).dayOfMonth()) + i == lastSignDay; ++i) {
            ++continueDay;
        }
        result.setContinueSignDay(Integer.valueOf(continueDay));
    }

    private void createValidation(MemberInfoSignVo memberInfoSignVo) {
        this.validation(memberInfoSignVo);
    }

    private void updateValidation(MemberInfoSignVo memberInfoSignVo) {
        this.validation(memberInfoSignVo);
    }

    private void validation(MemberInfoSignVo memberInfoSignVo) {
    }
}

