/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.member.business.member.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.member.business.member.local.entity.MemberInfoSupply;
import com.biz.crm.member.business.member.local.repository.MemberInfoSupplyRepository;
import com.biz.crm.member.business.member.local.service.MemberInfoSupplyService;
import com.biz.crm.member.business.member.sdk.dto.MemberInfoSupplyPaginationDto;
import com.biz.crm.member.business.member.sdk.event.MemberInfoSupplyEventListener;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoSupplyVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="memberInfoSupplyService")
public class MemberInfoSupplyServiceImpl
implements MemberInfoSupplyService {
    private static final Logger log = LoggerFactory.getLogger(MemberInfoSupplyServiceImpl.class);
    @Autowired(required=false)
    private MemberInfoSupplyRepository memberInfoSupplyRepository;
    @Autowired(required=false)
    private List<MemberInfoSupplyEventListener> eventListeners;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public Page<MemberInfoSupplyVo> findByConditions(Pageable pageable, MemberInfoSupplyPaginationDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        dto = Optional.ofNullable(dto).orElse(new MemberInfoSupplyPaginationDto());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.memberInfoSupplyRepository.findByConditions((Page<MemberInfoSupplyVo>)page, dto);
    }

    @Override
    public MemberInfoSupplyVo findDetailById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        MemberInfoSupply memberInfoSupply = this.memberInfoSupplyRepository.findById(id);
        MemberInfoSupplyVo memberInfoSupplyVo = (MemberInfoSupplyVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)memberInfoSupply, MemberInfoSupplyVo.class, HashSet.class, LinkedList.class, new String[0]);
        return memberInfoSupplyVo;
    }

    @Override
    @Transactional
    public MemberInfoSupplyVo create(MemberInfoSupplyVo memberInfoSupplyVo) {
        this.createValidation(memberInfoSupplyVo);
        MemberInfoSupply memberInfoSupply = (MemberInfoSupply)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)memberInfoSupplyVo, MemberInfoSupply.class, HashSet.class, LinkedList.class, new String[0]));
        memberInfoSupply.setTenantCode(TenantUtils.getTenantCode());
        memberInfoSupply.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        memberInfoSupply.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        this.memberInfoSupplyRepository.saveOrUpdate((Object)memberInfoSupply);
        return memberInfoSupplyVo;
    }

    @Override
    @Transactional
    public MemberInfoSupplyVo update(MemberInfoSupplyVo memberInfoSupplyVo) {
        this.updateValidation(memberInfoSupplyVo);
        String currentId = memberInfoSupplyVo.getId();
        MemberInfoSupply current = this.memberInfoSupplyRepository.findById(currentId);
        current = (MemberInfoSupply)((Object)Validate.notNull((Object)((Object)current), (String)"\u4fee\u6539\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]));
        current = (MemberInfoSupply)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)memberInfoSupplyVo, MemberInfoSupply.class, HashSet.class, LinkedList.class, new String[0]));
        this.memberInfoSupplyRepository.saveOrUpdate((Object)current);
        return memberInfoSupplyVo;
    }

    @Override
    @Transactional
    public void enableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.memberInfoSupplyRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
    }

    @Override
    @Transactional
    public void disableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.memberInfoSupplyRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
    }

    @Override
    @Transactional
    public void updateDelFlagByIds(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.memberInfoSupplyRepository.updateDelFlagByIds(ids);
    }

    private void createValidation(MemberInfoSupplyVo memberInfoSupplyVo) {
        this.validation(memberInfoSupplyVo);
    }

    private void updateValidation(MemberInfoSupplyVo memberInfoSupplyVo) {
        this.validation(memberInfoSupplyVo);
    }

    private void validation(MemberInfoSupplyVo memberInfoSupplyVo) {
    }
}

