/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.member.business.member.local.service.internal;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.member.business.member.local.entity.MemberInfoTag;
import com.biz.crm.member.business.member.local.repository.MemberInfoTagRepository;
import com.biz.crm.member.business.member.local.service.MemberInfoTagService;
import com.biz.crm.member.business.member.sdk.dto.MemberInfoTagPaginationDto;
import com.biz.crm.member.business.member.sdk.event.MemberInfoTagEventListener;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoTagVo;
import com.biz.crm.member.business.member.sdk.vo.MemberLabelUpdVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="memberInfoTagService")
public class MemberInfoTagServiceImpl
implements MemberInfoTagService {
    private static final Logger log = LoggerFactory.getLogger(MemberInfoTagServiceImpl.class);
    @Autowired(required=false)
    private MemberInfoTagRepository memberInfoTagRepository;
    @Autowired(required=false)
    private List<MemberInfoTagEventListener> eventListeners;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public Page<MemberInfoTagVo> findByConditions(Pageable pageable, MemberInfoTagPaginationDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        dto = Optional.ofNullable(dto).orElse(new MemberInfoTagPaginationDto());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.memberInfoTagRepository.findByConditions((Page<MemberInfoTagVo>)page, dto);
    }

    @Override
    public MemberInfoTagVo findDetailById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        MemberInfoTag memberInfoTag = this.memberInfoTagRepository.findById(id);
        MemberInfoTagVo memberInfoTagVo = (MemberInfoTagVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)memberInfoTag, MemberInfoTagVo.class, HashSet.class, LinkedList.class, new String[0]);
        return memberInfoTagVo;
    }

    @Override
    @Transactional
    public MemberInfoTagVo create(MemberInfoTagVo memberInfoTagVo) {
        this.createValidation(memberInfoTagVo);
        MemberInfoTag memberInfoTag = (MemberInfoTag)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)memberInfoTagVo, MemberInfoTag.class, HashSet.class, LinkedList.class, new String[0]));
        memberInfoTag.setTenantCode(TenantUtils.getTenantCode());
        memberInfoTag.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        memberInfoTag.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        this.memberInfoTagRepository.saveOrUpdate((Object)memberInfoTag);
        return memberInfoTagVo;
    }

    @Override
    @Transactional
    public MemberInfoTagVo update(MemberInfoTagVo memberInfoTagVo) {
        this.updateValidation(memberInfoTagVo);
        String currentId = memberInfoTagVo.getId();
        MemberInfoTag current = this.memberInfoTagRepository.findById(currentId);
        current = (MemberInfoTag)((Object)Validate.notNull((Object)((Object)current), (String)"\u4fee\u6539\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]));
        current = (MemberInfoTag)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)memberInfoTagVo, MemberInfoTag.class, HashSet.class, LinkedList.class, new String[0]));
        this.memberInfoTagRepository.saveOrUpdate((Object)current);
        return memberInfoTagVo;
    }

    @Override
    @Transactional
    public void enableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.memberInfoTagRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
    }

    @Override
    @Transactional
    public void disableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.memberInfoTagRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
    }

    @Override
    @Transactional
    public void updateDelFlagByIds(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.memberInfoTagRepository.updateDelFlagByIds(ids);
    }

    @Override
    public void memberLabelUpd(MemberLabelUpdVo memberLabelUpdVo) {
        Validate.notNull((Object)memberLabelUpdVo, (String)"\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)memberLabelUpdVo.getMemberCode(), (String)"\u4f1a\u5458\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List list = ((LambdaQueryChainWrapper)this.memberInfoTagRepository.lambdaQuery().eq(MemberInfoTag::getMemberCode, (Object)memberLabelUpdVo.getMemberCode())).list();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            Set ids = list.stream().map(UuidEntity::getId).collect(Collectors.toSet());
            this.memberInfoTagRepository.removeByIds(ids);
        }
        if (CollectionUtils.isNotEmpty((Collection)memberLabelUpdVo.getMemberInfoTagVo())) {
            for (MemberInfoTagVo memberInfoTagVo : memberLabelUpdVo.getMemberInfoTagVo()) {
                memberInfoTagVo.setMemberCode(memberLabelUpdVo.getMemberCode());
                this.create(memberInfoTagVo);
            }
        }
    }

    @Override
    public List<MemberInfoTagVo> queryMemberLabel(String memberCode) {
        Validate.notBlank((CharSequence)memberCode, (String)"\u4f1a\u5458\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List list = ((LambdaQueryChainWrapper)this.memberInfoTagRepository.lambdaQuery().eq(MemberInfoTag::getMemberCode, (Object)memberCode)).list();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)list, MemberInfoTag.class, MemberInfoTagVo.class, HashSet.class, ArrayList.class, new String[0]);
        }
        return Lists.newArrayList();
    }

    private void createValidation(MemberInfoTagVo memberInfoTagVo) {
        this.validation(memberInfoTagVo);
    }

    private void updateValidation(MemberInfoTagVo memberInfoTagVo) {
        this.validation(memberInfoTagVo);
    }

    private void validation(MemberInfoTagVo memberInfoTagVo) {
        Validate.notBlank((CharSequence)memberInfoTagVo.getMemberCode(), (String)"\u4f1a\u5458\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)memberInfoTagVo.getTagCode(), (String)"\u6807\u7b7e\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)memberInfoTagVo.getTagName(), (String)"\u6807\u7b7e\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)memberInfoTagVo.getTagType(), (String)"\u6807\u7b7e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }
}

