/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.member.business.member.local.service.internal;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.member.business.member.local.entity.MessageManage;
import com.biz.crm.member.business.member.local.entity.MessageNotify;
import com.biz.crm.member.business.member.local.entity.PopupNotify;
import com.biz.crm.member.business.member.local.repository.MessageManageRepository;
import com.biz.crm.member.business.member.local.repository.MessageNotifyRepository;
import com.biz.crm.member.business.member.local.repository.PopupNotifyRepository;
import com.biz.crm.member.business.member.local.service.MessageManageService;
import com.biz.crm.member.business.member.local.utils.AssertUtils;
import com.biz.crm.member.business.member.sdk.dto.MessageManageDto;
import com.biz.crm.member.business.member.sdk.dto.MessageManagePageDto;
import com.biz.crm.member.business.member.sdk.dto.MessageNotifyDto;
import com.biz.crm.member.business.member.sdk.dto.PopupNotifyDto;
import com.biz.crm.member.business.member.sdk.enums.TriggerConditionEnum;
import com.biz.crm.member.business.member.sdk.vo.MessageManagePageVo;
import com.biz.crm.member.business.member.sdk.vo.MessageManageVo;
import com.biz.crm.member.business.member.sdk.vo.MessageNotifyVo;
import com.biz.crm.member.business.member.sdk.vo.PopupNotifyVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class MessageManageServiceImpl
implements MessageManageService {
    @Autowired
    private MessageManageRepository messageManageRepository;
    @Autowired
    private MessageNotifyRepository messageNotifyRepository;
    @Autowired
    private PopupNotifyRepository popupNotifyRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private RedisMutexService redisMutexService;
    public static final String MMS_MESSAGE_MANAGE_CODE_REDIS_KEY = "mms:message:manage:code:index:%s";
    public static final String MMS_MESSAGE_MANAGE_CODE_PREFIX = "MM";

    private String generateCode(String tenantCode) {
        String redisKey = String.format(MMS_MESSAGE_MANAGE_CODE_REDIS_KEY, tenantCode);
        String index = this.redisMutexService.getAndIncrement(redisKey, 1L, Integer.valueOf(6));
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        return StringUtils.join((Object[])new String[]{MMS_MESSAGE_MANAGE_CODE_PREFIX, format.format(new Date()), index});
    }

    @Override
    public Page<MessageManagePageVo> findByConditions(Pageable pageable, MessageManagePageDto messageManageDto) {
        if (Objects.isNull(messageManageDto)) {
            messageManageDto = new MessageManagePageDto();
        }
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.messageManageRepository.findByConditions((Page<MessageManageVo>)page, messageManageDto);
    }

    @Override
    public MessageManageVo findDetailById(String id) {
        PopupNotify popupNotify;
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        MessageManage messageManage = (MessageManage)((Object)this.messageManageRepository.getById((Serializable)((Object)id)));
        Validate.notNull((Object)((Object)messageManage), (String)"\u6d88\u606f\u914d\u7f6e\u4e0d\u5b58\u5728\uff01", (Object[])new Object[0]);
        MessageManageVo messageManageVo = (MessageManageVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)messageManage, MessageManageVo.class, HashSet.class, LinkedList.class, new String[0]);
        MessageNotify messageNotify = (MessageNotify)((Object)((LambdaQueryChainWrapper)this.messageNotifyRepository.lambdaQuery().eq(MessageNotify::getMessageCode, (Object)messageManage.getCode())).one());
        if (Objects.nonNull((Object)messageNotify)) {
            MessageNotifyVo messageNotifyVo = (MessageNotifyVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)messageNotify, MessageNotifyVo.class, HashSet.class, LinkedList.class, new String[0]);
            messageManageVo.setMessage(messageNotifyVo);
        }
        if (Objects.nonNull((Object)(popupNotify = (PopupNotify)((Object)((LambdaQueryChainWrapper)this.popupNotifyRepository.lambdaQuery().eq(PopupNotify::getMessageCode, (Object)messageManage.getCode())).one())))) {
            PopupNotifyVo popupNotifyVo = (PopupNotifyVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)popupNotify, PopupNotifyVo.class, HashSet.class, LinkedList.class, new String[0]);
            messageManageVo.setPopup(popupNotifyVo);
        }
        return messageManageVo;
    }

    @Override
    @Transactional
    public MessageManageVo create(MessageManageDto messageManageDto) {
        PopupNotifyDto popup;
        this.createValidate(messageManageDto);
        String tenantCode = TenantUtils.getTenantCode();
        messageManageDto.setCode(this.generateCode(tenantCode));
        messageManageDto.setTenantCode(tenantCode);
        messageManageDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        messageManageDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        MessageManage messageManage = (MessageManage)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)messageManageDto, MessageManage.class, HashSet.class, LinkedList.class, new String[0]));
        this.messageManageRepository.saveOrUpdate((Object)messageManage);
        MessageNotifyDto message = messageManageDto.getMessage();
        if (Objects.nonNull(message) && messageManage.getMessageNotify().booleanValue()) {
            message.setMessageCode(messageManage.getCode());
            message.setTenantCode(TenantUtils.getTenantCode());
            message.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            message.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            MessageNotify messageNotify = (MessageNotify)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)message, MessageNotify.class, HashSet.class, LinkedList.class, new String[0]));
            this.messageNotifyRepository.saveOrUpdate((Object)messageNotify);
        }
        if (Objects.nonNull(popup = messageManageDto.getPopup()) && messageManage.getPopupNotify().booleanValue()) {
            popup.setMessageCode(messageManage.getCode());
            popup.setTenantCode(TenantUtils.getTenantCode());
            popup.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            popup.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            PopupNotify popupNotify = (PopupNotify)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)popup, PopupNotify.class, HashSet.class, LinkedList.class, new String[0]));
            this.popupNotifyRepository.saveOrUpdate((Object)popupNotify);
        }
        return (MessageManageVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)messageManage, MessageManageVo.class, HashSet.class, LinkedList.class, new String[0]);
    }

    private void createValidate(MessageManageDto messageManageDto) {
        Validate.notNull((Object)messageManageDto, (String)"\u65b0\u589e\u5b9e\u4f53\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)messageManageDto.getTriggerType(), (String)"\u89e6\u53d1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)messageManageDto.getTriggerCondition(), (String)"\u89e6\u53d1\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)messageManageDto.getTriggerWeight(), (String)"\u6743\u91cd\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)messageManageDto.getMessageNotify(), (String)"\u662f\u5426\u6d88\u606f\u901a\u77e5\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)messageManageDto.getPopupNotify(), (String)"\u662f\u5426\u5f39\u7a97\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        switch (TriggerConditionEnum.codeToEnum((String)messageManageDto.getTriggerCondition())) {
            case MEMBER_APPROVAL_PASS: {
                Validate.isTrue((messageManageDto.getMessageNotify() == false ? 1 : 0) != 0, (String)"\u4f1a\u5458\u5ba1\u6279\u901a\u8fc7\u4e0d\u80fd\u5f00\u542f\u6d88\u606f\u901a\u77e5", (Object[])new Object[0]);
                Validate.isTrue((messageManageDto.getPopupNotify() == false ? 1 : 0) != 0, (String)"\u4f1a\u5458\u5ba1\u6279\u901a\u8fc7\u4e0d\u80fd\u5f00\u542f\u5f39\u7a97", (Object[])new Object[0]);
                break;
            }
            case BENEFIT_NO_CLAIM_30: 
            case BENEFIT_EXCHANGE_SUCCESS: 
            case ORDER_EXPIRED_30: 
            case ACTIVITY_APPROVAL_PASS: 
            case ACTIVITY_REJECT: 
            case ACTIVITY_SIGN_3: {
                AssertUtils.isTrue(messageManageDto.getPopupNotify() == false, "\u4e0d\u80fd\u5f00\u542f\u5f00\u5c4f\u5f39\u7a97");
            }
        }
        if (messageManageDto.getMessageNotify().booleanValue()) {
            MessageNotifyDto message = messageManageDto.getMessage();
            Validate.notNull((Object)message, (String)"\u5f00\u542f\u6d88\u606f\u901a\u77e5\u65f6\uff0c\u6d88\u606f\u901a\u77e5\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)message.getTitle(), (String)"\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)message.getContent(), (String)"\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
        if (messageManageDto.getPopupNotify().booleanValue()) {
            PopupNotifyDto popup = messageManageDto.getPopup();
            Validate.notNull((Object)popup, (String)"\u5f00\u542f\u5f39\u7a97\u65f6\uff0c\u5f39\u7a97\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)popup.getFrequency(), (String)"\u9891\u6b21\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)popup.getSkipType(), (String)"\u8df3\u8f6c\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notNull((Object)popup.getStartDate(), (String)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notNull((Object)popup.getEndDate(), (String)"\u7ed3\u675f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
    }

    @Override
    @Transactional
    public MessageManageVo update(MessageManageDto messageManageDto) {
        PopupNotifyDto popup;
        this.updateValidate(messageManageDto);
        MessageManage oldMessageManage = (MessageManage)((Object)this.messageManageRepository.getById((Serializable)((Object)messageManageDto.getId())));
        Validate.notNull((Object)((Object)oldMessageManage), (String)"\u6d88\u606f\u914d\u7f6e\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        MessageManage messageManage = (MessageManage)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)messageManageDto, MessageManage.class, HashSet.class, LinkedList.class, new String[0]));
        messageManage.setTenantCode(oldMessageManage.getTenantCode());
        messageManage.setEnableStatus(oldMessageManage.getEnableStatus());
        messageManage.setDelFlag(oldMessageManage.getDelFlag());
        this.messageManageRepository.saveOrUpdate((Object)messageManage);
        QueryWrapper messageNotifyQueryWrapper = new QueryWrapper();
        messageNotifyQueryWrapper.eq((Object)"message_code", (Object)messageManage.getCode());
        messageNotifyQueryWrapper.eq((Object)"tenant_code", (Object)messageManage.getTenantCode());
        this.messageNotifyRepository.remove((Wrapper)messageNotifyQueryWrapper);
        QueryWrapper popupNotifyQueryWrapper = new QueryWrapper();
        popupNotifyQueryWrapper.eq((Object)"message_code", (Object)messageManage.getCode());
        popupNotifyQueryWrapper.eq((Object)"tenant_code", (Object)messageManage.getTenantCode());
        this.popupNotifyRepository.remove((Wrapper)popupNotifyQueryWrapper);
        MessageNotifyDto message = messageManageDto.getMessage();
        if (Objects.nonNull(message) && messageManageDto.getMessageNotify().booleanValue()) {
            message.setMessageCode(messageManage.getCode());
            message.setTenantCode(TenantUtils.getTenantCode());
            message.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            message.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            MessageNotify messageNotify = (MessageNotify)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)message, MessageNotify.class, HashSet.class, LinkedList.class, new String[0]));
            this.messageNotifyRepository.saveOrUpdate((Object)messageNotify);
        }
        if (Objects.nonNull(popup = messageManageDto.getPopup()) && messageManageDto.getPopupNotify().booleanValue()) {
            popup.setMessageCode(messageManage.getCode());
            popup.setTenantCode(TenantUtils.getTenantCode());
            popup.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            popup.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            PopupNotify popupNotify = (PopupNotify)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)popup, PopupNotify.class, HashSet.class, LinkedList.class, new String[0]));
            this.popupNotifyRepository.saveOrUpdate((Object)popupNotify);
        }
        return (MessageManageVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)messageManage, MessageManageVo.class, HashSet.class, LinkedList.class, new String[0]);
    }

    private void updateValidate(MessageManageDto messageManageDto) {
        Validate.notNull((Object)messageManageDto, (String)"\u7f16\u8f91\u5b9e\u4f53\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)messageManageDto.getTriggerType(), (String)"\u89e6\u53d1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)messageManageDto.getTriggerCondition(), (String)"\u89e6\u53d1\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)messageManageDto.getTriggerWeight(), (String)"\u6743\u91cd\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)messageManageDto.getMessageNotify(), (String)"\u662f\u5426\u6d88\u606f\u901a\u77e5\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)messageManageDto.getPopupNotify(), (String)"\u662f\u5426\u5f39\u7a97\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)messageManageDto.getId(), (String)"\u7f16\u8f91\u65f6\uff0c\u4e3b\u952eid\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)messageManageDto.getCode(), (String)"\u7f16\u8f91\u65f6\uff0c\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (messageManageDto.getMessageNotify().booleanValue()) {
            MessageNotifyDto message = messageManageDto.getMessage();
            Validate.notNull((Object)message, (String)"\u5f00\u542f\u6d88\u606f\u901a\u77e5\u65f6\uff0c\u6d88\u606f\u901a\u77e5\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)message.getTitle(), (String)"\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)message.getContent(), (String)"\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
        if (messageManageDto.getPopupNotify().booleanValue()) {
            PopupNotifyDto popup = messageManageDto.getPopup();
            Validate.notNull((Object)popup, (String)"\u5f00\u542f\u5f39\u7a97\u65f6\uff0c\u5f39\u7a97\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)popup.getFrequency(), (String)"\u9891\u6b21\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)popup.getSkipType(), (String)"\u8df3\u8f6c\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notNull((Object)popup.getStartDate(), (String)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notNull((Object)popup.getEndDate(), (String)"\u7ed3\u675f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
    }

    @Override
    public void enableBatch(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.messageManageRepository.lambdaUpdate().set(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.ENABLE.getCode())).in(UuidEntity::getId, ids)).update();
    }

    @Override
    public void disableBatch(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.messageManageRepository.lambdaUpdate().set(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.DISABLE.getCode())).in(UuidEntity::getId, ids)).update();
    }

    @Override
    public void deleteBatch(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.messageManageRepository.lambdaUpdate().set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).in(UuidEntity::getId, ids)).update();
    }
}

