/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.member.business.member.local.service.internal;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.member.business.member.local.entity.MessageManage;
import com.biz.crm.member.business.member.local.entity.MessageNotify;
import com.biz.crm.member.business.member.local.helper.UserSearchHelper;
import com.biz.crm.member.business.member.local.repository.MessageManageRepository;
import com.biz.crm.member.business.member.local.repository.MessageNotifyRepository;
import com.biz.crm.member.business.member.local.service.MessageNotifyService;
import com.biz.crm.member.business.member.sdk.dto.MessageNotifyPaginationDto;
import com.biz.crm.member.business.member.sdk.vo.MessageNotifyVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service(value="messageNotifyServiceImpl")
public class MessageNotifyServiceImpl
implements MessageNotifyService {
    @Autowired
    private MessageNotifyRepository messageNotifyRepository;
    @Autowired
    private MessageManageRepository messageManageRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private UserSearchHelper userSearchHelper;

    @Override
    public Page<MessageNotifyVo> findByConditions(Pageable pageable, MessageNotifyPaginationDto messageManageDto) {
        if (Objects.isNull(messageManageDto)) {
            messageManageDto = new MessageNotifyPaginationDto();
        }
        messageManageDto.setMemberCode(this.userSearchHelper.getMemberLogin().getMemberCode());
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.messageNotifyRepository.findByConditions((Page<MessageNotifyVo>)page, messageManageDto);
    }

    @Override
    public void create(MessageNotifyVo messageNotifyVo) {
        MessageManage messageManage = (MessageManage)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.messageManageRepository.lambdaQuery().eq(MessageManage::getTriggerType, (Object)messageNotifyVo.getTriggerType())).eq(MessageManage::getTriggerCondition, (Object)messageNotifyVo.getTriggerCondition())).one());
        if (messageManage.getMessageNotify().booleanValue()) {
            messageNotifyVo.setTitle(messageManage.getTitle());
            messageNotifyVo.setContent(messageManage.getContent());
            MessageNotify messageNotify = (MessageNotify)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)messageNotifyVo, MessageNotify.class, HashSet.class, LinkedList.class, new String[0]));
            messageNotify.setSendFlag("0");
            messageNotify.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            messageNotify.setTenantCode(TenantUtils.getTenantCode());
            messageNotify.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            this.messageNotifyRepository.saveOrUpdate((Object)messageNotify);
        }
    }

    private void validate(MessageNotifyVo messageNotifyVo) {
        Validate.notNull((Object)messageNotifyVo.getMemberCode(), (String)"\u4f1a\u5458\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)messageNotifyVo.getTriggerType(), (String)"\u89e6\u53d1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)messageNotifyVo.getTriggerCondition(), (String)"\u89e6\u53d1\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }
}

