/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.member.business.member.local.service.internal;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.member.business.member.local.entity.PrizeEntity;
import com.biz.crm.member.business.member.local.observer.RafflePrizeObserver;
import com.biz.crm.member.business.member.local.repository.PrizeRepository;
import com.biz.crm.member.business.member.local.service.PrizeService;
import com.biz.crm.member.business.member.sdk.dto.PrizeDto;
import com.biz.crm.member.business.member.sdk.enums.PrizeInventoryEnum;
import com.biz.crm.member.business.member.sdk.enums.PrizeTypeEnum;
import com.biz.crm.member.business.member.sdk.vo.PrizeVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PrizeServiceImpl
implements PrizeService {
    @Autowired
    private PrizeRepository prizeRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private RedisMutexService redisMutexService;
    @Autowired
    private RafflePrizeObserver rafflePrizeObserver;
    public static final String MMS_PRIZE_CODE_REDIS_KEY = "mms:prize:code:index:%s";
    public static final String MMS_PRIZE_CODE_PREFIX = "JP";

    private String generateCode(String tenantCode) {
        String redisKey = String.format(MMS_PRIZE_CODE_REDIS_KEY, tenantCode);
        String index = this.redisMutexService.getAndIncrement(redisKey, 1L, Integer.valueOf(6));
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        return StringUtils.join((Object[])new String[]{MMS_PRIZE_CODE_PREFIX, format.format(new Date()), index});
    }

    @Override
    public Page<PrizeVo> findByConditions(Pageable pageable, PrizeDto prizeDto) {
        if (Objects.isNull(prizeDto)) {
            prizeDto = new PrizeDto();
        }
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.prizeRepository.findByConditions((Page<PrizeVo>)page, prizeDto);
    }

    @Override
    public PrizeVo findDetailById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        PrizeVo prizeVo = this.prizeRepository.findDetailById(id);
        if (PrizeInventoryEnum.EXITS.getCode().equals(prizeVo.getInventory())) {
            prizeVo.setPutNum(prizeVo.getTotalNum().subtract(prizeVo.getInventoryNum()));
        }
        return prizeVo;
    }

    @Override
    public PrizeVo create(PrizeDto prizeDto) {
        this.createValidate(prizeDto);
        prizeDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        prizeDto.setCode(this.generateCode(TenantUtils.getTenantCode()));
        prizeDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        prizeDto.setTenantCode(TenantUtils.getTenantCode());
        PrizeEntity prizeEntity = (PrizeEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)prizeDto, PrizeEntity.class, HashSet.class, LinkedList.class, new String[0]));
        this.prizeRepository.saveOrUpdate((Object)prizeEntity);
        return (PrizeVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)prizeEntity, PrizeVo.class, HashSet.class, LinkedList.class, new String[0]);
    }

    private void createValidate(PrizeDto prizeDto) {
        Validate.notNull((Object)prizeDto, (String)" \u65b0\u589e\u8bf7\u6c42\u5b9e\u4f53\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)prizeDto.getPrizeType(), (String)"\u5956\u54c1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)prizeDto.getPrizeName(), (String)"\u5956\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (!PrizeTypeEnum.THANKS.getCode().equals(prizeDto.getPrizeType())) {
            Validate.notNull((Object)prizeDto.getInventory(), (String)"\u662f\u5426\u5e93\u5b58\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            if (PrizeInventoryEnum.EXITS.getCode().equals(prizeDto.getInventory())) {
                Validate.notNull((Object)prizeDto.getInventoryNum(), (String)"\u5e93\u5b58\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                prizeDto.setTotalNum(prizeDto.getInventoryNum());
                prizeDto.setPutNumHit(BigDecimal.ZERO);
            }
        }
    }

    @Override
    public PrizeVo update(PrizeDto prizeDto) {
        this.updateValidate(prizeDto);
        PrizeEntity oldPrize = (PrizeEntity)((Object)this.prizeRepository.getById((Serializable)((Object)prizeDto.getId())));
        if (PrizeInventoryEnum.WITH_OUT.getCode().equals(oldPrize.getInventory()) && PrizeInventoryEnum.EXITS.getCode().equals(prizeDto.getInventory())) {
            prizeDto.setTotalNum(prizeDto.getInventoryNum());
        }
        prizeDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        prizeDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        prizeDto.setTenantCode(TenantUtils.getTenantCode());
        PrizeEntity prizeEntity = (PrizeEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)prizeDto, PrizeEntity.class, HashSet.class, LinkedList.class, new String[0]));
        this.prizeRepository.saveOrUpdate((Object)prizeEntity);
        return (PrizeVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)prizeEntity, PrizeVo.class, HashSet.class, LinkedList.class, new String[0]);
    }

    private void updateValidate(PrizeDto prizeDto) {
        Validate.notNull((Object)prizeDto, (String)" \u65b0\u589e\u8bf7\u6c42\u5b9e\u4f53\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)prizeDto.getPrizeType(), (String)"\u5956\u54c1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)prizeDto.getPrizeName(), (String)"\u5956\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (!PrizeTypeEnum.THANKS.getCode().equals(prizeDto.getPrizeType())) {
            Validate.notNull((Object)prizeDto.getInventory(), (String)"\u662f\u5426\u5e93\u5b58\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            if (PrizeInventoryEnum.EXITS.getCode().equals(prizeDto.getInventory())) {
                Validate.notNull((Object)prizeDto.getInventoryNum(), (String)"\u5e93\u5b58\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            }
        }
        Validate.notBlank((CharSequence)prizeDto.getId(), (String)"\u7f16\u8f91\u65f6\u4e3b\u952eid\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)prizeDto.getCode(), (String)"\u7f16\u8f91\u65f6,\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }

    @Override
    public void enableBatch(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.prizeRepository.lambdaUpdate().set(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.ENABLE.getCode())).in(UuidEntity::getId, ids)).update();
    }

    @Override
    public void disableBatch(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.prizeRepository.lambdaUpdate().set(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.DISABLE.getCode())).in(UuidEntity::getId, ids)).update();
    }

    @Override
    public void deleteBatch(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.prizeRepository.lambdaUpdate().set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).in(UuidEntity::getId, ids)).update();
    }

    @Override
    public List<PrizeEntity> findByCodes(List<String> codes) {
        if (CollectionUtils.isEmpty(codes)) {
            return null;
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.prizeRepository.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).in(PrizeEntity::getCode, codes)).list();
    }

    @Override
    public PrizeEntity findByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        return (PrizeEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.prizeRepository.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(PrizeEntity::getCode, (Object)code)).one());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void adjust(String id, BigDecimal number) {
        if (StringUtils.isBlank((CharSequence)id) || Objects.isNull(number)) {
            return;
        }
        PrizeEntity prizeEntity = (PrizeEntity)((Object)this.prizeRepository.getById((Serializable)((Object)id)));
        Validate.notNull((Object)((Object)prizeEntity), (String)"\u5956\u54c1\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        String redisKey = String.format("mms:prize:lock:index:%s", TenantUtils.getTenantCode() + prizeEntity.getCode());
        boolean locked = false;
        try {
            locked = this.redisMutexService.tryLock(redisKey, TimeUnit.SECONDS, 5);
            PrizeEntity entity = (PrizeEntity)((Object)this.prizeRepository.getById((Serializable)((Object)id)));
            BigDecimal inventoryNum = entity.getInventoryNum();
            Validate.isTrue((inventoryNum.compareTo(number.negate()) > 0 ? 1 : 0) != 0, (String)"\u8c03\u6574\u6570\u91cf\u8d85\u8fc7\u5e93\u5b58\u6570\u91cf", (Object[])new Object[0]);
            entity.setInventoryNum(inventoryNum.add(number));
            this.prizeRepository.saveOrUpdate((Object)entity);
        }
        finally {
            if (locked) {
                this.redisMutexService.unlock(redisKey);
            }
        }
    }

    @Override
    public void updateInventory(Map<String, BigDecimal> putMap) {
        this.prizeRepository.updateInventory(putMap);
    }

    @Override
    public void save(PrizeEntity prizeEntity) {
        this.prizeRepository.saveOrUpdate((Object)prizeEntity);
    }
}

