/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.member.business.member.local.service.internal;

import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.member.business.member.local.entity.ProductCategory;
import com.biz.crm.member.business.member.local.repository.ProductCategoryRepository;
import com.biz.crm.member.business.member.local.service.ProductCategoryService;
import com.biz.crm.member.business.member.sdk.dto.ProductCategoryDto;
import com.biz.crm.member.business.member.sdk.vo.ProductCategoryVo;
import com.biz.crm.member.business.member.sdk.vo.ProductPageVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class ProductCategoryServiceImpl
implements ProductCategoryService {
    @Autowired
    private ProductCategoryRepository productCategoryRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private RedisMutexService redisMutexService;
    public static final String MMS_CATEGORY_PRODUCT_CODE_REDIS_KEY = "mms:category:product:code:index:%s";
    public static final String MMS_CATEGORY_PRODUCT_CODE_PREFIX = "SPFL";

    @Override
    public Page<ProductCategoryVo> findByConditions(Pageable pageable, ProductCategoryDto productCategoryDto) {
        if (Objects.isNull(productCategoryDto)) {
            productCategoryDto = new ProductCategoryDto();
        }
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.productCategoryRepository.findByConditions((Page<ProductPageVo>)page, productCategoryDto);
    }

    @Override
    public ProductCategoryVo findDetailById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        ProductCategory productCategory = (ProductCategory)((Object)this.productCategoryRepository.getById((Serializable)((Object)id)));
        return (ProductCategoryVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)productCategory, ProductCategoryVo.class, HashSet.class, LinkedList.class, new String[0]);
    }

    @Override
    public ProductCategoryVo create(ProductCategoryDto productCategoryDto) {
        Validate.notNull((Object)productCategoryDto, (String)"\u65b0\u589e\u5b9e\u4f53\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)productCategoryDto.getCategoryName(), (String)"\u5206\u7c7b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)productCategoryDto.getSortIndex(), (String)"\u5206\u7c7b\u6392\u5e8f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (productCategoryDto.getSortIndex() <= 0) {
            throw new RuntimeException("\u6392\u5e8f\u8bf7\u8f93\u5165\u5927\u4e8e0\u7684\u6574\u6570");
        }
        productCategoryDto.setCategoryCode(this.generateCode(TenantUtils.getTenantCode()));
        productCategoryDto.setTenantCode(TenantUtils.getTenantCode());
        productCategoryDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        productCategoryDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        ProductCategory productCategory = (ProductCategory)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)productCategoryDto, ProductCategory.class, HashSet.class, LinkedList.class, new String[0]));
        this.productCategoryRepository.saveOrUpdate((Object)productCategory);
        return (ProductCategoryVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)productCategory, ProductCategoryVo.class, HashSet.class, LinkedList.class, new String[0]);
    }

    private String generateCode(String tenantCode) {
        String redisKey = String.format(MMS_CATEGORY_PRODUCT_CODE_REDIS_KEY, tenantCode);
        String index = this.redisMutexService.getAndIncrement(redisKey, 1L, Integer.valueOf(6));
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        return StringUtils.join((Object[])new String[]{MMS_CATEGORY_PRODUCT_CODE_PREFIX, format.format(new Date()), index});
    }

    @Override
    public ProductCategoryVo update(ProductCategoryDto productCategoryDto) {
        Validate.notNull((Object)productCategoryDto, (String)"\u4fee\u6539\u5b9e\u4f53\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)productCategoryDto.getCategoryName(), (String)"\u5206\u7c7b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)productCategoryDto.getSortIndex(), (String)"\u5206\u7c7b\u6392\u5e8f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)productCategoryDto.getId(), (String)"\u7f16\u8f91\u65f6\uff0c\u4e3b\u952eid\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)productCategoryDto.getCategoryCode(), (String)"\u7f16\u8f91\u65f6\uff0c\u5206\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (productCategoryDto.getSortIndex() <= 0) {
            throw new RuntimeException("\u6392\u5e8f\u8bf7\u8f93\u5165\u5927\u4e8e0\u7684\u6574\u6570");
        }
        ProductCategory productCategory = (ProductCategory)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)productCategoryDto, ProductCategory.class, HashSet.class, LinkedList.class, new String[0]));
        this.productCategoryRepository.saveOrUpdate((Object)productCategory);
        return (ProductCategoryVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)productCategory, ProductCategoryVo.class, HashSet.class, LinkedList.class, new String[0]);
    }

    @Override
    public void enableBatch(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.productCategoryRepository.lambdaUpdate().set(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.ENABLE.getCode())).in(UuidEntity::getId, ids)).update();
    }

    @Override
    public void disableBatch(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.productCategoryRepository.lambdaUpdate().set(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.DISABLE.getCode())).in(UuidEntity::getId, ids)).update();
    }

    @Override
    public void deleteBatch(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.productCategoryRepository.lambdaUpdate().set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).in(UuidEntity::getId, ids)).update();
    }

    @Override
    public void down(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return;
        }
        this.productCategoryRepository.down(id);
    }

    @Override
    public void up(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return;
        }
        this.productCategoryRepository.up(id);
    }
}

