/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.member.business.member.local.service.internal;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.member.business.member.local.entity.Product;
import com.biz.crm.member.business.member.local.entity.ProductExchangeRule;
import com.biz.crm.member.business.member.local.entity.ProductFile;
import com.biz.crm.member.business.member.local.repository.ProductExchangeRuleRepository;
import com.biz.crm.member.business.member.local.repository.ProductFileRepository;
import com.biz.crm.member.business.member.local.repository.ProductRepository;
import com.biz.crm.member.business.member.local.service.ProductService;
import com.biz.crm.member.business.member.sdk.dto.ProductDto;
import com.biz.crm.member.business.member.sdk.dto.ProductExchangeRuleDto;
import com.biz.crm.member.business.member.sdk.dto.ProductFileDto;
import com.biz.crm.member.business.member.sdk.dto.ProductPageDto;
import com.biz.crm.member.business.member.sdk.enums.ProductSourceEnum;
import com.biz.crm.member.business.member.sdk.enums.ShelfStatusEnum;
import com.biz.crm.member.business.member.sdk.vo.ProductExchangeRuleVo;
import com.biz.crm.member.business.member.sdk.vo.ProductFileVo;
import com.biz.crm.member.business.member.sdk.vo.ProductPageVo;
import com.biz.crm.member.business.member.sdk.vo.ProductVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ProductServiceImpl
implements ProductService {
    @Autowired
    private ProductRepository productRepository;
    @Autowired
    private ProductExchangeRuleRepository productExchangeRuleRepository;
    @Autowired
    private ProductFileRepository productFileRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private RedisMutexService redisMutexService;
    @Autowired
    private LoginUserService loginUserService;
    public static final String MMS_SHELF_PRODUCT_CODE_REDIS_KEY = "mms:shelf:product:code:index:%s";
    public static final String MMS_SHELF_PRODUCT_CODE_PREFIX = "SJSP";

    @Override
    public Page<ProductPageVo> findByConditions(Pageable pageable, ProductPageDto productPageDto) {
        if (Objects.isNull(productPageDto)) {
            productPageDto = new ProductPageDto();
        }
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.productRepository.findByConditions((Page<ProductPageVo>)page, productPageDto);
    }

    @Override
    public ProductVo findDetailById(String id) {
        List productFiles;
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        Product product = (Product)((Object)this.productRepository.getById((Serializable)((Object)id)));
        Validate.notNull((Object)((Object)product), (String)"\u5546\u54c1\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        ProductVo productVo = (ProductVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)product, ProductVo.class, HashSet.class, LinkedList.class, new String[0]);
        ProductExchangeRule productExchangeRule = (ProductExchangeRule)((Object)((LambdaQueryChainWrapper)this.productExchangeRuleRepository.lambdaQuery().eq(ProductExchangeRule::getShelfCode, (Object)product.getCode())).one());
        if (Objects.nonNull((Object)productExchangeRule)) {
            ProductExchangeRuleVo productExchangeRuleVo = (ProductExchangeRuleVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)productExchangeRule, ProductExchangeRuleVo.class, HashSet.class, LinkedList.class, new String[0]);
            productVo.setRule(productExchangeRuleVo);
        }
        if (CollectionUtils.isNotEmpty((Collection)(productFiles = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.productFileRepository.lambdaQuery().eq(ProductFile::getShelfCode, (Object)product.getCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list()))) {
            List productFileVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)productFiles, ProductFile.class, ProductFileVo.class, HashSet.class, LinkedList.class, new String[0]);
            productVo.setFiles(productFileVos);
            this.splitFiles(productFileVos, productVo);
        }
        return productVo;
    }

    public void splitFiles(List<ProductFileVo> productFileVos, ProductVo productVo) {
        ArrayList<ProductFileVo> viewPagerFile = new ArrayList<ProductFileVo>();
        ArrayList<ProductFileVo> productFile = new ArrayList<ProductFileVo>();
        ArrayList<ProductFileVo> smallFile = new ArrayList<ProductFileVo>();
        for (ProductFileVo productFileVo : productFileVos) {
            if ("1".equals(productFileVo.getType())) {
                viewPagerFile.add(productFileVo);
                continue;
            }
            if ("2".equals(productFileVo.getType())) {
                productFile.add(productFileVo);
                continue;
            }
            smallFile.add(productFileVo);
        }
        productVo.setViewPagerFile(viewPagerFile);
        productVo.setProductFile(productFile);
        productVo.setSmallFile(smallFile);
    }

    @Override
    @Transactional
    public ProductVo create(ProductDto productDto) {
        List<ProductFileDto> files;
        this.createValidate(productDto);
        productDto.setCode(this.generateCode(TenantUtils.getTenantCode()));
        Product product = (Product)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)productDto, Product.class, HashSet.class, LinkedList.class, new String[0]));
        this.productRepository.saveOrUpdate((Object)product);
        ProductExchangeRuleDto rule = productDto.getRule();
        if (Objects.nonNull(rule)) {
            ProductExchangeRule productExchangeRule = (ProductExchangeRule)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)rule, ProductExchangeRule.class, HashSet.class, LinkedList.class, new String[0]));
            productExchangeRule.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            productExchangeRule.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            productExchangeRule.setTenantCode(TenantUtils.getTenantCode());
            productExchangeRule.setShelfCode(product.getCode());
            this.productExchangeRuleRepository.saveOrUpdate((Object)productExchangeRule);
        }
        if (CollectionUtils.isNotEmpty(files = this.getProductFileDtos(productDto))) {
            files.stream().forEach(e -> {
                e.setShelfCode(product.getCode());
                e.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                e.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                e.setTenantCode(TenantUtils.getTenantCode());
            });
            List productFiles = (List)this.nebulaToolkitService.copyCollectionByWhiteList(files, ProductFileDto.class, ProductFile.class, HashSet.class, LinkedList.class, new String[0]);
            this.productFileRepository.saveBatch(productFiles);
        }
        return (ProductVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)product, ProductVo.class, HashSet.class, LinkedList.class, new String[0]);
    }

    private List<ProductFileDto> getProductFileDtos(ProductDto productDto) {
        List smallFile;
        List productFile;
        ArrayList<ProductFileDto> fileDtos = new ArrayList<ProductFileDto>();
        List viewPagerFile = productDto.getViewPagerFile();
        if (CollectionUtils.isNotEmpty((Collection)viewPagerFile)) {
            for (ProductFileDto productFileDto : viewPagerFile) {
                Validate.notBlank((CharSequence)productFileDto.getFileId(), (String)"\u6587\u4ef6id\u4e3a\u7a7a", (Object[])new Object[0]);
                Validate.notBlank((CharSequence)productFileDto.getFileName(), (String)"\u6587\u4ef6\u540d\u79f0\u4e3a\u7a7a", (Object[])new Object[0]);
                productFileDto.setType("1");
                fileDtos.add(productFileDto);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(productFile = productDto.getProductFile()))) {
            for (ProductFileDto productFileDto : productFile) {
                Validate.notBlank((CharSequence)productFileDto.getFileId(), (String)"\u6587\u4ef6id\u4e3a\u7a7a", (Object[])new Object[0]);
                Validate.notBlank((CharSequence)productFileDto.getFileName(), (String)"\u6587\u4ef6\u540d\u79f0\u4e3a\u7a7a", (Object[])new Object[0]);
                productFileDto.setType("2");
                fileDtos.add(productFileDto);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(smallFile = productDto.getSmallFile()))) {
            for (ProductFileDto productFileDto : smallFile) {
                Validate.notBlank((CharSequence)productFileDto.getFileId(), (String)"\u6587\u4ef6id\u4e3a\u7a7a", (Object[])new Object[0]);
                Validate.notBlank((CharSequence)productFileDto.getFileName(), (String)"\u6587\u4ef6\u540d\u79f0\u4e3a\u7a7a", (Object[])new Object[0]);
                productFileDto.setType("3");
                fileDtos.add(productFileDto);
            }
        }
        return fileDtos;
    }

    private void createValidate(ProductDto productDto) {
        ProductExchangeRuleDto rule;
        Validate.notNull((Object)productDto, (String)"\u65b0\u589e\u5b9e\u4f53\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)productDto.getName(), (String)"\u4e0a\u67b6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)productDto.getProductType(), (String)"\u5546\u54c1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)productDto.getProductCategoryCode(), (String)"\u5546\u54c1\u5206\u7c7b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)productDto.getSource(), (String)"\u5546\u54c1\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (ProductSourceEnum.MAIN.getCode().equals(productDto.getSource())) {
            Validate.notBlank((CharSequence)productDto.getUnitCode(), (String)"\u8ba1\u91cf\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
        if (Objects.nonNull(rule = productDto.getRule())) {
            Validate.notBlank((CharSequence)rule.getLevelCode(), (String)"\u7b49\u7ea7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)rule.getLevelName(), (String)"\u7b49\u7ea7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)rule.getExchangePeriod(), (String)"\u5151\u6362\u5468\u671f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)rule.getExchangePeriodName(), (String)"\u5151\u6362\u5468\u671f\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notNull((Object)rule.getQuantity(), (String)"\u53ef\u5151\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notNull((Object)rule.getIntegralPrice(), (String)"\u79ef\u5206\u4ef7\u683c\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notNull((Object)rule.getInventoryQuantity(), (String)"\u5e93\u5b58\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notNull((Object)rule.getUpDate(), (String)"\u4e0a\u67b6\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notNull((Object)rule.getDownDate(), (String)"\u4e0b\u67b6\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
        productDto.setStatus(ShelfStatusEnum.DOWN.getCode());
        Date now = new Date();
        productDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        productDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        productDto.setTenantCode(TenantUtils.getTenantCode());
    }

    private String generateCode(String tenantCode) {
        String redisKey = String.format(MMS_SHELF_PRODUCT_CODE_REDIS_KEY, tenantCode);
        String index = this.redisMutexService.getAndIncrement(redisKey, 1L, Integer.valueOf(6));
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        return StringUtils.join((Object[])new String[]{MMS_SHELF_PRODUCT_CODE_PREFIX, format.format(new Date()), index});
    }

    @Override
    @Transactional
    public ProductVo update(ProductDto productDto) {
        this.updateValidate(productDto);
        productDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        productDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        productDto.setTenantCode(TenantUtils.getTenantCode());
        Product product = (Product)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)productDto, Product.class, HashSet.class, LinkedList.class, new String[0]));
        this.productRepository.saveOrUpdate((Object)product);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"shelf_code", (Object)productDto.getCode());
        queryWrapper.eq((Object)"tenant_code", (Object)productDto.getTenantCode());
        this.productExchangeRuleRepository.remove((Wrapper)queryWrapper);
        ProductExchangeRuleDto rule = productDto.getRule();
        if (Objects.nonNull(rule)) {
            ProductExchangeRule productExchangeRule = (ProductExchangeRule)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)rule, ProductExchangeRule.class, HashSet.class, LinkedList.class, new String[0]));
            productExchangeRule.setShelfCode(product.getCode());
            productExchangeRule.setTenantCode(TenantUtils.getTenantCode());
            productExchangeRule.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            productExchangeRule.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            this.productExchangeRuleRepository.saveOrUpdate((Object)productExchangeRule);
        }
        List<ProductFileDto> files = this.getProductFileDtos(productDto);
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"shelf_code", (Object)product.getCode());
        wrapper.eq((Object)"tenant_code", (Object)product.getTenantCode());
        this.productFileRepository.remove((Wrapper)wrapper);
        if (CollectionUtils.isNotEmpty(files)) {
            List productFiles = (List)this.nebulaToolkitService.copyCollectionByWhiteList(files, ProductFileDto.class, ProductFile.class, HashSet.class, LinkedList.class, new String[0]);
            productFiles.stream().forEach(e -> {
                e.setId(null);
                e.setShelfCode(product.getCode());
                e.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                e.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                e.setTenantCode(TenantUtils.getTenantCode());
            });
            this.productFileRepository.saveBatch(productFiles);
        }
        return (ProductVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)product, ProductVo.class, HashSet.class, LinkedList.class, new String[0]);
    }

    private void updateValidate(ProductDto productDto) {
        List files;
        Validate.notNull((Object)productDto, (String)"\u65b0\u589e\u5b9e\u4f53\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)productDto.getName(), (String)"\u4e0a\u67b6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)productDto.getProductType(), (String)"\u5546\u54c1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)productDto.getProductCategoryCode(), (String)"\u5546\u54c1\u5206\u7c7b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)productDto.getSource(), (String)"\u5546\u54c1\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (ProductSourceEnum.MAIN.getCode().equals(productDto.getSource())) {
            Validate.notBlank((CharSequence)productDto.getUnitCode(), (String)"\u8ba1\u91cf\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
        Validate.notBlank((CharSequence)productDto.getId(), (String)"\u7f16\u8f91\u65f6\uff0c\u4e3b\u952eid\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)productDto.getCode(), (String)"\u7f16\u8f91\u65f6\uff0c\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ProductExchangeRuleDto rule = productDto.getRule();
        if (Objects.nonNull(rule)) {
            Validate.notBlank((CharSequence)rule.getLevelCode(), (String)"\u7b49\u7ea7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)rule.getLevelName(), (String)"\u7b49\u7ea7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)rule.getExchangePeriod(), (String)"\u5151\u6362\u5468\u671f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)rule.getExchangePeriodName(), (String)"\u5151\u6362\u5468\u671f\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notNull((Object)rule.getQuantity(), (String)"\u53ef\u5151\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notNull((Object)rule.getIntegralPrice(), (String)"\u79ef\u5206\u4ef7\u683c\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notNull((Object)rule.getInventoryQuantity(), (String)"\u5e93\u5b58\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notNull((Object)rule.getUpDate(), (String)"\u4e0a\u67b6\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notNull((Object)rule.getDownDate(), (String)"\u4e0b\u67b6\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
        if (CollectionUtils.isNotEmpty((Collection)(files = productDto.getFiles()))) {
            for (ProductFileDto file : files) {
                Validate.notBlank((CharSequence)file.getFileId(), (String)"\u6587\u4ef6id\u4e3a\u7a7a", (Object[])new Object[0]);
                Validate.notBlank((CharSequence)file.getFileName(), (String)"\u6587\u4ef6\u540d\u79f0\u4e3a\u7a7a", (Object[])new Object[0]);
                Validate.notBlank((CharSequence)file.getType(), (String)"\u6587\u4ef6\u7c7b\u578b\u4e3a\u7a7a", (Object[])new Object[0]);
            }
        }
    }

    @Override
    public void disableBatch(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.productRepository.lambdaUpdate().set(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.DISABLE.getCode())).in(UuidEntity::getId, ids)).update();
    }

    @Override
    public void shelfUp(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.productRepository.lambdaUpdate().set(Product::getStatus, (Object)ShelfStatusEnum.UP.getCode())).in(UuidEntity::getId, ids)).update();
    }

    @Override
    public void shelfDown(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.productRepository.lambdaUpdate().set(Product::getStatus, (Object)ShelfStatusEnum.DOWN.getCode())).in(UuidEntity::getId, ids)).update();
    }

    @Override
    public void enableBatch(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.productRepository.lambdaUpdate().set(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.ENABLE.getCode())).in(UuidEntity::getId, ids)).update();
    }

    @Override
    public void deleteBatch(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.productRepository.lambdaUpdate().set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).in(UuidEntity::getId, ids)).update();
    }

    @Override
    public void adjust(String id, BigDecimal number) {
        if (StringUtils.isBlank((CharSequence)id) || Objects.isNull(number)) {
            return;
        }
        ProductVo productVo = this.findDetailById(id);
        ProductExchangeRuleVo rule = productVo.getRule();
        Validate.notNull((Object)rule, (String)"\u5151\u6362\u89c4\u5219\u4e3a\u7a7a", (Object[])new Object[0]);
        BigDecimal inventoryQuantity = rule.getInventoryQuantity();
        if (number.compareTo(BigDecimal.ZERO) < 0) {
            Validate.isTrue((number.negate().compareTo(inventoryQuantity) < 0 ? 1 : 0) != 0, (String)"\u5e93\u5b58\u8c03\u6574\u8d85\u8fc7\u5e93\u5b58\u6570\u91cf", (Object[])new Object[0]);
        }
        rule.setInventoryQuantity(inventoryQuantity.add(number));
        ProductExchangeRule productExchangeRule = (ProductExchangeRule)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)rule, ProductExchangeRule.class, HashSet.class, LinkedList.class, new String[0]));
        this.productExchangeRuleRepository.saveOrUpdate((Object)productExchangeRule);
    }
}

