/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.member.business.member.local.service.internal;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.member.business.member.local.entity.QuestionnaireQuestion;
import com.biz.crm.member.business.member.local.repository.QuestionnaireQuestionRepository;
import com.biz.crm.member.business.member.local.service.QuestionnaireQuestionService;
import com.biz.crm.member.business.member.sdk.dto.QuestionnaireQuestionDto;
import com.biz.crm.member.business.member.sdk.vo.QuestionVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class QuestionnaireQuestionServiceImpl
implements QuestionnaireQuestionService {
    @Autowired
    private QuestionnaireQuestionRepository repository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private GenerateCodeService generateCodeService;

    @Override
    @Transactional
    public void createQuestion(List<QuestionnaireQuestionDto> dtoList, String questionnaireCode) {
        this.validateCreate(dtoList);
        Collection questionnaireQuestions = this.nebulaToolkitService.copyCollectionByWhiteList(dtoList, QuestionnaireQuestionDto.class, QuestionnaireQuestion.class, HashSet.class, LinkedList.class, new String[0]);
        this.populateProperty(questionnaireQuestions, questionnaireCode);
        this.repository.saveBatch(questionnaireQuestions);
    }

    @Override
    public List<QuestionVo> listByQuestionnaireCodeOrderBySortIndex(String questionnaireCode) {
        return this.repository.listByQuestionnaireCodeOrderBySortIndex(questionnaireCode);
    }

    @Override
    public void logicDeleteByQuestionnaireCode(String questionnaireCode) {
        this.repository.logicDeleteByQuestionnaireCode(questionnaireCode);
    }

    @Override
    public QuestionnaireQuestion getQuestionInfoByCode(String questionCode) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(QuestionnaireQuestion::getCode, (Object)questionCode);
        return (QuestionnaireQuestion)((Object)this.repository.getOne((Wrapper)queryWrapper));
    }

    private void populateProperty(Collection<QuestionnaireQuestion> questionnaireQuestions, String questionnaireCode) {
        for (QuestionnaireQuestion question : questionnaireQuestions) {
            question.setQuestionnaireCode(questionnaireCode);
            question.setTenantCode(TenantUtils.getTenantCode());
            question.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            question.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            question.setCode((String)this.generateCodeService.generateCode("TM", 5).get(0));
        }
    }

    private void validateCreate(List<QuestionnaireQuestionDto> dtoList) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(dtoList), (String)"\u914d\u7f6e\u9898\u76ee\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        for (QuestionnaireQuestionDto questionDto : dtoList) {
            Validate.notNull((Object)questionDto.getSortIndex(), (String)"\u9898\u76ee\u5e8f\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)questionDto.getTitle(), (String)"\u9898\u76ee\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)questionDto.getField(), (String)"\u9898\u76ee\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
    }
}

