/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.member.business.member.local.service.internal;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.member.business.member.local.entity.AnswerRecord;
import com.biz.crm.member.business.member.local.entity.AnswerUser;
import com.biz.crm.member.business.member.local.entity.Questionnaire;
import com.biz.crm.member.business.member.local.helper.UserSearchHelper;
import com.biz.crm.member.business.member.local.repository.AnswerUserRepository;
import com.biz.crm.member.business.member.local.repository.QuestionnaireRepository;
import com.biz.crm.member.business.member.local.service.AnswerRecordService;
import com.biz.crm.member.business.member.local.service.MemberInfoIntegralRecordService;
import com.biz.crm.member.business.member.local.service.QuestionnaireQuestionService;
import com.biz.crm.member.business.member.local.service.QuestionnaireService;
import com.biz.crm.member.business.member.sdk.dto.AnswerRecordPaginationDto;
import com.biz.crm.member.business.member.sdk.dto.QuestionDto;
import com.biz.crm.member.business.member.sdk.dto.QuestionnaireDto;
import com.biz.crm.member.business.member.sdk.dto.QuestionnairePaginationDto;
import com.biz.crm.member.business.member.sdk.dto.QuestionnaireQuestionDto;
import com.biz.crm.member.business.member.sdk.dto.QuestionnaireSubmitDto;
import com.biz.crm.member.business.member.sdk.enums.IntegralSourceEnum;
import com.biz.crm.member.business.member.sdk.enums.QuestionnaireLifeCycleStatusEnum;
import com.biz.crm.member.business.member.sdk.enums.QuestionnaireStatusEnum;
import com.biz.crm.member.business.member.sdk.vo.AnswerRecordVo;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoIntegralRecordVo;
import com.biz.crm.member.business.member.sdk.vo.QuestionAnswerVo;
import com.biz.crm.member.business.member.sdk.vo.QuestionCountVo;
import com.biz.crm.member.business.member.sdk.vo.QuestionStatisticVo;
import com.biz.crm.member.business.member.sdk.vo.QuestionVo;
import com.biz.crm.member.business.member.sdk.vo.QuestionnaireAnalyzeVo;
import com.biz.crm.member.business.member.sdk.vo.QuestionnaireDetailVo;
import com.biz.crm.member.business.member.sdk.vo.QuestionnaireVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class QuestionnaireServiceImpl
implements QuestionnaireService {
    private static final Logger log = LoggerFactory.getLogger(QuestionnaireServiceImpl.class);
    @Autowired
    private LoginUserService loginUserService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private GenerateCodeService generateCodeService;
    @Autowired
    private QuestionnaireRepository questionnaireRepository;
    @Autowired
    private QuestionnaireQuestionService questionnaireQuestionService;
    @Autowired
    private AnswerRecordService answerRecordService;
    @Autowired
    private AnswerUserRepository answerUserRepository;
    @Autowired
    private MemberInfoIntegralRecordService memberInfoIntegralRecordService;
    @Autowired
    private UserSearchHelper userSearchHelper;
    private final List<String> NEED_STATISTIC_TYPE = Arrays.asList("select", "radio", "checkbox");

    @Override
    public QuestionnaireVo createQuestionnairePublish(QuestionDto dto) {
        QuestionnaireDto basicInfo = dto.getQuestionnaireDto();
        this.createValidate(basicInfo);
        Date startTime = basicInfo.getStartTime();
        Date currentTime = new Date(System.currentTimeMillis());
        QuestionnaireStatusEnum publishStatus = QuestionnaireStatusEnum.NO_STARTED;
        if (startTime.before(currentTime)) {
            publishStatus = QuestionnaireStatusEnum.RUNNING;
        }
        return this.createQuestionnaire(dto, publishStatus);
    }

    @Override
    @Transactional
    public QuestionnaireVo createQuestionnaire(QuestionDto dto, QuestionnaireStatusEnum statusEnum) {
        QuestionnaireDto questionnaireDto = dto.getQuestionnaireDto();
        String questionnaireCode = questionnaireDto.getCode();
        Optional.ofNullable(questionnaireCode).ifPresent(code -> {
            Questionnaire questionnaire = this.questionnaireRepository.getByCode((String)code);
            Validate.notNull((Object)((Object)questionnaire), (String)"\u590d\u5236\u7684\u95ee\u5377\u4e0d\u5b58\u5728", (Object[])new Object[0]);
            String pubStatus = questionnaire.getPubStatus();
            Validate.isTrue((!QuestionnaireStatusEnum.NO_STARTED.getValue().equals(pubStatus) ? 1 : 0) != 0, (String)"\u672a\u53d1\u5e03\u7684\u95ee\u5377\u4e0d\u80fd\u590d\u5236", (Object[])new Object[0]);
        });
        questionnaireDto.setId("");
        questionnaireDto.setCode("");
        QuestionnaireVo result = this.createBasicQuestionnaire(questionnaireDto, statusEnum);
        dto.getQuestionDtoList().stream().forEach(question -> question.setId(""));
        this.questionnaireQuestionService.createQuestion(dto.getQuestionDtoList(), result.getCode());
        return result;
    }

    @Override
    public Page<QuestionnaireVo> pageResult(Pageable pageable, QuestionnairePaginationDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        dto = Optional.ofNullable(dto).orElse(new QuestionnairePaginationDto());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<QuestionnaireVo> result = this.questionnaireRepository.pageInfo((Page<QuestionnaireVo>)page, dto);
        this.populateCommitNum(result.getRecords());
        return result;
    }

    @Override
    @Transactional
    public void logicDelete(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.questionnaireRepository.logicDelete(ids);
    }

    @Override
    public void turnOnQuestionnaire(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.questionnaireRepository.modifyEnableStatus(ids, EnableStatusEnum.ENABLE);
    }

    @Override
    public void turnOffQuestionnaire(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.questionnaireRepository.modifyEnableStatus(ids, EnableStatusEnum.DISABLE);
    }

    @Override
    public void publishQuestionnaire(String questionnaireCode) {
        Validate.notBlank((CharSequence)questionnaireCode, (String)"\u95ee\u5377\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Questionnaire currentQuestionnaire = this.questionnaireRepository.getByCode(questionnaireCode);
        String pubStatus = currentQuestionnaire.getPubStatus();
        String enableStatus = currentQuestionnaire.getEnableStatus();
        Validate.isTrue((!QuestionnaireStatusEnum.FINISH.getValue().equals(pubStatus) ? 1 : 0) != 0, (String)"\u5df2\u7ed3\u675f\u7684\u95ee\u5377\u4e0d\u80fd\u518d\u53d1\u5e03", (Object[])new Object[0]);
        Validate.isTrue((boolean)EnableStatusEnum.ENABLE.getCode().equals(enableStatus), (String)"\u7981\u7528\u72b6\u6001\u7684\u95ee\u5377\u4e0d\u80fd\u53d1\u5e03", (Object[])new Object[0]);
        Date startTime = currentQuestionnaire.getStartTime();
        Date currentTime = new Date(System.currentTimeMillis());
        QuestionnaireStatusEnum statusEnum = QuestionnaireStatusEnum.RUNNING;
        int compareResult = startTime.compareTo(currentTime);
        if (compareResult >= 0) {
            statusEnum = QuestionnaireStatusEnum.NO_STARTED;
        }
        this.questionnaireRepository.modifyQuestionnaireStatus(questionnaireCode, statusEnum);
    }

    @Override
    public void finishQuestionnaire(String questionnaireCode) {
        Validate.notBlank((CharSequence)questionnaireCode, (String)"\u95ee\u5377\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.questionnaireRepository.modifyQuestionnaireStatus(questionnaireCode, QuestionnaireStatusEnum.FINISH);
    }

    @Override
    public QuestionnaireDetailVo getQuestionnaireDetailByCode(String questionnaireCode) {
        Validate.notBlank((CharSequence)questionnaireCode, (String)"\u95ee\u5377\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Questionnaire questionnaire = this.questionnaireRepository.getByCode(questionnaireCode);
        Validate.notNull((Object)((Object)questionnaire), (String)"\u5f53\u524d\u95ee\u5377\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        QuestionnaireDetailVo result = (QuestionnaireDetailVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)questionnaire, QuestionnaireDetailVo.class, HashSet.class, LinkedList.class, new String[0]);
        List<QuestionVo> questionList = this.questionnaireQuestionService.listByQuestionnaireCodeOrderBySortIndex(questionnaireCode);
        result.setQuestionVoList(questionList);
        return result;
    }

    @Override
    @Transactional
    public QuestionnaireVo modifyQuestionnaire(QuestionDto dto) {
        QuestionnaireDto basicInfo = dto.getQuestionnaireDto();
        QuestionnaireVo result = this.modifyQuestionnaireBasicInfo(basicInfo);
        String questionnaireCode = basicInfo.getCode();
        List questionDtoList = dto.getQuestionDtoList();
        this.questionnaireQuestionService.logicDeleteByQuestionnaireCode(questionnaireCode);
        this.clearQuestionListId(questionDtoList);
        this.questionnaireQuestionService.createQuestion(questionDtoList, questionnaireCode);
        return result;
    }

    @Override
    @Transactional
    public QuestionnaireVo copyQuestionnaireByCode(String questionnaireCode) {
        Questionnaire sourceQuestionnaire = this.questionnaireRepository.getByCode(questionnaireCode);
        Validate.notNull((Object)((Object)sourceQuestionnaire), (String)"\u62f7\u8d1d\u5bf9\u8c61\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        sourceQuestionnaire.setId("");
        sourceQuestionnaire.setCode("");
        QuestionnaireDto questionnaireDto = (QuestionnaireDto)this.nebulaToolkitService.copyObjectByBlankList((Object)sourceQuestionnaire, QuestionnaireDto.class, HashSet.class, LinkedList.class, new String[0]);
        List<QuestionVo> sourceQuestionListVo = this.questionnaireQuestionService.listByQuestionnaireCodeOrderBySortIndex(questionnaireCode);
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(sourceQuestionListVo), (String)"\u62f7\u8d1d\u95ee\u5377\u9898\u76ee\u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Collection questionnaireQuestionDtos = this.nebulaToolkitService.copyCollectionByWhiteList(sourceQuestionListVo, QuestionVo.class, QuestionnaireQuestionDto.class, HashSet.class, LinkedList.class, new String[0]);
        this.clearQuestionListId(questionnaireQuestionDtos);
        QuestionDto targetDto = new QuestionDto();
        targetDto.setQuestionnaireDto(questionnaireDto);
        targetDto.setQuestionDtoList((List)questionnaireQuestionDtos);
        QuestionnaireVo result = this.createQuestionnaire(targetDto, QuestionnaireStatusEnum.NO_PUBLISH);
        return result;
    }

    @Override
    public List<QuestionnaireAnalyzeVo> getQuestionnaireAnalyze(String questionnaireCode) {
        Validate.notBlank((CharSequence)questionnaireCode, (String)"\u95ee\u5377\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<QuestionVo> questionVoList = this.questionnaireQuestionService.listByQuestionnaireCodeOrderBySortIndex(questionnaireCode);
        Collection result = this.nebulaToolkitService.copyCollectionByWhiteList(questionVoList, QuestionVo.class, QuestionnaireAnalyzeVo.class, HashSet.class, LinkedList.class, new String[0]);
        List<QuestionVo> needStatisticQuestionInfoList = questionVoList.stream().filter(obj -> this.NEED_STATISTIC_TYPE.contains(obj.getType())).collect(Collectors.toList());
        List<String> questionCodes = needStatisticQuestionInfoList.stream().map(QuestionVo::getCode).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(questionCodes)) {
            return (List)result;
        }
        List<AnswerRecord> records = this.answerRecordService.listAnswerRecord(questionCodes);
        Map<String, List<QuestionStatisticVo>> statisticMap = this.generateStatisticMap(records, needStatisticQuestionInfoList);
        for (QuestionnaireAnalyzeVo analyzeVo : result) {
            String questionCode = analyzeVo.getCode();
            analyzeVo.setAnalyzeList(statisticMap.get(questionCode));
            List analyzeList = analyzeVo.getAnalyzeList();
            if (CollectionUtils.isEmpty((Collection)analyzeList)) {
                analyzeVo.setValidCount(Integer.valueOf(0));
                continue;
            }
            Optional<Integer> count = analyzeList.stream().map(QuestionStatisticVo::getStatistic).reduce(Integer::sum);
            if (count.isPresent()) {
                analyzeVo.setValidCount(count.get());
                continue;
            }
            analyzeVo.setValidCount(Integer.valueOf(0));
        }
        return (List)result;
    }

    private Map<String, List<QuestionStatisticVo>> generateStatisticMap(List<AnswerRecord> records, List<QuestionVo> questionVoList) {
        HashMap<String, List<QuestionStatisticVo>> statisticMap = new HashMap<String, List<QuestionStatisticVo>>();
        for (QuestionVo questionInfo : questionVoList) {
            ArrayList<QuestionStatisticVo> result = new ArrayList<QuestionStatisticVo>();
            String questionCode = questionInfo.getCode();
            if (questionCode == null) continue;
            List<AnswerRecord> answerRecords = records.stream().filter(record -> record.getQuestionCode().equals(questionInfo.getCode())).collect(Collectors.toList());
            this.generateRadioStatistic(result, answerRecords, questionInfo);
            this.generateCheckboxStatistic(result, answerRecords, questionInfo);
            this.generateSelectStatistic(result, answerRecords, questionInfo);
            statisticMap.put(questionCode, result);
        }
        return statisticMap;
    }

    private void generateSelectStatistic(List<QuestionStatisticVo> result, List<AnswerRecord> answerRecords, QuestionVo questionInfo) {
        String type = questionInfo.getType();
        if (!"select".equals(type) || CollectionUtils.isEmpty(answerRecords)) {
            return;
        }
        String questionCode = questionInfo.getCode();
        int allCount = answerRecords.size();
        Map<String, List<AnswerRecord>> groupByAnswerValueMap = answerRecords.stream().collect(Collectors.groupingBy(AnswerRecord::getAnswerValue));
        for (Map.Entry<String, List<AnswerRecord>> groupEntry : groupByAnswerValueMap.entrySet()) {
            String answerValue = groupEntry.getKey();
            List<AnswerRecord> answerRecordList = groupEntry.getValue();
            int statisticCount = answerRecordList.size();
            double rate = 0.0;
            if (allCount != 0) {
                rate = (double)statisticCount / (double)allCount * 100.0;
            }
            QuestionStatisticVo statisticResult = new QuestionStatisticVo();
            statisticResult.setQuestionCode(questionCode);
            statisticResult.setAnswerValue(answerValue);
            statisticResult.setStatistic(Integer.valueOf(statisticCount));
            statisticResult.setRate(BigDecimal.valueOf(rate));
            try {
                String[] addressArray = answerValue.split(",");
                statisticResult.setProvince(addressArray[0]);
                statisticResult.setCity(addressArray[1]);
                statisticResult.setArea(addressArray[2]);
            }
            catch (RuntimeException e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new RuntimeException("\u7701\u5e02\u533a\u683c\u5f0f\u9519\u8bef,\u7701\u5e02\u533a\u6570\u636e\u683c\u5f0f\u5fc5\u987b\u4ee5\u9017\u53f7\u5206\u5272,\u4f8b\u5982: xxx\u7701,xx\u5e02,xx\u533a");
            }
            result.add(statisticResult);
        }
    }

    private void generateCheckboxStatistic(List<QuestionStatisticVo> result, List<AnswerRecord> answerRecords, QuestionVo questionInfo) {
        String type = questionInfo.getType();
        if (!"checkbox".equals(type)) {
            return;
        }
        String questionCode = questionInfo.getCode();
        int allCount = answerRecords.size();
        List answerValueList = answerRecords.stream().map(AnswerRecord::getAnswerValue).collect(Collectors.toList());
        String configJsonValue = questionInfo.getConfigJsonValue();
        List configList = (List)JSONObject.parseObject((String)configJsonValue, List.class);
        for (JSONObject config : configList) {
            String configLabel = String.valueOf(config.get((Object)"label"));
            String configValue = String.valueOf(config.get((Object)"value"));
            long statisticCount = answerValueList.stream().filter(answerValue -> Arrays.asList(answerValue.split(",")).contains(configLabel)).count();
            double rate = 0.0;
            if (allCount != 0) {
                rate = (double)statisticCount / (double)allCount * 100.0;
            }
            QuestionStatisticVo statisticResult = new QuestionStatisticVo();
            statisticResult.setQuestionCode(questionCode);
            statisticResult.setStatistic(Integer.valueOf((int)statisticCount));
            statisticResult.setAnswerValue(configValue);
            statisticResult.setLabel(configLabel);
            statisticResult.setRate(BigDecimal.valueOf(rate));
            result.add(statisticResult);
        }
    }

    private void generateRadioStatistic(List<QuestionStatisticVo> result, List<AnswerRecord> answerRecords, QuestionVo questionInfo) {
        String type = questionInfo.getType();
        if (!"radio".equals(type)) {
            return;
        }
        String questionCode = questionInfo.getCode();
        int allCount = answerRecords.size();
        Map<String, List<AnswerRecord>> groupByAnswerValueMap = answerRecords.stream().collect(Collectors.groupingBy(AnswerRecord::getAnswerValue));
        String configJsonValue = questionInfo.getConfigJsonValue();
        List configList = (List)JSON.parseObject((String)configJsonValue, List.class);
        for (JSONObject config : configList) {
            String configValue = String.valueOf(config.get((Object)"value"));
            String configLabel = String.valueOf(config.get((Object)"label"));
            List<AnswerRecord> answerRecordList = groupByAnswerValueMap.getOrDefault(configValue, Collections.EMPTY_LIST);
            int statisticSize = answerRecordList.size();
            double rate = 0.0;
            if (allCount != 0) {
                rate = (double)statisticSize / (double)allCount * 100.0;
            }
            QuestionStatisticVo statisticResult = new QuestionStatisticVo();
            statisticResult.setAnswerValue(configValue);
            statisticResult.setLabel(configLabel);
            statisticResult.setStatistic(Integer.valueOf(statisticSize));
            statisticResult.setQuestionCode(questionCode);
            statisticResult.setRate(BigDecimal.valueOf(rate));
            result.add(statisticResult);
        }
    }

    @Override
    public Page<AnswerRecordVo> pageQuestionDetail(Pageable pageable, AnswerRecordPaginationDto dto) {
        return this.answerRecordService.pageAnswerRecord(pageable, dto);
    }

    @Override
    public List<QuestionAnswerVo> getQuestionAnswer(String questionnaireCode, String memberCode) {
        List<QuestionVo> questionVoList = this.questionnaireQuestionService.listByQuestionnaireCodeOrderBySortIndex(questionnaireCode);
        Collection result = this.nebulaToolkitService.copyCollectionByWhiteList(questionVoList, QuestionVo.class, QuestionAnswerVo.class, HashSet.class, LinkedList.class, new String[0]);
        List<String> questionCodes = questionVoList.stream().map(QuestionVo::getCode).distinct().collect(Collectors.toList());
        List<AnswerRecordVo> answerRecordVoList = this.answerRecordService.getByQuestionCodes(questionCodes, memberCode);
        Map<String, AnswerRecordVo> answerRecordVoMap = answerRecordVoList.stream().collect(Collectors.toMap(AnswerRecordVo::getQuestionCode, obj -> obj));
        for (QuestionAnswerVo questionAnswerVo : result) {
            String questionCode = questionAnswerVo.getCode();
            questionAnswerVo.setAnswerRecordVo(answerRecordVoMap.get(questionCode));
        }
        return (List)result;
    }

    @Override
    public Page<QuestionnaireVo> pageQuestionnaireWithStatus(Pageable pageable, String rangeStatus) {
        Page<QuestionnaireVo> page;
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        Page<QuestionnaireVo> result = page = new Page<QuestionnaireVo>((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        String pubStatus = "";
        if ("allow_join".equals(rangeStatus)) {
            pubStatus = QuestionnaireStatusEnum.RUNNING.getValue();
            String memberCode = this.userSearchHelper.getMemberLogin().getMemberCode();
            List<String> submitQuestionnaireCodes = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.answerUserRepository.lambdaQuery().eq(AnswerUser::getMemberCode, (Object)memberCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list().stream().map(AnswerUser::getQuestionnaireCode).collect(Collectors.toList());
            result = this.questionnaireRepository.appPageByPubStatusWithEnableStatus(page, pubStatus, submitQuestionnaireCodes);
        } else if ("all".equals(rangeStatus)) {
            result = this.questionnaireRepository.appPageByPubStatusWithEnableStatus(page, pubStatus, Collections.EMPTY_LIST);
        } else {
            String userAccount = this.loginUserService.getLoginUser().getAccount();
            result = this.questionnaireRepository.pageQuestionnaireByUserAccount(page, userAccount);
        }
        this.populateLifeCycleStatus(result.getRecords());
        return result;
    }

    @Override
    public Page<QuestionnaireVo> pageQuestionnaireAllowJoin(Pageable pageable) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        QuestionnairePaginationDto paginationDto = new QuestionnairePaginationDto();
        paginationDto.setPubStatus(QuestionnaireStatusEnum.RUNNING.getValue());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<QuestionnaireVo> result = this.questionnaireRepository.pageInfo((Page<QuestionnaireVo>)page, paginationDto);
        for (QuestionnaireVo record : result.getRecords()) {
            record.setLifeCycleStatus(QuestionnaireLifeCycleStatusEnum.ALLOW_JOIN.getValue());
        }
        return result;
    }

    @Override
    public Page<QuestionnaireVo> pageQuestionnaireBySubmitted(Pageable pageable) {
        AbstractCrmUserIdentity loginUser = this.loginUserService.getAbstractLoginUser();
        String userAccount = loginUser.getAccount();
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<QuestionnaireVo> result = this.questionnaireRepository.pageQuestionnaireByUserAccount((Page<QuestionnaireVo>)page, userAccount);
        for (QuestionnaireVo record : result.getRecords()) {
            record.setLifeCycleStatus(QuestionnaireLifeCycleStatusEnum.SUBMITTED.getValue());
        }
        return result;
    }

    @Override
    @Transactional
    public QuestionnaireVo submitQuestionnaire(List<QuestionnaireSubmitDto> dtoList) {
        String memberCode = this.userSearchHelper.getMemberLogin().getMemberCode();
        String memberPhone = this.userSearchHelper.getMemberLogin().getMemberPhone();
        String questionnaireCode = dtoList.get(0).getQuestionnaireCode();
        Questionnaire questionnaire = this.questionnaireRepository.getByCode(questionnaireCode);
        BigDecimal obtainPoints = questionnaire.getObtainPoints();
        AnswerUser answerUser = new AnswerUser();
        answerUser.setMemberCode(memberCode);
        answerUser.setQuestionnaireCode(questionnaireCode);
        answerUser.setTenantCode(TenantUtils.getTenantCode());
        answerUser.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        answerUser.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        answerUser.setObtainPoints(obtainPoints);
        answerUser.setTel(memberPhone);
        this.answerUserRepository.save((Object)answerUser);
        ArrayList<AnswerRecord> answerRecords = new ArrayList<AnswerRecord>();
        for (QuestionnaireSubmitDto submitDto : dtoList) {
            String generateAnswerRecordCode = (String)this.generateCodeService.generateCode("QA", 5).get(0);
            String questionCode = submitDto.getQuestionCode();
            String answerValue = submitDto.getAnswerValue();
            AnswerRecord record = new AnswerRecord();
            record.setQuestionCode(questionCode);
            record.setAnswerValue(answerValue);
            record.setCode(generateAnswerRecordCode);
            record.setMemberCode(memberCode);
            record.setTenantCode(TenantUtils.getTenantCode());
            record.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            record.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            answerRecords.add(record);
        }
        this.answerRecordService.batchSave(answerRecords);
        MemberInfoIntegralRecordVo memberInfoIntegralRecordVo = new MemberInfoIntegralRecordVo();
        memberInfoIntegralRecordVo.setMemberCode(memberCode);
        memberInfoIntegralRecordVo.setSource(IntegralSourceEnum.QUESTIONNAIRE.getValue());
        memberInfoIntegralRecordVo.setType(IntegralSourceEnum.QUESTIONNAIRE.getType());
        memberInfoIntegralRecordVo.setIntegral(Integer.valueOf(obtainPoints.intValue()));
        this.memberInfoIntegralRecordService.commonInternal(memberInfoIntegralRecordVo);
        QuestionnaireVo result = (QuestionnaireVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)questionnaire, QuestionnaireVo.class, HashSet.class, LinkedList.class, new String[0]);
        return result;
    }

    @Override
    public List<QuestionAnswerVo> getQuestionnaireDetailBySubmit(String questionnaireCode) {
        String account = this.loginUserService.getAbstractLoginUser().getAccount();
        LambdaQueryWrapper queryUser = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryUser.eq(AnswerUser::getQuestionnaireCode, (Object)questionnaireCode)).eq(UuidOpEntity::getCreateAccount, (Object)account)).last("limit 1");
        AnswerUser answerUser = (AnswerUser)((Object)this.answerUserRepository.getOne((Wrapper)queryUser));
        String memberCode = answerUser.getMemberCode();
        List<QuestionAnswerVo> result = this.getQuestionAnswer(questionnaireCode, memberCode);
        return result;
    }

    private void populateLifeCycleStatus(List<QuestionnaireVo> records) {
        if (CollectionUtils.isEmpty(records)) {
            return;
        }
        for (QuestionnaireVo record : records) {
            String pubStatus = record.getPubStatus();
            if (QuestionnaireStatusEnum.FINISH.getValue().equals(pubStatus)) {
                record.setLifeCycleStatus(QuestionnaireLifeCycleStatusEnum.EXPIRED.getValue());
            }
            if (QuestionnaireStatusEnum.NO_STARTED.getValue().equals(pubStatus)) {
                record.setLifeCycleStatus(QuestionnaireLifeCycleStatusEnum.NO_START.getValue());
            }
            if (!QuestionnaireStatusEnum.RUNNING.getValue().equals(pubStatus)) continue;
            record.setLifeCycleStatus(QuestionnaireLifeCycleStatusEnum.ALLOW_JOIN.getValue());
        }
        List questionnaireCodes = records.stream().map(QuestionnaireVo::getCode).distinct().collect(Collectors.toList());
        UserIdentity loginUser = this.loginUserService.getLoginUser();
        String userAccount = loginUser.getAccount();
        LambdaQueryWrapper queryUserQuestionnaire = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryUserQuestionnaire.eq(UuidOpEntity::getCreateAccount, (Object)userAccount)).in(AnswerUser::getQuestionnaireCode, questionnaireCodes);
        List currentUserQuestionnaire = this.answerUserRepository.list((Wrapper)queryUserQuestionnaire);
        if (CollectionUtils.isEmpty((Collection)currentUserQuestionnaire)) {
            return;
        }
        Set joinQuestionnaireCodes = currentUserQuestionnaire.stream().map(AnswerUser::getQuestionnaireCode).collect(Collectors.toSet());
        for (QuestionnaireVo record : records) {
            String questionnaireCode = record.getCode();
            if (!joinQuestionnaireCodes.contains(questionnaireCode)) continue;
            record.setLifeCycleStatus(QuestionnaireLifeCycleStatusEnum.SUBMITTED.getValue());
        }
    }

    private void clearQuestionListId(Collection<QuestionnaireQuestionDto> questionDtoList) {
        for (QuestionnaireQuestionDto dto : questionDtoList) {
            dto.setId("");
        }
    }

    private QuestionnaireVo modifyQuestionnaireBasicInfo(QuestionnaireDto basicInfo) {
        this.modifyValidate(basicInfo);
        Questionnaire questionnaire = (Questionnaire)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)basicInfo, Questionnaire.class, HashSet.class, LinkedList.class, new String[0]));
        this.questionnaireRepository.saveOrUpdate((Object)questionnaire);
        QuestionnaireVo result = (QuestionnaireVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)questionnaire, QuestionnaireVo.class, HashSet.class, LinkedList.class, new String[0]);
        return result;
    }

    private void populateCommitNum(List<QuestionnaireVo> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        List<String> questionnaireCodes = list.stream().filter(obj -> {
            String finishValue = QuestionnaireStatusEnum.FINISH.getValue();
            String runningValue = QuestionnaireStatusEnum.RUNNING.getValue();
            String pubStatus = obj.getPubStatus();
            return finishValue.equals(pubStatus) || runningValue.equals(pubStatus);
        }).map(QuestionnaireVo::getCode).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(questionnaireCodes)) {
            return;
        }
        List<QuestionCountVo> countVoList = this.answerUserRepository.countCommitGroupByQuestionnaireCode(questionnaireCodes);
        if (CollectionUtils.isEmpty(countVoList)) {
            return;
        }
        Map<String, Integer> countMap = countVoList.stream().distinct().collect(Collectors.toMap(QuestionCountVo::getCode, QuestionCountVo::getCommitCount));
        for (QuestionnaireVo questionnaireVo : list) {
            String code = questionnaireVo.getCode();
            Integer commitCount = countMap.getOrDefault(code, 0);
            questionnaireVo.setCommitCount(commitCount);
        }
    }

    private QuestionnaireVo createBasicQuestionnaire(QuestionnaireDto dto, QuestionnaireStatusEnum statusEnum) {
        this.createValidate(dto);
        Questionnaire questionnaire = (Questionnaire)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, Questionnaire.class, HashSet.class, LinkedList.class, new String[0]));
        questionnaire.setCode((String)this.generateCodeService.generateCode("WJ", 5).get(0));
        questionnaire.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        questionnaire.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        questionnaire.setTenantCode(TenantUtils.getTenantCode());
        questionnaire.setPubStatus(statusEnum.getValue());
        this.questionnaireRepository.save((Object)questionnaire);
        QuestionnaireVo result = (QuestionnaireVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)questionnaire, QuestionnaireVo.class, HashSet.class, LinkedList.class, new String[0]);
        return result;
    }

    private void createValidate(QuestionnaireDto dto) {
        Validate.notBlank((CharSequence)dto.getTitle(), (String)"\u95ee\u5377\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getStartTime(), (String)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getEndTime(), (String)"\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Date currentTime = new Date(System.currentTimeMillis());
        Validate.isTrue((dto.getEndTime().compareTo(currentTime) == 1 ? 1 : 0) != 0, (String)"\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u5f53\u524d\u65f6\u95f4", (Object[])new Object[0]);
    }

    private void modifyValidate(QuestionnaireDto dto) {
        String questionnaireCode = dto.getCode();
        Questionnaire questionnaire = this.questionnaireRepository.getByCode(questionnaireCode);
        String pubStatus = questionnaire.getPubStatus();
        Validate.isTrue((!QuestionnaireStatusEnum.RUNNING.getValue().equals(pubStatus) ? 1 : 0) != 0, (String)"\u6b63\u5728\u8fdb\u884c\u4e2d\u7684\u95ee\u5377\u4e0d\u80fd\u7f16\u8f91", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getCode(), (String)"\u95ee\u5377\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }
}

