/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.member.business.member.local.service.internal;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.member.business.member.local.entity.RaffleBaseConfig;
import com.biz.crm.member.business.member.local.entity.RaffleManage;
import com.biz.crm.member.business.member.local.repository.RaffleBaseConfigRepository;
import com.biz.crm.member.business.member.local.repository.RaffleManageRepository;
import com.biz.crm.member.business.member.local.service.RaffleManageService;
import com.biz.crm.member.business.member.local.service.RafflePrizeService;
import com.biz.crm.member.business.member.sdk.dto.RaffleBaseConfigDto;
import com.biz.crm.member.business.member.sdk.dto.RaffleManageDto;
import com.biz.crm.member.business.member.sdk.dto.RaffleManagePageDto;
import com.biz.crm.member.business.member.sdk.dto.RaffleMemberDto;
import com.biz.crm.member.business.member.sdk.dto.RafflePrizeDetailsDto;
import com.biz.crm.member.business.member.sdk.dto.RafflePrizeDto;
import com.biz.crm.member.business.member.sdk.enums.PrizeInventoryEnum;
import com.biz.crm.member.business.member.sdk.enums.PrizeOverSelectEnum;
import com.biz.crm.member.business.member.sdk.enums.PrizeTypeEnum;
import com.biz.crm.member.business.member.sdk.vo.RaffleBaseConfigVo;
import com.biz.crm.member.business.member.sdk.vo.RaffleManagePageVo;
import com.biz.crm.member.business.member.sdk.vo.RaffleManageVo;
import com.biz.crm.member.business.member.sdk.vo.RafflePrizeVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RaffleManageServiceImpl
implements RaffleManageService {
    @Autowired
    private RaffleManageRepository raffleManageRepository;
    @Autowired
    private RaffleBaseConfigRepository raffleBaseConfigRepository;
    @Autowired
    private RafflePrizeService rafflePrizeService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private RedisMutexService redisMutexService;
    public static final String MMS_RAFFLE_MANAGE_CODE_REDIS_KEY = "mms:raffle:manage:code:index:%s";
    public static final String MMS_RAFFLE_MANAGE_CODE_PREFIX = "ZP";

    private String generateCode(String tenantCode) {
        String redisKey = String.format(MMS_RAFFLE_MANAGE_CODE_REDIS_KEY, tenantCode);
        String index = this.redisMutexService.getAndIncrement(redisKey, 1L, Integer.valueOf(6));
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        return StringUtils.join((Object[])new String[]{MMS_RAFFLE_MANAGE_CODE_PREFIX, format.format(new Date()), index});
    }

    @Override
    public Page<RaffleManagePageVo> findByConditions(Pageable pageable, RaffleManagePageDto raffleManagePageDto) {
        if (Objects.isNull(raffleManagePageDto)) {
            raffleManagePageDto = new RaffleManagePageDto();
        }
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.raffleManageRepository.findByConditions((Page<RaffleManagePageVo>)page, raffleManagePageDto);
    }

    @Override
    public RaffleManageVo findDetailById(String id, String code) {
        List<RafflePrizeVo> prizeVos;
        if (StringUtils.isBlank((CharSequence)id) && StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        RaffleManage raffleManage = null;
        raffleManage = StringUtils.isNotBlank((CharSequence)id) ? (RaffleManage)((Object)this.raffleManageRepository.getById((Serializable)((Object)id))) : (RaffleManage)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.raffleManageRepository.lambdaQuery().eq(RaffleManage::getCode, (Object)code)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.ENABLE.getCode())).one());
        Validate.notNull((Object)((Object)raffleManage), (String)"\u6d3b\u52a8\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        RaffleManageVo raffleManageVo = (RaffleManageVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)raffleManage, RaffleManageVo.class, HashSet.class, LinkedList.class, new String[0]);
        List baseConfigs = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.raffleBaseConfigRepository.lambdaQuery().eq(RaffleBaseConfig::getRaffleCode, (Object)raffleManageVo.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)raffleManage.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
        if (CollectionUtils.isNotEmpty((Collection)baseConfigs)) {
            List raffleBaseConfigVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)baseConfigs, RaffleBaseConfig.class, RaffleBaseConfigVo.class, HashSet.class, LinkedList.class, new String[0]);
            for (RaffleBaseConfigVo raffleBaseConfigVo : raffleBaseConfigVos) {
                this.transtStringToList(raffleBaseConfigVo, null);
            }
            raffleManageVo.setBaseConfigs(raffleBaseConfigVos);
        }
        if (CollectionUtils.isNotEmpty(prizeVos = this.rafflePrizeService.findByRaffleCode(TenantUtils.getTenantCode(), raffleManage.getCode()))) {
            for (RafflePrizeVo prizeVo : prizeVos) {
                this.transtStringToList(null, prizeVo);
            }
            raffleManageVo.setRafflePrizes(prizeVos);
        }
        return raffleManageVo;
    }

    @Override
    @Transactional
    public RaffleManageVo create(RaffleManageDto raffleManageDto) {
        List rafflePrizes;
        this.createValidate(raffleManageDto);
        raffleManageDto.setCode(this.generateCode(TenantUtils.getTenantCode()));
        raffleManageDto.setTenantCode(TenantUtils.getTenantCode());
        raffleManageDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        raffleManageDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        RaffleManage raffleManage = (RaffleManage)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)raffleManageDto, RaffleManage.class, HashSet.class, LinkedList.class, new String[0]));
        this.raffleManageRepository.saveOrUpdate((Object)raffleManage);
        List baseConfigs = raffleManageDto.getBaseConfigs();
        if (CollectionUtils.isNotEmpty((Collection)baseConfigs)) {
            for (RaffleBaseConfigDto baseConfig : baseConfigs) {
                baseConfig.setId(null);
                baseConfig.setTenantCode(TenantUtils.getTenantCode());
                baseConfig.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                baseConfig.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                baseConfig.setRaffleCode(raffleManage.getCode());
            }
            List raffleBaseConfigs = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)baseConfigs, RaffleBaseConfigDto.class, RaffleBaseConfig.class, HashSet.class, LinkedList.class, new String[0]);
            this.raffleBaseConfigRepository.saveOrUpdateBatch(raffleBaseConfigs);
        }
        if (CollectionUtils.isNotEmpty((Collection)(rafflePrizes = raffleManageDto.getRafflePrizes()))) {
            for (RafflePrizeDto rafflePrize : rafflePrizes) {
                rafflePrize.setRaffleCode(raffleManage.getCode());
            }
            this.rafflePrizeService.saveBatch(rafflePrizes);
        }
        return (RaffleManageVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)raffleManage, RaffleManageVo.class, HashSet.class, LinkedList.class, new String[0]);
    }

    private void createValidate(RaffleManageDto raffleManageDto) {
        Validate.notNull((Object)raffleManageDto, (String)"\u65b0\u589e\u5b9e\u4f53\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)raffleManageDto.getActivityName(), (String)"\u6d3b\u52a8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)raffleManageDto.getBackgroundFileId(), (String)"\u80cc\u666f\u56fe\u7247\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)raffleManageDto.getFileId(), (String)"\u8f6c\u76d8\u56fe\u7247\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)raffleManageDto.getStartButtonFileId(), (String)"\u5f00\u59cb\u6309\u94ae\u56fe\u7247\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)raffleManageDto.getCuttingLineFileId(), (String)"\u5206\u5272\u7ebf\u56fe\u7247\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)raffleManageDto.getStartDate(), (String)"\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)raffleManageDto.getEndDate(), (String)"\u6d3b\u52a8\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List baseConfigs = raffleManageDto.getBaseConfigs();
        if (CollectionUtils.isEmpty((Collection)baseConfigs)) {
            throw new RuntimeException("\u672a\u914d\u7f6e\u5927\u8f6c\u76d8\u62bd\u5956\u6b21\u6570");
        }
        ArrayList baseconfigMemberLevels = new ArrayList();
        for (RaffleBaseConfigDto baseConfig : baseConfigs) {
            baseconfigMemberLevels.addAll(baseConfig.getMemberLevels());
            this.transtListToString(baseConfig.getMemberLevels(), baseConfig, null);
            Validate.notBlank((CharSequence)baseConfig.getMemberLevelCode(), (String)"\u4f1a\u5458\u7b49\u7ea7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notNull((Object)baseConfig.getOneRaffleNum(), (String)"\u4e00\u6bb5\u62bd\u5956\u6b21\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notNull((Object)baseConfig.getOneRaffleUseIntegral(), (String)"\u4e00\u6bb5\u6bcf\u6b21\u6d88\u8017\u79ef\u5206\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
        List baseConfigMemberCodeList = baseconfigMemberLevels.stream().map(RaffleMemberDto::getMemberLevelCode).distinct().collect(Collectors.toList());
        Validate.isTrue((baseConfigMemberCodeList.size() == baseconfigMemberLevels.size() ? 1 : 0) != 0, (String)"\u62bd\u5956\u6b21\u6570,\u4f1a\u5458\u7ea7\u522b\u914d\u7f6e\u91cd\u590d", (Object[])new Object[0]);
        List rafflePrizes = raffleManageDto.getRafflePrizes();
        if (CollectionUtils.isEmpty((Collection)rafflePrizes)) {
            throw new RuntimeException("\u672a\u914d\u7f6e\u5927\u8f6c\u76d8\u5956\u54c1\u914d\u7f6e\u4fe1\u606f");
        }
        ArrayList rafflePrizeMemberLevels = new ArrayList();
        for (RafflePrizeDto rafflePrize : rafflePrizes) {
            rafflePrizeMemberLevels.addAll(rafflePrize.getMemberLevels());
            this.transtListToString(rafflePrize.getMemberLevels(), null, rafflePrize);
            Validate.notBlank((CharSequence)rafflePrize.getMemberLevelCode(), (String)"\u4f1a\u5458\u7b49\u7ea7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)rafflePrize.getPrizeOverSelect(), (String)"\u5956\u54c1\u53d1\u5b8c\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            List details = rafflePrize.getDetails();
            this.validatePrizeDetail(rafflePrize, details);
        }
        List prizeMemberCodeList = rafflePrizeMemberLevels.stream().map(RaffleMemberDto::getMemberLevelCode).distinct().collect(Collectors.toList());
        Validate.isTrue((prizeMemberCodeList.size() == rafflePrizeMemberLevels.size() ? 1 : 0) != 0, (String)"\u5956\u54c1\u914d\u7f6e,\u4f1a\u5458\u7ea7\u522b\u914d\u7f6e\u91cd\u590d", (Object[])new Object[0]);
    }

    private void transtListToString(List<RaffleMemberDto> memberLevels, RaffleBaseConfigDto configDto, RafflePrizeDto prizeDto) {
        if (CollectionUtils.isEmpty(memberLevels)) {
            throw new RuntimeException("\u4f1a\u5458\u7b49\u7ea7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String memberLevelNames = memberLevels.stream().map(RaffleMemberDto::getMemberLevelName).collect(Collectors.joining(","));
        String memberLevelCodes = memberLevels.stream().map(RaffleMemberDto::getMemberLevelCode).collect(Collectors.joining(","));
        if (!Objects.isNull(configDto)) {
            configDto.setMemberLevelCode(memberLevelCodes);
            configDto.setMemberLevelName(memberLevelNames);
            configDto.setMemberLevelJson(JSON.toJSONString(memberLevels));
        } else {
            prizeDto.setMemberLevelCode(memberLevelCodes);
            prizeDto.setMemberLevelName(memberLevelNames);
            prizeDto.setMemberLevelJson(JSON.toJSONString(memberLevels));
        }
    }

    private void transtStringToList(RaffleBaseConfigVo baseConfig, RafflePrizeVo prizeVo) {
        if (!Objects.isNull(baseConfig)) {
            baseConfig.setMemberLevels(JSONArray.parseArray((String)baseConfig.getMemberLevelJson(), RaffleMemberDto.class));
        } else {
            prizeVo.setMemberLevels(JSONArray.parseArray((String)prizeVo.getMemberLevelJson(), RaffleMemberDto.class));
        }
    }

    private void validatePrizeDetail(RafflePrizeDto rafflePrize, List<RafflePrizeDetailsDto> details) {
        if (CollectionUtils.isNotEmpty(details)) {
            long count;
            this.validateDefault(details);
            if (PrizeOverSelectEnum.NO_INVENTORY.getCode().equals(rafflePrize.getPrizeOverSelect())) {
                count = details.stream().filter(e -> e.getPrizeFlag() != false && PrizeInventoryEnum.WITH_OUT.getCode().equals(e.getInventory())).count();
                Validate.isTrue((count == 1L ? 1 : 0) != 0, (String)"\u5956\u54c1\u53d1\u5b8c\u9009\u62e9\u65e0\u5e93\u5b58\u5956\u54c1\u65f6\uff0c\u5fc5\u987b\u914d\u7f6e\u65e0\u5e93\u5b58\u5956\u54c1", (Object[])new Object[0]);
            }
            if (PrizeOverSelectEnum.NONE.getCode().equals(rafflePrize.getPrizeOverSelect())) {
                count = details.stream().filter(e -> PrizeTypeEnum.THANKS.getCode().equals(e.getPrizeType())).count();
                Validate.isTrue((count == 1L ? 1 : 0) != 0, (String)"\u5956\u54c1\u53d1\u5b8c\u9009\u62e9\u4e0d\u4e2d\u5956\u65f6\uff0c\u5fc5\u987b\u914d\u7f6e\u8c22\u8c22\u53c2\u4e0e", (Object[])new Object[0]);
            }
        }
    }

    public void validateDefault(List<RafflePrizeDetailsDto> details) {
        BigDecimal rate = BigDecimal.ZERO;
        for (RafflePrizeDetailsDto detail : details) {
            this.baseVaildate(detail);
            rate = rate.add(detail.getPrizeProb().divide(new BigDecimal(100)));
        }
        if (rate.compareTo(new BigDecimal("1")) != 0) {
            throw new RuntimeException("\u4e2d\u5956\u6982\u7387\u4e4b\u548c\u5fc5\u987b\u7b49\u4e8e1");
        }
    }

    private void baseVaildate(RafflePrizeDetailsDto detail) {
        if (PrizeInventoryEnum.EXITS.getCode().equals(detail.getInventory())) {
            Validate.notNull((Object)detail.getPutCopies(), (String)"\u6295\u653e\u4efd\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notNull((Object)detail.getPutNum(), (String)"\u6295\u653e\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notNull((Object)detail.getQuantity(), (String)"\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
        Validate.notBlank((CharSequence)detail.getPrizeCode(), (String)"\u5956\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)detail.getPrizeProb(), (String)"\u4e2d\u5956\u6982\u7387\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)detail.getPrizeType(), (String)"\u5956\u54c1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }

    @Override
    @Transactional
    public RaffleManageVo update(RaffleManageDto raffleManageDto) {
        this.updateValidate(raffleManageDto);
        raffleManageDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        raffleManageDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        raffleManageDto.setTenantCode(TenantUtils.getTenantCode());
        RaffleManage raffleManage = (RaffleManage)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)raffleManageDto, RaffleManage.class, HashSet.class, LinkedList.class, new String[0]));
        this.raffleManageRepository.saveOrUpdate((Object)raffleManage);
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.raffleBaseConfigRepository.lambdaUpdate().set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).eq(RaffleBaseConfig::getRaffleCode, (Object)raffleManage.getCode())).update();
        List baseConfigs = raffleManageDto.getBaseConfigs();
        if (CollectionUtils.isNotEmpty((Collection)baseConfigs)) {
            for (RaffleBaseConfigDto baseConfig : baseConfigs) {
                baseConfig.setId(null);
                baseConfig.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                baseConfig.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                baseConfig.setTenantCode(TenantUtils.getTenantCode());
                baseConfig.setRaffleCode(raffleManage.getCode());
            }
            List raffleBaseConfigs = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)baseConfigs, RaffleBaseConfigDto.class, RaffleBaseConfig.class, HashSet.class, LinkedList.class, new String[0]);
            this.raffleBaseConfigRepository.saveBatch(raffleBaseConfigs);
        }
        List rafflePrizes = raffleManageDto.getRafflePrizes();
        this.rafflePrizeService.updateBatch(rafflePrizes, raffleManage.getCode());
        return (RaffleManageVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)raffleManage, RaffleManageVo.class, HashSet.class, LinkedList.class, new String[0]);
    }

    private void updateValidate(RaffleManageDto raffleManageDto) {
        List rafflePrizes;
        Validate.notNull((Object)raffleManageDto, (String)"\u7f16\u8f91\u53c2\u6570\u5b9e\u4f53\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)raffleManageDto.getActivityName(), (String)"\u6d3b\u52a8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)raffleManageDto.getBackgroundFileId(), (String)"\u80cc\u666f\u56fe\u7247\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)raffleManageDto.getFileId(), (String)"\u8f6c\u76d8\u56fe\u7247\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)raffleManageDto.getStartButtonFileId(), (String)"\u5f00\u59cb\u6309\u94ae\u56fe\u7247\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)raffleManageDto.getCuttingLineFileId(), (String)"\u5206\u5272\u7ebf\u56fe\u7247\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)raffleManageDto.getStartDate(), (String)"\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)raffleManageDto.getEndDate(), (String)"\u6d3b\u52a8\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)raffleManageDto.getId(), (String)"\u7f16\u8f91\u65f6\uff0c\u4e3b\u952eid\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)raffleManageDto.getCode(), (String)"\u7f16\u8f91\u65f6\uff0c\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List baseConfigs = raffleManageDto.getBaseConfigs();
        if (CollectionUtils.isNotEmpty((Collection)baseConfigs)) {
            for (RaffleBaseConfigDto baseConfig : baseConfigs) {
                this.transtListToString(baseConfig.getMemberLevels(), baseConfig, null);
                Validate.notBlank((CharSequence)baseConfig.getMemberLevelCode(), (String)"\u4f1a\u5458\u7b49\u7ea7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                Validate.notNull((Object)baseConfig.getOneRaffleNum(), (String)"\u4e00\u6bb5\u62bd\u5956\u6b21\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                Validate.notNull((Object)baseConfig.getOneRaffleUseIntegral(), (String)"\u4e00\u6bb5\u6bcf\u6b21\u6d88\u8017\u79ef\u5206\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(rafflePrizes = raffleManageDto.getRafflePrizes()))) {
            for (RafflePrizeDto rafflePrize : rafflePrizes) {
                this.transtListToString(rafflePrize.getMemberLevels(), null, rafflePrize);
                Validate.notBlank((CharSequence)rafflePrize.getMemberLevelCode(), (String)"\u4f1a\u5458\u7b49\u7ea7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                Validate.notBlank((CharSequence)rafflePrize.getPrizeOverSelect(), (String)"\u5956\u54c1\u53d1\u5b8c\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                List details = rafflePrize.getDetails();
                this.validatePrizeDetail(rafflePrize, details);
            }
        }
    }

    @Override
    public void enableBatch(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.raffleManageRepository.lambdaUpdate().set(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.ENABLE.getCode())).in(UuidEntity::getId, ids)).update();
    }

    @Override
    public void disableBatch(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.raffleManageRepository.lambdaUpdate().set(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.DISABLE.getCode())).in(UuidEntity::getId, ids)).update();
    }

    @Override
    @Transactional
    public void deleteBatch(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        List raffleManages = ((LambdaQueryChainWrapper)this.raffleManageRepository.lambdaQuery().in(UuidEntity::getId, ids)).list();
        if (CollectionUtils.isEmpty((Collection)raffleManages)) {
            return;
        }
        List<String> codeList = raffleManages.stream().map(RaffleManage::getCode).collect(Collectors.toList());
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.raffleManageRepository.lambdaUpdate().set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).in(UuidEntity::getId, ids)).update();
        ((LambdaUpdateChainWrapper)this.raffleBaseConfigRepository.lambdaUpdate().set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).in(RaffleBaseConfig::getRaffleCode, codeList);
        this.rafflePrizeService.deleteBatch(codeList);
    }

    @Override
    public RaffleManageVo findByActivityCode(String activityCode) {
        if (StringUtils.isBlank((CharSequence)activityCode)) {
            return null;
        }
        RaffleManage one = (RaffleManage)((Object)((LambdaQueryChainWrapper)this.raffleManageRepository.lambdaQuery().eq(RaffleManage::getCode, (Object)activityCode)).one());
        return (RaffleManageVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)one, RaffleManageVo.class, HashSet.class, LinkedList.class, new String[0]);
    }
}

