/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.member.business.member.local.service.internal;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.member.business.member.local.entity.PrizeEntity;
import com.biz.crm.member.business.member.local.entity.RafflePrizeDetails;
import com.biz.crm.member.business.member.local.repository.RafflePrizeDetailsRepository;
import com.biz.crm.member.business.member.local.service.PrizeService;
import com.biz.crm.member.business.member.local.service.RafflePrizeDetailsService;
import com.biz.crm.member.business.member.local.utils.AssertUtils;
import com.biz.crm.member.business.member.sdk.enums.PrizeInventoryEnum;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RafflePrizeDetailsServiceImpl
implements RafflePrizeDetailsService {
    @Autowired
    private RafflePrizeDetailsRepository rafflePrizeDetailsRepository;
    @Autowired(required=false)
    private PrizeService prizeService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private RedisMutexService redisMutexService;
    public static final String MMS_RAFFLE_PRIZE_DETAIL_CODE_REDIS_KEY = "mms:raffle:prize:detail:code:index:%s";
    public static final String MMS_RAFFLE_PRIZE_DETAIL_CODE_PREFIX = "RPD";

    private String generateCode(String tenantCode) {
        String redisKey = String.format(MMS_RAFFLE_PRIZE_DETAIL_CODE_REDIS_KEY, tenantCode);
        String index = this.redisMutexService.getAndIncrement(redisKey, 1L, Integer.valueOf(6));
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        return StringUtils.join((Object[])new String[]{MMS_RAFFLE_PRIZE_DETAIL_CODE_PREFIX, format.format(new Date()), index});
    }

    @Override
    public List<RafflePrizeDetails> findByRafflePrizeCodes(List<String> prizeCodes) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.rafflePrizeDetailsRepository.lambdaQuery().in(RafflePrizeDetails::getRafflePrizeCode, prizeCodes)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    @Override
    public void saveBatch(List<RafflePrizeDetails> rafflePrizeDetails) {
        this.validateInventoryPrize(rafflePrizeDetails);
        ArrayList prizeCodes = new ArrayList();
        for (RafflePrizeDetails rafflePrizeDetail : rafflePrizeDetails) {
            rafflePrizeDetail.setCode(this.generateCode(TenantUtils.getTenantCode()));
        }
        this.rafflePrizeDetailsRepository.saveOrUpdateBatch(rafflePrizeDetails);
    }

    public void validateInventoryPrize(List<RafflePrizeDetails> rafflePrizeDetails) {
        Map<String, BigDecimal> putMap = rafflePrizeDetails.stream().filter(e -> StringUtils.isNotBlank((CharSequence)e.getPrizeCode()) && ObjectUtil.isNotNull((Object)e.getPutNum())).collect(Collectors.groupingBy(x -> x.getPrizeCode(), Collectors.reducing(BigDecimal.ZERO, t -> t.getPutNum(), (v1, v2) -> v1.add((BigDecimal)v2))));
        List<String> prizeCodes = rafflePrizeDetails.stream().map(RafflePrizeDetails::getPrizeCode).collect(Collectors.toList());
        List<PrizeEntity> prizeEntities = this.prizeService.findByCodes(prizeCodes);
        if (CollectionUtils.isEmpty(prizeEntities)) {
            throw new IllegalArgumentException("\u5956\u54c1\u4e0d\u5b58\u5728\uff01");
        }
        Map prizeMap = prizeEntities.stream().collect(Collectors.toMap(PrizeEntity::getCode, Function.identity()));
        putMap.forEach((k, v) -> {
            PrizeEntity prizeEntity = (PrizeEntity)((Object)((Object)prizeMap.get(k)));
            Validate.notNull((Object)((Object)prizeEntity), (String)"\u5956\u54c1\u4e0d\u5b58\u5728", (Object[])new Object[0]);
            if (PrizeInventoryEnum.EXITS.getCode().equals(prizeEntity.getInventory())) {
                AssertUtils.isTrue(v.compareTo(prizeEntity.getInventoryNum()) <= 0, "\u6295\u653e\u5956\u54c1:" + prizeEntity.getPrizeName() + "\u8d85\u8fc7\u5e93\u5b58\u6570\u91cf");
            }
        });
        if (MapUtil.isNotEmpty(putMap)) {
            this.prizeService.updateInventory(putMap);
        }
    }

    @Override
    public void deleteBatch(List<String> prizeCodeList) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.rafflePrizeDetailsRepository.lambdaUpdate().set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).in(RafflePrizeDetails::getRafflePrizeCode, prizeCodeList)).update();
    }

    @Override
    public RafflePrizeDetails detail(String detailId) {
        return (RafflePrizeDetails)((Object)this.rafflePrizeDetailsRepository.getById((Serializable)((Object)detailId)));
    }

    @Override
    public void save(RafflePrizeDetails rafflePrizeDetails) {
        this.rafflePrizeDetailsRepository.saveOrUpdate((Object)rafflePrizeDetails);
    }

    @Override
    public void deleteByRaffleCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.rafflePrizeDetailsRepository.lambdaUpdate().set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).eq(RafflePrizeDetails::getRaffleCode, (Object)code)).update();
    }

    @Override
    public void delete(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return;
        }
        this.rafflePrizeDetailsRepository.removeById((Serializable)((Object)id));
    }

    @Override
    public int reduceInventory(String code, BigDecimal num) {
        return this.rafflePrizeDetailsRepository.reduceInventory(code, num);
    }
}

