/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.member.business.member.local.service.internal;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.member.business.member.local.entity.RafflePrizeRecord;
import com.biz.crm.member.business.member.local.repository.RafflePrizeRecordRepository;
import com.biz.crm.member.business.member.local.service.RafflePrizeRecordService;
import com.biz.crm.member.business.member.sdk.dto.RafflePrizeRecordDto;
import com.biz.crm.member.business.member.sdk.vo.PrizeVo;
import com.biz.crm.member.business.member.sdk.vo.RafflePrizeRecordVo;
import com.biz.crm.member.business.member.sdk.vo.StaticsPrizeVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import jodd.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class RafflePrizeRecordServiceImpl
implements RafflePrizeRecordService {
    @Autowired
    private RafflePrizeRecordRepository rafflePrizeRecordRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private RedisMutexService redisMutexService;
    public static final String MMS_PRIZE_RECORD_REDIS_KEY = "mms:prize:record:index:%s";
    public static final String MMS_PRIZE_RECORD_PREFIX = "ZJ";

    private String generateCode(String tenantCode) {
        String redisKey = String.format(MMS_PRIZE_RECORD_REDIS_KEY, tenantCode);
        String index = this.redisMutexService.getAndIncrement(redisKey, 1L, Integer.valueOf(6));
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        return StringUtils.join((Object[])new String[]{MMS_PRIZE_RECORD_PREFIX, format.format(new Date()), index});
    }

    @Override
    public Page<RafflePrizeRecordVo> findByConditions(Pageable pageable, RafflePrizeRecordDto rafflePrizeRecordDto) {
        if (Objects.isNull(rafflePrizeRecordDto)) {
            rafflePrizeRecordDto = new RafflePrizeRecordDto();
        }
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.rafflePrizeRecordRepository.findByConditions((Page<RafflePrizeRecordVo>)page, rafflePrizeRecordDto);
    }

    @Override
    public Page<RafflePrizeRecordVo> findByConditionsByApplet(Pageable pageable, RafflePrizeRecordDto rafflePrizeRecordDto) {
        Validate.isTrue((boolean)StringUtils.isNotEmpty((CharSequence)rafflePrizeRecordDto.getMemberCode()), (String)"\u5c0f\u7a0b\u5e8f\u67e5\u8be2\u4e2d\u5956\u8bb0\u5f55\u65f6,\u4e2d\u5956\u4eba\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<RafflePrizeRecordVo> recordVoPage = this.rafflePrizeRecordRepository.findByConditionsByApplet((Page<RafflePrizeRecordVo>)page, rafflePrizeRecordDto);
        int threeDaysMilliseconds = 259200000;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        for (RafflePrizeRecordVo vo : recordVoPage.getRecords()) {
            Date endDate = vo.getEndDate();
            long leftTime = endDate.getTime() - new Date().getTime();
            if (leftTime >= (long)threeDaysMilliseconds) continue;
            if (leftTime <= 0L) {
                vo.setHint("\u6d3b\u52a8\u5df2\u7ed3\u675f");
                continue;
            }
            vo.setHint("\u6700\u8fdf\u9886\u5956\u65f6\u95f4\u4e3a:" + simpleDateFormat.format(vo.getEndDate()));
        }
        return recordVoPage;
    }

    @Override
    public RafflePrizeRecordVo findDetailById(String id, String code) {
        if (StringUtil.isBlank((CharSequence)id) && StringUtil.isBlank((CharSequence)code)) {
            return null;
        }
        RafflePrizeRecord rafflePrizeRecord = null;
        rafflePrizeRecord = !StringUtil.isBlank((CharSequence)id) ? (RafflePrizeRecord)((Object)this.rafflePrizeRecordRepository.getById((Serializable)((Object)id))) : (RafflePrizeRecord)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.rafflePrizeRecordRepository.lambdaQuery().eq(RafflePrizeRecord::getCode, (Object)code)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).one());
        Validate.notNull((Object)((Object)rafflePrizeRecord), (String)"\u4e2d\u5956\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        return (RafflePrizeRecordVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)rafflePrizeRecord, RafflePrizeRecordVo.class, HashSet.class, LinkedList.class, new String[0]);
    }

    @Override
    public RafflePrizeRecordVo create(RafflePrizeRecordDto rafflePrizeRecordDto) {
        this.validateCreate(rafflePrizeRecordDto);
        rafflePrizeRecordDto.setCode(this.generateCode(TenantUtils.getTenantCode()));
        rafflePrizeRecordDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        rafflePrizeRecordDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        rafflePrizeRecordDto.setTenantCode(TenantUtils.getTenantCode());
        RafflePrizeRecord rafflePrizeRecord = (RafflePrizeRecord)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)rafflePrizeRecordDto, RafflePrizeRecord.class, HashSet.class, LinkedList.class, new String[0]));
        this.rafflePrizeRecordRepository.saveOrUpdate((Object)rafflePrizeRecord);
        return (RafflePrizeRecordVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)rafflePrizeRecord, RafflePrizeRecordVo.class, HashSet.class, LinkedList.class, new String[0]);
    }

    private void validateCreate(RafflePrizeRecordDto rafflePrizeRecordDto) {
    }

    @Override
    public RafflePrizeRecordVo update(RafflePrizeRecordDto recordDto) {
        return null;
    }

    @Override
    public void enableBatch(List<String> ids) {
    }

    @Override
    public void disableBatch(List<String> ids) {
    }

    @Override
    public void deleteBatch(List<String> ids) {
    }

    @Override
    public PrizeVo statisticsPrize(String prizeCode) {
        StaticsPrizeVo staticsPrizeVo = this.rafflePrizeRecordRepository.staticsByStatus(prizeCode);
        PrizeVo prizeVo = new PrizeVo();
        BigDecimal putNum = staticsPrizeVo.getPutNumHit().add(staticsPrizeVo.getPutInventoryNum());
        BigDecimal putNumHit = staticsPrizeVo.getPutNumHit();
        BigDecimal claimed = staticsPrizeVo.getClaimed();
        BigDecimal waitClaimed = staticsPrizeVo.getWaitClaimed();
        BigDecimal expired = staticsPrizeVo.getExpired();
        BigDecimal useClaimed = staticsPrizeVo.getUseClaimed();
        BigDecimal unUseClaimed = staticsPrizeVo.getUnUseClaimed();
        BigDecimal expiredClaimed = staticsPrizeVo.getExpiredClaimed();
        return null;
    }

    @Override
    public void updateClaimStatus(String code, String claimStatus) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{code, claimStatus})) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.rafflePrizeRecordRepository.lambdaUpdate().set(RafflePrizeRecord::getClaimStatus, (Object)claimStatus)).set(RafflePrizeRecord::getClaimTime, (Object)new Date())).eq(RafflePrizeRecord::getCode, (Object)code)).update();
    }
}

