/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.member.business.member.local.service.internal;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.member.business.member.local.entity.PrizeEntity;
import com.biz.crm.member.business.member.local.entity.RafflePrizeDetails;
import com.biz.crm.member.business.member.local.entity.RafflePrizeEntity;
import com.biz.crm.member.business.member.local.repository.RafflePrizeRepository;
import com.biz.crm.member.business.member.local.service.PrizeService;
import com.biz.crm.member.business.member.local.service.RafflePrizeDetailsService;
import com.biz.crm.member.business.member.local.service.RafflePrizeService;
import com.biz.crm.member.business.member.sdk.dto.RafflePrizeDetailsDto;
import com.biz.crm.member.business.member.sdk.dto.RafflePrizeDto;
import com.biz.crm.member.business.member.sdk.vo.RafflePrizeDetailsVo;
import com.biz.crm.member.business.member.sdk.vo.RafflePrizeVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RafflePrizeServiceImpl
implements RafflePrizeService {
    @Autowired
    private RafflePrizeRepository rafflePrizeRepository;
    @Autowired
    private RafflePrizeDetailsService rafflePrizeDetailsService;
    @Autowired
    private PrizeService prizeService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private RedisMutexService redisMutexService;
    public static final String MMS_RAFFLE_PRIZE_CODE_REDIS_KEY = "mms:raffle:prize:code:index:%s";
    public static final String MMS_RAFFLE_PRIZE_CODE_PREFIX = "RP";

    private String generateCode(String tenantCode) {
        String redisKey = String.format(MMS_RAFFLE_PRIZE_CODE_REDIS_KEY, tenantCode);
        String index = this.redisMutexService.getAndIncrement(redisKey, 1L, Integer.valueOf(6));
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        return StringUtils.join((Object[])new String[]{MMS_RAFFLE_PRIZE_CODE_PREFIX, format.format(new Date()), index});
    }

    @Override
    public List<RafflePrizeVo> findByRaffleCode(String tenantCode, String code) {
        List entities = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.rafflePrizeRepository.lambdaQuery().eq(RafflePrizeEntity::getRaffleCode, (Object)code)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).list();
        if (CollectionUtils.isEmpty((Collection)entities)) {
            return null;
        }
        List rafflePrizeVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)entities, RafflePrizeEntity.class, RafflePrizeVo.class, HashSet.class, LinkedList.class, new String[0]);
        List<String> rafflePrizeCodes = rafflePrizeVos.stream().map(RafflePrizeVo::getCode).collect(Collectors.toList());
        List<RafflePrizeDetails> details = this.rafflePrizeDetailsService.findByRafflePrizeCodes(rafflePrizeCodes);
        if (!CollectionUtils.isEmpty(details)) {
            List rafflePrizeDetailsVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(details, RafflePrizeDetails.class, RafflePrizeDetailsVo.class, HashSet.class, LinkedList.class, new String[0]);
            List<String> prizeCodes = rafflePrizeDetailsVos.stream().filter(e -> StringUtils.isNotBlank((CharSequence)e.getPrizeCode())).map(RafflePrizeDetailsVo::getPrizeCode).collect(Collectors.toList());
            List<PrizeEntity> prizeEntities = this.prizeService.findByCodes(prizeCodes);
            this.fillPrizeInfo(rafflePrizeDetailsVos, prizeEntities);
            Map<String, List<RafflePrizeDetailsVo>> detailMap = rafflePrizeDetailsVos.stream().collect(Collectors.groupingBy(RafflePrizeDetailsVo::getRafflePrizeCode));
            rafflePrizeVos.stream().forEach(e -> e.setDetails((List)detailMap.get(e.getCode())));
            return rafflePrizeVos;
        }
        return rafflePrizeVos;
    }

    public void fillPrizeInfo(List<RafflePrizeDetailsVo> rafflePrizeDetailsVos, List<PrizeEntity> prizeEntities) {
        if (CollectionUtils.isNotEmpty(prizeEntities)) {
            Map prizeEntityMap = prizeEntities.stream().collect(Collectors.toMap(PrizeEntity::getCode, Function.identity()));
            for (RafflePrizeDetailsVo detailsVo : rafflePrizeDetailsVos) {
                PrizeEntity prize = (PrizeEntity)((Object)prizeEntityMap.get(detailsVo.getPrizeCode()));
                if (Objects.isNull((Object)prize)) continue;
                detailsVo.setUnitName(prize.getUnitName());
                detailsVo.setUnitPrice(prize.getUnitPrice());
                detailsVo.setPrizeType(prize.getPrizeType());
                detailsVo.setPrizeTypeName(prize.getPrizeTypeName());
                detailsVo.setInventory(prize.getInventory());
                detailsVo.setClaimValidate(prize.getReceiveTimeLimit());
                detailsVo.setUseValidate(prize.getVirtualTimeLimit());
                detailsVo.setUseValidate(prize.getVirtualTimeLimit());
                detailsVo.setClaimValidate(prize.getReceiveTimeLimit());
                if (Objects.isNull(prize.getUnitPrice()) || Objects.isNull(detailsVo.getQuantity())) continue;
                detailsVo.setTotalPrice(prize.getUnitPrice().multiply(detailsVo.getQuantity()));
                detailsVo.setTotalValue(detailsVo.getTotalPrice().multiply(detailsVo.getPutCopies()));
            }
        }
    }

    @Override
    @Transactional
    public void saveBatch(List<RafflePrizeDto> rafflePrizes) {
        if (CollectionUtils.isEmpty(rafflePrizes)) {
            return;
        }
        String tenantCode = TenantUtils.getTenantCode();
        ArrayList<RafflePrizeDetailsDto> detailsDtos = new ArrayList<RafflePrizeDetailsDto>();
        for (RafflePrizeDto rafflePrize : rafflePrizes) {
            if (StringUtils.isBlank((CharSequence)rafflePrize.getCode())) {
                rafflePrize.setCode(this.generateCode(TenantUtils.getTenantCode()));
            }
            rafflePrize.setTenantCode(tenantCode);
            rafflePrize.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            rafflePrize.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            List details = rafflePrize.getDetails();
            this.buildPrizeDetials(tenantCode, detailsDtos, rafflePrize, details);
            this.buildPrizePoll(rafflePrize);
        }
        List rafflePrizeEntities = (List)this.nebulaToolkitService.copyCollectionByWhiteList(rafflePrizes, RafflePrizeDto.class, RafflePrizeEntity.class, HashSet.class, LinkedList.class, new String[0]);
        this.rafflePrizeRepository.saveOrUpdateBatch(rafflePrizeEntities);
        if (CollectionUtils.isEmpty(detailsDtos)) {
            return;
        }
        List rafflePrizeDetails = (List)this.nebulaToolkitService.copyCollectionByWhiteList(detailsDtos, RafflePrizeDetailsDto.class, RafflePrizeDetails.class, HashSet.class, LinkedList.class, new String[0]);
        this.rafflePrizeDetailsService.saveBatch(rafflePrizeDetails);
    }

    public void buildPrizePoll(RafflePrizeDto rafflePrize) {
        List details = rafflePrize.getDetails();
        if (CollectionUtils.isEmpty((Collection)details)) {
            return;
        }
        ArrayList list = new ArrayList();
        Integer maxLength = 0;
        for (RafflePrizeDetailsDto prize : details) {
            Integer length;
            BigDecimal probability = prize.getPrizeProb().divide(new BigDecimal(100));
            String doubleVa = probability.doubleValue() + "";
            if (!doubleVa.contains(".") || (length = Integer.valueOf(doubleVa.length() - (doubleVa.indexOf(".") + 1))) <= maxLength) continue;
            maxLength = length;
        }
        Double pow = Math.pow(10.0, maxLength.intValue());
        Long aLong = new Long(pow.longValue());
        for (RafflePrizeDetailsDto prize : details) {
            BigDecimal probability = prize.getPrizeProb();
            Integer prizeLevel = Integer.valueOf(prize.getPrizeLevel());
            long longValue = probability.multiply(new BigDecimal(aLong)).longValue();
            List integerList = Stream.generate(() -> prizeLevel).limit(longValue).collect(Collectors.toList());
            list.addAll(integerList);
        }
        Collections.shuffle(list);
        if (CollUtil.isEmpty(list)) {
            return;
        }
        String prizePollStr = JSON.toJSONString(list);
        rafflePrize.setPrizePool(prizePollStr);
    }

    private void buildPrizeDetials(String tenantCode, List<RafflePrizeDetailsDto> detailsDtos, RafflePrizeDto rafflePrize, List<RafflePrizeDetailsDto> details) {
        if (CollectionUtils.isEmpty(details)) {
            return;
        }
        for (RafflePrizeDetailsDto detail : details) {
            detail.setId(null);
            detail.setRaffleCode(rafflePrize.getRaffleCode());
            detail.setRafflePrizeCode(rafflePrize.getCode());
            detail.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            detail.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            detail.setTenantCode(tenantCode);
            detail.setPutInventoryCopies(detail.getPutCopies());
            detail.setPutInventoryNum(detail.getPutNum());
            detailsDtos.add(detail);
        }
        rafflePrize.setDetails(details);
    }

    @Override
    public void deleteBatch(List<String> codeList) {
        if (CollectionUtils.isEmpty(codeList)) {
            return;
        }
        List entities = ((LambdaQueryChainWrapper)this.rafflePrizeRepository.lambdaQuery().in(RafflePrizeEntity::getRaffleCode, codeList)).list();
        if (CollectionUtils.isEmpty((Collection)entities)) {
            return;
        }
        List<String> prizeCodeList = entities.stream().map(RafflePrizeEntity::getCode).collect(Collectors.toList());
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.rafflePrizeRepository.lambdaUpdate().set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).in(RafflePrizeEntity::getRaffleCode, codeList)).update();
        this.rafflePrizeDetailsService.deleteBatch(prizeCodeList);
    }

    @Override
    @Transactional
    public void updateBatch(List<RafflePrizeDto> rafflePrizes, String code) {
        if (CollectionUtils.isEmpty(rafflePrizes)) {
            return;
        }
        for (RafflePrizeDto rafflePrize : rafflePrizes) {
            List details = rafflePrize.getDetails();
            if (CollectionUtils.isEmpty((Collection)details)) continue;
            List filter = details.stream().filter(e -> StringUtils.isBlank((CharSequence)e.getId())).collect(Collectors.toList());
            rafflePrize.setDetails(filter);
            this.buildPrizePoll(rafflePrize);
        }
        this.saveBatch(rafflePrizes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void adjust(String detailId, BigDecimal number) {
        if (StringUtils.isBlank((CharSequence)detailId) || Objects.isNull(number)) {
            return;
        }
        RafflePrizeDetails rafflePrizeDetails = this.rafflePrizeDetailsService.detail(detailId);
        Validate.notNull((Object)((Object)rafflePrizeDetails), (String)"\u5956\u9879\u4e0d\u5b58\u5728\uff01", (Object[])new Object[0]);
        String redisKey = String.format("mms:prize:lock:index:%s", TenantUtils.getTenantCode() + rafflePrizeDetails.getPrizeCode());
        boolean locked = false;
        try {
            RafflePrizeDetails detail = this.rafflePrizeDetailsService.detail(detailId);
            Validate.notNull((Object)((Object)detail), (String)"\u5956\u9879\u4e0d\u5b58\u5728\uff01", (Object[])new Object[0]);
            PrizeEntity prizeEntity = this.prizeService.findByCode(detail.getPrizeCode());
            Validate.notNull((Object)((Object)prizeEntity), (String)"\u5956\u54c1\u4e0d\u5b58\u5728", (Object[])new Object[0]);
            BigDecimal prizeInventoryNum = prizeEntity.getInventoryNum();
            Validate.notNull((Object)detail.getQuantity(), (String)"\u5956\u9879\u914d\u7f6e\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            BigDecimal raffleInventoryNum = detail.getQuantity().multiply(number);
            if (BigDecimal.ZERO.compareTo(number) > 0) {
                Validate.isTrue((raffleInventoryNum.negate().compareTo(number) < 0 ? 1 : 0) != 0, (String)"\u8c03\u6574\u6570\u91cf\u5fc5\u987b\u5c0f\u4e8e\u5927\u8f6c\u76d8\u5e93\u5b58\u6570\u91cf", (Object[])new Object[0]);
            } else {
                Validate.isTrue((prizeInventoryNum.compareTo(number) > 0 ? 1 : 0) != 0, (String)"\u8c03\u6574\u6570\u91cf\u5fc5\u987b\u5c0f\u4e8e\u5927\u5956\u54c1\u5e93\u5b58\u6570\u91cf", (Object[])new Object[0]);
            }
            detail.setPutCopies(detail.getPutCopies().add(number));
            detail.setPutNum(detail.getPutNum().add(raffleInventoryNum));
            detail.setPutInventoryCopies(detail.getPutInventoryCopies().add(number));
            detail.setPutInventoryNum(detail.getPutInventoryNum().add(raffleInventoryNum));
            this.rafflePrizeDetailsService.save(detail);
            prizeEntity.setInventoryNum(prizeEntity.getInventoryNum().add(raffleInventoryNum.negate()));
            this.prizeService.save(prizeEntity);
        }
        finally {
            if (locked) {
                this.redisMutexService.unlock(redisKey);
            }
        }
    }

    @Override
    public void delete(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return;
        }
        RafflePrizeDetails detail = this.rafflePrizeDetailsService.detail(id);
        Validate.notNull((Object)((Object)detail), (String)"\u5956\u9879\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        this.rafflePrizeDetailsService.delete(id);
        List<PrizeEntity> prizeEntities = this.prizeService.findByCodes(Lists.newArrayList((Object[])new String[]{detail.getPrizeCode()}));
        if (CollectionUtils.isEmpty(prizeEntities)) {
            throw new RuntimeException("\u5956\u54c1\u4e0d\u5b58\u5728");
        }
        String prizeId = prizeEntities.get(0).getId();
        this.prizeService.adjust(prizeId, detail.getPutInventoryNum());
    }

    @Override
    public RafflePrizeVo findByCode(String rafflePrizeCode, String tenantCode) {
        if (StringUtils.isBlank((CharSequence)rafflePrizeCode)) {
            return null;
        }
        RafflePrizeEntity one = (RafflePrizeEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.rafflePrizeRepository.lambdaQuery().eq(RafflePrizeEntity::getCode, (Object)rafflePrizeCode)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.ENABLE.getCode())).one());
        return (RafflePrizeVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)one, RafflePrizeVo.class, HashSet.class, LinkedList.class, new String[0]);
    }

    @Override
    public RafflePrizeVo findByCodeAndLevel(String rafflePrizeCode, String tenantCode, String level) {
        return this.rafflePrizeRepository.findByCodeAndLevel(rafflePrizeCode, tenantCode, level);
    }
}

