/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.member.business.member.local.service.internal;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.org.sdk.service.OrgVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import com.biz.crm.member.business.member.local.entity.MemberInfoArchives;
import com.biz.crm.member.business.member.local.entity.RealOrder;
import com.biz.crm.member.business.member.local.entity.VerificationUser;
import com.biz.crm.member.business.member.local.helper.UserSearchHelper;
import com.biz.crm.member.business.member.local.repository.MemberInfoArchivesRepository;
import com.biz.crm.member.business.member.local.repository.RealOrderRepository;
import com.biz.crm.member.business.member.local.repository.VerificationUserRepository;
import com.biz.crm.member.business.member.local.service.MemberInfoArchivesService;
import com.biz.crm.member.business.member.local.service.MemberInfoService;
import com.biz.crm.member.business.member.local.service.RealOrderService;
import com.biz.crm.member.business.member.sdk.dto.AppOrderPaginationDto;
import com.biz.crm.member.business.member.sdk.dto.DispatchSalesmanDto;
import com.biz.crm.member.business.member.sdk.dto.RealAndDummyOrderPaginationDto;
import com.biz.crm.member.business.member.sdk.dto.RealOrderPaginationDto;
import com.biz.crm.member.business.member.sdk.dto.VerificationRealOrderDto;
import com.biz.crm.member.business.member.sdk.enums.AppRealOrderStatusEnum;
import com.biz.crm.member.business.member.sdk.enums.CpsYesOrNoEnum;
import com.biz.crm.member.business.member.sdk.enums.DummyOrderStatusEnum;
import com.biz.crm.member.business.member.sdk.enums.OrderSettleStatusEnum;
import com.biz.crm.member.business.member.sdk.enums.RealOrderStatusEnum;
import com.biz.crm.member.business.member.sdk.enums.RealOrderTypeEnum;
import com.biz.crm.member.business.member.sdk.enums.VerificationOrderStatusEnum;
import com.biz.crm.member.business.member.sdk.enums.VerificationUserTypeEnum;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoArchivesVo;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoVo;
import com.biz.crm.member.business.member.sdk.vo.RealAndDummyOrderVo;
import com.biz.crm.member.business.member.sdk.vo.RealOrderDistributeVo;
import com.biz.crm.member.business.member.sdk.vo.RealOrderVo;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.service.ProcessBusinessMappingService;
import com.biz.crm.workflow.sdk.service.ProcessBusinessService;
import com.biz.crm.workflow.sdk.vo.ProcessBusinessVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.JsonUtils;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="realOrderService")
public class RealOrderServiceImpl
implements RealOrderService {
    private static final Logger log = LoggerFactory.getLogger(RealOrderServiceImpl.class);
    @Autowired(required=false)
    private RealOrderRepository realOrderRepository;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private UserSearchHelper userSearchHelper;
    @Autowired(required=false)
    private OrgVoService orgVoService;
    @Autowired
    private MemberInfoArchivesService memberInfoArchivesService;
    @Autowired
    private MemberInfoService memberInfoService;
    @Autowired
    private MemberInfoArchivesRepository memberInfoArchivesRepository;
    @Autowired
    private VerificationUserRepository verificationUserRepository;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    @Autowired
    private ProcessBusinessService processBusinessService;
    @Autowired(required=false)
    private ProcessBusinessMappingService processBusinessMappingService;
    @Value(value="${crm.business.realorder.process-key:}")
    private String defaultProcessKey;
    private static final Set<String> STATUS_SET = Sets.newHashSet((Object[])new String[]{ProcessStatusEnum.PREPARE.getDictCode(), ProcessStatusEnum.PASS.getDictCode(), ProcessStatusEnum.REJECT.getDictCode(), ProcessStatusEnum.RECOVER.getDictCode()});

    @Override
    public Page<RealOrderVo> findByConditions(Pageable pageable, RealOrderPaginationDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        dto = Optional.ofNullable(dto).orElse(new RealOrderPaginationDto());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.realOrderRepository.findByConditions((Page<RealOrderVo>)page, dto);
    }

    @Override
    public RealOrderVo findDetailById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        RealOrder realOrder = this.realOrderRepository.findById(id);
        RealOrderVo realOrderVo = (RealOrderVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)realOrder, RealOrderVo.class, HashSet.class, LinkedList.class, new String[0]);
        return realOrderVo;
    }

    @Override
    @Transactional
    public RealOrderVo create(RealOrderVo realOrderVo) {
        this.createValidation(realOrderVo);
        RealOrder realOrder = (RealOrder)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)realOrderVo, RealOrder.class, HashSet.class, LinkedList.class, new String[0]));
        realOrder.setTenantCode(TenantUtils.getTenantCode());
        realOrder.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        realOrder.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        MemberInfoVo memberInfoVo = this.memberInfoService.findDetailByMemberCode(realOrder.getUserCode());
        Validate.notNull((Object)memberInfoVo, (String)"\u4f1a\u5458\u4fe1\u606f\u5f02\u5e38", (Object[])new Object[0]);
        MemberInfoArchivesVo memberInfoArchivesVo = this.memberInfoArchivesService.findDetailByMemberCode(realOrder.getUserCode());
        Validate.notNull((Object)memberInfoArchivesVo, (String)"\u4f1a\u5458\u6863\u6848\u4fe1\u606f\u5f02\u5e38", (Object[])new Object[0]);
        List orgVos = this.orgVoService.findByOrgCodes(Arrays.asList(memberInfoArchivesVo.getOrgCode()));
        if (CollectionUtils.isNotEmpty((Collection)orgVos)) {
            OrgVo orgVo = (OrgVo)orgVos.get(0);
            if (orgVo != null && Objects.equals("1", orgVo.getAuthority())) {
                realOrder.setOrderType(RealOrderTypeEnum.MARKET_ORDER.getValue());
                realOrder.setOrderStatus(RealOrderStatusEnum.STAY_DELIVERY.getValue());
                realOrder.setOrgCode(orgVo.getOrgCode());
                realOrder.setOrgName(orgVo.getOrgName());
            } else {
                realOrder.setOrderType(RealOrderTypeEnum.TOTAL_ORDER.getValue());
                realOrder.setOrderStatus(RealOrderStatusEnum.STAY_SHIP.getValue());
                if (orgVo != null) {
                    realOrder.setOrgCode(orgVo.getOrgCode());
                    realOrder.setOrgName(orgVo.getOrgName());
                }
            }
        }
        realOrder.setOrderCode((String)this.generateCodeService.generateCode("SW", 5).get(0));
        realOrder.setUserName(memberInfoVo.getMemberName());
        realOrder.setOrderTime(new Date());
        realOrder.setOrderName(memberInfoVo.getMemberName());
        realOrder.setOrderPhone(memberInfoVo.getMemberPhone());
        this.realOrderRepository.saveOrUpdate((Object)realOrder);
        realOrderVo.setOrderCode(realOrder.getOrderCode());
        realOrderVo.setId(realOrder.getId());
        return realOrderVo;
    }

    @Override
    @Transactional
    public RealOrderVo update(RealOrderVo realOrderVo) {
        this.updateValidation(realOrderVo);
        String currentId = realOrderVo.getId();
        RealOrder current = this.realOrderRepository.findById(currentId);
        current = (RealOrder)((Object)Validate.notNull((Object)((Object)current), (String)"\u4fee\u6539\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]));
        current = (RealOrder)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)realOrderVo, RealOrder.class, HashSet.class, LinkedList.class, new String[0]));
        this.realOrderRepository.saveOrUpdate((Object)current);
        return realOrderVo;
    }

    @Override
    @Transactional
    public void enableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.realOrderRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
    }

    @Override
    @Transactional
    public void disableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.realOrderRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
    }

    @Override
    @Transactional
    public void updateDelFlagByIds(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.realOrderRepository.updateDelFlagByIds(ids);
    }

    @Override
    public void changeTotalOrder(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.realOrderRepository.changeTotalOrder(ids);
    }

    @Override
    public void changeMarketOrder(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.realOrderRepository.changeMarketOrder(ids);
    }

    @Override
    public void changeDistribute(RealOrderDistributeVo realOrderDistributeVo) {
        Validate.notBlank((CharSequence)realOrderDistributeVo.getId(), (String)"\u8bf7\u9009\u62e9\u8ba2\u5355", (Object[])new Object[0]);
        RealOrder realOrder = this.realOrderRepository.findById(realOrderDistributeVo.getId());
        Validate.notNull((Object)((Object)realOrder), (String)"\u5b9e\u7269\u8ba2\u5355\u4e0d\u5b58\u5728!", (Object[])new Object[0]);
        if (Objects.equals("\u529e\u4e8b\u5904\u8d1f\u8d23\u4eba", realOrderDistributeVo.getRoleName())) {
            realOrder.setOfficeName(realOrderDistributeVo.getSalesmanName());
            realOrder.setOfficePhone(realOrderDistributeVo.getSalesmanPhone());
        } else {
            realOrder.setSalesmanName(realOrderDistributeVo.getSalesmanName());
            realOrder.setSalesmanPhone(realOrderDistributeVo.getSalesmanPhone());
        }
        realOrder.setFlagDistribute(CpsYesOrNoEnum.YES.getValue());
        this.realOrderRepository.updateById((Object)realOrder);
    }

    @Override
    public void shipOrderById(RealOrderVo realOrderVo) {
        Validate.notBlank((CharSequence)realOrderVo.getId(), (String)"\u8bf7\u9009\u62e9\u8ba2\u5355", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)realOrderVo.getExpressNum(), (String)"\u5feb\u9012\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        RealOrder realOrder = this.realOrderRepository.findById(realOrderVo.getId());
        Validate.notNull((Object)((Object)realOrder), (String)"\u5b9e\u7269\u8ba2\u5355\u4e0d\u5b58\u5728!", (Object[])new Object[0]);
        Validate.isTrue((boolean)Objects.equals(RealOrderStatusEnum.STAY_SHIP.getValue(), realOrder.getOrderStatus()), (String)"\u5f85\u53d1\u8d27\u72b6\u6001\u624d\u5141\u8bb8\u53d1\u8d27,\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        realOrder.setExpressNum(realOrder.getExpressNum());
        realOrder.setOrderStatus(RealOrderStatusEnum.HAS_SHIP.getValue());
        this.realOrderRepository.updateById((Object)realOrder);
    }

    @Override
    public void cancelShipOrderById(RealOrderVo realOrderVo) {
        Validate.notBlank((CharSequence)realOrderVo.getId(), (String)"\u8bf7\u9009\u62e9\u8ba2\u5355", (Object[])new Object[0]);
        RealOrder realOrder = this.realOrderRepository.findById(realOrderVo.getId());
        Validate.notNull((Object)((Object)realOrder), (String)"\u5b9e\u7269\u8ba2\u5355\u4e0d\u5b58\u5728!", (Object[])new Object[0]);
        Validate.isTrue((boolean)Objects.equals(RealOrderStatusEnum.HAS_SHIP.getValue(), realOrder.getOrderStatus()), (String)"\u5f85\u53d1\u8d27\u72b6\u6001\u624d\u5141\u8bb8\u53d1\u8d27,\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        realOrder.setExpressNum(null);
        realOrder.setOrderStatus(RealOrderStatusEnum.STAY_SHIP.getValue());
        this.realOrderRepository.updateById((Object)realOrder);
    }

    @Override
    public void realOrderImportExpressNum(RealOrderVo realOrderVo) {
        Validate.notBlank((CharSequence)realOrderVo.getOrderCode(), (String)"\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)realOrderVo.getExpressNum(), (String)"\u5feb\u9012\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        RealOrder realOrder = (RealOrder)((Object)((LambdaQueryChainWrapper)this.realOrderRepository.lambdaQuery().eq(RealOrder::getOrderCode, (Object)realOrderVo.getOrderCode())).one());
        if (realOrder != null && Objects.equals(RealOrderStatusEnum.STAY_SHIP.getValue(), realOrder.getOrderStatus())) {
            realOrder.setExpressNum(realOrder.getExpressNum());
            realOrder.setOrderStatus(RealOrderStatusEnum.HAS_SHIP.getValue());
            this.realOrderRepository.updateById((Object)realOrder);
        }
    }

    @Override
    @Transactional
    public void settleSubmit(RealOrderVo realOrderVo) {
        Validate.notBlank((CharSequence)realOrderVo.getId(), (String)"\u8bf7\u9009\u62e9\u8ba2\u5355", (Object[])new Object[0]);
        RealOrder realOrder = this.realOrderRepository.findById(realOrderVo.getId());
        Validate.notNull((Object)((Object)realOrder), (String)"\u5b9e\u7269\u8ba2\u5355\u4e0d\u5b58\u5728!", (Object[])new Object[0]);
        Validate.isTrue((boolean)Objects.equals(OrderSettleStatusEnum.STAY_SETTLE.getValue(), realOrder.getSettleStatus()), (String)"\u8bf7\u9009\u62e9\u672a\u7ed3\u7b97\u8ba2\u5355!", (Object[])new Object[0]);
        realOrder.setProcessNumber(this.commitProcess(realOrder));
        realOrder.setProcessStatus(ProcessStatusEnum.COMMIT.getDictCode());
        realOrder.setSettleStatus(OrderSettleStatusEnum.LOAD_SETTLE.getValue());
        this.realOrderRepository.updateById((Object)realOrder);
    }

    @Override
    public Page<RealOrderVo> appPageRealOrder(Pageable pageable, AppOrderPaginationDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        dto = Optional.ofNullable(dto).orElse(new AppOrderPaginationDto());
        this.appPageValidate(dto);
        String orderStatus = dto.getOrderStatus();
        String orderStatusAll = AppRealOrderStatusEnum.ALL.getValue();
        ArrayList ordersStatusList = Lists.newArrayList();
        if (orderStatusAll.equals(orderStatus)) {
            ordersStatusList = null;
        } else if (Objects.equals(RealOrderStatusEnum.STAY_SHIP.getValue(), dto.getOrderStatus())) {
            ordersStatusList.add(RealOrderStatusEnum.STAY_SHIP.getValue());
            ordersStatusList.add(RealOrderStatusEnum.STAY_DELIVERY.getValue());
        } else if (Objects.equals(RealOrderStatusEnum.HAS_SHIP.getValue(), dto.getOrderStatus())) {
            ordersStatusList.add(RealOrderStatusEnum.HAS_SHIP.getValue());
            ordersStatusList.add(RealOrderStatusEnum.IN_DELIVERY.getValue());
        } else {
            ordersStatusList.add(orderStatus);
        }
        dto.setOrderStatusList((List)ordersStatusList);
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        String memberCode = this.userSearchHelper.getMemberLogin().getMemberCode();
        Page<RealOrderVo> result = this.realOrderRepository.appPageRealOrder((Page<RealOrderVo>)page, dto, memberCode);
        return result;
    }

    @Override
    public Page<RealAndDummyOrderVo> findByConditionsRealAndOrder(Pageable pageable, RealAndDummyOrderPaginationDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        dto = Optional.ofNullable(dto).orElse(new RealAndDummyOrderPaginationDto());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<RealAndDummyOrderVo> byConditionsRealAndOrder = this.realOrderRepository.findByConditionsRealAndOrder((Page<RealAndDummyOrderVo>)page, dto);
        if (byConditionsRealAndOrder != null && CollectionUtils.isNotEmpty((Collection)byConditionsRealAndOrder.getRecords())) {
            for (RealAndDummyOrderVo record : byConditionsRealAndOrder.getRecords()) {
                if (Objects.equals("0", record.getOrderType())) {
                    record.setOrderType("\u5b9e\u7269\u8ba2\u5355");
                    record.setOrderStatus(RealOrderStatusEnum.getNameByCode((String)record.getOrderStatus()));
                    continue;
                }
                record.setOrderType("\u865a\u62df\u8ba2\u5355");
                record.setOrderStatus(DummyOrderStatusEnum.getNameByCode((String)record.getOrderStatus()));
            }
        }
        return byConditionsRealAndOrder;
    }

    @Override
    public RealOrderVo findDetailByOrderCode(String orderCode) {
        if (StringUtils.isBlank((CharSequence)orderCode)) {
            return null;
        }
        RealOrder realOrder = (RealOrder)((Object)((LambdaQueryChainWrapper)this.realOrderRepository.lambdaQuery().eq(RealOrder::getOrderCode, (Object)orderCode)).one());
        if (realOrder == null) {
            return null;
        }
        RealOrderVo realOrderVo = (RealOrderVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)realOrder, RealOrderVo.class, HashSet.class, LinkedList.class, new String[0]);
        return realOrderVo;
    }

    @Override
    public Page<RealOrderVo> appPageDeliveryOrder(Pageable pageable, String orderStatus) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        Validate.notBlank((CharSequence)orderStatus, (String)"\u8ba2\u5355\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String allValue = VerificationOrderStatusEnum.ALL.getValue();
        if (allValue.equals(orderStatus)) {
            orderStatus = "";
        }
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        String memberPhone = this.userSearchHelper.getMemberLogin().getMemberPhone();
        VerificationUser verificationUser = (VerificationUser)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.verificationUserRepository.lambdaQuery().eq(VerificationUser::getPhone, (Object)memberPhone)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.ENABLE.getCode())).eq(VerificationUser::getUserType, (Object)VerificationUserTypeEnum.STUFF.getCode())).one());
        Validate.notNull((Object)((Object)verificationUser), (String)"\u5f53\u524d\u767b\u5f55\u7528\u6237\u4e0d\u662f\u5b9e\u7269\u6838\u9500\u4eba\u5458\u6216\u5df2\u88ab\u7981\u7528\uff0c\u65e0\u6743\u83b7\u53d6\u8ba2\u5355\u4fe1\u606f", (Object[])new Object[0]);
        String userCode = verificationUser.getUserCode();
        Page<RealOrderVo> result = this.realOrderRepository.appPageRealOrderBySalesmanCode((Page<RealOrderVo>)page, orderStatus, userCode);
        return result;
    }

    @Override
    public Page<RealOrderVo> appPageDispatchOrder(Pageable pageable, String orderStatus) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        Validate.notBlank((CharSequence)orderStatus, (String)"\u8ba2\u5355\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String allValue = VerificationOrderStatusEnum.ALL.getValue();
        if (allValue.equals(orderStatus)) {
            orderStatus = "";
        }
        String memberCode = this.userSearchHelper.getMemberLogin().getMemberCode();
        MemberInfoArchives infoArchives = (MemberInfoArchives)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.memberInfoArchivesRepository.lambdaQuery().eq(MemberInfoArchives::getMemberCode, (Object)memberCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).one());
        Validate.notNull((Object)((Object)infoArchives), (String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u6863\u6848\u4fe1\u606f\uff0c\u65e0\u6cd5\u83b7\u53d6\u5230\u5206\u53d1\u8ba2\u5355\u6570\u636e", (Object[])new Object[0]);
        String orgCode = infoArchives.getOrgCode();
        Validate.notBlank((CharSequence)orgCode, (String)"\u5f53\u524d\u7528\u6237\u7684\u7ec4\u7ec7\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<RealOrderVo> result = this.realOrderRepository.appPageDispatchOrder((Page<RealOrderVo>)page, orderStatus, orgCode);
        return result;
    }

    @Override
    public void appDispatchSalesmanForOrder(DispatchSalesmanDto dto) {
        this.validationDispatchSalesman(dto);
        String orderCode = dto.getOrderCode();
        RealOrder realOrder = (RealOrder)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.realOrderRepository.lambdaQuery().eq(RealOrder::getOrderCode, (Object)orderCode)).eq(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.ENABLE.getCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).one());
        Validate.notNull((Object)((Object)realOrder), (String)"\u5206\u53d1\u7684\u8ba2\u5355\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        String orderStatus = realOrder.getOrderStatus();
        String stayDeliveryValue = RealOrderStatusEnum.STAY_DELIVERY.getValue();
        Validate.isTrue((boolean)stayDeliveryValue.equals(orderStatus), (String)"\u8ba2\u5355\u72b6\u6001\u4e0d\u662f\u5f85\u914d\u9001\uff0c\u4e0d\u80fd\u5206\u53d1", (Object[])new Object[0]);
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.realOrderRepository.lambdaUpdate().set(RealOrder::getSalesmanCode, (Object)dto.getSalesmanCode())).set(RealOrder::getSalesmanName, (Object)dto.getSalesmanName())).set(RealOrder::getSalesmanPhone, (Object)dto.getSalesmanPhone())).eq(RealOrder::getOrderCode, (Object)dto.getOrderCode())).update();
    }

    @Override
    public void appWriteOrderById(VerificationRealOrderDto dto) {
        String realOrderId = dto.getVerificationOrderId();
        RealOrder realOrder = (RealOrder)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.realOrderRepository.lambdaQuery().eq(UuidEntity::getId, (Object)realOrderId)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.ENABLE.getCode())).one());
        Validate.notNull((Object)((Object)realOrder), (String)"\u6838\u9500\u8ba2\u5355\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        String orderStatus = realOrder.getOrderStatus();
        String inDeliveryValue = RealOrderStatusEnum.IN_DELIVERY.getValue();
        Validate.isTrue((boolean)inDeliveryValue.equals(orderStatus), (String)"\u6838\u9500\u5931\u8d25,\u8ba2\u5355\u72b6\u6001\u4e0d\u662f\u914d\u9001\u4e2d", (Object[])new Object[0]);
        String memberPhone = this.userSearchHelper.getMemberLogin().getMemberPhone();
        VerificationUser verificationUser = (VerificationUser)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.verificationUserRepository.lambdaQuery().eq(VerificationUser::getPhone, (Object)memberPhone)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.ENABLE.getCode())).eq(VerificationUser::getUserType, (Object)VerificationUserTypeEnum.STUFF.getCode())).one());
        Validate.notNull((Object)((Object)verificationUser), (String)"\u5f53\u524d\u767b\u5f55\u7528\u6237\u4e0d\u662f\u5b9e\u7269\u6838\u9500\u4eba\u5458\u6216\u5df2\u88ab\u7981\u7528,\u65e0\u6743\u6838\u9500\u8be5\u8ba2\u5355", (Object[])new Object[0]);
        String userCode = verificationUser.getUserCode();
        String userName = verificationUser.getUserName();
        String relationAgentCode = dto.getRelationAgentCode();
        String relationAgentName = dto.getRelationAgentName();
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.realOrderRepository.lambdaUpdate().set(RealOrder::getWriteOffCode, (Object)userCode)).set(RealOrder::getWriteOffName, (Object)userName)).set(RealOrder::getWriteOffTime, (Object)new Date(System.currentTimeMillis()))).set(RealOrder::getOrderStatus, (Object)RealOrderStatusEnum.HAS_WRITE_OFF.getValue())).set(StringUtils.isNotBlank((CharSequence)relationAgentCode), RealOrder::getRelationAgentCode, (Object)relationAgentCode).set(StringUtils.isNotBlank((CharSequence)relationAgentName), RealOrder::getRelationAgentName, (Object)relationAgentName).eq(UuidEntity::getId, (Object)realOrderId);
    }

    @Override
    public void appDeliveryOrderById(String orderId) {
        Validate.notBlank((CharSequence)orderId, (String)"\u8ba2\u5355Id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        RealOrder realOrder = (RealOrder)((Object)this.realOrderRepository.getById((Serializable)((Object)orderId)));
        Validate.notNull((Object)((Object)realOrder), (String)"\u6b64\u8ba2\u5355\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        String orderStatus = realOrder.getOrderStatus();
        String stayDeliveryValue = RealOrderStatusEnum.STAY_DELIVERY.getValue();
        Validate.isTrue((boolean)stayDeliveryValue.equals(orderStatus), (String)"\u8ba2\u5355\u7684\u72b6\u6001\u4e0d\u662f\u5f85\u914d\u9001,\u53bb\u914d\u9001\u5931\u8d25", (Object[])new Object[0]);
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.realOrderRepository.lambdaUpdate().set(RealOrder::getOrderStatus, (Object)RealOrderStatusEnum.IN_DELIVERY)).eq(UuidEntity::getId, (Object)orderId)).eq(RealOrder::getOrderType, (Object)RealOrderTypeEnum.MARKET_ORDER.getValue())).update();
    }

    @Override
    public List<CustomerVo> appListAgentCustomer() {
        String memberCode = this.userSearchHelper.getMemberLogin().getMemberCode();
        MemberInfoArchives infoArchives = (MemberInfoArchives)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.memberInfoArchivesRepository.lambdaQuery().eq(MemberInfoArchives::getMemberCode, (Object)memberCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.ENABLE.getCode())).one());
        Validate.notNull((Object)((Object)infoArchives), (String)"\u5f53\u524d\u767b\u5f55\u7528\u6237\u6863\u6848\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        String orgCode = infoArchives.getOrgCode();
        Validate.notBlank((CharSequence)orgCode, (String)"\u5f53\u524d\u767b\u5f55\u7528\u6237\u7684\u7ec4\u7ec7\u4fe1\u606f\u4e3a\u7a7a", (Object[])new Object[0]);
        List result = this.customerVoService.findByOrgCodes(Arrays.asList(orgCode));
        return result;
    }

    private void validationDispatchSalesman(DispatchSalesmanDto dto) {
        Validate.notNull((Object)dto, (String)"\u4e1a\u52a1\u5458\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getOrderCode(), (String)"\u8ba2\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getSalesmanCode(), (String)"\u4e1a\u52a1\u5458\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getSalesmanName(), (String)"\u4e1a\u52a1\u5458\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getSalesmanPhone(), (String)"\u4e1a\u52a1\u5458\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }

    private void appPageValidate(AppOrderPaginationDto dto) {
        Validate.notNull((Object)dto, (String)"\u67e5\u8be2\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getOrderSource(), (String)"\u6570\u636e\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getOrderStatus(), (String)"\u8ba2\u5355\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }

    private void createValidation(RealOrderVo realOrderVo) {
        this.validation(realOrderVo);
    }

    private void updateValidation(RealOrderVo realOrderVo) {
        this.validation(realOrderVo);
    }

    private void validation(RealOrderVo realOrderVo) {
        Validate.notBlank((CharSequence)realOrderVo.getOrderSource(), (String)"\u8ba2\u5355\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)realOrderVo.getProductImg(), (String)"\u5546\u54c1\u56fe\u7247\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)realOrderVo.getUserCode(), (String)"\u5173\u8054\u7528\u6237\u4f1a\u5458\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)realOrderVo.getProductName(), (String)"\u5546\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)realOrderVo.getProductNum(), (String)"\u5546\u54c1\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)realOrderVo.getReceiptName(), (String)"\u6536\u8d27\u4eba\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)realOrderVo.getReceiptPhone(), (String)"\u6536\u8d27\u4eba\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)realOrderVo.getReceiptAddress(), (String)"\u6536\u8d27\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }

    private String commitProcess(RealOrder dto) {
        ProcessBusinessDto processBusiness = Optional.ofNullable(dto.getProcessBusiness()).orElse(new ProcessBusinessDto());
        String processKey = processBusiness.getProcessKey();
        if (StringUtils.isBlank((CharSequence)processKey)) {
            processBusiness.setProcessKey(this.defaultProcessKey);
        }
        processBusiness.setBusinessNo(dto.getId());
        processBusiness.setBusinessFormJson(JsonUtils.obj2JsonString((Object)((Object)dto)));
        processBusiness.setBusinessCode("mms_real_order_create");
        processBusiness.setProcessTitle(dto.getOrderName() + dto.getOrderCode());
        this.processBusinessMappingService.deleteByBusinessNoAndBusinessCodeAndProcessKey(dto.getId(), "mms_real_order_create", processBusiness.getProcessKey());
        ProcessBusinessVo processBusinessVo = this.processBusinessService.processStart(processBusiness);
        return processBusinessVo.getProcessNo();
    }
}

