/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.member.business.member.local.service.internal;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.member.business.member.local.entity.PrizeEntity;
import com.biz.crm.member.business.member.local.entity.RewardActivityUserCountEntity;
import com.biz.crm.member.business.member.local.helper.UserSearchHelper;
import com.biz.crm.member.business.member.local.repository.RewardActivityUserCountRepository;
import com.biz.crm.member.business.member.local.service.HolidayIntegralAction;
import com.biz.crm.member.business.member.local.service.MemberInfoAssetsService;
import com.biz.crm.member.business.member.local.service.MemberInfoIntegralRecordService;
import com.biz.crm.member.business.member.local.service.PrizeService;
import com.biz.crm.member.business.member.local.service.RaffleManageService;
import com.biz.crm.member.business.member.local.service.RafflePrizeDetailsService;
import com.biz.crm.member.business.member.local.service.RafflePrizeRecordService;
import com.biz.crm.member.business.member.local.service.RafflePrizeService;
import com.biz.crm.member.business.member.local.service.RewardActivityLotteryService;
import com.biz.crm.member.business.member.sdk.dto.LotteryDto;
import com.biz.crm.member.business.member.sdk.dto.RaffleMemberDto;
import com.biz.crm.member.business.member.sdk.dto.RafflePrizeRecordDto;
import com.biz.crm.member.business.member.sdk.enums.ChannelTypeEnum;
import com.biz.crm.member.business.member.sdk.enums.ClaimStatusEnum;
import com.biz.crm.member.business.member.sdk.enums.EmployStatusEnum;
import com.biz.crm.member.business.member.sdk.enums.IntegralSourceEnum;
import com.biz.crm.member.business.member.sdk.enums.PrizeInventoryEnum;
import com.biz.crm.member.business.member.sdk.enums.PrizeOverSelectEnum;
import com.biz.crm.member.business.member.sdk.enums.PrizeTypeEnum;
import com.biz.crm.member.business.member.sdk.vo.LotteryVo;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoAssetsVo;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoIntegralRecordVo;
import com.biz.crm.member.business.member.sdk.vo.RaffleBaseConfigVo;
import com.biz.crm.member.business.member.sdk.vo.RaffleManageVo;
import com.biz.crm.member.business.member.sdk.vo.RafflePrizeDetailsVo;
import com.biz.crm.member.business.member.sdk.vo.RafflePrizeRecordVo;
import com.biz.crm.member.business.member.sdk.vo.RafflePrizeVo;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.math.BigDecimal;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RewardActivityLotteryServiceImpl
implements RewardActivityLotteryService {
    @Autowired
    private RafflePrizeRecordService rafflePrizeRecordService;
    @Autowired
    private RaffleManageService raffleManageService;
    @Autowired
    private RafflePrizeService rafflePrizeService;
    @Autowired
    private UserSearchHelper userSearchHelper;
    @Autowired
    private RewardActivityUserCountRepository rewardActivityUserCountRepository;
    @Autowired
    private RedisMutexService redisMutexService;
    @Autowired
    private RafflePrizeDetailsService rafflePrizeDetailsService;
    @Autowired
    private MemberInfoIntegralRecordService memberInfoIntegralRecordService;
    @Autowired
    private PrizeService prizeService;
    @Autowired
    private MemberInfoAssetsService memberInfoAssetsService;
    @Autowired
    private HolidayIntegralAction holidayIntegralAction;

    @Override
    public Page<RafflePrizeRecordVo> findByConditions(Pageable pageable, RafflePrizeRecordDto rafflePrizeRecordDto) {
        if (Objects.isNull(rafflePrizeRecordDto)) {
            rafflePrizeRecordDto = new RafflePrizeRecordDto();
        }
        String memberCode = this.userSearchHelper.getMemberLogin().getMemberCode();
        Validate.notBlank((CharSequence)memberCode, (String)"\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u4eba\u4fe1\u606f\u5931\u8d25\uff01", (Object[])new Object[0]);
        rafflePrizeRecordDto.setMemberCode(memberCode);
        Page<RafflePrizeRecordVo> recordVoPage = this.rafflePrizeRecordService.findByConditions(pageable, rafflePrizeRecordDto);
        return recordVoPage;
    }

    @Override
    public String getRuleDes(String activityCode) {
        RaffleManageVo raffleManageVo = this.raffleManageService.findByActivityCode(activityCode);
        Validate.notNull((Object)raffleManageVo, (String)"\u6d3b\u52a8\u4e0d\u5b58\u5728!", (Object[])new Object[0]);
        return raffleManageVo.getRuleDes();
    }

    @Override
    public LotteryVo rewardInfo(String activityCode) {
        LotteryVo lotteryVo = new LotteryVo();
        String memberLevel = "VIP2023063000000041";
        String memberCode = "mm11233444";
        RaffleManageVo raffleManageVo = this.raffleManageService.findDetailById(null, activityCode);
        List rafflePrizes = raffleManageVo.getRafflePrizes();
        if (CollectionUtils.isEmpty((Collection)rafflePrizes)) {
            throw new RuntimeException("\u6d3b\u52a8\u672a\u914d\u7f6e\u5956\u54c1");
        }
        RafflePrizeVo rafflePrizeVo = rafflePrizes.stream().filter(e -> e.getMemberLevels().stream().map(RaffleMemberDto::getMemberLevelCode).collect(Collectors.toList()).contains(memberLevel)).findFirst().orElse(null);
        Validate.notNull((Object)rafflePrizeVo, (String)"\u5bf9\u5e94\u4f1a\u5458\u7b49\u7ea7\u672a\u914d\u7f6e\u5956\u54c1", (Object[])new Object[0]);
        lotteryVo.setPrizeVo(rafflePrizeVo);
        List baseConfigs = raffleManageVo.getBaseConfigs();
        if (CollectionUtils.isEmpty((Collection)baseConfigs)) {
            throw new RuntimeException("\u6d3b\u52a8\u672a\u914d\u7f6e\u62bd\u5956\u6b21\u6570");
        }
        RaffleBaseConfigVo raffleBaseConfigVo = baseConfigs.stream().filter(e -> e.getMemberLevels().stream().map(RaffleMemberDto::getMemberLevelCode).collect(Collectors.toList()).contains(memberLevel)).findFirst().orElse(null);
        Validate.notNull((Object)raffleBaseConfigVo, (String)"\u5bf9\u5e94\u4f1a\u5458\u7b49\u7ea7\u4e3a\u914d\u7f6e\u62bd\u5956\u6b21\u6570", (Object[])new Object[0]);
        RewardActivityUserCountEntity countEntity = (RewardActivityUserCountEntity)((Object)((LambdaQueryChainWrapper)this.rewardActivityUserCountRepository.lambdaQuery().eq(RewardActivityUserCountEntity::getMemberCode, (Object)memberCode)).one());
        if (Objects.isNull((Object)countEntity)) {
            RewardActivityUserCountEntity count = new RewardActivityUserCountEntity();
            count.setUseTimes(0);
            count.setMemberCode(memberCode);
            count.setTenantCode(TenantUtils.getTenantCode());
            this.rewardActivityUserCountRepository.save((Object)count);
            countEntity = count;
        }
        Integer remainLotteryNum = raffleBaseConfigVo.getOneRaffleNum() + raffleBaseConfigVo.getTwoRaffleNum() - countEntity.getUseTimes();
        lotteryVo.setRemainLotteryNum(remainLotteryNum);
        Integer oneRaffleUseIntegral = raffleBaseConfigVo.getOneRaffleUseIntegral();
        Integer twoRaffleUseIntegral = raffleBaseConfigVo.getTwoRaffleUseIntegral();
        if (countEntity.getUseTimes() > raffleBaseConfigVo.getOneRaffleNum()) {
            lotteryVo.setUseIntegral(twoRaffleUseIntegral);
        } else {
            lotteryVo.setUseIntegral(oneRaffleUseIntegral);
        }
        return lotteryVo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public RafflePrizeDetailsVo lottery(LotteryDto lotteryDto) {
        Validate.notNull((Object)lotteryDto, (String)"\u5b9e\u4f53\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)lotteryDto.getMemberCode(), (String)"\u4f1a\u5458\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)lotteryDto.getRafflePrizeCode(), (String)"\u62bd\u5956\u5927\u8f6c\u76d8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String redisKey = String.format("mms:lottery:member:lock:index:%s", TenantUtils.getTenantCode() + lotteryDto.getMemberCode() + lotteryDto.getRafflePrizeCode());
        boolean locked = false;
        try {
            locked = this.redisMutexService.tryLock(redisKey, TimeUnit.SECONDS, 5);
            String level = "VIP2023063000000041";
            String memberCode = lotteryDto.getMemberCode();
            RafflePrizeVo rafflePrizeVo = this.rafflePrizeService.findByCodeAndLevel(lotteryDto.getRafflePrizeCode(), TenantUtils.getTenantCode(), level);
            this.rewardActivityUserCountRepository.updateUseTimes(lotteryDto.getMemberCode());
            MemberInfoIntegralRecordVo recordVo = new MemberInfoIntegralRecordVo();
            recordVo.setIntegral(lotteryDto.getIntegral());
            recordVo.setMemberCode(memberCode);
            recordVo.setSource(IntegralSourceEnum.BIG_TURNTABLE_PAY.getValue());
            recordVo.setType(IntegralSourceEnum.BIG_TURNTABLE_PAY.getType());
            this.memberInfoIntegralRecordService.commonInternal(recordVo);
            String prizePool = rafflePrizeVo.getPrizePool();
            List list = JSONObject.parseArray((String)prizePool, Integer.class);
            SecureRandom random = new SecureRandom();
            int num = random.nextInt(list.size());
            String prizeLevel = String.valueOf(list.get(num));
            List details = rafflePrizeVo.getDetails();
            RafflePrizeDetailsVo detailsVo = details.stream().filter(e -> StringUtils.isNotBlank((CharSequence)e.getPrizeLevel()) && e.getPrizeLevel().equals(prizeLevel)).findFirst().orElse(null);
            if (Objects.isNull(detailsVo)) {
                throw new RuntimeException("\u7cfb\u7edf\u5f02\u5e38,\u8bf7\u7a0d\u540e\u518d\u8bd5!");
            }
            if (PrizeInventoryEnum.EXITS.getCode().equals(detailsVo.getInventory())) {
                detailsVo = this.getRafflePrizeDetailsVo(rafflePrizeVo, detailsVo);
            }
            PrizeEntity prizeEntity = this.prizeService.findByCode(detailsVo.getPrizeCode());
            Validate.notNull((Object)((Object)prizeEntity), (String)"\u672a\u77e5\u5956\u54c1\u4fe1\u606f", (Object[])new Object[0]);
            if (PrizeTypeEnum.THANKS.getCode().equals(prizeEntity.getPrizeType())) {
                RafflePrizeDetailsVo rafflePrizeDetailsVo = detailsVo;
                return rafflePrizeDetailsVo;
            }
            RafflePrizeRecordDto rafflePrizeRecordDto = new RafflePrizeRecordDto();
            rafflePrizeRecordDto.setClaimStatus(ClaimStatusEnum.NO_CLAIM.getCode());
            if (PrizeTypeEnum.INTEGRAL.getCode().equals(detailsVo.getPrizeType())) {
                MemberInfoIntegralRecordVo vo = new MemberInfoIntegralRecordVo();
                vo.setMemberCode(lotteryDto.getMemberCode());
                vo.setSource(IntegralSourceEnum.BIG_TURNTABLE.getValue());
                vo.setType(IntegralSourceEnum.BIG_TURNTABLE.getType());
                vo.setIntegral(Integer.valueOf(detailsVo.getQuantity().intValue()));
                BigDecimal holidayIntegral = this.holidayIntegralAction.getHolidayIntegralByDate(memberCode, detailsVo.getQuantity(), ChannelTypeEnum.RAFFLE.getCode());
                if (!Objects.isNull(holidayIntegral)) {
                    vo.setIntegral(Integer.valueOf(holidayIntegral.intValue()));
                }
                this.memberInfoIntegralRecordService.commonInternal(vo);
                rafflePrizeRecordDto.setClaimStatus(ClaimStatusEnum.CLAIMD.getCode());
            }
            RafflePrizeRecordVo rafflePrizeRecordVo = this.buildPrizeRecord(lotteryDto, level, detailsVo, prizeEntity, rafflePrizeRecordDto);
            detailsVo.setRecordCode(rafflePrizeRecordVo.getCode());
            RafflePrizeDetailsVo rafflePrizeDetailsVo = detailsVo;
            return rafflePrizeDetailsVo;
        }
        finally {
            if (locked) {
                this.redisMutexService.unlock(redisKey);
            }
        }
    }

    private RafflePrizeRecordVo buildPrizeRecord(LotteryDto lotteryDto, String level, RafflePrizeDetailsVo detailsVo, PrizeEntity prizeEntity, RafflePrizeRecordDto rafflePrizeRecordDto) {
        rafflePrizeRecordDto.setActivityCode(lotteryDto.getRaffleActivityCode());
        rafflePrizeRecordDto.setRafflePrizeCode(lotteryDto.getRafflePrizeCode());
        rafflePrizeRecordDto.setRafflePrizeDetailCode(detailsVo.getCode());
        rafflePrizeRecordDto.setMemberCode(lotteryDto.getMemberCode());
        rafflePrizeRecordDto.setEmployStatus(EmployStatusEnum.NO_USE.getCode());
        rafflePrizeRecordDto.setQuantity(detailsVo.getQuantity() == null ? BigDecimal.ZERO : detailsVo.getQuantity());
        rafflePrizeRecordDto.setMemberLevelCode(level);
        rafflePrizeRecordDto.setMemberLevelName("");
        rafflePrizeRecordDto.setPrizeCode(prizeEntity.getCode());
        rafflePrizeRecordDto.setPrizeName(prizeEntity.getPrizeName());
        rafflePrizeRecordDto.setPrizeType(prizeEntity.getPrizeType());
        rafflePrizeRecordDto.setPrizeLevel(detailsVo.getPrizeLevel());
        rafflePrizeRecordDto.setPrizeLevelName(detailsVo.getPrizeLevelName());
        rafflePrizeRecordDto.setUnitPrice(prizeEntity.getUnitPrice());
        rafflePrizeRecordDto.setTotalPrice(ObjectUtil.isNotNull((Object)prizeEntity.getUnitPrice()) ? prizeEntity.getUnitPrice().multiply(detailsVo.getQuantity()) : BigDecimal.ZERO);
        RafflePrizeRecordVo rafflePrizeRecordVo = this.rafflePrizeRecordService.create(rafflePrizeRecordDto);
        return rafflePrizeRecordVo;
    }

    private RafflePrizeDetailsVo getRafflePrizeDetailsVo(RafflePrizeVo rafflePrizeVo, RafflePrizeDetailsVo detailsVo) {
        if (detailsVo.getPutInventoryCopies().compareTo(BigDecimal.ZERO) == 0) {
            detailsVo = this.forwardBySelect(rafflePrizeVo);
        } else {
            int i = this.rafflePrizeDetailsService.reduceInventory(detailsVo.getCode(), new BigDecimal("-1"));
            if (i != 1) {
                detailsVo = this.forwardBySelect(rafflePrizeVo);
            }
        }
        return detailsVo;
    }

    public RafflePrizeDetailsVo forwardBySelect(RafflePrizeVo rafflePrizeVo) {
        List details = rafflePrizeVo.getDetails();
        String prizeOverSelect = rafflePrizeVo.getPrizeOverSelect();
        if (PrizeOverSelectEnum.NONE.getCode().equals(prizeOverSelect)) {
            return details.stream().filter(e -> e.getPrizeType().equals(PrizeTypeEnum.THANKS.getCode())).findFirst().orElse(null);
        }
        if (PrizeOverSelectEnum.NO_INVENTORY.getCode().equals(prizeOverSelect)) {
            return details.stream().filter(e -> e.getPrizeFlag()).findFirst().orElse(null);
        }
        List collect = details.stream().sorted(Comparator.comparing(RafflePrizeDetailsVo::getPrizeLevel, Comparator.reverseOrder())).collect(Collectors.toList());
        for (RafflePrizeDetailsVo detailsVo : collect) {
            if (detailsVo.getPutInventoryCopies().compareTo(BigDecimal.ZERO) == 0) continue;
            return detailsVo;
        }
        return null;
    }

    private void validateIntegral(LotteryDto lotteryDto, RafflePrizeVo rafflePrizeVo) {
        MemberInfoAssetsVo detailByMemberCode = this.memberInfoAssetsService.findDetailByMemberCode(lotteryDto.getMemberCode());
        Integer currentIntegral = detailByMemberCode.getCurrentIntegral();
        if (lotteryDto.getIntegral() > currentIntegral) {
            throw new RuntimeException("\u79ef\u5206\u4f59\u989d\u4e0d\u8db3");
        }
        RewardActivityUserCountEntity countEntity = (RewardActivityUserCountEntity)((Object)((LambdaQueryChainWrapper)this.rewardActivityUserCountRepository.lambdaQuery().eq(RewardActivityUserCountEntity::getMemberCode, (Object)lotteryDto.getMemberCode())).one());
        if (rafflePrizeVo.getOneRaffleNum() + rafflePrizeVo.getTwoRaffleNum() <= countEntity.getUseTimes()) {
            throw new RuntimeException("\u62bd\u5956\u6b21\u6570\u5df2\u7ecf\u6d88\u8017\u5b8c\u4e86");
        }
    }
}

