/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.member.business.member.local.service.internal;

import cn.hutool.core.collection.CollUtil;
import com.biz.crm.member.business.member.local.service.DummyOrderService;
import com.biz.crm.member.business.member.local.service.DummyOrderUserService;
import com.biz.crm.member.business.member.local.service.RafflePrizeRecordService;
import com.biz.crm.member.business.member.local.service.RealOrderService;
import com.biz.crm.member.business.member.local.service.RewardInfoService;
import com.biz.crm.member.business.member.sdk.dto.RewardInfoDto;
import com.biz.crm.member.business.member.sdk.dto.RewardUserDto;
import com.biz.crm.member.business.member.sdk.enums.ClaimStatusEnum;
import com.biz.crm.member.business.member.sdk.enums.OrderSourceEnum;
import com.biz.crm.member.business.member.sdk.enums.PrizeTypeEnum;
import com.biz.crm.member.business.member.sdk.vo.DummyOrderUserVo;
import com.biz.crm.member.business.member.sdk.vo.DummyOrderVo;
import com.biz.crm.member.business.member.sdk.vo.RafflePrizeRecordVo;
import com.biz.crm.member.business.member.sdk.vo.RealOrderVo;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RewardInfoServiceImpl
implements RewardInfoService {
    @Autowired
    private RafflePrizeRecordService rafflePrizeRecordService;
    @Autowired
    private DummyOrderService dummyOrderService;
    @Autowired
    private RealOrderService realOrderService;
    @Autowired
    private DummyOrderUserService dummyOrderUserService;

    @Override
    @Transactional
    public void claim(RewardInfoDto rewardInfoDto) {
        Validate.notNull((Object)rewardInfoDto, (String)"\u9886\u53d6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)rewardInfoDto.getMemberCode(), (String)"\u4f1a\u5458\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)rewardInfoDto.getRecordCode(), (String)"\u4e2d\u5956\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        RafflePrizeRecordVo rafflePrizeRecordVo = this.rafflePrizeRecordService.findDetailById(null, rewardInfoDto.getRecordCode());
        Date now = new Date();
        if (PrizeTypeEnum.REAL.getCode().equals(rafflePrizeRecordVo.getPrizeType())) {
            Validate.notBlank((CharSequence)rewardInfoDto.getReceiptName(), (String)"\u6536\u8d27\u4eba\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)rewardInfoDto.getReceiptAddress(), (String)"\u6536\u8d27\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)rewardInfoDto.getReceiptPhone(), (String)"\u6536\u83b7\u4eba\u624b\u673a\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            RealOrderVo realOrderVo = new RealOrderVo();
            realOrderVo.setOrderSource(OrderSourceEnum.INTERACT_ACTIVITY.getValue());
            realOrderVo.setOrderTime(now);
            realOrderVo.setProductCode(rafflePrizeRecordVo.getPrizeCode());
            realOrderVo.setProductName(rafflePrizeRecordVo.getPrizeName());
            realOrderVo.setRelationCode(rewardInfoDto.getRecordCode());
            this.realOrderService.create(realOrderVo);
        } else {
            List users = rewardInfoDto.getUsers();
            if (CollUtil.isEmpty((Collection)users)) {
                throw new RuntimeException("\u865a\u62df\u7269\u54c1\uff0c\u9886\u53d6\u65f6\u8bf7\u5f55\u5165\u4eba\u5458");
            }
            DummyOrderVo dummyOrderVo = new DummyOrderVo();
            dummyOrderVo.setOrderSource(OrderSourceEnum.INTERACT_ACTIVITY.getValue());
            dummyOrderVo.setOrderTime(now);
            dummyOrderVo.setProductCode(rafflePrizeRecordVo.getPrizeCode());
            dummyOrderVo.setProductName(rafflePrizeRecordVo.getPrizeName());
            dummyOrderVo.setRelationCode(rewardInfoDto.getRecordCode());
            DummyOrderVo orderVo = this.dummyOrderService.create(dummyOrderVo);
            for (RewardUserDto user : users) {
                Validate.notBlank((CharSequence)user.getName(), (String)"\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                Validate.notBlank((CharSequence)user.getPhone(), (String)"\u624b\u673a\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                DummyOrderUserVo userVo = new DummyOrderUserVo();
                userVo.setName(user.getName());
                userVo.setPhone(user.getPhone());
                userVo.setOrderCode(orderVo.getOrderCode());
                this.dummyOrderUserService.create(userVo);
            }
        }
        this.rafflePrizeRecordService.updateClaimStatus(rafflePrizeRecordVo.getCode(), ClaimStatusEnum.CLAIMD.getCode());
    }
}

