/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.member.business.member.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.member.business.member.local.entity.ScenicAreaManagement;
import com.biz.crm.member.business.member.local.entity.ScenicImageManagement;
import com.biz.crm.member.business.member.local.repository.ScenicAreaManagementRepository;
import com.biz.crm.member.business.member.local.service.ScenicAreaManagementService;
import com.biz.crm.member.business.member.local.service.ScenicImageManagementService;
import com.biz.crm.member.business.member.sdk.dto.ScenicAreaManagementPaginationDto;
import com.biz.crm.member.business.member.sdk.vo.ScenicAreaManagementVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="scenicAreaManagementServiceImpl")
public class ScenicAreaManagementServiceImpl
implements ScenicAreaManagementService {
    private static final Logger log = LoggerFactory.getLogger(ScenicAreaManagementServiceImpl.class);
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired
    private ScenicImageManagementService scenicImageManagementService;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private ScenicAreaManagementRepository scenicAreaManagementRepository;

    @Override
    public Page<ScenicAreaManagementVo> findByConditions(Pageable pageable, ScenicAreaManagementPaginationDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        dto = Optional.ofNullable(dto).orElse(new ScenicAreaManagementPaginationDto());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.scenicAreaManagementRepository.findByConditions((Page<ScenicAreaManagementVo>)page, dto);
    }

    @Override
    @Transactional
    public ScenicAreaManagementVo create(ScenicAreaManagementVo scenicAreaManagementVo) {
        this.createValidation(scenicAreaManagementVo);
        ScenicAreaManagement scenicAreaManagement = (ScenicAreaManagement)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)scenicAreaManagementVo, ScenicAreaManagement.class, HashSet.class, LinkedList.class, new String[0]));
        scenicAreaManagement.setId(null);
        scenicAreaManagement.setTenantCode(TenantUtils.getTenantCode());
        scenicAreaManagement.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        scenicAreaManagement.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        scenicAreaManagement.setCode((String)this.generateCodeService.generateCode("JQ", 5).get(0));
        log.info("========================\u300b\u300b\u300b\u300b\u300b{}", (Object)scenicAreaManagement);
        log.info("<<<<<<========================");
        this.scenicAreaManagementRepository.saveOrUpdate((Object)scenicAreaManagement);
        String scenicId = scenicAreaManagement.getId();
        if (StringUtils.isNotEmpty((CharSequence)scenicAreaManagementVo.getScenicIcon())) {
            this.setImage(scenicId, "scenicIcon", scenicAreaManagementVo.getScenicIcon());
        }
        if (StringUtils.isNotEmpty((CharSequence)scenicAreaManagementVo.getAnchorIcon())) {
            this.setImage(scenicId, "anchorIcon", scenicAreaManagementVo.getAnchorIcon());
        }
        if (StringUtils.isNotEmpty((CharSequence)scenicAreaManagementVo.getBackgroundPicture())) {
            this.setImage(scenicId, "backgroundPicture", scenicAreaManagementVo.getBackgroundPicture());
        }
        return scenicAreaManagementVo;
    }

    @Override
    public ScenicAreaManagementVo findDetailById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        ScenicAreaManagement scenicAreaManagement = this.scenicAreaManagementRepository.findById(id);
        Validate.notNull((Object)((Object)scenicAreaManagement), (String)"\u666f\u533a\u672a\u627e\u5230", (Object[])new Object[0]);
        ScenicAreaManagementVo scenicAreaManagementVo = (ScenicAreaManagementVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)scenicAreaManagement, ScenicAreaManagementVo.class, HashSet.class, LinkedList.class, new String[0]);
        scenicAreaManagementVo.setScenicIcon(this.getImage(id, "scenicIcon").getUrl());
        scenicAreaManagementVo.setBackgroundPicture(this.getImage(id, "backgroundPicture").getUrl());
        scenicAreaManagementVo.setAnchorIcon(this.getImage(id, "anchorIcon").getUrl());
        return scenicAreaManagementVo;
    }

    @Override
    @Transactional
    public ScenicAreaManagementVo update(ScenicAreaManagementVo scenicAreaManagementVo) {
        this.updateValidation(scenicAreaManagementVo);
        String currentId = scenicAreaManagementVo.getId();
        ScenicAreaManagement current = this.scenicAreaManagementRepository.findById(currentId);
        current = (ScenicAreaManagement)((Object)Validate.notNull((Object)((Object)current), (String)"\u4fee\u6539\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]));
        current = (ScenicAreaManagement)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)scenicAreaManagementVo, ScenicAreaManagement.class, HashSet.class, LinkedList.class, new String[0]));
        this.scenicAreaManagementRepository.saveOrUpdate((Object)current);
        if (StringUtils.isNotEmpty((CharSequence)scenicAreaManagementVo.getScenicIcon())) {
            this.removeImageByScenicIdAndType(scenicAreaManagementVo.getId(), "scenicIcon");
            this.setImage(scenicAreaManagementVo.getId(), "scenicIcon", scenicAreaManagementVo.getScenicIcon());
        }
        if (StringUtils.isNotEmpty((CharSequence)scenicAreaManagementVo.getAnchorIcon())) {
            this.removeImageByScenicIdAndType(scenicAreaManagementVo.getId(), "anchorIcon");
            this.setImage(scenicAreaManagementVo.getId(), "anchorIcon", scenicAreaManagementVo.getAnchorIcon());
        }
        if (StringUtils.isNotEmpty((CharSequence)scenicAreaManagementVo.getBackgroundPicture())) {
            this.removeImageByScenicIdAndType(scenicAreaManagementVo.getId(), "backgroundPicture");
            this.setImage(scenicAreaManagementVo.getId(), "backgroundPicture", scenicAreaManagementVo.getBackgroundPicture());
        }
        return scenicAreaManagementVo;
    }

    @Override
    @Transactional
    public void enableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.scenicAreaManagementRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
    }

    @Override
    @Transactional
    public void disableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.scenicAreaManagementRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
    }

    @Override
    @Transactional
    public void updateDelFlagByIds(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.scenicAreaManagementRepository.updateDelFlagByIds(ids);
    }

    private void setImage(String scenicId, String type, String url) {
        ScenicImageManagement scenicImageManagement = new ScenicImageManagement();
        scenicImageManagement.setScenicAreaId(scenicId);
        scenicImageManagement.setId(null);
        scenicImageManagement.setType(type);
        scenicImageManagement.setUrl(url);
        scenicImageManagement.setTenantCode(TenantUtils.getTenantCode());
        this.scenicImageManagementService.save(scenicImageManagement);
    }

    private void removeImageByScenicIdAndType(String scenicId, String type) {
        ScenicImageManagement scenicImageManagement = new ScenicImageManagement();
        scenicImageManagement.setScenicAreaId(scenicId);
        scenicImageManagement.setType(type);
        this.scenicImageManagementService.removeImageByScenicIdAndType(scenicImageManagement);
    }

    private ScenicImageManagement getImage(String scenicId, String type) {
        ScenicImageManagement scenicImageManagement = new ScenicImageManagement();
        scenicImageManagement.setScenicAreaId(scenicId);
        scenicImageManagement.setType(type);
        List<ScenicImageManagement> list = this.scenicImageManagementService.selectByScenicAreaIdAndType(scenicImageManagement);
        Iterator<ScenicImageManagement> iterator = list.iterator();
        if (iterator.hasNext()) {
            ScenicImageManagement imageManagement = iterator.next();
            return imageManagement;
        }
        return null;
    }

    private void createValidation(ScenicAreaManagementVo scenicAreaManagementVo) {
        this.validation(scenicAreaManagementVo);
    }

    private void updateValidation(ScenicAreaManagementVo scenicAreaManagementVo) {
        this.validation(scenicAreaManagementVo);
    }

    private void validation(ScenicAreaManagementVo scenicAreaManagementVo) {
        Validate.notBlank((CharSequence)scenicAreaManagementVo.getName(), (String)"\u666f\u533a\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)scenicAreaManagementVo.getScenicIcon(), (String)"\u666f\u533aicon\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)scenicAreaManagementVo.getAnchorIcon(), (String)"\u951a\u70b9icon\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }
}

