/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.member.business.member.local.service.internal;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.member.business.member.local.entity.ScenicImageManagement;
import com.biz.crm.member.business.member.local.entity.ScenicSpotsManagement;
import com.biz.crm.member.business.member.local.repository.ScenicSpotsManagementRepository;
import com.biz.crm.member.business.member.local.service.ScenicImageManagementService;
import com.biz.crm.member.business.member.local.service.ScenicSpotsManagementService;
import com.biz.crm.member.business.member.sdk.vo.ScenicSpotsManagementVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="scenicSpotsManagementServiceImpl")
public class ScenicSpotsManagementServiceImpl
implements ScenicSpotsManagementService {
    private static final Logger log = LoggerFactory.getLogger(ScenicSpotsManagementServiceImpl.class);
    @Autowired
    private ScenicSpotsManagementRepository scenicSpotsManagementRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private ScenicImageManagementService scenicImageManagementService;
    @Autowired
    private GenerateCodeService generateCodeService;

    @Override
    public List<ScenicSpotsManagementVo> findByScenicId(String id) {
        List list = ((LambdaQueryChainWrapper)this.scenicSpotsManagementRepository.lambdaQuery().eq(ScenicSpotsManagement::getScenicAreaId, (Object)id)).list();
        ArrayList<ScenicSpotsManagementVo> result = new ArrayList<ScenicSpotsManagementVo>();
        for (ScenicSpotsManagement scenicSpotsManagement : list) {
            ScenicSpotsManagementVo scenicSpotsManagementVo = (ScenicSpotsManagementVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)scenicSpotsManagement, ScenicSpotsManagementVo.class, HashSet.class, LinkedList.class, new String[0]);
            scenicSpotsManagementVo.setScenicPicture(this.getImage(id, "scenicPicture").getUrl());
            scenicSpotsManagementVo.setScenicVRPicture(this.getImage(id, "scenicVRPicture").getUrl());
            scenicSpotsManagementVo.setScenicVRVideo(this.getImage(id, "scenicVRVideo").getUrl());
            scenicSpotsManagementVo.setThumbnailPicture(this.getImage(id, "thumbnailPicture").getUrl());
            result.add(scenicSpotsManagementVo);
        }
        return result;
    }

    @Override
    @Transactional
    public ScenicSpotsManagementVo create(ScenicSpotsManagementVo scenicSpotsManagementVo) {
        this.createValidation(scenicSpotsManagementVo);
        ScenicSpotsManagement spotsManagement = (ScenicSpotsManagement)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)scenicSpotsManagementVo, ScenicSpotsManagement.class, HashSet.class, LinkedList.class, new String[0]));
        spotsManagement.setId(null);
        spotsManagement.setTenantCode(TenantUtils.getTenantCode());
        spotsManagement.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        spotsManagement.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        spotsManagement.setCode((String)this.generateCodeService.generateCode("JD", 5).get(0));
        this.scenicSpotsManagementRepository.saveOrUpdate((Object)spotsManagement);
        String scenicId = spotsManagement.getScenicAreaId();
        if (StringUtils.isNotEmpty((CharSequence)scenicSpotsManagementVo.getScenicPicture())) {
            this.setImage(scenicId, "scenicPicture", scenicSpotsManagementVo.getScenicPicture());
        }
        if (StringUtils.isNotEmpty((CharSequence)scenicSpotsManagementVo.getThumbnailPicture())) {
            this.setImage(scenicId, "thumbnailPicture", scenicSpotsManagementVo.getThumbnailPicture());
        }
        if (StringUtils.isNotEmpty((CharSequence)scenicSpotsManagementVo.getScenicVRPicture())) {
            this.setImage(scenicId, "scenicVRPicture", scenicSpotsManagementVo.getScenicVRPicture());
        }
        if (StringUtils.isNotEmpty((CharSequence)scenicSpotsManagementVo.getScenicVRVideo())) {
            this.setImage(scenicId, "scenicVRVideo", scenicSpotsManagementVo.getScenicVRVideo());
        }
        return scenicSpotsManagementVo;
    }

    @Override
    @Transactional
    public ScenicSpotsManagementVo update(ScenicSpotsManagementVo scenicSpotsManagementVo) {
        this.updateValidation(scenicSpotsManagementVo);
        String currentId = scenicSpotsManagementVo.getId();
        String scenicId = scenicSpotsManagementVo.getScenicAreaId();
        ScenicSpotsManagement current = this.scenicSpotsManagementRepository.findById(currentId);
        current = (ScenicSpotsManagement)((Object)Validate.notNull((Object)((Object)current), (String)"\u4fee\u6539\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]));
        current = (ScenicSpotsManagement)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)scenicSpotsManagementVo, ScenicSpotsManagement.class, HashSet.class, LinkedList.class, new String[0]));
        this.scenicSpotsManagementRepository.saveOrUpdate((Object)current);
        if (StringUtils.isNotEmpty((CharSequence)scenicSpotsManagementVo.getScenicPicture())) {
            this.removeImageByScenicIdAndType(scenicId, "scenicPicture");
            this.setImage(scenicId, "scenicPicture", scenicSpotsManagementVo.getScenicPicture());
        }
        if (StringUtils.isNotEmpty((CharSequence)scenicSpotsManagementVo.getThumbnailPicture())) {
            this.removeImageByScenicIdAndType(scenicId, "thumbnailPicture");
            this.setImage(scenicId, "thumbnailPicture", scenicSpotsManagementVo.getThumbnailPicture());
        }
        if (StringUtils.isNotEmpty((CharSequence)scenicSpotsManagementVo.getScenicVRPicture())) {
            this.removeImageByScenicIdAndType(scenicId, "scenicVRPicture");
            this.setImage(scenicId, "scenicVRPicture", scenicSpotsManagementVo.getScenicVRPicture());
        }
        if (StringUtils.isNotEmpty((CharSequence)scenicSpotsManagementVo.getScenicVRVideo())) {
            this.removeImageByScenicIdAndType(scenicId, "scenicVRVideo");
            this.setImage(scenicId, "scenicVRVideo", scenicSpotsManagementVo.getScenicVRVideo());
        }
        return scenicSpotsManagementVo;
    }

    private void setImage(String scenicId, String type, String url) {
        ScenicImageManagement scenicImageManagement = new ScenicImageManagement();
        scenicImageManagement.setScenicAreaId(scenicId);
        scenicImageManagement.setId(null);
        scenicImageManagement.setType(type);
        scenicImageManagement.setUrl(url);
        scenicImageManagement.setTenantCode(TenantUtils.getTenantCode());
        this.scenicImageManagementService.save(scenicImageManagement);
    }

    private void removeImageByScenicIdAndType(String scenicId, String type) {
        ScenicImageManagement scenicImageManagement = new ScenicImageManagement();
        scenicImageManagement.setScenicAreaId(scenicId);
        scenicImageManagement.setType(type);
        this.scenicImageManagementService.removeImageByScenicIdAndType(scenicImageManagement);
    }

    private ScenicImageManagement getImage(String scenicId, String type) {
        ScenicImageManagement scenicImageManagement = new ScenicImageManagement();
        scenicImageManagement.setScenicAreaId(scenicId);
        scenicImageManagement.setType(type);
        List<ScenicImageManagement> list = this.scenicImageManagementService.selectByScenicAreaIdAndType(scenicImageManagement);
        Iterator<ScenicImageManagement> iterator = list.iterator();
        if (iterator.hasNext()) {
            ScenicImageManagement imageManagement = iterator.next();
            return imageManagement;
        }
        return null;
    }

    private void createValidation(ScenicSpotsManagementVo scenicSpotsManagementVo) {
        this.validation(scenicSpotsManagementVo);
    }

    private void updateValidation(ScenicSpotsManagementVo scenicSpotsManagementVo) {
        this.validation(scenicSpotsManagementVo);
    }

    private void validation(ScenicSpotsManagementVo scenicSpotsManagementVo) {
        Validate.notBlank((CharSequence)scenicSpotsManagementVo.getName(), (String)"\u666f\u70b9\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }
}

