/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.member.business.member.local.service.internal;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.member.business.member.local.entity.SignInRuleDetail;
import com.biz.crm.member.business.member.local.repository.SignInRuleDetailRepository;
import com.biz.crm.member.business.member.local.service.SignInRuleDetailService;
import com.biz.crm.member.business.member.sdk.dto.SignInRuleDetailPaginationDto;
import com.biz.crm.member.business.member.sdk.vo.SignInRuleDetailVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="signInRuleDetailService")
public class SignInRuleDetailServiceImpl
implements SignInRuleDetailService {
    private static final Logger log = LoggerFactory.getLogger(SignInRuleDetailServiceImpl.class);
    @Autowired(required=false)
    private SignInRuleDetailRepository signInRuleDetailRepository;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public Page<SignInRuleDetailVo> findByConditions(Pageable pageable, SignInRuleDetailPaginationDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        dto = Optional.ofNullable(dto).orElse(new SignInRuleDetailPaginationDto());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.signInRuleDetailRepository.findByConditions((Page<SignInRuleDetailVo>)page, dto);
    }

    @Override
    public SignInRuleDetailVo findDetailById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        SignInRuleDetail signInRuleDetail = this.signInRuleDetailRepository.findById(id);
        SignInRuleDetailVo signInRuleDetailVo = (SignInRuleDetailVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)signInRuleDetail, SignInRuleDetailVo.class, HashSet.class, LinkedList.class, new String[0]);
        return signInRuleDetailVo;
    }

    @Override
    @Transactional
    public SignInRuleDetailVo create(SignInRuleDetailVo signInRuleDetailVo) {
        this.createValidation(signInRuleDetailVo);
        SignInRuleDetail signInRuleDetail = (SignInRuleDetail)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)signInRuleDetailVo, SignInRuleDetail.class, HashSet.class, LinkedList.class, new String[0]));
        String tenantCode = TenantUtils.getTenantCode();
        Validate.notBlank((CharSequence)tenantCode, (String)"tenantCode\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        signInRuleDetail.setTenantCode(tenantCode);
        signInRuleDetail.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        signInRuleDetail.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        this.signInRuleDetailRepository.saveOrUpdate((Object)signInRuleDetail);
        return signInRuleDetailVo;
    }

    @Override
    @Transactional
    public SignInRuleDetailVo update(SignInRuleDetailVo signInRuleDetailVo) {
        this.updateValidation(signInRuleDetailVo);
        String currentId = signInRuleDetailVo.getId();
        SignInRuleDetail current = this.signInRuleDetailRepository.findById(currentId);
        current = (SignInRuleDetail)((Object)Validate.notNull((Object)((Object)current), (String)"\u4fee\u6539\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]));
        current = (SignInRuleDetail)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)signInRuleDetailVo, SignInRuleDetail.class, HashSet.class, LinkedList.class, new String[0]));
        this.signInRuleDetailRepository.saveOrUpdate((Object)current);
        return signInRuleDetailVo;
    }

    @Override
    @Transactional
    public void enableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.signInRuleDetailRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
    }

    @Override
    @Transactional
    public void disableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.signInRuleDetailRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
    }

    @Override
    @Transactional
    public void updateDelFlagByIds(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.signInRuleDetailRepository.updateDelFlagByIds(ids);
    }

    @Override
    public void batchSaveOrUpdate(List<SignInRuleDetailVo> list) {
        List oldList = ((LambdaQueryChainWrapper)this.signInRuleDetailRepository.lambdaQuery().eq(SignInRuleDetail::getSignInId, (Object)list.get(0).getSignInId())).list();
        if (CollectionUtils.isNotEmpty((Collection)oldList)) {
            Set ids = oldList.stream().map(UuidEntity::getId).collect(Collectors.toSet());
            this.signInRuleDetailRepository.removeByIds(ids);
        }
        for (SignInRuleDetailVo signInRuleDetailVo : list) {
            this.create(signInRuleDetailVo);
        }
    }

    @Override
    public List<SignInRuleDetailVo> findListDetailById(String id) {
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.signInRuleDetailRepository.lambdaQuery().eq(SignInRuleDetail::getSignInId, (Object)id)).orderByAsc(SignInRuleDetail::getSeq)).list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Lists.newArrayList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)list, SignInRuleDetail.class, SignInRuleDetailVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    private void createValidation(SignInRuleDetailVo signInRuleDetailVo) {
        this.validation(signInRuleDetailVo);
    }

    private void updateValidation(SignInRuleDetailVo signInRuleDetailVo) {
        this.validation(signInRuleDetailVo);
    }

    private void validation(SignInRuleDetailVo signInRuleDetailVo) {
        Validate.notBlank((CharSequence)signInRuleDetailVo.getSignInId(), (String)"\u7b7e\u5230\u89c4\u5219ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)signInRuleDetailVo.getLinkDayNum(), (String)"\u672c\u6708\u8fde\u7eed\u7b7e\u5230X\u5929\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)signInRuleDetailVo.getLinkIntegralNum(), (String)"\u53ef\u989d\u5916\u83b7\u5f97x\u79ef\u5206", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)signInRuleDetailVo.getIconImage(), (String)"\u56fe\u6807\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }
}

