/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.member.business.member.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.member.business.member.local.entity.SignInRule;
import com.biz.crm.member.business.member.local.repository.SignInRuleRepository;
import com.biz.crm.member.business.member.local.service.SignInRuleDetailService;
import com.biz.crm.member.business.member.local.service.SignInRuleService;
import com.biz.crm.member.business.member.sdk.dto.SignInRulePaginationDto;
import com.biz.crm.member.business.member.sdk.vo.SignInRuleDetailVo;
import com.biz.crm.member.business.member.sdk.vo.SignInRuleVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="signInRuleService")
public class SignInRuleServiceImpl
implements SignInRuleService {
    private static final Logger log = LoggerFactory.getLogger(SignInRuleServiceImpl.class);
    @Autowired(required=false)
    private SignInRuleRepository signInRuleRepository;
    @Autowired
    private SignInRuleDetailService signInRuleDetailService;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public Page<SignInRuleVo> findByConditions(Pageable pageable, SignInRulePaginationDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        dto = Optional.ofNullable(dto).orElse(new SignInRulePaginationDto());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.signInRuleRepository.findByConditions((Page<SignInRuleVo>)page, dto);
    }

    @Override
    public SignInRuleVo findDetailById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        SignInRule signInRule = this.signInRuleRepository.findById(id);
        SignInRuleVo signInRuleVo = (SignInRuleVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)signInRule, SignInRuleVo.class, HashSet.class, LinkedList.class, new String[0]);
        List<SignInRuleDetailVo> list = this.signInRuleDetailService.findListDetailById(signInRule.getId());
        signInRuleVo.setList(list);
        return signInRuleVo;
    }

    @Override
    @Transactional
    public SignInRuleVo create(SignInRuleVo signInRuleVo) {
        this.createValidation(signInRuleVo);
        SignInRule signInRule = (SignInRule)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)signInRuleVo, SignInRule.class, HashSet.class, LinkedList.class, new String[0]));
        signInRule.setTenantCode(TenantUtils.getTenantCode());
        signInRule.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        signInRule.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        this.signInRuleRepository.saveOrUpdate((Object)signInRule);
        if (CollectionUtils.isNotEmpty((Collection)signInRuleVo.getList())) {
            int seq = 1;
            for (SignInRuleDetailVo signInRuleDetailVo : signInRuleVo.getList()) {
                signInRuleDetailVo.setId(null);
                signInRuleDetailVo.setSignInId(signInRule.getId());
                signInRuleDetailVo.setSeq(Integer.valueOf(seq++));
            }
            this.signInRuleDetailService.batchSaveOrUpdate(signInRuleVo.getList());
        }
        return signInRuleVo;
    }

    @Override
    @Transactional
    public SignInRuleVo update(SignInRuleVo signInRuleVo) {
        this.updateValidation(signInRuleVo);
        String currentId = signInRuleVo.getId();
        if (StringUtils.isNotBlank((CharSequence)currentId)) {
            SignInRule current = this.signInRuleRepository.findById(currentId);
            current = (SignInRule)((Object)Validate.notNull((Object)((Object)current), (String)"\u4fee\u6539\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]));
            current = (SignInRule)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)signInRuleVo, SignInRule.class, HashSet.class, LinkedList.class, new String[0]));
            this.signInRuleRepository.saveOrUpdate((Object)current);
            if (CollectionUtils.isNotEmpty((Collection)signInRuleVo.getList())) {
                int seq = 1;
                for (SignInRuleDetailVo signInRuleDetailVo : signInRuleVo.getList()) {
                    signInRuleDetailVo.setId(null);
                    signInRuleDetailVo.setSignInId(current.getId());
                    signInRuleDetailVo.setSeq(Integer.valueOf(seq++));
                }
                this.signInRuleDetailService.batchSaveOrUpdate(signInRuleVo.getList());
            }
        } else {
            this.create(signInRuleVo);
        }
        return signInRuleVo;
    }

    @Override
    @Transactional
    public void enableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.signInRuleRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
    }

    @Override
    @Transactional
    public void disableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.signInRuleRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
    }

    @Override
    @Transactional
    public void updateDelFlagByIds(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.signInRuleRepository.updateDelFlagByIds(ids);
    }

    @Override
    public SignInRuleVo findDetail() {
        List list = this.signInRuleRepository.list();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            SignInRuleVo signInRuleVo = (SignInRuleVo)this.nebulaToolkitService.copyObjectByWhiteList(list.get(0), SignInRuleVo.class, HashSet.class, LinkedList.class, new String[0]);
            List<SignInRuleDetailVo> signInRuleDetailVos = this.signInRuleDetailService.findListDetailById(signInRuleVo.getId());
            signInRuleVo.setList(signInRuleDetailVos);
            return signInRuleVo;
        }
        return new SignInRuleVo();
    }

    private void createValidation(SignInRuleVo signInRuleVo) {
        this.validation(signInRuleVo);
    }

    private void updateValidation(SignInRuleVo signInRuleVo) {
        this.validation(signInRuleVo);
    }

    private void validation(SignInRuleVo signInRuleVo) {
        Validate.notNull((Object)signInRuleVo.getEveryIntegral(), (String)"\u6bcf\u6b21\u53ef\u83b7\u5f97x\u79ef\u5206\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)signInRuleVo.getYearIntegralLimit(), (String)"\u6bcf\u6b21\u53ef\u83b7\u5f97x\u79ef\u5206\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }
}

