/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.member.business.member.local.service.internal;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.member.business.member.local.entity.SystemSettings;
import com.biz.crm.member.business.member.local.entity.SystemSettingsDetail;
import com.biz.crm.member.business.member.local.repository.SystemSettingsDetailRepository;
import com.biz.crm.member.business.member.local.repository.SystemSettingsRepository;
import com.biz.crm.member.business.member.local.service.SystemSettingsService;
import com.biz.crm.member.business.member.sdk.enums.SystemSettingsDetailEnum;
import com.biz.crm.member.business.member.sdk.enums.SystemSettingsTypeEnum;
import com.biz.crm.member.business.member.sdk.vo.SystemSettingsDetailVo;
import com.biz.crm.member.business.member.sdk.vo.SystemSettingsReservedVo;
import com.biz.crm.member.business.member.sdk.vo.SystemSettingsVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="systemSettingsServiceImpl")
public class SystemSettingsServiceImpl
implements SystemSettingsService {
    private static final Logger log = LoggerFactory.getLogger(SystemSettingsServiceImpl.class);
    @Autowired
    private SystemSettingsRepository systemSettingsRepository;
    @Autowired
    private SystemSettingsDetailRepository systemSettingsDetailRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private GenerateCodeService generateCodeService;

    @Override
    public List<SystemSettingsVo> findAll() {
        List listTitleInit = this.systemSettingsRepository.list();
        List<String> listType = listTitleInit.stream().map(SystemSettings::getType).collect(Collectors.toList());
        this.attributePaddingTitle(listType);
        List list = this.systemSettingsRepository.list();
        ArrayList<SystemSettingsVo> resultList = new ArrayList<SystemSettingsVo>();
        for (SystemSettings systemSettings : list) {
            String type = systemSettings.getType();
            SystemSettingsVo systemSettingsVo = (SystemSettingsVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)systemSettings, SystemSettingsVo.class, HashSet.class, LinkedList.class, new String[0]);
            List listDetail = ((LambdaQueryChainWrapper)this.systemSettingsDetailRepository.lambdaQuery().eq(SystemSettingsDetail::getType, (Object)type)).list();
            ArrayList<SystemSettingsDetailVo> resultDetailList = new ArrayList<SystemSettingsDetailVo>();
            for (SystemSettingsDetail systemSettingsDetail : listDetail) {
                SystemSettingsDetailVo systemSettingsDetailVo = (SystemSettingsDetailVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)systemSettingsDetail, SystemSettingsDetailVo.class, HashSet.class, LinkedList.class, new String[0]);
                if (systemSettingsDetailVo.getTypeKey().equals(SystemSettingsDetailEnum.CONTINUOUS_X_LEVEL_MEMBER.getValue())) continue;
                resultDetailList.add(systemSettingsDetailVo);
            }
            systemSettingsVo.setDetails(resultDetailList);
            resultList.add(systemSettingsVo);
        }
        return resultList;
    }

    @Override
    public List<SystemSettingsReservedVo> findReserved() {
        ArrayList<SystemSettingsReservedVo> reservedVos = new ArrayList<SystemSettingsReservedVo>();
        List list = ((LambdaQueryChainWrapper)this.systemSettingsDetailRepository.lambdaQuery().eq(SystemSettingsDetail::getType, (Object)SystemSettingsTypeEnum.BENEFITS_CLASSIFICATION_SETTING.getValue())).list();
        for (SystemSettingsDetail systemSettingsDetail : list) {
            SystemSettingsReservedVo systemSettingsReservedVo = (SystemSettingsReservedVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)systemSettingsDetail, SystemSettingsReservedVo.class, HashSet.class, LinkedList.class, new String[0]);
            reservedVos.add(systemSettingsReservedVo);
        }
        return reservedVos;
    }

    private void attributePaddingTitle(List<String> list) {
        if (!list.contains(SystemSettingsTypeEnum.VALIDITY_PERIOD_OF_POINTS_SETTING.getValue())) {
            this.doAttributePaddingTitle(SystemSettingsTypeEnum.VALIDITY_PERIOD_OF_POINTS_SETTING.getValue());
            this.doAttributePaddingField(SystemSettingsTypeEnum.VALIDITY_PERIOD_OF_POINTS_SETTING.getValue(), SystemSettingsDetailEnum.VALIDITY_PERIOD_OF_POINTS.getValue(), "12", "");
        }
        if (!list.contains(SystemSettingsTypeEnum.BENEFITS_CLASSIFICATION_SETTING.getValue())) {
            this.doAttributePaddingTitle(SystemSettingsTypeEnum.BENEFITS_CLASSIFICATION_SETTING.getValue());
            this.doAttributePaddingFieldReserved(SystemSettingsTypeEnum.BENEFITS_CLASSIFICATION_SETTING.getValue(), SystemSettingsDetailEnum.CONTINUOUS_X_LEVEL_MEMBER.getValue(), "A");
            this.doAttributePaddingFieldReserved(SystemSettingsTypeEnum.BENEFITS_CLASSIFICATION_SETTING.getValue(), SystemSettingsDetailEnum.BIRTHDAY_BENEFITS.getValue(), "B");
            this.doAttributePaddingFieldReserved(SystemSettingsTypeEnum.BENEFITS_CLASSIFICATION_SETTING.getValue(), SystemSettingsDetailEnum.TASTING_SEND_WINE.getValue(), "C");
            this.doAttributePaddingFieldReserved(SystemSettingsTypeEnum.BENEFITS_CLASSIFICATION_SETTING.getValue(), SystemSettingsDetailEnum.ECOLOGICAL_TOUR.getValue(), "D");
        }
        if (!list.contains(SystemSettingsTypeEnum.APPRECIATION_ADVISOR_CARD.getValue())) {
            this.doAttributePaddingTitle(SystemSettingsTypeEnum.APPRECIATION_ADVISOR_CARD.getValue());
            this.doAttributePaddingField(SystemSettingsTypeEnum.APPRECIATION_ADVISOR_CARD.getValue(), SystemSettingsDetailEnum.CARD_IMAGE.getValue(), "", "");
        }
        if (!list.contains(SystemSettingsTypeEnum.MEMBERSHIP_FISSION.getValue())) {
            this.doAttributePaddingTitle(SystemSettingsTypeEnum.MEMBERSHIP_FISSION.getValue());
            this.doAttributePaddingField(SystemSettingsTypeEnum.MEMBERSHIP_FISSION.getValue(), SystemSettingsDetailEnum.MEMBERSHIP_CARD.getValue(), "\u5f00\u542f", "");
            this.doAttributePaddingField(SystemSettingsTypeEnum.MEMBERSHIP_FISSION.getValue(), SystemSettingsDetailEnum.INVITATION_POINTS_RATIO.getValue(), "10%", "");
        }
        if (!list.contains(SystemSettingsTypeEnum.GROUP_BUYING_CONFIG.getValue())) {
            this.doAttributePaddingTitle(SystemSettingsTypeEnum.GROUP_BUYING_CONFIG.getValue());
            this.doAttributePaddingField(SystemSettingsTypeEnum.GROUP_BUYING_CONFIG.getValue(), SystemSettingsDetailEnum.MEMBERSHIP_THRESHOLD.getValue(), "300", "");
            this.doAttributePaddingField(SystemSettingsTypeEnum.GROUP_BUYING_CONFIG.getValue(), SystemSettingsDetailEnum.SIGNING_RECORD_STATISTICS_TIME.getValue(), "2023\u5e7410\u67081\u65e5 13:00:00", "");
            this.doAttributePaddingField(SystemSettingsTypeEnum.GROUP_BUYING_CONFIG.getValue(), SystemSettingsDetailEnum.FLAG_NEED_APPROVAL.getValue(), "", "");
        }
        if (!list.contains(SystemSettingsTypeEnum.CULTURAL_AND_TOURISM_ANSWER_CONFIG.getValue())) {
            this.doAttributePaddingTitle(SystemSettingsTypeEnum.CULTURAL_AND_TOURISM_ANSWER_CONFIG.getValue());
            this.doAttributePaddingField(SystemSettingsTypeEnum.CULTURAL_AND_TOURISM_ANSWER_CONFIG.getValue(), SystemSettingsDetailEnum.ANSWERING_CORRECTLY_POINTS.getValue(), "1", "");
            this.doAttributePaddingField(SystemSettingsTypeEnum.CULTURAL_AND_TOURISM_ANSWER_CONFIG.getValue(), SystemSettingsDetailEnum.MAX_POINTS_PER_MONTH.getValue(), "10", "");
            this.doAttributePaddingField(SystemSettingsTypeEnum.CULTURAL_AND_TOURISM_ANSWER_CONFIG.getValue(), SystemSettingsDetailEnum.ACTIVITY_RULES.getValue(), "", "");
        }
        if (!list.contains(SystemSettingsTypeEnum.CUSTOMER_SERVICE_CONFIG.getValue())) {
            this.doAttributePaddingTitle(SystemSettingsTypeEnum.CUSTOMER_SERVICE_CONFIG.getValue());
            this.doAttributePaddingField(SystemSettingsTypeEnum.CUSTOMER_SERVICE_CONFIG.getValue(), SystemSettingsDetailEnum.ONLINE_CUSTOMER_SERVICE_SETTINGS.getValue(), "\u5173\u95ed", "");
            this.doAttributePaddingField(SystemSettingsTypeEnum.CUSTOMER_SERVICE_CONFIG.getValue(), SystemSettingsDetailEnum.TELEPHONE_CUSTOMER_SERVICE_SETTINGS.getValue(), "\u5173\u95ed", "");
            this.doAttributePaddingField(SystemSettingsTypeEnum.CUSTOMER_SERVICE_CONFIG.getValue(), SystemSettingsDetailEnum.CUSTOMER_SERVICE_TELEPHONE.getValue(), "1234567890", "");
        }
        if (!list.contains(SystemSettingsTypeEnum.UPGRADE_RULES.getValue())) {
            this.doAttributePaddingTitle(SystemSettingsTypeEnum.UPGRADE_RULES.getValue());
            this.doAttributePaddingField(SystemSettingsTypeEnum.UPGRADE_RULES.getValue(), SystemSettingsDetailEnum.UPGRADE_RULE_DESC.getValue(), "", "");
        }
        if (!list.contains(SystemSettingsTypeEnum.BUSINESS_CARD_PAGE_COMPANY_INTRODUCTION.getValue())) {
            this.doAttributePaddingTitle(SystemSettingsTypeEnum.BUSINESS_CARD_PAGE_COMPANY_INTRODUCTION.getValue());
            this.doAttributePaddingField(SystemSettingsTypeEnum.BUSINESS_CARD_PAGE_COMPANY_INTRODUCTION.getValue(), SystemSettingsDetailEnum.CARD_PAGE_COMPANY_PROFILE.getValue(), "", "");
        }
    }

    private void doAttributePaddingTitle(String type) {
        SystemSettings systemSettings = new SystemSettings();
        systemSettings.setId(null);
        systemSettings.setType(type);
        systemSettings.setTenantCode(TenantUtils.getTenantCode());
        systemSettings.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        systemSettings.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        this.systemSettingsRepository.saveOrUpdate((Object)systemSettings);
    }

    private void doAttributePaddingField(String type, String typeKey, String typeValue, String typeValueText) {
        SystemSettingsDetail systemSettingsDetail = new SystemSettingsDetail();
        systemSettingsDetail.setId(null);
        systemSettingsDetail.setType(type);
        systemSettingsDetail.setTypeKey(typeKey);
        systemSettingsDetail.setTypeValue(typeValue);
        systemSettingsDetail.setTypeValueText(typeValueText);
        systemSettingsDetail.setTenantCode(TenantUtils.getTenantCode());
        systemSettingsDetail.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        systemSettingsDetail.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        this.systemSettingsDetailRepository.saveOrUpdate((Object)systemSettingsDetail);
    }

    private void doAttributePaddingFieldReserved(String type, String typeKey, String reservedOne) {
        SystemSettingsDetail systemSettingsDetail = new SystemSettingsDetail();
        systemSettingsDetail.setId(null);
        systemSettingsDetail.setReservedFieldsOne(reservedOne);
        systemSettingsDetail.setType(type);
        systemSettingsDetail.setTypeKey(typeKey);
        systemSettingsDetail.setTenantCode(TenantUtils.getTenantCode());
        systemSettingsDetail.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        systemSettingsDetail.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        this.systemSettingsDetailRepository.saveOrUpdate((Object)systemSettingsDetail);
    }

    private void createValidation(SystemSettingsVo systemSettingsVo) {
        this.validation(systemSettingsVo);
    }

    private void updateValidation(SystemSettingsVo systemSettingsVo) {
        this.validation(systemSettingsVo);
    }

    private void validation(SystemSettingsVo systemSettingsVo) {
        Validate.notBlank((CharSequence)systemSettingsVo.getType(), (String)"\u7cfb\u7edf\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        for (SystemSettingsDetailVo detail : systemSettingsVo.getDetails()) {
            Validate.notBlank((CharSequence)detail.getType(), (String)"\u7cfb\u7edf\u8be6\u7ec6\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)detail.getTypeKey(), (String)"\u7cfb\u7edf\u8be6\u7ec6\u7c7b\u578bkey\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
    }
}

