/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.member.business.member.local.service.internal;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.member.business.member.local.entity.TastingConsultant;
import com.biz.crm.member.business.member.local.entity.TastingRelBenefits;
import com.biz.crm.member.business.member.local.entity.TastingRelCustomer;
import com.biz.crm.member.business.member.local.repository.TastingConsultantRepository;
import com.biz.crm.member.business.member.local.repository.TastingRelBenefitsRepository;
import com.biz.crm.member.business.member.local.repository.TastingRelCustomerRepository;
import com.biz.crm.member.business.member.local.service.MemberInfoBenefitsService;
import com.biz.crm.member.business.member.local.service.TastingConsultantService;
import com.biz.crm.member.business.member.sdk.dto.TastingConsultantDto;
import com.biz.crm.member.business.member.sdk.dto.TastingConsultantPageDto;
import com.biz.crm.member.business.member.sdk.dto.TastingRelBenefitsDto;
import com.biz.crm.member.business.member.sdk.dto.TastingRelCustomerDto;
import com.biz.crm.member.business.member.sdk.enums.MemberInfoBenefitsStatusEnum;
import com.biz.crm.member.business.member.sdk.enums.MemberInfoMemberBenefitsTypeEnum;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoBenefitsVo;
import com.biz.crm.member.business.member.sdk.vo.TastingConsultantPageVo;
import com.biz.crm.member.business.member.sdk.vo.TastingConsultantVo;
import com.biz.crm.member.business.member.sdk.vo.TastingRelBenefitsVo;
import com.biz.crm.member.business.member.sdk.vo.TastingRelCustomerVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class TastingConsultantServiceImpl
implements TastingConsultantService {
    private static final Logger log = LoggerFactory.getLogger(TastingConsultantServiceImpl.class);
    @Autowired
    private TastingConsultantRepository tastingConsultantRepository;
    @Autowired
    private TastingRelCustomerRepository tastingRelCustomerRepository;
    @Autowired
    private TastingRelBenefitsRepository tastingRelBenefitsRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private RedisMutexService redisMutexService;
    @Autowired
    private LoginUserService loginUserService;
    @Autowired
    private MemberInfoBenefitsService memberInfoBenefitsService;
    public static final String MMS_TASTING_CONSULTANT_CODE_REDIS_KEY = "mms:tasting:consultant:code:index:%s";
    public static final String MMS_TASTING_CONSULTANT_CODE_PREFIX = "PJGW";

    @Override
    public Page<TastingConsultantPageVo> findByConditions(Pageable pageable, TastingConsultantPageDto tastingConsultantPageDto) {
        if (Objects.isNull(tastingConsultantPageDto)) {
            tastingConsultantPageDto = new TastingConsultantPageDto();
        }
        tastingConsultantPageDto.setTenantCode(TenantUtils.getTenantCode());
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.tastingConsultantRepository.findByConditions((Page<TastingConsultantPageVo>)page, tastingConsultantPageDto);
    }

    @Override
    public TastingConsultantVo findDetailById(String id) {
        List tastingRelBenefits;
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        TastingConsultant tastingConsultant = (TastingConsultant)((Object)this.tastingConsultantRepository.getById((Serializable)((Object)id)));
        Validate.notNull((Object)((Object)tastingConsultant), (String)"\u54c1\u9274\u987e\u95ee\u4e0d\u5b58\u5728\uff01", (Object[])new Object[0]);
        TastingConsultantVo tastingConsultantVo = (TastingConsultantVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)tastingConsultant, TastingConsultantVo.class, HashSet.class, LinkedList.class, new String[0]);
        List tastingRelCustomers = ((LambdaQueryChainWrapper)this.tastingRelCustomerRepository.lambdaQuery().eq(TastingRelCustomer::getTastingCode, (Object)tastingConsultantVo.getCode())).list();
        if (!CollectionUtils.isEmpty((Collection)tastingRelCustomers)) {
            List tastingRelCustomerVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)tastingRelCustomers, TastingRelCustomer.class, TastingRelCustomerVo.class, HashSet.class, LinkedList.class, new String[0]);
            tastingConsultantVo.setCustomers(tastingRelCustomerVos);
        }
        if (!CollectionUtils.isEmpty((Collection)(tastingRelBenefits = ((LambdaQueryChainWrapper)this.tastingRelBenefitsRepository.lambdaQuery().eq(TastingRelBenefits::getTastingCode, (Object)tastingConsultantVo.getCode())).list()))) {
            List tastingRelBenefitsVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)tastingRelBenefits, TastingRelBenefits.class, TastingRelBenefitsVo.class, HashSet.class, LinkedList.class, new String[0]);
            tastingConsultantVo.setBenefits(tastingRelBenefitsVos);
        }
        return tastingConsultantVo;
    }

    @Override
    @Transactional
    public TastingConsultantVo create(TastingConsultantDto tastingConsultantDto) {
        List customers;
        this.createValidate(tastingConsultantDto);
        log.info("\u521b\u5efa\u54c1\u9274\u987e\u95ee\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)tastingConsultantDto));
        TastingConsultant tastingConsultant = (TastingConsultant)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)tastingConsultantDto, TastingConsultant.class, HashSet.class, LinkedList.class, new String[0]));
        this.tastingConsultantRepository.saveOrUpdate((Object)tastingConsultant);
        List benefits = tastingConsultantDto.getBenefits();
        if (!CollectionUtils.isEmpty((Collection)benefits)) {
            this.saveRelBenefits(tastingConsultant.getCode(), benefits);
            this.createMemberBenefits(tastingConsultant.getCode(), benefits);
        }
        if (!CollectionUtils.isEmpty((Collection)(customers = tastingConsultantDto.getCustomers()))) {
            this.saveRelCustomer(tastingConsultant.getCode(), customers);
        }
        return (TastingConsultantVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)tastingConsultant, TastingConsultantVo.class, HashSet.class, LinkedList.class, new String[0]);
    }

    private void createMemberBenefits(String code, List<TastingRelBenefitsDto> benefits) {
        for (TastingRelBenefitsDto benefit : benefits) {
            MemberInfoBenefitsVo memberInfoBenefitsVo = new MemberInfoBenefitsVo();
            memberInfoBenefitsVo.setMemberCode(code);
            memberInfoBenefitsVo.setBenefitsCode(benefit.getBenefitsCode());
            memberInfoBenefitsVo.setBenefitsName(benefit.getBenefitsName());
            memberInfoBenefitsVo.setBenefitsType(benefit.getBenefitsType());
            memberInfoBenefitsVo.setExchangeStatus(MemberInfoBenefitsStatusEnum.STAY_EXCHANGE.getValue());
            memberInfoBenefitsVo.setMemberBenefitsType(MemberInfoMemberBenefitsTypeEnum.TASTING_BENEFITS.getValue());
            this.memberInfoBenefitsService.create(memberInfoBenefitsVo);
        }
    }

    private void createValidate(TastingConsultantDto tastingConsultantDto) {
        List benefits;
        Validate.notNull((Object)tastingConsultantDto, (String)"\u65b0\u589e\u53c2\u6570\u5b9e\u4f53\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)tastingConsultantDto.getPhone(), (String)"\u540d\u5b57\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)tastingConsultantDto.getCompany(), (String)"\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)tastingConsultantDto.getGender(), (String)"\u6027\u522b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)tastingConsultantDto.getBirthday(), (String)"\u751f\u65e5\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)tastingConsultantDto.getAge(), (String)"\u5e74\u9f84\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)tastingConsultantDto.getPosition(), (String)"\u804c\u52a1\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)tastingConsultantDto.getValidateStartDate(), (String)"\u751f\u6548\u671f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)tastingConsultantDto.getValidateEndDate(), (String)"\u751f\u6548\u671f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        tastingConsultantDto.setCode(this.generateCode(TenantUtils.getTenantCode()));
        List customers = tastingConsultantDto.getCustomers();
        if (!CollectionUtils.isEmpty((Collection)customers)) {
            for (TastingRelCustomerDto customer : customers) {
                Validate.notBlank((CharSequence)customer.getOrgCode(), (String)"\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                Validate.notBlank((CharSequence)customer.getOrgName(), (String)"\u7ec4\u7ec7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)(benefits = tastingConsultantDto.getBenefits()))) {
            for (TastingRelBenefitsDto benefit : benefits) {
                Validate.notBlank((CharSequence)benefit.getBenefitsCode(), (String)"\u6743\u76ca\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                Validate.notBlank((CharSequence)benefit.getBenefitsName(), (String)"\u6743\u76ca\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                Validate.notBlank((CharSequence)benefit.getBenefitsType(), (String)"\u6743\u76ca\u7c7b\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                Validate.notNull((Object)benefit.getQuantity(), (String)"\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                Validate.notBlank((CharSequence)benefit.getDeliveryFrequency(), (String)"\u53d1\u653e\u9891\u6b21\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            }
        }
        Date now = new Date();
        tastingConsultantDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        tastingConsultantDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        tastingConsultantDto.setTenantCode(TenantUtils.getTenantCode());
    }

    private String generateCode(String tenantCode) {
        String redisKey = String.format(MMS_TASTING_CONSULTANT_CODE_REDIS_KEY, tenantCode);
        String index = this.redisMutexService.getAndIncrement(redisKey, 1L, Integer.valueOf(6));
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        return StringUtils.join((Object[])new String[]{MMS_TASTING_CONSULTANT_CODE_PREFIX, format.format(new Date()), index});
    }

    @Override
    @Transactional
    public TastingConsultantVo update(TastingConsultantDto tastingConsultantDto) {
        this.updateValidate(tastingConsultantDto);
        log.info("\u4fee\u6539\u54c1\u9274\u987e\u95ee\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)tastingConsultantDto));
        TastingConsultant tastingConsultant = (TastingConsultant)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)tastingConsultantDto, TastingConsultant.class, HashSet.class, LinkedList.class, new String[0]));
        this.tastingConsultantRepository.saveOrUpdate((Object)tastingConsultant);
        QueryWrapper customerQueryWrapper = new QueryWrapper();
        customerQueryWrapper.eq((Object)"tasting_code", (Object)tastingConsultant.getCode());
        customerQueryWrapper.eq((Object)"tenant_code", (Object)tastingConsultant.getTenantCode());
        this.tastingRelCustomerRepository.remove((Wrapper)customerQueryWrapper);
        List customers = tastingConsultantDto.getCustomers();
        this.saveRelCustomer(tastingConsultant.getCode(), customers);
        QueryWrapper benefitsQueryWrapper = new QueryWrapper();
        customerQueryWrapper.eq((Object)"tasting_code", (Object)tastingConsultant.getCode());
        customerQueryWrapper.eq((Object)"tenant_code", (Object)tastingConsultant.getTenantCode());
        this.tastingRelBenefitsRepository.remove((Wrapper)benefitsQueryWrapper);
        List benefits = tastingConsultantDto.getBenefits();
        this.saveRelBenefits(tastingConsultant.getCode(), benefits);
        return (TastingConsultantVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)tastingConsultant, TastingConsultantVo.class, HashSet.class, LinkedList.class, new String[0]);
    }

    private void saveRelBenefits(String code, List<TastingRelBenefitsDto> benefitsDtos) {
        List tastingRelBenefits = (List)this.nebulaToolkitService.copyCollectionByWhiteList(benefitsDtos, TastingRelBenefitsDto.class, TastingRelBenefits.class, HashSet.class, LinkedList.class, new String[0]);
        tastingRelBenefits.stream().forEach(e -> {
            e.setTastingCode(code);
            e.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            e.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            e.setTenantCode(TenantUtils.getTenantCode());
        });
        this.tastingRelBenefitsRepository.saveBatch(tastingRelBenefits);
    }

    private void saveRelCustomer(String code, List<TastingRelCustomerDto> customerDtos) {
        List tastingRelCustomers = (List)this.nebulaToolkitService.copyCollectionByWhiteList(customerDtos, TastingRelCustomerDto.class, TastingRelCustomer.class, HashSet.class, LinkedList.class, new String[0]);
        tastingRelCustomers.stream().forEach(e -> {
            e.setTastingCode(code);
            e.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            e.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            e.setTenantCode(TenantUtils.getTenantCode());
        });
        this.tastingRelCustomerRepository.saveBatch(tastingRelCustomers);
    }

    private void updateValidate(TastingConsultantDto tastingConsultantDto) {
        List benefits;
        Validate.notNull((Object)tastingConsultantDto, (String)"\u4fee\u6539\u53c2\u6570\u5b9e\u4f53\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)tastingConsultantDto.getPhone(), (String)"\u540d\u5b57\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)tastingConsultantDto.getCompany(), (String)"\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)tastingConsultantDto.getGender(), (String)"\u6027\u522b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)tastingConsultantDto.getBirthday(), (String)"\u751f\u65e5\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)tastingConsultantDto.getAge(), (String)"\u5e74\u9f84\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)tastingConsultantDto.getPosition(), (String)"\u804c\u52a1\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)tastingConsultantDto.getValidateStartDate(), (String)"\u751f\u6548\u671f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)tastingConsultantDto.getValidateEndDate(), (String)"\u751f\u6548\u671f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)tastingConsultantDto.getCode(), (String)"\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)tastingConsultantDto.getId(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u4e3b\u952eid\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List customers = tastingConsultantDto.getCustomers();
        if (!CollectionUtils.isEmpty((Collection)customers)) {
            for (TastingRelCustomerDto customer : customers) {
                Validate.notBlank((CharSequence)customer.getOrgCode(), (String)"\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                Validate.notBlank((CharSequence)customer.getOrgName(), (String)"\u7ec4\u7ec7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)(benefits = tastingConsultantDto.getBenefits()))) {
            for (TastingRelBenefitsDto benefit : benefits) {
                Validate.notBlank((CharSequence)benefit.getBenefitsCode(), (String)"\u6743\u76ca\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                Validate.notBlank((CharSequence)benefit.getBenefitsName(), (String)"\u6743\u76ca\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                Validate.notBlank((CharSequence)benefit.getBenefitsType(), (String)"\u6743\u76ca\u7c7b\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                Validate.notNull((Object)benefit.getQuantity(), (String)"\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                Validate.notBlank((CharSequence)benefit.getDeliveryFrequency(), (String)"\u53d1\u653e\u9891\u6b21\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            }
        }
        Date now = new Date();
        tastingConsultantDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        tastingConsultantDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        tastingConsultantDto.setTenantCode(TenantUtils.getTenantCode());
    }

    @Override
    public void enableBatch(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.tastingConsultantRepository.lambdaUpdate().set(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.ENABLE.getCode())).in(UuidEntity::getId, ids)).update();
    }

    @Override
    public void disableBatch(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.tastingConsultantRepository.lambdaUpdate().set(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.DISABLE.getCode())).in(UuidEntity::getId, ids)).update();
    }

    @Override
    public void deleteBatch(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.tastingConsultantRepository.lambdaUpdate().set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).in(UuidEntity::getId, ids)).update();
    }

    @Override
    public TastingConsultantVo queryFlagTastingByPhone(String memberPhone) {
        Validate.notBlank((CharSequence)memberPhone, (String)"\u67e5\u8be2\u54c1\u9274\u987e\u95ee,\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        TastingConsultantVo tastingConsultantVo = this.tastingConsultantRepository.queryFlagTastingByPhone(memberPhone);
        return tastingConsultantVo;
    }
}

