/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.member.business.member.local.service.internal;

import com.biz.crm.member.business.member.local.helper.UserSearchHelper;
import com.biz.crm.member.business.member.local.service.LevelManageService;
import com.biz.crm.member.business.member.local.service.MemberInfoLevelChangeRecordService;
import com.biz.crm.member.business.member.local.service.MemberInfoService;
import com.biz.crm.member.business.member.local.service.SystemSettingsDetailService;
import com.biz.crm.member.business.member.local.service.TouristAPIService;
import com.biz.crm.member.business.member.sdk.enums.SystemSettingsDetailEnum;
import com.biz.crm.member.business.member.sdk.vo.LevelManageVo;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoLevelChangeRecordVo;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoVo;
import com.biz.crm.member.business.member.sdk.vo.TouristAPIVo;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TouristAPIServiceImpl
implements TouristAPIService {
    private static final Logger log = LoggerFactory.getLogger(TouristAPIServiceImpl.class);
    @Autowired
    private UserSearchHelper userSearchHelper;
    @Autowired
    private MemberInfoService memberInfoService;
    @Autowired
    private SystemSettingsDetailService systemSettingsDetailService;
    @Autowired
    private MemberInfoLevelChangeRecordService memberInfoLevelChangeRecordService;
    @Autowired
    private LevelManageService levelManageService;

    @Override
    public TouristAPIVo cardInfo() {
        TouristAPIVo resultVo = new TouristAPIVo();
        String memberCode = this.userSearchHelper.getMemberLogin().getMemberCode();
        MemberInfoVo memberInfoVo = this.memberInfoService.findDetailByMemberCode(memberCode);
        if ((memberInfoVo = Optional.ofNullable(memberInfoVo).orElse(new MemberInfoVo())).getInviteMemberCode() == null) {
            return null;
        }
        MemberInfoVo memberInfoVoInvite = this.memberInfoService.findDetailByMemberCode(memberInfoVo.getInviteMemberCode());
        if (memberInfoVoInvite.getLinkTastingName() == null) {
            MemberInfoLevelChangeRecordVo detailByMemberCode = this.memberInfoLevelChangeRecordService.findDetailByMemberCode(memberCode);
            LevelManageVo detailByLevelCode = this.levelManageService.findDetailByLevelCode(detailByMemberCode.getLevelCode());
            resultVo.setInviterName(memberInfoVoInvite.getMemberName());
            resultVo.setCardUrl(detailByLevelCode.getCardImageOne());
            return resultVo;
        }
        String typeValue = this.systemSettingsDetailService.findValueByKey(SystemSettingsDetailEnum.CARD_IMAGE.getValue()).getTypeValue();
        resultVo.setInviterName(memberInfoVoInvite.getLinkTastingName());
        resultVo.setCardUrl(typeValue);
        return resultVo;
    }
}

