/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.member.business.member.local.service.internal;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.member.business.member.local.entity.MemberInfoArchives;
import com.biz.crm.member.business.member.local.entity.VerificationUser;
import com.biz.crm.member.business.member.local.helper.UserSearchHelper;
import com.biz.crm.member.business.member.local.repository.MemberInfoArchivesRepository;
import com.biz.crm.member.business.member.local.repository.VerificationUserRepository;
import com.biz.crm.member.business.member.local.service.VerificationUserService;
import com.biz.crm.member.business.member.sdk.dto.VerificationUserDto;
import com.biz.crm.member.business.member.sdk.enums.VerificationUserTypeEnum;
import com.biz.crm.member.business.member.sdk.vo.VerificationUserVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class VerificationUserServiceImpl
implements VerificationUserService {
    @Autowired
    private VerificationUserRepository verificationUserRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private RedisMutexService redisMutexService;
    @Autowired
    private UserSearchHelper userSearchHelper;
    @Autowired
    private MemberInfoArchivesRepository memberInfoArchivesRepository;
    public static final String MMS_VERIFICATION_USER_CODE_REDIS_KEY = "mms:role:code:index:%s";
    public static final String MMS_VERIFICATION_USER_CODE_PREFIX = "HX";

    private String generateCode(String tenantCode) {
        String redisKey = String.format(MMS_VERIFICATION_USER_CODE_REDIS_KEY, tenantCode);
        String index = this.redisMutexService.getAndIncrement(redisKey, 1L, Integer.valueOf(6));
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        return StringUtils.join((Object[])new String[]{MMS_VERIFICATION_USER_CODE_PREFIX, format.format(new Date()), index});
    }

    @Override
    public Page<VerificationUserVo> findByConditions(Pageable pageable, VerificationUserDto verificationUserDto) {
        if (Objects.isNull(verificationUserDto)) {
            verificationUserDto = new VerificationUserDto();
        }
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.verificationUserRepository.findByConditions((Page<VerificationUserVo>)page, verificationUserDto);
    }

    @Override
    public VerificationUserVo findDetailById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        VerificationUser verificationUser = (VerificationUser)((Object)this.verificationUserRepository.getById((Serializable)((Object)id)));
        Validate.notNull((Object)((Object)verificationUser), (String)"\u4eba\u5458\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        return (VerificationUserVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)verificationUser, VerificationUserVo.class, HashSet.class, LinkedList.class, new String[0]);
    }

    @Override
    @Transactional
    public VerificationUserVo create(VerificationUserDto verificationUserDto) {
        Validate.notNull((Object)verificationUserDto, (String)"\u65b0\u589e\u5b9e\u4f53\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)verificationUserDto.getRoleCode(), (String)"\u89d2\u8272\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)verificationUserDto.getUserName(), (String)"\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)verificationUserDto.getUserType(), (String)"\u4eba\u5458\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        verificationUserDto.setUserCode(this.generateCode(TenantUtils.getTenantCode()));
        verificationUserDto.setTenantCode(TenantUtils.getTenantCode());
        verificationUserDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        verificationUserDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        VerificationUser verificationUser = (VerificationUser)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)verificationUserDto, VerificationUser.class, HashSet.class, LinkedList.class, new String[0]));
        this.verificationUserRepository.saveOrUpdate((Object)verificationUser);
        return (VerificationUserVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)verificationUser, VerificationUserVo.class, HashSet.class, LinkedList.class, new String[0]);
    }

    @Override
    @Transactional
    public VerificationUserVo update(VerificationUserDto verificationUserDto) {
        Validate.notNull((Object)verificationUserDto, (String)"\u7f16\u8f91\u5b9e\u4f53\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)verificationUserDto.getRoleCode(), (String)"\u89d2\u8272\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)verificationUserDto.getUserName(), (String)"\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)verificationUserDto.getUserType(), (String)"\u4eba\u5458\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)verificationUserDto.getId(), (String)"\u7f16\u8f91\u65f6,\u4e3b\u952eid\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)verificationUserDto.getUserCode(), (String)"\u7f16\u8f91\u65f6,\u4eba\u5458\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        verificationUserDto.setTenantCode(TenantUtils.getTenantCode());
        verificationUserDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        verificationUserDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        VerificationUser verificationUser = (VerificationUser)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)verificationUserDto, VerificationUser.class, HashSet.class, LinkedList.class, new String[0]));
        this.verificationUserRepository.saveOrUpdate((Object)verificationUser);
        return (VerificationUserVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)verificationUser, VerificationUserVo.class, HashSet.class, LinkedList.class, new String[0]);
    }

    @Override
    public void enableBatch(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.verificationUserRepository.lambdaUpdate().set(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.ENABLE.getCode())).in(UuidEntity::getId, ids)).update();
    }

    @Override
    public void disableBatch(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.verificationUserRepository.lambdaUpdate().set(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.DISABLE.getCode())).in(UuidEntity::getId, ids)).update();
    }

    @Override
    public void deleteBatch(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.verificationUserRepository.lambdaUpdate().set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).in(UuidEntity::getId, ids)).update();
    }

    @Override
    public List<VerificationUserVo> listDispatchSalesman() {
        String memberCode = this.userSearchHelper.getMemberLogin().getMemberCode();
        MemberInfoArchives memberInfoArchives = (MemberInfoArchives)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.memberInfoArchivesRepository.lambdaQuery().eq(MemberInfoArchives::getMemberCode, (Object)memberCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).eq(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.ENABLE.getCode())).one());
        Validate.notNull((Object)((Object)memberInfoArchives), (String)"\u5f53\u524d\u767b\u5f55\u7528\u6237\u7684\u6863\u6848\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        String orgCode = memberInfoArchives.getOrgCode();
        Validate.notBlank((CharSequence)orgCode, (String)"\u5f53\u524d\u767b\u5f55\u7528\u6237\u6ca1\u6709\u6240\u5c5e\u7ec4\u7ec7\u4fe1\u606f", (Object[])new Object[0]);
        List verificationUserList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.verificationUserRepository.lambdaQuery().eq(VerificationUser::getOrgCode, (Object)orgCode)).eq(VerificationUser::getUserType, (Object)VerificationUserTypeEnum.STUFF.getCode())).eq(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.ENABLE.getCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).list();
        if (CollectionUtils.isEmpty((Collection)verificationUserList)) {
            verificationUserList = Collections.EMPTY_LIST;
        }
        Collection result = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)verificationUserList, VerificationUser.class, VerificationUserVo.class, HashSet.class, LinkedList.class, new String[0]);
        return (List)result;
    }
}

