/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.member.business.member.local.service.internal;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.member.business.member.local.entity.ViewpagerEntity;
import com.biz.crm.member.business.member.local.repository.ViewpagerFileRepository;
import com.biz.crm.member.business.member.local.repository.ViewpagerRepository;
import com.biz.crm.member.business.member.local.service.ViewpagerService;
import com.biz.crm.member.business.member.sdk.dto.ViewpagerDto;
import com.biz.crm.member.business.member.sdk.enums.SkipTypeEnum;
import com.biz.crm.member.business.member.sdk.vo.ViewpagerVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class ViewpagerServiceImpl
implements ViewpagerService {
    @Autowired
    private ViewpagerRepository viewpagerRepository;
    @Autowired
    private ViewpagerFileRepository viewpagerFileRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private RedisMutexService redisMutexService;
    public static final String MMS_VIEWPAGER_CODE_REDIS_KEY = "mms:viewpager:code:index:%s";
    public static final String MMS_VIEWPAGER_CODE_PREFIX = "LB";

    private String generateCode(String tenantCode) {
        String redisKey = String.format(MMS_VIEWPAGER_CODE_REDIS_KEY, tenantCode);
        String index = this.redisMutexService.getAndIncrement(redisKey, 1L, Integer.valueOf(6));
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        return StringUtils.join((Object[])new String[]{MMS_VIEWPAGER_CODE_PREFIX, format.format(new Date()), index});
    }

    @Override
    public Page<ViewpagerVo> findByConditions(Pageable pageable, ViewpagerDto viewpagerDto) {
        if (Objects.isNull(viewpagerDto)) {
            viewpagerDto = new ViewpagerDto();
        }
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.viewpagerRepository.findByConditions((Page<ViewpagerVo>)page, viewpagerDto);
    }

    @Override
    public ViewpagerVo findDetailById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        ViewpagerEntity viewpagerEntity = (ViewpagerEntity)((Object)this.viewpagerRepository.getById((Serializable)((Object)id)));
        ViewpagerVo viewpagerVo = (ViewpagerVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)viewpagerEntity, ViewpagerVo.class, HashSet.class, LinkedList.class, new String[0]);
        return viewpagerVo;
    }

    @Override
    @Transactional
    public ViewpagerVo create(ViewpagerDto viewpagerDto) {
        this.createValidate(viewpagerDto);
        String code = this.generateCode(TenantUtils.getTenantCode());
        viewpagerDto.setCode(code);
        ViewpagerEntity viewpagerEntity = (ViewpagerEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)viewpagerDto, ViewpagerEntity.class, HashSet.class, LinkedList.class, new String[0]));
        viewpagerEntity.setTenantCode(TenantUtils.getTenantCode());
        viewpagerEntity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        viewpagerEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        this.viewpagerRepository.saveOrUpdate((Object)viewpagerEntity);
        return (ViewpagerVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)viewpagerEntity, ViewpagerVo.class, HashSet.class, LinkedList.class, new String[0]);
    }

    private void createValidate(ViewpagerDto viewpagerDto) {
        Validate.notNull((Object)viewpagerDto, (String)"\u65b0\u589e\u5b9e\u4f53\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)viewpagerDto.getSortIndex(), (String)"\u5e8f\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)viewpagerDto.getStartDate(), (String)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)viewpagerDto.getEndDate(), (String)"\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)viewpagerDto.getUseArea(), (String)"\u5e94\u7528\u533a\u57df\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)viewpagerDto.getSkipType(), (String)"\u8df3\u8f6c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)viewpagerDto.getMainFileCode(), (String)"\u56fe\u7247\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (!SkipTypeEnum.NO.getCode().equals(viewpagerDto.getSkipType())) {
            Validate.notBlank((CharSequence)viewpagerDto.getSkipUrl(), (String)"\u8df3\u8f6c\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
    }

    @Override
    @Transactional
    public ViewpagerVo update(ViewpagerDto viewpagerDto) {
        this.updateValidate(viewpagerDto);
        ViewpagerEntity oldViewpager = (ViewpagerEntity)((Object)this.viewpagerRepository.getById((Serializable)((Object)viewpagerDto.getId())));
        Validate.notNull((Object)((Object)oldViewpager), (String)"\u7f16\u8f91\u5bf9\u8c61\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        ViewpagerEntity viewpagerEntity = (ViewpagerEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)viewpagerDto, ViewpagerEntity.class, HashSet.class, LinkedList.class, new String[0]));
        this.viewpagerRepository.saveOrUpdate((Object)viewpagerEntity);
        return (ViewpagerVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)viewpagerEntity, ViewpagerVo.class, HashSet.class, LinkedList.class, new String[0]);
    }

    private void updateValidate(ViewpagerDto viewpagerDto) {
        Validate.notNull((Object)viewpagerDto, (String)"\u7f16\u8f91\u5b9e\u4f53\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)viewpagerDto.getSortIndex(), (String)"\u5e8f\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)viewpagerDto.getStartDate(), (String)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)viewpagerDto.getEndDate(), (String)"\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)viewpagerDto.getUseArea(), (String)"\u5e94\u7528\u533a\u57df\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)viewpagerDto.getSkipType(), (String)"\u8df3\u8f6c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)viewpagerDto.getMainFileCode(), (String)"\u56fe\u7247\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)viewpagerDto.getCode(), (String)"\u7f16\u8f91\u65f6\uff0c\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)viewpagerDto.getId(), (String)"\u7f16\u8f91\u65f6\uff0c\u4e3b\u952eid\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (!SkipTypeEnum.NO.getCode().equals(viewpagerDto.getSkipType())) {
            Validate.notBlank((CharSequence)viewpagerDto.getSkipUrl(), (String)"\u8df3\u8f6c\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
    }

    @Override
    public void enableBatch(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.viewpagerRepository.lambdaUpdate().set(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.ENABLE.getCode())).in(UuidEntity::getId, ids)).update();
    }

    @Override
    public void disableBatch(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.viewpagerRepository.lambdaUpdate().set(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.DISABLE.getCode())).in(UuidEntity::getId, ids)).update();
    }

    @Override
    public void deleteBatch(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.viewpagerRepository.lambdaUpdate().set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).in(UuidEntity::getId, ids)).update();
    }

    @Override
    public List<ViewpagerVo> getEnableOneByUseArea(String useAreaCode) {
        Validate.notBlank((CharSequence)useAreaCode, (String)"\u5e94\u7528\u533a\u57df\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Date currentTime = new Date(System.currentTimeMillis());
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.le(ViewpagerEntity::getStartDate, (Object)currentTime)).ge(ViewpagerEntity::getEndDate, (Object)currentTime)).eq(ViewpagerEntity::getUseArea, (Object)useAreaCode)).eq(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.ENABLE.getCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode());
        List bannerList = this.viewpagerRepository.list((Wrapper)queryWrapper);
        Collection result = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)bannerList, ViewpagerEntity.class, ViewpagerVo.class, HashSet.class, LinkedList.class, new String[0]);
        return (List)result;
    }
}

