package com.biz.crm.member.business.member.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/**
 * 活动-报名配置Dto
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/16 10:58
 **/
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ActivityApplyConfigDto", description = "活动-报名配置Dto")
public class ActivityApplyConfigDto extends TenantFlagOpDto {

    @ApiModelProperty("活动编码")
    private String activityCode;

    @ApiModelProperty("组件字段")
    private String field;

    @ApiModelProperty("组件类型")
    private String type;

    @ApiModelProperty("提示语")
    private String placeholder;

    @ApiModelProperty("是否必填")
    private Boolean required;

    @ApiModelProperty("默认值")
    private String defaultValue;

    @ApiModelProperty("排序（按数字顺序排列）")
    private Integer sortIndex;

    @ApiModelProperty("标题")
    private String title;

    @ApiModelProperty("多选/单选的json值")
    private String configJsonValue;

}
