package com.biz.crm.member.business.member.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.biz.crm.member.business.member.sdk.vo.ActivityApplyConfigVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 活动基础配置dto
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/16 11:32
 **/
@Data
@ApiModel(value = "ActivityManageDto",description = "活动基础配置dto")
public class ActivityManageDto extends TenantFlagOpDto {

    @ApiModelProperty("活动编码")
    private String code;

    @ApiModelProperty("活动名称")
    private String name;

    @ApiModelProperty("活动地址")
    private String address;

    @ApiModelProperty("活动说明")
    private String activityDsc;

    @ApiModelProperty("报名是否需要审批")
    private String needApproval;

    @ApiModelProperty("报名是否需要审批")
    private String needApprovalName;

    @ApiModelProperty("报名人数上限数量")
    private Integer applyCeilingNum;

    @ApiModelProperty("报名等级限制")
    private String applyRequire;

    @ApiModelProperty("报名等级限制名称")
    private String applyRequireName;

    @ApiModelProperty("报名时间（开始）")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date applyStartDate;

    @ApiModelProperty("报名结束（结束）")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date applyEndDate;

    @ApiModelProperty("签到时间（开始）")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date signStartDate;

    @ApiModelProperty("签到结束（结束）")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date signEndDate;

    @ApiModelProperty("活动详情")
    private String activityDetailDesc;

    @ApiModelProperty("文件id")
    private String fileId;

    @ApiModelProperty("文件名")
    private String fileName;

    @ApiModelProperty("省")
    private String provinceCode;

    @ApiModelProperty("省名称")
    private String provinceName;

    @ApiModelProperty("市")
    private String cityCode;

    @ApiModelProperty("市名称")
    private String cityName;

    @ApiModelProperty("区")
    private String districtCode;

    @ApiModelProperty("区名称")
    private String districtName;

    @ApiModelProperty("报名配置")
    private List<ActivityApplyConfigDto> activityApplyConfigDto;
}
