package com.biz.crm.member.business.member.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.biz.crm.member.business.member.sdk.enums.ActivityStatusEnum;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 活动基础配置分页dto
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/16 11:32
 **/
@Data
@ApiModel(value = "ActivityManagePageDto",description = "活动基础配置分页dto")
public class ActivityManagePageDto extends TenantFlagOpDto {

    @ApiModelProperty("活动编码")
    private String code;

    @ApiModelProperty("活动名称")
    private String name;

    @ApiModelProperty("活动地址")
    private String address;

    @ApiModelProperty("活动说明")
    private String activityDsc;

    @ApiModelProperty("报名是否需要审批")
    private String needApproval;

    @ApiModelProperty("报名是否需要审批")
    private String needApprovalName;

    @ApiModelProperty("报名人数上限数量")
    private Integer applyCeilingNum;

    @ApiModelProperty("报名等级限制")
    private String applyRequire;

    @ApiModelProperty("报名等级限制名称")
    private String applyRequireName;

    @ApiModelProperty("报名时间（开始）")
    private String applyStartDate;

    @ApiModelProperty("报名结束（结束）")
    private String applyEndDate;

    @ApiModelProperty("签到时间（开始）")
    private String signStartDate;

    @ApiModelProperty("签到结束（结束）")
    private String signEndDate;

    @ApiModelProperty("活动详情")
    private String activityDetailDesc;

    @ApiModelProperty("文件id")
    private String fileId;

    @ApiModelProperty("文件名")
    private String fileName;

    @ApiModelProperty("当前用户名(小程序所用)")
    private String userName;
    @ApiModelProperty("是否来自小程序")
    private String fromPhone;

    /**  小程序活动状态
     * {@link ActivityStatusEnum#getCode()}
     */
    private String activityStatus;

    public void setApplyStartDate(String applyStartDate) {
        if(applyStartDate!=null&&!applyStartDate.equals("")){
            this.applyStartDate = applyStartDate+" 00:00:00";
        }
    }

    public void setApplyEndDate(String applyEndDate) {
        if(applyEndDate!=null&&!applyEndDate.equals("")){
            this.applyEndDate = applyEndDate+" 23:59:59";
        }
    }

    public void setSignStartDate(String signStartDate) {
        if(signStartDate!=null&&!signStartDate.equals("")){
            this.signStartDate = signStartDate+" 00:00:00";
        }
    }

    public void setSignEndDate(String signEndDate) {
        if(signEndDate!=null&&!signEndDate.equals("")){
            this.signEndDate = signEndDate+" 23:59:59";
        }
    }

}
